/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.events.editor.EditFileEvent;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.util.DataObjectListCellRenderer;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ui.EditorDialog;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;
import pojos.AnnotationData;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;
import pojos.TagAnnotationData;
import pojos.TextualAnnotationData;

class DocComponent
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private static final int DELETE = 0;
    private static final int EDIT = 1;
    private static final int DOWNLOAD = 2;
    private static final int OPEN = 3;
    private Object data;
    private EditorModel model;
    private JButton deleteButton;
    private JButton editButton;
    private JButton downloadButton;
    private JButton openButton;
    private JLabel label;
    private Point popupPoint;
    private String originalDescription;
    private String originalName;

    private String formatTootTip(AnnotationData annotation) {
        StringBuffer buf = new StringBuffer();
        buf.append("<html><body>");
        ExperimenterData exp = null;
        if (annotation.getId() > 0L) {
            exp = this.model.getOwner((DataObject)annotation);
        }
        if (exp != null) {
            buf.append("<b>");
            buf.append("Owner: ");
            buf.append("</b>");
            buf.append(EditorUtil.formatExperimenter(exp));
            buf.append("<br>");
        }
        if (this.data instanceof FileAnnotationData) {
            String ns = ((FileAnnotationData)this.data).getNameSpace();
            if ("openmicroscopy.org/omero/editor/experiment".equals(ns)) {
                buf.append("<b>");
                buf.append("Editor File: ");
                buf.append("</b>");
                buf.append("Experiment");
                buf.append("<br>");
                buf.append("<b>");
            } else if ("openmicroscopy.org/omero/editor/protocol".equals(ns)) {
                buf.append("<b>");
                buf.append("Editor File: ");
                buf.append("</b>");
                buf.append("Protocol");
                buf.append("<br>");
                buf.append("<b>");
            }
            if (annotation.getId() > 0L) {
                buf.append("<b>");
                buf.append("Date Added: ");
                buf.append("</b>");
                buf.append(UIUtilities.formatWDMYDate(annotation.getLastModified()));
                buf.append("<br>");
                buf.append("<b>");
            }
            buf.append("Size: ");
            buf.append("</b>");
            buf.append(UIUtilities.formatFileSize(((FileAnnotationData)annotation).getFileSize()));
            buf.append("<br>");
        } else if (this.data instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)this.data;
            exp = MetadataViewerAgent.getUserDetails();
            String description = tag.getTagDescription();
            if (tag.getId() > 0L) {
                List descriptions = tag.getTagDescriptions();
                if (descriptions != null && descriptions.size() > 0) {
                    for (TextualAnnotationData desc : descriptions) {
                        if (desc == null) continue;
                        ExperimenterData owner = desc.getOwner();
                        buf.append("<b>Described by: ");
                        buf.append(EditorUtil.formatExperimenter(owner));
                        buf.append("</b><br>");
                        List<String> l = owner.getId() == exp.getId() && description != null ? UIUtilities.wrapStyleWord(description) : UIUtilities.wrapStyleWord(desc.getText());
                        if (l == null) continue;
                        Iterator<String> j = l.iterator();
                        while (j.hasNext()) {
                            buf.append(j.next());
                            buf.append("<br>");
                        }
                    }
                }
            } else {
                buf.append("<b>Described by: ");
                buf.append(EditorUtil.formatExperimenter(exp));
                buf.append("</b><br>");
                List<String> l = UIUtilities.wrapStyleWord(description);
                if (l != null) {
                    Iterator<String> j = l.iterator();
                    while (j.hasNext()) {
                        buf.append(j.next());
                        buf.append("<br>");
                    }
                }
            }
        }
        buf.append("</body></html>");
        return buf.toString();
    }

    private void postFileClicked() {
        if (this.data == null) {
            return;
        }
        if (this.data instanceof FileAnnotationData) {
            FileAnnotationData f = (FileAnnotationData)this.data;
            Registry reg = MetadataViewerAgent.getRegistry();
            reg.getEventBus().post(new EditFileEvent(f));
        }
    }

    private void initButton() {
        IconManager icons = IconManager.getInstance();
        this.deleteButton = new JButton(icons.getIcon(57));
        UIUtilities.unifiedButtonLookAndFeel(this.deleteButton);
        this.deleteButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        if (this.data instanceof FileAnnotationData) {
            FileAnnotationData fa = (FileAnnotationData)this.data;
            this.deleteButton.setToolTipText("Remove the attachment.");
            if (fa.getId() > 0L) {
                this.downloadButton = new JButton(icons.getIcon(59));
                this.downloadButton.setOpaque(false);
                UIUtilities.unifiedButtonLookAndFeel(this.downloadButton);
                this.downloadButton.setBackground(UIUtilities.BACKGROUND_COLOR);
                this.downloadButton.setToolTipText("Download the selected file.");
                this.downloadButton.setActionCommand("2");
                this.downloadButton.addActionListener(this);
                String ns = fa.getNameSpace();
                if ("openmicroscopy.org/omero/editor/experiment".equals(ns) || "openmicroscopy.org/omero/editor/protocol".equals(ns)) {
                    this.openButton = new JButton(icons.getIcon(60));
                    this.openButton.setOpaque(false);
                    UIUtilities.unifiedButtonLookAndFeel(this.openButton);
                    this.openButton.setBackground(UIUtilities.BACKGROUND_COLOR);
                    this.openButton.setToolTipText("Open the file in the editor.");
                    this.openButton.setActionCommand("3");
                    this.openButton.addActionListener(this);
                }
            }
        } else if (this.data instanceof TagAnnotationData) {
            this.deleteButton.setToolTipText("Remove the Tag.");
            this.editButton = new JButton(icons.getIcon(54));
            this.editButton.setOpaque(false);
            UIUtilities.unifiedButtonLookAndFeel(this.editButton);
            this.editButton.setBackground(UIUtilities.BACKGROUND_COLOR);
            this.editButton.setToolTipText("Add or Edit the description.");
            this.editButton.setActionCommand("1");
            this.editButton.addActionListener(this);
            this.editButton.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    DocComponent.this.popupPoint = e.getPoint();
                }
            });
        }
        this.deleteButton.addActionListener(this);
        this.deleteButton.setActionCommand("0");
    }

    private void initComponents() {
        if (this.model.isCurrentUserOwner(this.data)) {
            this.initButton();
        }
        this.label = new JLabel();
        this.label.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        if (this.data == null) {
            this.label.setText("None");
        } else if (this.data instanceof FileAnnotationData) {
            FileAnnotationData f = (FileAnnotationData)this.data;
            this.label.setToolTipText(this.formatTootTip((AnnotationData)f));
            this.label.setText(EditorUtil.getPartialName(f.getFileName()));
            this.initButton();
            if (f.getId() < 0L) {
                this.label.setForeground(DataObjectListCellRenderer.NEW_FOREGROUND_COLOR);
            }
        } else if (this.data instanceof File) {
            this.initButton();
            File f = (File)this.data;
            this.label.setText(f.getName());
            this.label.setForeground(Color.BLUE);
        } else if (this.data instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)this.data;
            this.label.setToolTipText(this.formatTootTip((AnnotationData)tag));
            this.label.setText(tag.getTagValue());
            this.initButton();
            if (tag.getId() < 0L) {
                this.label.setForeground(DataObjectListCellRenderer.NEW_FOREGROUND_COLOR);
            }
        }
        this.label.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DocComponent.this.postFileClicked();
                }
            }
        });
    }

    private void buildGUI() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(this.label);
        JToolBar bar = new JToolBar();
        bar.setBackground(UIUtilities.BACKGROUND_COLOR);
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.setOpaque(true);
        if (this.editButton != null) {
            bar.add(this.editButton);
        }
        if (this.deleteButton != null) {
            bar.add(this.deleteButton);
        }
        if (this.downloadButton != null) {
            bar.add(this.downloadButton);
        }
        if (this.openButton != null) {
            bar.add(this.openButton);
        }
        if (bar.getComponentCount() > 0) {
            this.add(bar);
        }
    }

    private void editDescription() {
        String text;
        TagAnnotationData tag = (TagAnnotationData)this.data;
        this.originalDescription = text = this.model.getTagDescription(tag);
        this.originalName = tag.getTagValue();
        SwingUtilities.convertPointToScreen(this.popupPoint, this);
        JFrame f = MetadataViewerAgent.getRegistry().getTaskBar().getFrame();
        EditorDialog d = new EditorDialog(f, (DataObject)tag, false, 1);
        d.addPropertyChangeListener(this);
        d.setOriginalDescription(this.originalDescription);
        d.setSize(300, 250);
        UIUtilities.showOnScreen(d, this.popupPoint);
    }

    private void download() {
        JFrame f = EditorAgent.getRegistry().getTaskBar().getFrame();
        FileChooser chooser = new FileChooser(f, 2, "Download", "Select where to download the file.");
        chooser.addPropertyChangeListener(this);
        chooser.centerDialog();
    }

    DocComponent(Object data, EditorModel model) {
        if (model == null) {
            throw new IllegalArgumentException("No Model.");
        }
        this.originalDescription = null;
        this.model = model;
        this.data = data;
        this.initComponents();
        this.buildGUI();
    }

    Object getData() {
        return this.data;
    }

    boolean hasBeenModified() {
        if (this.originalName == null) {
            return false;
        }
        if (this.data instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)this.data;
            if (!this.originalName.equals(tag.getTagValue())) {
                return true;
            }
            String txt = tag.getTagDescription();
            if (txt != null) {
                return !this.originalDescription.equals(txt);
            }
            return false;
        }
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.firePropertyChange("removeAnnotation", null, this);
                break;
            }
            case 1: {
                this.editDescription();
                break;
            }
            case 2: {
                this.download();
                break;
            }
            case 3: {
                if (!(this.data instanceof FileAnnotationData)) break;
                EventBus bus = MetadataViewerAgent.getRegistry().getEventBus();
                bus.post(new EditFileEvent((FileAnnotationData)this.data));
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("createNoParent".equals(name)) {
            TagAnnotationData tag = (TagAnnotationData)this.data;
            this.label.setToolTipText(this.formatTootTip((AnnotationData)tag));
            this.label.setText(tag.getTagValue());
            this.firePropertyChange("editTag", null, this);
        } else if ("approveSelection".equals(name)) {
            File folder = (File)evt.getNewValue();
            if (folder == null) {
                folder = UIUtilities.getDefaultFolder();
            }
            UserNotifier un = EditorAgent.getRegistry().getUserNotifier();
            un.notifyDownload((FileAnnotationData)this.data, folder);
        }
    }
}

