/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import omero.model.AcquisitionMode;
import omero.model.ContrastMethod;
import omero.model.Illumination;
import org.openmicroscopy.shoola.agents.metadata.editor.AcquisitionDataUI;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.util.DataComponent;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.data.model.EnumerationObject;
import org.openmicroscopy.shoola.util.ui.JLabelButton;
import org.openmicroscopy.shoola.util.ui.NumericalTextField;
import org.openmicroscopy.shoola.util.ui.OMEComboBox;
import org.openmicroscopy.shoola.util.ui.OMETextArea;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ChannelAcquisitionData;
import pojos.ChannelData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChannelAcquisitionComponent
extends JPanel
implements PropertyChangeListener {
    private static final String LASER_TYPE = "Laser";
    private static final String ARC_TYPE = "Arc";
    private static final String FILAMENT_TYPE = "Filament";
    private static final String EMITTING_DIODE_TYPE = "Emitting Diode";
    private static final int GENERAL = 0;
    private static final int LIGHT = 1;
    private static final int DETECTOR = 2;
    private AcquisitionDataUI parent;
    private ChannelData channel;
    private OMEComboBox illuminationBox;
    private OMEComboBox contrastMethodBox;
    private OMEComboBox modeBox;
    private OMEComboBox binningBox;
    private OMEComboBox detectorBox;
    private OMEComboBox laserMediumBox;
    private OMEComboBox lightTypeBox;
    private OMEComboBox arcTypeBox;
    private OMEComboBox filamentTypeBox;
    private OMEComboBox laserTypeBox;
    private OMEComboBox laserTuneableBox;
    private OMEComboBox laserPockelCellBox;
    private OMEComboBox laserPulseBox;
    private Map<String, DataComponent> fieldsGeneral;
    private Map<String, DataComponent> fieldsDetector;
    private Map<String, DataComponent> fieldsLight;
    private JLabelButton unsetLight;
    private boolean unsetLightShown;
    private JPanel lightPane;
    private JLabelButton unsetDetector;
    private boolean unsetDetectorShown;
    private JPanel detectorPane;
    private JLabelButton unsetGeneral;
    private boolean unsetGeneralShown;
    private JPanel generalPane;
    private boolean init;
    private EditorModel model;

    private void resetBoxes() {
        List<EnumerationObject> l = this.model.getChannelEnumerations(Editor.ILLUMINATION_TYPE);
        Object[] array = new EnumerationObject[l.size() + 1];
        Iterator<EnumerationObject> j = l.iterator();
        int i = 0;
        while (j.hasNext()) {
            array[i] = j.next();
            ++i;
        }
        array[i] = new EnumerationObject("Not Set");
        this.illuminationBox = EditorUtil.createComboBox(array);
        l = this.model.getChannelEnumerations(Editor.CONTRAST_METHOD);
        array = new EnumerationObject[l.size() + 1];
        j = l.iterator();
        i = 0;
        while (j.hasNext()) {
            array[i] = j.next();
            ++i;
        }
        array[i] = new EnumerationObject("Not Set");
        this.contrastMethodBox = EditorUtil.createComboBox(array);
        l = this.model.getChannelEnumerations(Editor.MODE);
        array = new EnumerationObject[l.size() + 1];
        j = l.iterator();
        i = 0;
        while (j.hasNext()) {
            array[i] = j.next();
            ++i;
        }
        array[i] = new EnumerationObject("Not Set");
        this.modeBox = EditorUtil.createComboBox(array);
        l = this.model.getChannelEnumerations(Editor.BINNING);
        array = new EnumerationObject[l.size() + 1];
        j = l.iterator();
        i = 0;
        while (j.hasNext()) {
            array[i] = j.next();
            ++i;
        }
        array[i] = new EnumerationObject("Not Set");
        this.binningBox = EditorUtil.createComboBox(array);
        l = this.model.getChannelEnumerations(Editor.DETECTOR_TYPE);
        array = new EnumerationObject[l.size() + 1];
        j = l.iterator();
        i = 0;
        while (j.hasNext()) {
            array[i] = j.next();
            ++i;
        }
        array[i] = new EnumerationObject("Not Set");
        this.detectorBox = EditorUtil.createComboBox(array);
        l = this.model.getChannelEnumerations(Editor.LASER_TYPE);
        this.laserTypeBox = EditorUtil.createComboBox(l);
        l = this.model.getChannelEnumerations(Editor.ARC_TYPE);
        this.arcTypeBox = EditorUtil.createComboBox(l);
        l = this.model.getChannelEnumerations(Editor.FILAMENT_TYPE);
        this.filamentTypeBox = EditorUtil.createComboBox(l);
        l = this.model.getChannelEnumerations(Editor.LASER_MEDIUM);
        this.laserMediumBox = EditorUtil.createComboBox(l);
        l = this.model.getChannelEnumerations(Editor.LASER_PULSE);
        array = new EnumerationObject[l.size() + 1];
        j = l.iterator();
        i = 0;
        while (j.hasNext()) {
            array[i] = j.next();
            ++i;
        }
        array[i] = new EnumerationObject("Not Set");
        this.laserPulseBox = EditorUtil.createComboBox(array);
    }

    private void initComponents() {
        this.resetBoxes();
        Object[] values = new String[]{"Yes", "No", "Not Set"};
        this.laserTuneableBox = EditorUtil.createComboBox(values);
        this.laserPockelCellBox = EditorUtil.createComboBox(values);
        values = new String[]{ARC_TYPE, EMITTING_DIODE_TYPE, FILAMENT_TYPE, LASER_TYPE, "Not Set"};
        this.lightTypeBox = EditorUtil.createComboBox(values);
        this.lightTypeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChannelAcquisitionComponent.this.handleLightSourceSelection();
            }
        });
        this.fieldsGeneral = new LinkedHashMap<String, DataComponent>();
        this.fieldsDetector = new LinkedHashMap<String, DataComponent>();
        this.fieldsLight = new LinkedHashMap<String, DataComponent>();
        this.unsetDetector = null;
        this.unsetDetectorShown = false;
        this.detectorPane = new JPanel();
        this.detectorPane.setBorder(BorderFactory.createTitledBorder("Camera"));
        this.detectorPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.detectorPane.setLayout(new GridBagLayout());
        this.unsetLight = null;
        this.unsetLightShown = false;
        this.lightPane = new JPanel();
        this.lightPane.setBorder(BorderFactory.createTitledBorder("Light"));
        this.lightPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.lightPane.setLayout(new GridBagLayout());
        this.unsetGeneral = null;
        this.unsetGeneralShown = false;
        this.generalPane = new JPanel();
        this.generalPane.setBorder(BorderFactory.createTitledBorder("Info"));
        this.generalPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.generalPane.setLayout(new GridBagLayout());
    }

    private void handleLightSourceSelection() {
        ChannelAcquisitionData data = this.model.getChannelAcquisitionData(this.channel.getIndex());
        String selected = (String)this.lightTypeBox.getSelectedItem();
        String kind = "";
        if (LASER_TYPE.equals(selected)) {
            kind = ChannelAcquisitionData.LASER;
        } else if (FILAMENT_TYPE.equals(selected)) {
            kind = ChannelAcquisitionData.FILAMENT;
        } else if (ARC_TYPE.equals(selected)) {
            kind = ChannelAcquisitionData.ARC;
        } else if (EMITTING_DIODE_TYPE.equals(selected)) {
            kind = ChannelAcquisitionData.LIGHT_EMITTING_DIODE;
        }
        this.fieldsLight.clear();
        Map<String, Object> d = EditorUtil.transformLightSource(kind, data);
        d.remove("Light");
        this.transformLightSource(kind, d);
        this.parent.layoutFields(this.lightPane, this.unsetLight, this.fieldsLight, this.unsetLightShown);
        this.revalidate();
        this.repaint();
    }

    private void displayUnsetLightFields() {
        this.unsetLightShown = !this.unsetLightShown;
        String s = "Show unset fields";
        if (this.unsetLightShown) {
            s = "Hide unset fields";
        }
        this.unsetLight.setText(s);
        this.parent.layoutFields(this.lightPane, this.unsetLight, this.fieldsLight, this.unsetLightShown);
    }

    private void transformLightSource(String kind, Map<String, Object> details) {
        String title = "Light Source";
        if (ChannelAcquisitionData.LASER.equals(kind)) {
            title = LASER_TYPE;
        } else if (ChannelAcquisitionData.ARC.equals(kind)) {
            title = ARC_TYPE;
        } else if (ChannelAcquisitionData.FILAMENT.equals(kind)) {
            title = FILAMENT_TYPE;
        } else if (ChannelAcquisitionData.LIGHT_EMITTING_DIODE.equals(kind)) {
            title = EMITTING_DIODE_TYPE;
        }
        this.lightPane.setBorder(BorderFactory.createTitledBorder(title));
        JComponent area = null;
        JLabel label = new JLabel();
        Font font = label.getFont();
        int sizeLabel = font.getSize() - 2;
        List notSet = (List)details.get("NotSet");
        details.remove("NotSet");
        if (notSet.size() > 0 && this.unsetLight == null) {
            this.unsetLight = this.parent.formatUnsetFieldsControl();
            this.unsetLight.setActionID(1);
            this.unsetLight.addPropertyChangeListener(this);
        }
        Set<Map.Entry<String, Object>> entrySet = details.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            boolean b;
            Object selected;
            String key = entry.getKey();
            boolean set = !notSet.contains(key);
            Object value = entry.getValue();
            label = UIUtilities.setTextFont(key, 1, sizeLabel);
            label.setBackground(UIUtilities.BACKGROUND_COLOR);
            if (ChannelAcquisitionData.LASER.equals(kind)) {
                if (key.equals("Type")) {
                    selected = this.model.getChannelEnumerationSelected(Editor.LASER_TYPE, (String)value);
                    if (selected != null) {
                        this.laserTypeBox.setSelectedItem(selected);
                        if (AcquisitionDataUI.UNSET_ENUM.contains(selected.toString())) {
                            set = false;
                        }
                    }
                    this.laserTypeBox.setEditedColor(UIUtilities.EDITED_COLOR);
                    area = this.laserTypeBox;
                } else if (key.equals("Medium")) {
                    selected = this.model.getChannelEnumerationSelected(Editor.LASER_MEDIUM, (String)value);
                    if (selected != null) {
                        this.laserMediumBox.setSelectedItem(selected);
                        if (AcquisitionDataUI.UNSET_ENUM.contains(selected.toString())) {
                            set = false;
                        }
                    }
                    this.laserMediumBox.setEditedColor(UIUtilities.EDITED_COLOR);
                    area = this.laserMediumBox;
                } else if (key.equals("Pulse")) {
                    selected = this.model.getChannelEnumerationSelected(Editor.LASER_PULSE, (String)value);
                    if (selected != null) {
                        this.laserPulseBox.setSelectedItem(selected);
                    } else {
                        set = false;
                        this.laserPulseBox.setSelectedIndex(this.laserPulseBox.getItemCount() - 1);
                    }
                    this.laserPulseBox.setEditedColor(UIUtilities.EDITED_COLOR);
                    area = this.laserPulseBox;
                } else if (key.equals("Tuneable")) {
                    if (value != null) {
                        b = (Boolean)value;
                        if (b) {
                            this.laserTuneableBox.setSelectedItem("Yes");
                        } else {
                            this.laserTuneableBox.setSelectedItem("No");
                        }
                    } else {
                        this.laserTuneableBox.setSelectedItem("Not Set");
                        set = false;
                    }
                    this.laserTuneableBox.setEditedColor(UIUtilities.EDITED_COLOR);
                    area = this.laserTuneableBox;
                } else if (key.equals("PockelCell")) {
                    if (value != null) {
                        b = (Boolean)value;
                        if (b) {
                            this.laserPockelCellBox.setSelectedItem("Yes");
                        } else {
                            this.laserPockelCellBox.setSelectedItem("No");
                        }
                    } else {
                        set = false;
                        this.laserPockelCellBox.setSelectedItem("Not Set");
                    }
                    this.laserPockelCellBox.setEditedColor(UIUtilities.EDITED_COLOR);
                    area = this.laserPockelCellBox;
                }
            } else if (ChannelAcquisitionData.ARC.equals(kind)) {
                if (key.equals("Type")) {
                    selected = this.model.getChannelEnumerationSelected(Editor.ARC_TYPE, (String)value);
                    if (selected != null) {
                        this.arcTypeBox.setSelectedItem(selected);
                        if (AcquisitionDataUI.UNSET_ENUM.contains(selected.toString())) {
                            set = false;
                        }
                    }
                    this.arcTypeBox.setEditedColor(UIUtilities.EDITED_COLOR);
                    area = this.arcTypeBox;
                }
            } else if (ChannelAcquisitionData.FILAMENT.equals(kind)) {
                if (key.equals("Type")) {
                    selected = this.model.getChannelEnumerationSelected(Editor.FILAMENT_TYPE, (String)value);
                    if (selected != null) {
                        this.filamentTypeBox.setSelectedItem(selected);
                        if (AcquisitionDataUI.UNSET_ENUM.contains(selected.toString())) {
                            set = false;
                        }
                    }
                    this.filamentTypeBox.setEditedColor(UIUtilities.EDITED_COLOR);
                    area = this.filamentTypeBox;
                }
            } else if (ChannelAcquisitionData.LIGHT_EMITTING_DIODE.equals(kind)) {
                if (key.equals("Type")) {
                    area = new JLabel();
                }
            } else {
                this.lightTypeBox.setSelectedIndex(this.lightTypeBox.getItemCount() - 1);
                area = this.lightTypeBox;
            }
            if (value instanceof Number) {
                area = UIUtilities.createComponent(NumericalTextField.class, null);
                if (value instanceof Double) {
                    ((NumericalTextField)area).setNumberType(Double.class);
                } else if (value instanceof Float) {
                    ((NumericalTextField)area).setNumberType(Float.class);
                }
                ((NumericalTextField)area).setText("" + value);
                ((NumericalTextField)area).setEditedColor(UIUtilities.EDITED_COLOR);
            } else if (key.equals("Pump")) {
                b = (Boolean)value;
                area = UIUtilities.createComponent(OMETextArea.class, null);
            } else if (key.equals("Model") || key.equals("Manufacturer") || key.equals("Serial Number")) {
                area = UIUtilities.createComponent(OMETextArea.class, null);
                if (value == null || value.equals("")) {
                    set = false;
                    value = "None";
                }
                ((OMETextArea)area).setEditable(false);
                ((OMETextArea)area).setText((String)value);
                ((OMETextArea)area).setEditedColor(UIUtilities.EDITED_COLOR);
            }
            if (area == null) continue;
            area.setEnabled(!set);
            DataComponent comp = new DataComponent(label, area);
            comp.setEnabled(false);
            comp.setSetField(!notSet.contains(key));
            this.fieldsLight.put(key, comp);
        }
    }

    private void displayUnsetDetectorFields() {
        this.unsetDetectorShown = !this.unsetDetectorShown;
        String s = "Show unset fields";
        if (this.unsetDetectorShown) {
            s = "Hide unset fields";
        }
        this.unsetDetector.setText(s);
        this.parent.layoutFields(this.detectorPane, this.unsetDetector, this.fieldsDetector, this.unsetDetectorShown);
    }

    private void transformDetectorSource(Map<String, Object> details) {
        JLabel label = new JLabel();
        Font font = label.getFont();
        int sizeLabel = font.getSize() - 2;
        List notSet = (List)details.get("NotSet");
        details.remove("NotSet");
        if (notSet.size() > 0 && this.unsetDetector == null) {
            this.unsetDetector = this.parent.formatUnsetFieldsControl();
            this.unsetDetector.setActionID(2);
            this.unsetDetector.addPropertyChangeListener(this);
        }
        Set<Map.Entry<String, Object>> entrySet = details.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            JComponent area;
            Object selected;
            String key = entry.getKey();
            boolean set = !notSet.contains(key);
            Object value = entry.getValue();
            label = UIUtilities.setTextFont(key, 1, sizeLabel);
            label.setBackground(UIUtilities.BACKGROUND_COLOR);
            if (key.equals("Binning")) {
                selected = this.model.getChannelEnumerationSelected(Editor.BINNING, (String)value);
                if (selected != null) {
                    this.binningBox.setSelectedItem(selected);
                } else {
                    set = false;
                    this.binningBox.setSelectedIndex(this.binningBox.getItemCount() - 1);
                }
                this.binningBox.setEditedColor(UIUtilities.EDITED_COLOR);
                area = this.binningBox;
            } else if (key.equals("Type")) {
                selected = this.model.getChannelEnumerationSelected(Editor.DETECTOR_TYPE, (String)value);
                if (selected != null) {
                    this.detectorBox.setSelectedItem(selected);
                } else {
                    set = false;
                    this.detectorBox.setSelectedIndex(this.detectorBox.getItemCount() - 1);
                }
                this.detectorBox.setEditedColor(UIUtilities.EDITED_COLOR);
                area = this.detectorBox;
            } else if (value instanceof Number) {
                area = UIUtilities.createComponent(NumericalTextField.class, null);
                if (value instanceof Double) {
                    ((NumericalTextField)area).setNumberType(Double.class);
                } else if (value instanceof Float) {
                    ((NumericalTextField)area).setNumberType(Float.class);
                }
                ((NumericalTextField)area).setText("" + value);
                ((NumericalTextField)area).setEditedColor(UIUtilities.EDITED_COLOR);
            } else {
                area = UIUtilities.createComponent(OMETextArea.class, null);
                if (value == null || value.equals("")) {
                    value = "None";
                }
                ((OMETextArea)area).setEditable(false);
                ((OMETextArea)area).setText((String)value);
                ((OMETextArea)area).setEditedColor(UIUtilities.EDITED_COLOR);
            }
            area.setEnabled(!set);
            DataComponent comp = new DataComponent(label, area);
            comp.setEnabled(false);
            comp.setSetField(!notSet.contains(key));
            this.fieldsDetector.put(key, comp);
        }
    }

    private void displayUnsetGeneralFields() {
        this.unsetGeneralShown = !this.unsetGeneralShown;
        String s = "Show unset fields";
        if (this.unsetGeneralShown) {
            s = "Hide unset fields";
        }
        this.unsetGeneral.setText(s);
        this.parent.layoutFields(this.generalPane, this.unsetGeneral, this.fieldsGeneral, this.unsetGeneralShown);
    }

    private void transformGeneralSource(Map<String, Object> details) {
        JLabel label = new JLabel();
        Font font = label.getFont();
        int sizeLabel = font.getSize() - 2;
        List notSet = (List)details.get("NotSet");
        details.remove("NotSet");
        if (notSet.size() > 0 && this.unsetGeneral == null) {
            this.unsetGeneral = this.parent.formatUnsetFieldsControl();
            this.unsetGeneral.setActionID(0);
            this.unsetGeneral.addPropertyChangeListener(this);
        }
        Set<Map.Entry<String, Object>> entrySet = details.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            JComponent area;
            Object selected;
            String key = entry.getKey();
            boolean set = !notSet.contains(key);
            Object value = entry.getValue();
            label = UIUtilities.setTextFont(key, 1, sizeLabel);
            label.setBackground(UIUtilities.BACKGROUND_COLOR);
            if (key.equals("Illumination")) {
                selected = this.model.getChannelEnumerationSelected(Editor.ILLUMINATION_TYPE, (String)value);
                if (selected != null) {
                    this.illuminationBox.setSelectedItem(selected);
                } else {
                    set = false;
                    this.illuminationBox.setSelectedIndex(this.illuminationBox.getItemCount() - 1);
                }
                this.illuminationBox.setEditedColor(UIUtilities.EDITED_COLOR);
                area = this.illuminationBox;
            } else if (key.equals("Contrast Method")) {
                selected = this.model.getChannelEnumerationSelected(Editor.ILLUMINATION_TYPE, (String)value);
                if (selected != null) {
                    this.contrastMethodBox.setSelectedItem(selected);
                } else {
                    set = false;
                    this.contrastMethodBox.setSelectedIndex(this.contrastMethodBox.getItemCount() - 1);
                }
                this.contrastMethodBox.setEditedColor(UIUtilities.EDITED_COLOR);
                area = this.contrastMethodBox;
            } else if (key.equals("Mode")) {
                selected = this.model.getChannelEnumerationSelected(Editor.MODE, (String)value);
                if (selected != null) {
                    this.modeBox.setSelectedItem(selected);
                } else {
                    set = false;
                    this.modeBox.setSelectedIndex(this.modeBox.getItemCount() - 1);
                }
                this.modeBox.setEditedColor(UIUtilities.EDITED_COLOR);
                area = this.modeBox;
            } else if (value instanceof Number) {
                area = UIUtilities.createComponent(NumericalTextField.class, null);
                if (value instanceof Double) {
                    ((NumericalTextField)area).setNumberType(Double.class);
                } else if (value instanceof Float) {
                    ((NumericalTextField)area).setNumberType(Float.class);
                }
                ((NumericalTextField)area).setText("" + value);
                ((NumericalTextField)area).setEditedColor(UIUtilities.EDITED_COLOR);
            } else {
                area = UIUtilities.createComponent(OMETextArea.class, null);
                if (value == null || value.equals("")) {
                    set = false;
                    value = "None";
                }
                ((OMETextArea)area).setEditable(false);
                ((OMETextArea)area).setText((String)value);
                ((OMETextArea)area).setEditedColor(UIUtilities.EDITED_COLOR);
            }
            area.setEnabled(!set);
            DataComponent comp = new DataComponent(label, area);
            comp.setEnabled(false);
            comp.setSetField(!notSet.contains(key));
            this.fieldsGeneral.put(key, comp);
        }
    }

    private void buildGUI() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new BoxLayout(this, 1));
        this.parent.layoutFields(this.detectorPane, this.unsetDetector, this.fieldsDetector, this.unsetDetectorShown);
        this.parent.layoutFields(this.lightPane, this.unsetLight, this.fieldsLight, this.unsetLightShown);
        this.parent.layoutFields(this.generalPane, this.unsetGeneral, this.fieldsGeneral, this.unsetGeneralShown);
        this.add(this.generalPane);
        this.add(this.detectorPane);
        this.add(this.lightPane);
        this.parent.attachListener(this.fieldsGeneral);
        this.parent.attachListener(this.fieldsDetector);
        this.parent.attachListener(this.fieldsLight);
    }

    ChannelAcquisitionComponent(AcquisitionDataUI parent, EditorModel model, ChannelData channel) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("No parent.");
        }
        if (channel == null) {
            throw new IllegalArgumentException("No channel.");
        }
        this.model = model;
        this.channel = channel;
        this.parent = parent;
        this.initComponents();
    }

    void setChannelAcquisitionData(int index) {
        if (this.channel.getIndex() != index) {
            return;
        }
        if (!this.init) {
            this.init = true;
            this.resetBoxes();
            this.removeAll();
            this.fieldsGeneral.clear();
            this.fieldsDetector.clear();
            this.fieldsLight.clear();
            this.transformGeneralSource(EditorUtil.transformChannelData(this.channel));
            ChannelAcquisitionData data = this.model.getChannelAcquisitionData(this.channel.getIndex());
            this.transformDetectorSource(EditorUtil.transformDetector(data));
            Map<String, Object> details = EditorUtil.transformLightSource(null, data);
            String kind = (String)details.get("Light");
            details.remove("Light");
            this.transformLightSource(kind, details);
            this.buildGUI();
        }
    }

    boolean hasDataToSave() {
        boolean b = this.parent.hasDataToSave(this.fieldsGeneral);
        if (b) {
            return true;
        }
        b = this.parent.hasDataToSave(this.fieldsDetector);
        if (b) {
            return true;
        }
        b = this.parent.hasDataToSave(this.fieldsLight);
        return b;
    }

    List<Object> prepareDataToSave() {
        Number number;
        Object value;
        DataComponent comp;
        String key;
        ArrayList<Object> data = new ArrayList<Object>();
        if (!this.hasDataToSave()) {
            return data;
        }
        if (this.channel.isDirty()) {
            for (Map.Entry<String, DataComponent> entry : this.fieldsGeneral.entrySet()) {
                EnumerationObject enumObject;
                key = entry.getKey();
                comp = entry.getValue();
                if (!comp.isDirty()) continue;
                value = comp.getAreaValue();
                if ("Name".equals(key)) {
                    this.channel.setName((String)value);
                    continue;
                }
                if ("Pin hole size (\u00b5m)".equals(key)) {
                    number = UIUtilities.extractNumber((String)value, Float.class);
                    if (number == null) continue;
                    this.channel.setPinholeSize((double)((Float)number).floatValue());
                    continue;
                }
                if ("ND Filter (%)".equals(key)) {
                    number = UIUtilities.extractNumber((String)value, Float.class);
                    if (number == null) continue;
                    this.channel.setNDFilter((double)((Float)number).floatValue());
                    continue;
                }
                if ("PockelCell".equals(key)) {
                    number = UIUtilities.extractNumber((String)value, Integer.class);
                    if (number == null) continue;
                    this.channel.setPockelCell(((Integer)value).intValue());
                    continue;
                }
                if ("Emission".equals(key)) {
                    number = UIUtilities.extractNumber((String)value, Integer.class);
                    if (number == null) continue;
                    this.channel.setEmissionWavelength(((Integer)number).intValue());
                    continue;
                }
                if ("Excitation".equals(key)) {
                    number = UIUtilities.extractNumber((String)value, Integer.class);
                    if (number == null) continue;
                    this.channel.setExcitationWavelength(((Integer)number).intValue());
                    continue;
                }
                if ("Illumination".equals(key)) {
                    enumObject = (EnumerationObject)value;
                    if (!(enumObject.getObject() instanceof Illumination)) continue;
                    this.channel.setIllumination((Illumination)enumObject.getObject());
                    continue;
                }
                if ("Mode".equals(key)) {
                    enumObject = (EnumerationObject)value;
                    if (!(enumObject.getObject() instanceof AcquisitionMode)) continue;
                    this.channel.setMode((AcquisitionMode)enumObject.getObject());
                    continue;
                }
                if (!"Contrast Method".equals(key) || !((enumObject = (EnumerationObject)value).getObject() instanceof ContrastMethod)) continue;
                this.channel.setContrastMethod((ContrastMethod)enumObject.getObject());
            }
            data.add(this.channel);
        }
        ChannelAcquisitionData metadata = this.model.getChannelAcquisitionData(this.channel.getIndex());
        for (Map.Entry<String, DataComponent> entry : this.fieldsDetector.entrySet()) {
            key = entry.getKey();
            comp = entry.getValue();
            if (comp.isDirty()) {
                value = comp.getAreaValue();
                if ("Model".equals(key)) {
                    metadata.setDetectorModel((String)value);
                } else if ("Manufacturer".equals(key)) {
                    metadata.setDetectorManufacturer((String)value);
                } else if ("Serial Number".equals(key)) {
                    metadata.setDetectorSerialNumber((String)value);
                } else if (!("Gain".equals(key) || "Voltage".equals(key) || "Offset".equals(key) || "Read out rate".equals(key))) {
                    if ("Zoom".equals(key)) {
                        number = UIUtilities.extractNumber((String)value, Float.class);
                        if (number != null) {
                            metadata.setDetectorZoom((double)((Float)number).floatValue());
                        }
                    } else if ("Amplification Gain".equals(key) && (number = UIUtilities.extractNumber((String)value, Float.class)) != null) {
                        metadata.setDetectorAmplificationGain((double)((Float)number).floatValue());
                    }
                }
            }
            data.add(metadata);
        }
        return data;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("selected".equals(name)) {
            int id = (Integer)evt.getNewValue();
            switch (id) {
                case 0: {
                    this.displayUnsetGeneralFields();
                    break;
                }
                case 1: {
                    this.displayUnsetLightFields();
                    break;
                }
                case 2: {
                    this.displayUnsetDetectorFields();
                }
            }
        }
    }
}

