/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import layout.TableLayout;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationUI;
import org.openmicroscopy.shoola.agents.metadata.editor.DocComponent;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.ViewedByComponent;
import org.openmicroscopy.shoola.env.data.util.ViewedByDef;
import org.openmicroscopy.shoola.util.ui.RatingComponent;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.border.SeparatorOneLineBorder;
import pojos.AnnotationData;
import pojos.FileAnnotationData;
import pojos.ImageData;
import pojos.RatingAnnotationData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnnotationDataUI
extends AnnotationUI
implements PropertyChangeListener {
    private RatingComponent rating;
    private JPanel tagsPane;
    private JPanel docPane;
    private JPanel viewedByPane;
    private int selectedValue;
    private int initialValue;
    private int viewedByRow;
    private int tagRow;
    private JPanel content;
    private Map<Long, ViewedByComponent> viewedBy;
    private JButton addTagsButton;
    private JButton addDocsButton;
    private EditorControl controller;
    private boolean tagFlag;
    private boolean docFlag;
    private List<String> tagNames;
    private Map<String, TagAnnotationData> existingTags;
    private JPopupMenu docSelectionMenu;
    private List<DocComponent> tagsDocList;
    private List<DocComponent> filesDocList;

    private JPopupMenu createDocSelectionMenu() {
        if (this.docSelectionMenu != null) {
            return this.docSelectionMenu;
        }
        this.docSelectionMenu = new JPopupMenu();
        JMenuItem item = new JMenuItem("Local document...");
        item.setToolTipText("Import a local document to the server and attach it.");
        item.addActionListener(this.controller);
        item.setActionCommand("0");
        this.docSelectionMenu.add(item);
        item = new JMenuItem("Uploaded document...");
        item.setToolTipText("Attach a document already uploaded.");
        item.addActionListener(this.controller);
        item.setActionCommand("1");
        this.docSelectionMenu.add(item);
        item = new JMenuItem("New Experiment...");
        item.setEnabled(this.controller.isSingleMode());
        item.setToolTipText("Create a new experiment.");
        item.addActionListener(this.controller);
        item.setActionCommand("6");
        this.docSelectionMenu.add(item);
        return this.docSelectionMenu;
    }

    private void initComponents() {
        this.tagFlag = false;
        this.docFlag = false;
        this.tagNames = new ArrayList<String>();
        this.tagsDocList = new ArrayList<DocComponent>();
        this.filesDocList = new ArrayList<DocComponent>();
        this.existingTags = new HashMap<String, TagAnnotationData>();
        IconManager icons = IconManager.getInstance();
        this.addTagsButton = new JButton(icons.getIcon(56));
        UIUtilities.unifiedButtonLookAndFeel(this.addTagsButton);
        this.addTagsButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.addTagsButton.setToolTipText("Add Tags.");
        this.addTagsButton.addActionListener(this.controller);
        this.addTagsButton.setActionCommand("2");
        this.addDocsButton = new JButton(icons.getIcon(56));
        this.addDocsButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.addDocsButton.setToolTipText("Attach a document.");
        this.addDocsButton.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                Point p = e.getPoint();
                AnnotationDataUI.this.createDocSelectionMenu().show(AnnotationDataUI.this.addDocsButton, p.x, p.y);
            }
        });
        UIUtilities.unifiedButtonLookAndFeel(this.addDocsButton);
        this.viewedBy = new HashMap<Long, ViewedByComponent>();
        this.initialValue = this.selectedValue = 0;
        this.rating = new RatingComponent(this.selectedValue, 1);
        this.rating.setOpaque(false);
        this.rating.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.rating.addPropertyChangeListener("rate", this);
        this.tagsPane = new JPanel();
        this.tagsPane.setLayout(new BoxLayout(this.tagsPane, 1));
        this.tagsPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        DocComponent doc = new DocComponent(null, this.model);
        this.tagsDocList.add(doc);
        this.tagsPane.add(doc);
        this.docPane = new JPanel();
        this.docPane.setLayout(new BoxLayout(this.docPane, 1));
        this.docPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        doc = new DocComponent(null, this.model);
        this.filesDocList.add(doc);
        this.docPane.add(doc);
        this.viewedByPane = new JPanel();
        this.viewedByPane.setLayout(new BoxLayout(this.viewedByPane, 1));
        this.viewedByPane.setOpaque(false);
        this.viewedByPane.setBackground(UIUtilities.BACKGROUND_COLOR);
    }

    private JToolBar createBar(JButton button) {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setBorder(null);
        bar.setBackground(UIUtilities.BACKGROUND_COLOR);
        bar.add(button);
        return bar;
    }

    private void buildGUI() {
        JLabel l = new JLabel();
        Font f = l.getFont();
        int size = f.getSize() - 1;
        this.content = new JPanel();
        this.content.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.content.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        double[] columns = new double[]{-2.0, 5.0, 300.0};
        TableLayout layout = new TableLayout();
        this.content.setLayout((LayoutManager)layout);
        layout.setColumn(columns);
        int i = 0;
        JPanel p = UIUtilities.buildComponentPanel(this.rating, 0, 0);
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        layout.insertRow(i, -2.0);
        this.content.add((Component)UIUtilities.setTextFont("rate", 1, size), "0, " + i);
        this.content.add((Component)p, "2, " + i);
        layout.insertRow(++i, -2.0);
        p = new JPanel(new FlowLayout(0, 0, 0));
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add(UIUtilities.setTextFont("tag", 1, size));
        p.add(this.createBar(this.addTagsButton));
        this.content.add((Component)p, "0, " + i + ", l, t");
        this.content.add((Component)this.tagsPane, "2, " + i);
        this.tagRow = i++;
        layout.insertRow(i, -2.0);
        p = new JPanel(new FlowLayout(0, 0, 0));
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add(UIUtilities.setTextFont("attachment", 1, size));
        p.add(this.createBar(this.addDocsButton));
        this.content.add((Component)p, "0, " + i + ", l, t");
        this.content.add((Component)this.docPane, "2, " + i);
        layout.insertRow(++i, 0.0);
        this.content.add((Component)UIUtilities.setTextFont("viewed by", 1, size), "0, " + i + ", l, t");
        p = UIUtilities.buildComponentPanel(this.viewedByPane, 0, 0);
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.content.add((Component)this.viewedByPane, "2, " + i);
        this.viewedByRow = i;
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setBackground(UIUtilities.BACKGROUND);
        this.setBorder(new SeparatorOneLineBorder());
        this.add(this.content);
    }

    private JPanel initRow() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        return p;
    }

    private JPanel layoutRow(JPanel row) {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(0, 0, 0));
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        Component[] comps = row.getComponents();
        row.removeAll();
        for (int i = 0; i < comps.length; ++i) {
            row.add(comps[i]);
            if (i >= comps.length - 1) continue;
            JLabel l = new JLabel();
            l.setBackground(UIUtilities.BACKGROUND_COLOR);
            l.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
            l.setText(", ");
            row.add(l);
        }
        p.add(row);
        return p;
    }

    private boolean layoutViewedBy() {
        Collection views = this.model.getViewedBy();
        this.viewedByPane.removeAll();
        this.viewedBy.clear();
        if (views == null || views.size() == 0) {
            return false;
        }
        Iterator i = views.iterator();
        JPanel p = this.initRow();
        int width = 0;
        while (i.hasNext()) {
            ViewedByDef def = (ViewedByDef)i.next();
            ViewedByComponent comp = new ViewedByComponent(def, this.model);
            this.viewedBy.put(def.getExperimenter().getId(), comp);
            if (width + comp.getPreferredSize().width >= 200) {
                this.viewedByPane.add(this.layoutRow(p));
                p = this.initRow();
                width = 0;
            } else {
                width += comp.getPreferredSize().width;
            }
            p.add(comp);
        }
        if (p.getComponentCount() > 0) {
            this.viewedByPane.add(this.layoutRow(p));
        }
        return true;
    }

    private void layoutAttachments(Collection list) {
        DocComponent doc;
        this.docPane.removeAll();
        this.filesDocList.clear();
        if (list != null && list.size() > 0) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                doc = new DocComponent(i.next(), this.model);
                doc.addPropertyChangeListener(this.controller);
                this.filesDocList.add(doc);
                this.docPane.add(doc);
            }
        }
        if (this.filesDocList.size() == 0) {
            doc = new DocComponent(null, this.model);
            this.filesDocList.add(doc);
            this.docPane.add(doc);
        }
        this.docPane.revalidate();
        this.docPane.repaint();
    }

    private void layoutTags(Collection list) {
        DocComponent doc;
        this.tagsPane.removeAll();
        this.tagsDocList.clear();
        if (list != null && list.size() > 0) {
            Iterator i = list.iterator();
            int width = 0;
            JPanel p = this.initRow();
            while (i.hasNext()) {
                doc = new DocComponent(i.next(), this.model);
                doc.addPropertyChangeListener(this.controller);
                this.tagsDocList.add(doc);
                if (width + doc.getPreferredSize().width >= 200) {
                    this.tagsPane.add(p);
                    p = this.initRow();
                    width = 0;
                } else {
                    width += doc.getPreferredSize().width;
                }
                p.add(doc);
            }
            if (p.getComponentCount() > 0) {
                this.tagsPane.add(p);
            }
        }
        if (this.tagsDocList.size() == 0) {
            doc = new DocComponent(null, this.model);
            this.tagsDocList.add(doc);
            this.tagsPane.add(doc);
        }
        this.tagsPane.revalidate();
        this.tagsPane.repaint();
    }

    AnnotationDataUI(EditorModel model, EditorControl controller) {
        super(model);
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.controller = controller;
        this.initComponents();
        this.buildGUI();
    }

    void setThumbnails() {
        Map<Long, BufferedImage> thumbnails = this.model.getThumbnails();
        if (thumbnails == null) {
            return;
        }
        Set<Map.Entry<Long, BufferedImage>> set = thumbnails.entrySet();
        for (Map.Entry<Long, BufferedImage> entry : set) {
            ViewedByComponent comp = this.viewedBy.get(entry.getKey());
            if (comp == null) continue;
            comp.setThumbnail(entry.getValue());
        }
    }

    @Override
    protected void buildUI() {
        this.selectedValue = 0;
        if (!this.model.isMultiSelection()) {
            this.selectedValue = this.model.getUserRating();
        }
        this.initialValue = this.selectedValue;
        this.rating.setValue(this.selectedValue);
        this.layoutAttachments(this.model.getAttachments());
        Object refObject = this.model.getRefObject();
        TableLayout layout = (TableLayout)this.content.getLayout();
        double h = 0.0;
        double hTag = 0.0;
        if (!this.model.isMultiSelection()) {
            if (refObject instanceof ImageData && this.layoutViewedBy()) {
                h = -2.0;
            }
            this.layoutTags(this.model.getTags());
            hTag = -2.0;
        }
        layout.setRow(this.viewedByRow, h);
        layout.setRow(this.tagRow, hTag);
        this.content.revalidate();
        this.content.repaint();
        this.revalidate();
        this.repaint();
    }

    void attachFile(File file) {
        Object data;
        List<FileAnnotationData> list = this.getCurrentAttachmentsSelection();
        boolean exist = false;
        if (this.filesDocList.size() > 0) {
            for (DocComponent doc : this.filesDocList) {
                File f;
                data = doc.getData();
                if (!(data instanceof File) || !(f = (File)doc.getData()).equals(file)) continue;
                exist = true;
            }
        }
        if (!exist) {
            data = null;
            try {
                this.docFlag = true;
                list.add(new FileAnnotationData(file));
            }
            catch (Exception e) {
                // empty catch block
            }
            this.firePropertyChange("save", Boolean.FALSE, Boolean.TRUE);
        }
        this.layoutAttachments(list);
    }

    void removeAttachedFile(Object file) {
        if (file == null) {
            return;
        }
        FileAnnotationData fData = (FileAnnotationData)file;
        List<FileAnnotationData> attachments = this.getCurrentAttachmentsSelection();
        Iterator<FileAnnotationData> i = attachments.iterator();
        ArrayList<FileAnnotationData> toKeep = new ArrayList<FileAnnotationData>();
        while (i.hasNext()) {
            FileAnnotationData data = i.next();
            if (data.getId() == fData.getId()) continue;
            toKeep.add(data);
        }
        this.handleObjectsSelection(FileAnnotationData.class, toKeep);
    }

    void removeTag(TagAnnotationData tag) {
        if (tag == null) {
            return;
        }
        List<TagAnnotationData> tags = this.getCurrentTagsSelection();
        Iterator<TagAnnotationData> i = tags.iterator();
        ArrayList<TagAnnotationData> toKeep = new ArrayList<TagAnnotationData>();
        while (i.hasNext()) {
            TagAnnotationData data = i.next();
            if (data.getId() == tag.getId()) continue;
            toKeep.add(data);
        }
        this.handleObjectsSelection(TagAnnotationData.class, toKeep);
    }

    void handleObjectsSelection(Class type, Collection objects) {
        if (objects == null) {
            return;
        }
        if (TagAnnotationData.class.equals((Object)type)) {
            this.layoutTags(objects);
            ArrayList<Long> ids = new ArrayList<Long>();
            Iterator i = objects.iterator();
            this.tagFlag = false;
            Collection tags = this.model.getTags();
            if (tags == null || tags.size() != objects.size()) {
                this.tagFlag = true;
            } else {
                while (i.hasNext()) {
                    TagAnnotationData tag = (TagAnnotationData)i.next();
                    ids.add(tag.getId());
                }
                for (TagAnnotationData tag : tags) {
                    if (ids.contains(tag.getId())) continue;
                    this.tagFlag = true;
                    break;
                }
            }
        } else if (FileAnnotationData.class.equals((Object)type)) {
            this.layoutAttachments(objects);
            ArrayList<Long> ids = new ArrayList<Long>();
            Iterator i = objects.iterator();
            this.docFlag = false;
            Collection attachments = this.model.getAttachments();
            if (attachments == null || attachments.size() != objects.size()) {
                this.docFlag = true;
            } else {
                while (i.hasNext()) {
                    FileAnnotationData data = (FileAnnotationData)i.next();
                    ids.add(data.getId());
                }
                for (FileAnnotationData data : attachments) {
                    if (ids.contains(data.getId())) continue;
                    this.docFlag = true;
                    break;
                }
            }
        }
        this.firePropertyChange("save", Boolean.FALSE, Boolean.TRUE);
    }

    List<TagAnnotationData> getCurrentTagsSelection() {
        ArrayList<TagAnnotationData> selection = new ArrayList<TagAnnotationData>();
        if (this.tagsDocList.size() == 0) {
            return selection;
        }
        for (DocComponent doc : this.tagsDocList) {
            TagAnnotationData tag;
            Object object = doc.getData();
            if (!(object instanceof TagAnnotationData) || (tag = (TagAnnotationData)object).getId() <= 0L) continue;
            selection.add(tag);
        }
        return selection;
    }

    List<FileAnnotationData> getCurrentAttachmentsSelection() {
        ArrayList<FileAnnotationData> list = new ArrayList<FileAnnotationData>();
        if (this.filesDocList.size() == 0) {
            return list;
        }
        for (DocComponent doc : this.filesDocList) {
            FileAnnotationData data;
            Object object = doc.getData();
            if (!(object instanceof FileAnnotationData) || (data = (FileAnnotationData)object).getId() <= 0L) continue;
            list.add(data);
        }
        return list;
    }

    @Override
    protected String getComponentTitle() {
        return "";
    }

    @Override
    protected List<AnnotationData> getAnnotationToRemove() {
        Collection original;
        long id;
        Object object;
        ArrayList<Long> idsToKeep;
        RatingAnnotationData rating;
        ArrayList<AnnotationData> l = new ArrayList<AnnotationData>();
        if (this.selectedValue != this.initialValue && this.selectedValue == 0 && (rating = this.model.getUserRatingAnnotation()) != null) {
            l.add((AnnotationData)rating);
        }
        if (this.tagFlag && !this.model.isMultiSelection()) {
            idsToKeep = new ArrayList();
            for (DocComponent doc : this.tagsDocList) {
                TagAnnotationData tag;
                object = doc.getData();
                if (!(object instanceof TagAnnotationData) || (id = (tag = (TagAnnotationData)object).getId()) <= 0L) continue;
                idsToKeep.add(id);
            }
            original = this.model.getTags();
            for (TagAnnotationData tag : original) {
                id = tag.getId();
                if (idsToKeep.contains(id)) continue;
                l.add((AnnotationData)tag);
            }
        }
        if (this.docFlag) {
            idsToKeep = new ArrayList<Long>();
            for (DocComponent doc : this.filesDocList) {
                FileAnnotationData fa;
                object = doc.getData();
                if (!(object instanceof FileAnnotationData) || (id = (fa = (FileAnnotationData)object).getId()) <= 0L) continue;
                idsToKeep.add(id);
            }
            original = this.model.getAttachments();
            for (FileAnnotationData fa : original) {
                id = fa.getId();
                if (idsToKeep.contains(id)) continue;
                l.add((AnnotationData)fa);
            }
        }
        return l;
    }

    @Override
    protected List<AnnotationData> getAnnotationToSave() {
        AnnotationData annotation;
        long id;
        Object object;
        ArrayList<Long> ids;
        Iterator j;
        Collection original;
        ArrayList<AnnotationData> l = new ArrayList<AnnotationData>();
        if (this.tagFlag) {
            original = this.model.getTags();
            j = original.iterator();
            ids = new ArrayList<Long>();
            while (j.hasNext()) {
                ids.add(((AnnotationData)j.next()).getId());
            }
            for (DocComponent doc : this.tagsDocList) {
                object = doc.getData();
                if (!(object instanceof TagAnnotationData) || ids.contains(id = (annotation = (AnnotationData)object).getId())) continue;
                l.add(annotation);
            }
        }
        for (DocComponent doc : this.tagsDocList) {
            object = doc.getData();
            if (!doc.hasBeenModified() || l.contains(annotation = (AnnotationData)object)) continue;
            l.add(annotation);
        }
        if (this.docFlag) {
            original = this.model.getAttachments();
            j = original.iterator();
            ids = new ArrayList();
            while (j.hasNext()) {
                ids.add(((AnnotationData)j.next()).getId());
            }
            for (DocComponent doc : this.filesDocList) {
                object = doc.getData();
                if (!(object instanceof FileAnnotationData) || ids.contains(id = (annotation = (AnnotationData)object).getId())) continue;
                l.add(annotation);
            }
        }
        if (this.selectedValue != this.initialValue) {
            l.add((AnnotationData)new RatingAnnotationData(this.selectedValue));
        }
        return l;
    }

    @Override
    protected boolean hasDataToSave() {
        if (this.tagFlag || this.docFlag) {
            return true;
        }
        Iterator<DocComponent> i = this.tagsDocList.iterator();
        while (i.hasNext()) {
            if (!i.next().hasBeenModified()) continue;
            return true;
        }
        return this.selectedValue != this.initialValue;
    }

    @Override
    protected void clearData() {
        this.tagNames.clear();
        this.existingTags.clear();
        this.selectedValue = 0;
        if (!this.model.isMultiSelection()) {
            this.selectedValue = this.model.getUserRating();
        }
        this.initialValue = 0;
        this.rating.removePropertyChangeListener("rate", this);
        this.rating.setValue(this.selectedValue);
        this.rating.addPropertyChangeListener("rate", this);
        this.tagsPane.removeAll();
        this.tagsDocList.clear();
        DocComponent doc = new DocComponent(null, this.model);
        this.tagsDocList.add(doc);
        this.tagsPane.add(doc);
        this.docPane.removeAll();
        doc = new DocComponent(null, this.model);
        this.filesDocList.add(doc);
        this.docPane.add(doc);
        this.tagFlag = false;
        this.docFlag = false;
        double h = 0.0;
        if (!this.model.isMultiSelection()) {
            h = -2.0;
        }
        TableLayout layout = (TableLayout)this.content.getLayout();
        layout.setRow(this.tagRow, h);
        this.content.revalidate();
        this.content.repaint();
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void clearDisplay() {
        this.clearData();
    }

    @Override
    protected void setComponentTitle() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int newValue;
        String name = evt.getPropertyName();
        if ("rate".equals(name) && (newValue = ((Integer)evt.getNewValue()).intValue()) != this.selectedValue) {
            this.selectedValue = newValue;
            this.firePropertyChange("save", Boolean.FALSE, Boolean.TRUE);
        }
    }
}

