/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.browser;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import layout.TableLayout;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.metadata.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserDisplay;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserNode;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserSet;
import org.openmicroscopy.shoola.agents.metadata.util.TreeCellRenderer;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;

class BrowserUI
extends JPanel
implements ActionListener {
    static final String LOADING_MSG = "Loading...";
    static final String NO_PARENTS_MSG = "Wild and Free";
    private static final int VIEW = 0;
    private static final String EMPTY_MSG = "";
    private BrowserControl controller;
    private BrowserModel model;
    private JTree treeDisplay;
    private JToolBar menuBar;
    private TreeExpansionListener listener;
    private TreeSelectionListener selectionListener;
    private JPopupMenu menu;
    private ViewerSorter sorter;

    private JPopupMenu createManagementMenu() {
        if (this.menu != null) {
            return this.menu;
        }
        this.menu = new JPopupMenu();
        this.menu.setBorder(BorderFactory.createBevelBorder(0));
        IconManager icons = IconManager.getInstance();
        JMenuItem item = new JMenuItem("Browse");
        item.setActionCommand("0");
        item.addActionListener(this);
        item.setIcon(icons.getIcon(12));
        this.menu.add(item);
        return this.menu;
    }

    private void handleMouseClick(MouseEvent evt) {
    }

    private void createMenuBar() {
        this.menuBar = new JToolBar();
        this.menuBar.setBorder(null);
        this.menuBar.setRollover(true);
        this.menuBar.setFloatable(false);
    }

    private void buildEmptyNode(DefaultMutableTreeNode node) {
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        tm.insertNodeInto(new DefaultMutableTreeNode(EMPTY_MSG), node, node.getChildCount());
    }

    private void addMenuToNode(TreeBrowserDisplay parent) {
        if (parent instanceof TreeBrowserSet) {
            this.buildEmptyNode(parent);
        }
    }

    private void createTree() {
        this.treeDisplay = new JTree();
        this.treeDisplay.setVisible(true);
        this.treeDisplay.setRootVisible(false);
        this.treeDisplay.setCellRenderer(new TreeCellRenderer());
        this.treeDisplay.setShowsRootHandles(true);
        ToolTipManager.sharedInstance().registerComponent(this.treeDisplay);
        TreeBrowserDisplay root = this.model.getLastSelectedNode();
        this.treeDisplay.setModel(new DefaultTreeModel(root));
        this.treeDisplay.expandPath(new TreePath(root.getPath()));
        this.treeDisplay.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                BrowserUI.this.handleMouseClick(e);
            }

            public void mouseReleased(MouseEvent e) {
                BrowserUI.this.handleMouseClick(e);
            }
        });
        this.selectionListener = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                BrowserUI.this.controller.onClick();
            }
        };
        this.treeDisplay.addTreeSelectionListener(this.selectionListener);
        this.listener = new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent e) {
                BrowserUI.this.onNodeNavigation(e, false);
            }

            public void treeExpanded(TreeExpansionEvent e) {
                BrowserUI.this.onNodeNavigation(e, true);
            }
        };
        this.treeDisplay.addTreeExpansionListener(this.listener);
    }

    private void onNodeNavigation(TreeExpansionEvent tee, boolean expanded) {
        TreeBrowserDisplay node = (TreeBrowserDisplay)tee.getPath().getLastPathComponent();
        node.setExpanded(expanded);
        this.controller.onNodeNavigation(node, expanded);
    }

    private void buildGUI() {
        double[][] size = new double[][]{{-1.0}, {100.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])size));
        this.add((Component)new JScrollPane(this.treeDisplay), "0, 0");
    }

    BrowserUI() {
    }

    void initialize(BrowserModel model, BrowserControl controller) {
        if (controller == null) {
            throw new IllegalArgumentException("Controller cannot be null");
        }
        if (model == null) {
            throw new IllegalArgumentException("Model cannot be null");
        }
        this.controller = controller;
        this.model = model;
        this.sorter = new ViewerSorter();
        this.createMenuBar();
        this.createTree();
        this.buildGUI();
    }

    JTree getTreeDisplay() {
        return this.treeDisplay;
    }

    void setRootNode() {
        this.treeDisplay.removeAll();
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        TreeBrowserDisplay root = this.model.getLastSelectedNode();
        this.treeDisplay.setModel(new DefaultTreeModel(root));
        tm.reload(root);
    }

    void addDefaultNode(String message) {
        this.addDefaultNode(this.model.getRoot(), message);
    }

    void addDefaultNode(TreeBrowserDisplay node, String message) {
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        node.removeAllChildren();
        tm.insertNodeInto(new TreeBrowserNode(message), node, node.getChildCount());
        tm.reload(node);
    }

    void setNodes(TreeBrowserDisplay parent, Collection nodes) {
        List sortedNodes = this.sorter.sort(nodes);
        DefaultTreeModel tm = (DefaultTreeModel)this.treeDisplay.getModel();
        parent.removeAllChildren();
        parent.removeAllChildrenDisplay();
        for (TreeBrowserDisplay child : sortedNodes) {
            if (!(child instanceof TreeBrowserNode)) {
                this.addMenuToNode(child);
            }
            parent.addChildDisplay(child);
            tm.insertNodeInto(child, parent, parent.getChildCount());
        }
        tm.reload(parent);
    }

    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.controller.browser(this.model.getSelectedNodes());
            }
        }
    }
}

