/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.browser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.openmicroscopy.shoola.agents.metadata.browser.Browser;
import org.openmicroscopy.shoola.agents.metadata.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.metadata.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.metadata.browser.BrowserUI;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserDisplay;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserNode;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserSet;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import org.openmicroscopy.shoola.util.ui.component.ObservableComponent;
import pojos.ProjectData;
import pojos.ScreenData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BrowserComponent
extends AbstractComponent
implements Browser {
    private BrowserModel model;
    private BrowserControl controller;
    private BrowserUI view;

    BrowserComponent(BrowserModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.view = new BrowserUI();
        this.controller = new BrowserControl();
    }

    void initialize(ObservableComponent comp) {
        this.controller.initialize(this, this.view);
        comp.addPropertyChangeListener(this.controller);
        this.view.initialize(this.model, this.controller);
    }

    @Override
    public JComponent getUI() {
        return this.view;
    }

    @Override
    public TreeBrowserDisplay getLastSelectedNode() {
        return this.model.getLastSelectedNode();
    }

    @Override
    public void setSelectedNodes(List<TreeBrowserDisplay> nodes) {
        List<TreeBrowserDisplay> n = this.model.getSelectedNodes();
        this.model.setSelectedDisplays(nodes);
        this.firePropertyChange("selectedNodes", n, nodes);
    }

    @Override
    public void setSelectedNode(TreeBrowserDisplay node) {
        ArrayList<TreeBrowserDisplay> nodes = new ArrayList<TreeBrowserDisplay>(1);
        nodes.add(node);
        this.setSelectedNodes(nodes);
    }

    @Override
    public void setRootObject(Object refObject) {
        if (refObject == null) {
            throw new IllegalArgumentException("Root object not valid.");
        }
        this.model.setRootObject(refObject);
        this.view.setRootNode();
    }

    @Override
    public void cancel(TreeBrowserDisplay node) {
        if (node == null) {
            throw new IllegalArgumentException("No node to handle.");
        }
        this.model.cancel(node);
    }

    @Override
    public void loadMetadata(TreeBrowserDisplay node) {
        if (node == null) {
            throw new IllegalArgumentException("No node to handle.");
        }
        this.model.loadMetadata(node);
    }

    @Override
    public void setParents(TreeBrowserDisplay node, Collection parents) {
        if (node == null) {
            node = this.model.getRoot();
        }
        if (parents == null || parents.size() == 0) {
            this.view.addDefaultNode(node, "Wild and Free");
            return;
        }
        Iterator i = parents.iterator();
        ArrayList<TreeBrowserDisplay> nodes = new ArrayList<TreeBrowserDisplay>();
        while (i.hasNext()) {
            Object uo = i.next();
            if (uo instanceof ProjectData) {
                nodes.add(new TreeBrowserNode(uo));
                continue;
            }
            if (uo instanceof ScreenData) {
                nodes.add(new TreeBrowserNode(uo));
                continue;
            }
            if (uo instanceof TagAnnotationData) {
                TagAnnotationData tag = (TagAnnotationData)uo;
                if (!"openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace())) continue;
                nodes.add(new TreeBrowserNode(uo));
                continue;
            }
            nodes.add(new TreeBrowserSet(uo));
        }
        this.view.setNodes(node, nodes);
    }
}

