/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.metadata.EditorLoader;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import pojos.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThumbnailLoader
extends EditorLoader {
    private static final int STANDARD_WIDTH = 96;
    private static final int STANDARD_HEIGHT = 96;
    private static final int THUMB_MAX_WIDTH = 200;
    private static final int THUMB_MAX_HEIGHT = 200;
    private ImageData image;
    private Set<Long> userIDs;
    private CallHandle handle;
    private Map<Long, BufferedImage> thumbnails;
    private boolean single;

    public ThumbnailLoader(Editor viewer, ImageData image, Set<Long> userIDs) {
        this(viewer, image, userIDs, false);
    }

    public ThumbnailLoader(Editor viewer, ImageData image, Set<Long> userIDs, boolean single) {
        super(viewer);
        this.image = image;
        this.userIDs = userIDs;
        this.thumbnails = new HashMap<Long, BufferedImage>();
        this.single = single;
    }

    @Override
    public void load() {
        this.handle = this.single ? this.mhView.loadThumbnails(this.image, this.userIDs, 200, 200, this) : this.mhView.loadThumbnails(this.image, this.userIDs, 96, 96, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        ThumbnailData td = (ThumbnailData)fe.getPartialResult();
        if (!this.single) {
            if (td != null) {
                this.thumbnails.put(td.getUserID(), td.getThumbnail());
            }
            if (this.thumbnails.size() == this.userIDs.size()) {
                this.viewer.setThumbnails(this.thumbnails, this.image.getId());
            }
        }
    }

    @Override
    public void handleNullResult() {
    }
}

