/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata;

import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserDisplay;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallAdapter;
import org.openmicroscopy.shoola.env.data.views.DataManagerView;
import org.openmicroscopy.shoola.env.data.views.MetadataHandlerView;
import org.openmicroscopy.shoola.env.log.LogMessage;

public abstract class MetadataLoader
extends DSCallAdapter {
    protected final TreeBrowserDisplay refNode;
    protected final MetadataViewer viewer;
    protected final Registry registry;
    protected final MetadataHandlerView mhView;
    protected final DataManagerView dmView;

    protected void checkType(Class type) {
    }

    public MetadataLoader(MetadataViewer viewer, TreeBrowserDisplay refNode) {
        if (viewer == null) {
            throw new NullPointerException("No viewer.");
        }
        this.viewer = viewer;
        this.refNode = refNode;
        this.registry = MetadataViewerAgent.getRegistry();
        this.mhView = (MetadataHandlerView)this.registry.getDataServicesView(MetadataHandlerView.class);
        this.dmView = (DataManagerView)this.registry.getDataServicesView(DataManagerView.class);
    }

    public void handleNullResult() {
        this.handleException(new Exception("No data available."));
    }

    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
    }

    public void handleException(Throwable exc) {
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        this.registry.getUserNotifier().notifyError("Data Retrieval Failure", s, exc);
        this.viewer.cancel(this.refNode);
    }

    public abstract void load();

    public abstract void cancel();
}

