/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.openmicroscopy.shoola.agents.measurement.util.roimenu.ROIPopupMenu;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROIActionController;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROINode;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROITableCellRenderer;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROITableModel;
import org.openmicroscopy.shoola.agents.measurement.util.ui.ShapeRenderer;
import org.openmicroscopy.shoola.agents.measurement.view.ObjectManager;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.graphutils.ShapeType;
import org.openmicroscopy.shoola.util.ui.treetable.OMETreeTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROITable
extends OMETreeTable
implements ROIActionController {
    private ROINode root;
    private Vector<String> columnNames;
    private HashMap<ROI, ROINode> ROIMap;
    private ROITableModel model;
    private ROIPopupMenu popupMenu;
    private ObjectManager manager;

    private boolean haveSameID(List<ROIShape> shapeList) {
        TreeMap<Long, ROIShape> shapeMap = new TreeMap<Long, ROIShape>();
        for (ROIShape shape : shapeList) {
            if (shapeMap.containsKey(shape.getID())) continue;
            if (shapeMap.size() == 0) {
                shapeMap.put(shape.getID(), shape);
                continue;
            }
            return false;
        }
        return true;
    }

    private long getSameID(List<ROIShape> shapeList) {
        TreeMap<Long, ROIShape> shapeMap = new TreeMap<Long, ROIShape>();
        if (shapeList.size() == 0) {
            return -1L;
        }
        for (ROIShape shape : shapeList) {
            if (shapeMap.containsKey(shape.getID())) continue;
            if (shapeMap.size() == 0) {
                shapeMap.put(shape.getID(), shape);
                continue;
            }
            return -1L;
        }
        return shapeList.get(0).getID();
    }

    private void createPopupMenu() {
        this.popupMenu = new ROIPopupMenu(this);
    }

    ROITable(ROITableModel model, Vector columnNames, ObjectManager manager) {
        super((TreeTableModel)model);
        this.model = model;
        this.manager = manager;
        this.root = (ROINode)model.getRoot();
        this.columnNames = columnNames;
        this.setAutoResizeMode(4);
        this.ROIMap = new HashMap();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            this.getColumn(i).setResizable(true);
        }
        this.setDefaultRenderer(ShapeType.class, new ShapeRenderer());
        this.setTreeCellRenderer(new ROITableCellRenderer());
        this.createPopupMenu();
    }

    public void selectROIShape(ROIShape shape) {
        ROINode parent = this.findParent(shape.getROI());
        if (parent == null) {
            return;
        }
        this.expandROIRow(parent);
        ROINode child = parent.findChild(shape);
        int row = this.getRowForPath(child.getPath());
        this.selectionModel.addSelectionInterval(row, row);
    }

    public void scrollToROIShape(ROIShape shape) {
        ROINode parent = this.findParent(shape.getROI());
        if (parent == null) {
            return;
        }
        this.expandROIRow(parent);
        ROINode child = parent.findChild(shape);
        this.scrollPathToVisible(child.getPath());
    }

    @Override
    protected void onMousePressed(MouseEvent e) {
        if (this.rightClick(e)) {
            this.popupMenu.getPopupMenu().show((Component)((Object)this), e.getX(), e.getY());
        }
    }

    public void refresh() {
        this.setTreeTableModel((TreeTableModel)new ROITableModel(this.root, this.columnNames));
    }

    public void clear() {
        int childCount = this.root.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.root.remove(0);
        }
        this.setTreeTableModel((TreeTableModel)new ROITableModel(this.root, this.columnNames));
        this.ROIMap = new HashMap();
        this.invalidate();
        this.repaint();
    }

    public void setValueAt(Object obj, int row, int column) {
        ROINode node = (ROINode)this.getNodeAtRow(row);
        super.setValueAt(obj, row, column);
        if (node.getUserObject() instanceof ROI) {
            ROI roi = (ROI)node.getUserObject();
            ROINode expandNode = node;
            if (roi.isVisible()) {
                this.expandROIRow(expandNode);
            } else {
                this.collapseROIRow(expandNode);
            }
        } else {
            ROINode expandNode = (ROINode)node.getParent();
            ROIShape roiShape = (ROIShape)node.getUserObject();
            if (roiShape.getROI().isVisible()) {
                this.expandROIRow(expandNode);
            } else {
                this.collapseROIRow(expandNode);
            }
        }
    }

    public void addROIShape(ROIShape shape) {
        ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
        shapeList.add(shape);
        this.addROIShapeList(shapeList);
    }

    public void addROIShapeList(List<ROIShape> shapeList) {
        ROINode parent = null;
        for (ROIShape shape : shapeList) {
            parent = this.findParent(shape.getROI());
            if (parent == null) {
                parent = new ROINode(shape.getROI());
                parent.setExpanded(true);
                this.ROIMap.put(shape.getROI(), parent);
                int childCount = this.root.getChildCount();
                this.root.insert(parent, childCount);
            }
            ROINode roiShapeNode = parent.findChild(shape.getCoord3D());
            ROINode newNode = new ROINode(shape);
            newNode.setExpanded(true);
            if (roiShapeNode != null) {
                int index = parent.getIndex((TreeNode)((Object)roiShapeNode));
                parent.remove(shape.getCoord3D());
                parent.insert(newNode, index);
                continue;
            }
            parent.insert(newNode, parent.getInsertionPoint(shape.getCoord3D()));
        }
        this.setTreeTableModel((TreeTableModel)new ROITableModel(this.root, this.columnNames));
        if (parent != null) {
            this.expandROIRow(parent);
        }
    }

    public void expandNode(ROINode node) {
        if (node.getUserObject() instanceof ROI) {
            this.expandROIRow((ROI)node.getUserObject());
        }
    }

    public ROIShape getROIShapeAtRow(int index) {
        TreePath path = this.getPathForRow(index);
        if (path == null) {
            return null;
        }
        ROINode node = (ROINode)((Object)path.getLastPathComponent());
        if (node.getUserObject() instanceof ROIShape) {
            return (ROIShape)node.getUserObject();
        }
        return null;
    }

    public ROI getROIAtRow(int index) {
        TreePath path = this.getPathForRow(index);
        ROINode node = (ROINode)((Object)path.getLastPathComponent());
        if (node.getUserObject() instanceof ROI) {
            return (ROI)node.getUserObject();
        }
        return null;
    }

    public void expandROIRow(ROINode parent) {
        int addedNodeIndex = this.root.getIndex((TreeNode)((Object)parent));
        parent.setExpanded(true);
        this.expandRow(addedNodeIndex);
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            ROINode node = (ROINode)this.root.getChildAt(i);
            if (!node.isExpanded()) continue;
            this.expandPath(node.getPath());
        }
    }

    public void collapseROIRow(ROINode parent) {
        int addedNodeIndex = this.root.getIndex((TreeNode)((Object)parent));
        this.collapseRow(addedNodeIndex);
        parent.setExpanded(false);
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            ROINode node = (ROINode)this.root.getChildAt(i);
            if (!node.isExpanded()) continue;
            this.expandROIRow(node);
        }
    }

    public void expandROIRow(ROI roi) {
        ROINode selectedNode = this.findParent(roi);
        this.expandROIRow(selectedNode);
    }

    public void removeROIShape(ROIShape shape) {
        ROINode parent = this.findParent(shape.getROI());
        if (parent == null) {
            return;
        }
        ROINode child = parent.findChild(shape);
        parent.remove(child);
        if (parent.getChildCount() == 0) {
            this.root.remove(parent);
        }
        this.setTreeTableModel((TreeTableModel)new ROITableModel(this.root, this.columnNames));
    }

    public void removeROI(ROI roi) {
        ROINode roiNode = this.findParent(roi);
        this.root.remove(roiNode);
        this.setTreeTableModel((TreeTableModel)new ROITableModel(this.root, this.columnNames));
    }

    public ROINode findParent(ROI roi) {
        if (this.ROIMap.containsKey(roi)) {
            return this.ROIMap.get(roi);
        }
        return null;
    }

    public void setROIAttributesChanged(ROIShape shape) {
        ROINode parent = this.findParent(shape.getROI());
        ROINode child = parent.findChild(shape);
        this.model.nodeUpdated(child);
    }

    public boolean isShapeTypeColumn(int column) {
        TableColumn col = this.getColumn(column);
        return col.getModelIndex() == 4;
    }

    @Override
    public void deleteROI() {
        ArrayList<ROIShape> selectionList = this.getSelectedROIShapes();
        this.manager.deleteROIShapes(selectionList);
    }

    ArrayList getSelectedObjects() {
        Object nodeObject;
        int i;
        int[] selectedRows = this.getSelectedRows();
        TreeMap<Long, ROI> roiMap = new TreeMap<Long, ROI>();
        ArrayList<Object> selectedList = new ArrayList<Object>();
        for (i = 0; i < selectedRows.length; ++i) {
            nodeObject = this.getNodeAtRow(selectedRows[i]).getUserObject();
            if (!(nodeObject instanceof ROI)) continue;
            ROI roi = (ROI)nodeObject;
            roiMap.put(roi.getID(), roi);
            selectedList.add(roi);
        }
        for (i = 0; i < selectedRows.length; ++i) {
            ROIShape roiShape;
            nodeObject = this.getNodeAtRow(selectedRows[i]).getUserObject();
            if (!(nodeObject instanceof ROIShape) || roiMap.containsKey((roiShape = (ROIShape)nodeObject).getID())) continue;
            selectedList.add(roiShape);
        }
        return selectedList;
    }

    TreeMap<Coord3D, ROIShape> buildPlaneMap(ArrayList objectList) {
        TreeMap<Coord3D, ROIShape> planeMap = new TreeMap<Coord3D, ROIShape>(new Coord3D());
        for (Object node : objectList) {
            if (node instanceof ROI) {
                ROI roi = (ROI)node;
                TreeMap<Coord3D, ROIShape> shapeMap = roi.getShapes();
                for (Coord3D coord : shapeMap.keySet()) {
                    if (planeMap.containsKey(coord)) {
                        return null;
                    }
                    planeMap.put(coord, shapeMap.get(coord));
                }
                continue;
            }
            if (!(node instanceof ROIShape)) continue;
            ROIShape shape = (ROIShape)node;
            if (planeMap.containsKey(shape.getCoord3D())) {
                return null;
            }
            planeMap.put(shape.getCoord3D(), shape);
        }
        return planeMap;
    }

    ArrayList<Long> getIDList(ArrayList selectedObjects) {
        TreeMap<Long, ROI> idMap = new TreeMap<Long, ROI>();
        ArrayList<Long> idList = new ArrayList<Long>();
        for (Object node : selectedObjects) {
            ROI roi = node instanceof ROI ? (ROI)node : ((ROIShape)node).getROI();
            if (idMap.containsKey(roi.getID())) continue;
            idMap.put(roi.getID(), roi);
            idList.add(roi.getID());
        }
        return idList;
    }

    ArrayList<ROIShape> getSelectedROIShapes() {
        Object nodeObject;
        int i;
        int[] selectedRows = this.getSelectedRows();
        TreeMap<Long, ROI> roiMap = new TreeMap<Long, ROI>();
        ArrayList<ROIShape> selectedList = new ArrayList<ROIShape>();
        for (i = 0; i < selectedRows.length; ++i) {
            nodeObject = this.getNodeAtRow(selectedRows[i]).getUserObject();
            if (!(nodeObject instanceof ROI)) continue;
            ROI roi = (ROI)nodeObject;
            roiMap.put(roi.getID(), roi);
            Iterator<ROIShape> shapeIterator = roi.getShapes().values().iterator();
            while (shapeIterator.hasNext()) {
                selectedList.add(shapeIterator.next());
            }
        }
        for (i = 0; i < selectedRows.length; ++i) {
            ROIShape roiShape;
            nodeObject = this.getNodeAtRow(selectedRows[i]).getUserObject();
            if (!(nodeObject instanceof ROIShape) || roiMap.containsKey((roiShape = (ROIShape)nodeObject).getID())) continue;
            selectedList.add(roiShape);
        }
        return selectedList;
    }

    private boolean onSeparatePlanes(List<ROIShape> shapeList) {
        TreeMap<Coord3D, ROIShape> shapeMap = new TreeMap<Coord3D, ROIShape>(new Coord3D());
        for (ROIShape shape : shapeList) {
            if (shapeMap.containsKey(shape.getCoord3D())) {
                return false;
            }
            shapeMap.put(shape.getCoord3D(), shape);
        }
        return true;
    }

    @Override
    public void duplicateROI() {
        this.manager.showReadyMessage();
        ArrayList<ROIShape> selectedObjects = this.getSelectedROIShapes();
        if (this.onSeparatePlanes(selectedObjects) && this.haveSameID(selectedObjects)) {
            this.manager.duplicateROI(this.getSameID(selectedObjects), selectedObjects);
        } else {
            this.manager.showMessage("Duplicate: ROIs must be from the same ROI and on separate planes.");
        }
    }

    @Override
    public void mergeROI() {
        this.manager.showReadyMessage();
        ArrayList<ROIShape> selectedObjects = this.getSelectedROIShapes();
        if (this.onSeparatePlanes(selectedObjects) && selectedObjects.size() > 1) {
            ArrayList<Long> idList = this.getIDList(selectedObjects);
            this.manager.mergeROI(idList, selectedObjects);
        } else {
            this.manager.showMessage("Merge: ROIs must be on separate planes and must include more than one.");
        }
    }

    @Override
    public void propagateROI() {
        this.manager.showReadyMessage();
        if (this.getSelectedRows().length != 1) {
            this.manager.showMessage("Propagate: Only one ROI may be propagated at a time.");
            return;
        }
        ROINode node = (ROINode)this.getNodeAtRow(this.getSelectedRow());
        Object nodeObject = node.getUserObject();
        if (nodeObject instanceof ROI) {
            this.manager.propagateROI((ROI)nodeObject);
        }
        if (nodeObject instanceof ROIShape) {
            this.manager.propagateROI(((ROIShape)nodeObject).getROI());
        }
    }

    @Override
    public void splitROI() {
        this.manager.showReadyMessage();
        ArrayList<ROIShape> selectedObjects = this.getSelectedROIShapes();
        if (this.onSeparatePlanes(selectedObjects) && this.haveSameID(selectedObjects)) {
            this.manager.splitROI(this.getSameID(selectedObjects), selectedObjects);
        } else {
            this.manager.showMessage("Split: ROIs must be from the same ROI and on separate planes.");
        }
    }

    @Override
    public void calculateStats() {
        this.manager.showReadyMessage();
        ArrayList<ROIShape> selectedObjects = this.getSelectedROIShapes();
        if (this.onSeparatePlanes(selectedObjects) && this.haveSameID(selectedObjects)) {
            this.manager.calculateStats(selectedObjects);
        } else {
            this.manager.showMessage("Calculate: ROIs must be from the same ROI and on separate planes.");
        }
    }
}

