/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.util.model.AttributeField;
import org.openmicroscopy.shoola.agents.measurement.util.model.FigureTableModel;
import org.openmicroscopy.shoola.agents.measurement.util.model.ValueType;
import org.openmicroscopy.shoola.agents.measurement.util.ui.FigureTable;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerControl;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ObjectInspector
extends JPanel {
    public static final int INDEX = 0;
    private static List<String> columnNames = new ArrayList<String>(2);
    private static final String NAME = "Inspector";
    private FigureTable fieldTable;
    private MeasurementViewerControl controller;
    private MeasurementViewerModel model;

    public int getIndex() {
        return 0;
    }

    private void initComponents() {
        ArrayList<AttributeField> l = new ArrayList<AttributeField>();
        l.add(new AttributeField(MeasurementAttributes.TEXT, "Text", true));
        l.add(new AttributeField(MeasurementAttributes.SHOWTEXT, "Show Text", false));
        l.add(new AttributeField(MeasurementAttributes.SHOWMEASUREMENT, "Show Measurements", false));
        l.add(new AttributeField(MeasurementAttributes.SHOWID, "Show ID", false));
        l.add(new AttributeField(MeasurementAttributes.STROKE_WIDTH, "Line Width", true, this.strokeRange(), ValueType.ENUM));
        l.add(new AttributeField(MeasurementAttributes.FONT_SIZE, "Font Size", true, this.fontRange(), ValueType.ENUM));
        l.add(new AttributeField(MeasurementAttributes.TEXT_COLOR, "Font Colour", false));
        l.add(new AttributeField(MeasurementAttributes.FILL_COLOR, "Fill Colour", false));
        l.add(new AttributeField(MeasurementAttributes.STROKE_COLOR, "Line Colour", false));
        l.add(new AttributeField(MeasurementAttributes.MEASUREMENTTEXT_COLOUR, "Measurement Colour", false));
        l.add(new AttributeField(MeasurementAttributes.WIDTH, "Width", true));
        l.add(new AttributeField(MeasurementAttributes.HEIGHT, "Height", true));
        this.fieldTable = new FigureTable(new FigureTableModel(l, columnNames));
        this.fieldTable.getTableHeader().setReorderingAllowed(false);
        this.fieldTable.setRowHeight(26);
        this.fieldTable.setSelectionMode(0);
        this.fieldTable.setCellSelectionEnabled(true);
        this.fieldTable.setColumnSelectionAllowed(true);
        this.fieldTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    int col = ObjectInspector.this.fieldTable.getSelectedColumn();
                    int row = ObjectInspector.this.fieldTable.getSelectedRow();
                    Object value = ObjectInspector.this.fieldTable.getValueAt(row, col);
                    if (value instanceof Boolean) {
                        ObjectInspector.this.toggleValue();
                    }
                } else if (e.getClickCount() > 1) {
                    e.consume();
                    int col = ObjectInspector.this.fieldTable.getSelectedColumn();
                    int row = ObjectInspector.this.fieldTable.getSelectedRow();
                    Object value = ObjectInspector.this.fieldTable.getValueAt(row, col);
                    if (value instanceof Color) {
                        ObjectInspector.this.controller.showColorPicker((Color)value);
                    }
                    if (value instanceof Boolean) {
                        ObjectInspector.this.toggleValue();
                    }
                }
            }
        });
    }

    ArrayList<Double> strokeRange() {
        ArrayList<Double> sRange = new ArrayList<Double>();
        sRange.add(new Double(0.5));
        sRange.add(new Double(0.75));
        sRange.add(new Double(1.0));
        sRange.add(new Double(2.0));
        sRange.add(new Double(3.0));
        sRange.add(new Double(4.0));
        return sRange;
    }

    ArrayList<Double> fontRange() {
        ArrayList<Double> fRange = new ArrayList<Double>();
        fRange.add(new Double(4.0));
        fRange.add(new Double(8.0));
        fRange.add(new Double(10.0));
        fRange.add(new Double(12.0));
        fRange.add(new Double(16.0));
        fRange.add(new Double(24.0));
        return fRange;
    }

    private void toggleValue() {
        int col = this.fieldTable.getSelectedColumn();
        int row = this.fieldTable.getSelectedRow();
        Boolean value = (Boolean)this.fieldTable.getModel().getValueAt(row, col);
        boolean newValue = value == false;
        this.fieldTable.getModel().setValueAt(newValue, row, col);
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.fieldTable), "Center");
    }

    ObjectInspector(MeasurementViewerControl controller, MeasurementViewerModel model) {
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.controller = controller;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    String getComponentName() {
        return NAME;
    }

    Icon getComponentIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(1);
    }

    void setCellColor(Color c) {
        int col = this.fieldTable.getSelectedColumn();
        int row = this.fieldTable.getSelectedRow();
        this.fieldTable.getModel().setValueAt(c, row, col);
    }

    void setModelData(Figure figure) {
        FigureTableModel tableModel = (FigureTableModel)this.fieldTable.getModel();
        tableModel.setData(figure);
        this.fieldTable.setModel(tableModel);
        this.fieldTable.repaint();
    }

    void setSelectedFigures(List<ROIShape> l) {
        FigureTableModel tableModel = (FigureTableModel)this.fieldTable.getModel();
        Iterator<ROIShape> i = l.iterator();
        try {
            while (i.hasNext()) {
                ROIShape shape = i.next();
                tableModel.setData(shape.getFigure());
                this.fieldTable.setModel(tableModel);
                this.fieldTable.repaint();
            }
        }
        catch (Exception e) {
            System.err.println("Exception" + l.get(0).toString());
            MeasurementAgent.getRegistry().getLogger().info((Object)this, "Figures selection" + e);
        }
    }

    static {
        columnNames.add("Field");
        columnNames.add("Value");
    }
}

