/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jhotdraw.draw.DelegationSelectionTool;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingListener;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.agents.events.measurement.SelectPlane;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.actions.MeasurementViewerAction;
import org.openmicroscopy.shoola.agents.measurement.view.CalculationWizard;
import org.openmicroscopy.shoola.agents.measurement.view.GraphPane;
import org.openmicroscopy.shoola.agents.measurement.view.IntensityResultsView;
import org.openmicroscopy.shoola.agents.measurement.view.IntensityView;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementResults;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerControl;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.agents.measurement.view.ObjectInspector;
import org.openmicroscopy.shoola.agents.measurement.view.ObjectManager;
import org.openmicroscopy.shoola.agents.measurement.view.ROIAssistant;
import org.openmicroscopy.shoola.agents.measurement.view.StatusBar;
import org.openmicroscopy.shoola.agents.measurement.view.ToolBar;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.TopWindow;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.roi.exception.NoSuchROIException;
import org.openmicroscopy.shoola.util.roi.exception.ROICreationException;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.ShapeList;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.LoadingWindow;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.drawingtools.canvas.DrawingCanvasView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MeasurementViewerUI
extends TopWindow
implements MouseListener,
MouseMotionListener {
    static final String RETRIEVE_MSG = "Cannot retrieve the ROI";
    static final String CREATE_MSG = "Cannot create the ROI";
    static final String DELETE_MSG = "Cannot delete the ROI";
    static final String UNKNOWN_MSG = "An unknown, unexpected error occurred in ";
    static final String DEFAULT_MSG = "";
    private static final Dimension DEFAULT_SIZE = new Dimension(400, 300);
    private static final Dimension MAXIMUM_SIZE = new Dimension(700, 300);
    private static final String WINDOW_TITLE = "Measurement Tool ";
    public static final int INSPECTOR_INDEX = 0;
    public static final int MANAGER_INDEX = 1;
    public static final int RESULTS_INDEX = 2;
    public static final int GRAPH_INDEX = 3;
    public static final int INTENSITY_INDEX = 4;
    public static final int CALCWIZARD_INDEX = 5;
    public static final int INTENSITYRESULTVIEW_INDEX = 6;
    private MeasurementViewerModel model;
    private MeasurementViewerControl controller;
    private MeasurementViewer component;
    private LoadingWindow loadingWindow = new LoadingWindow(this);
    private ToolBar toolBar;
    private ObjectInspector roiInspector;
    private ObjectManager roiManager;
    private MeasurementResults roiResults;
    private GraphPane graphPane;
    private IntensityView intensityView;
    private IntensityResultsView intensityResultsView;
    private CalculationWizard calcWizard;
    private JTabbedPane tabs;
    private StatusBar statusBar;
    private JCheckBoxMenuItem createMultipleFigure;
    private JCheckBoxMenuItem createSingleFigure;

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createControlsMenu());
        menuBar.add(this.createOptionsMenu());
        return menuBar;
    }

    private JMenu createControlsMenu() {
        JMenu menu = new JMenu("Controls");
        menu.setMnemonic(67);
        MeasurementViewerAction a = this.controller.getAction(MeasurementViewerControl.LOAD);
        JMenuItem item = new JMenuItem(a);
        item.setText(a.getName());
        menu.add(item);
        a = this.controller.getAction(MeasurementViewerControl.SAVE);
        item = new JMenuItem(a);
        item.setText(a.getName());
        menu.add(item);
        a = this.controller.getAction(MeasurementViewerControl.ROI_ASSISTANT);
        item = new JMenuItem(a);
        item.setText(a.getName());
        menu.add(item);
        return menu;
    }

    private JMenu createOptionsMenu() {
        JMenu menu = new JMenu("Options");
        ButtonGroup displayUnits = new ButtonGroup();
        menu.setMnemonic(79);
        JMenu subMenu = new JMenu("Units");
        MeasurementViewerAction a = this.controller.getAction(MeasurementViewerControl.IN_MICRONS);
        JCheckBoxMenuItem inMicronsMenu = new JCheckBoxMenuItem(a);
        inMicronsMenu.setText(a.getName());
        displayUnits.add(inMicronsMenu);
        subMenu.add(inMicronsMenu);
        a = this.controller.getAction(MeasurementViewerControl.IN_PIXELS);
        JCheckBoxMenuItem inPixelsMenu = new JCheckBoxMenuItem(a);
        inPixelsMenu.setText(a.getName());
        displayUnits.add(inPixelsMenu);
        subMenu.add(inPixelsMenu);
        inPixelsMenu.setSelected(true);
        menu.add(subMenu);
        ButtonGroup createFigureGroup = new ButtonGroup();
        JMenu creationMenu = new JMenu("ROI Creation");
        a = this.controller.getAction(MeasurementViewerControl.CREATESINGLEFIGURE);
        this.createSingleFigure = new JCheckBoxMenuItem(a);
        this.createSingleFigure.setText(a.getName());
        createFigureGroup.add(this.createSingleFigure);
        creationMenu.add(this.createSingleFigure);
        a = this.controller.getAction(MeasurementViewerControl.CREATEMULTIPLEFIGURE);
        this.createMultipleFigure = new JCheckBoxMenuItem(a);
        this.createMultipleFigure.setText(a.getName());
        createFigureGroup.add(this.createMultipleFigure);
        creationMenu.add(this.createMultipleFigure);
        this.createMultipleFigure.setSelected(true);
        menu.add(creationMenu);
        return menu;
    }

    private void initComponents() {
        this.statusBar = new StatusBar();
        this.toolBar = new ToolBar(this.component, this, this.controller, this.model);
        this.roiManager = new ObjectManager(this, this.model);
        this.roiInspector = new ObjectInspector(this.controller, this.model);
        this.roiResults = new MeasurementResults(this.controller, this.model, this);
        this.graphPane = new GraphPane(this, this.controller, this.model);
        this.intensityView = new IntensityView(this, this.model);
        this.intensityResultsView = new IntensityResultsView(this, this.model);
        this.calcWizard = new CalculationWizard(this.controller, this.model);
        this.tabs = new JTabbedPane(1, 0);
        DrawingCanvasView canvasView = this.model.getDrawingView();
        canvasView.addMouseListener(this);
        canvasView.addMouseMotionListener(this);
        this.addTabbedPaneListener();
        this.tabs.setAlignmentX(0.0f);
    }

    private void addTabbedPaneListener() {
        this.tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                if (MeasurementViewerUI.this.inDataView()) {
                    MeasurementViewerUI.this.controller.analyseSelectedFigures();
                }
            }
        });
    }

    private void buildGUI() {
        this.setJMenuBar(this.createMenuBar());
        this.tabs.addTab(this.roiManager.getComponentName(), this.roiManager.getComponentIcon(), this.roiManager);
        this.tabs.addTab(this.roiInspector.getComponentName(), this.roiInspector.getComponentIcon(), this.roiInspector);
        this.tabs.addTab(this.roiResults.getComponentName(), this.roiResults.getComponentIcon(), this.roiResults);
        this.tabs.addTab(this.graphPane.getComponentName(), this.graphPane.getComponentIcon(), this.graphPane);
        this.tabs.addTab(this.intensityView.getComponentName(), this.intensityView.getComponentIcon(), this.intensityView);
        this.tabs.addTab(this.intensityResultsView.getComponentName(), this.intensityResultsView.getComponentIcon(), this.intensityResultsView);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(0, 0));
        container.add((Component)this.toolBar, "North");
        container.add((Component)this.tabs, "Center");
        container.add((Component)this.statusBar, "South");
    }

    MeasurementViewerUI(String title) {
        super(WINDOW_TITLE + title);
    }

    void initialize(MeasurementViewer component, MeasurementViewerControl controller, MeasurementViewerModel model) {
        if (component == null) {
            throw new NullPointerException("No control.");
        }
        if (controller == null) {
            throw new NullPointerException("No control.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.component = component;
        this.model = model;
        this.controller = controller;
        controller.attachListeners();
        this.initComponents();
        this.buildGUI();
    }

    void mergeROI(List<Long> idList, List<ROIShape> shapeList) {
        try {
            this.model.setDataChanged();
            ROI newROI = this.model.cloneROI(idList.get(0));
            for (ROIShape shape : shapeList) {
                ROIShape newShape = new ROIShape(newROI, shape.getCoord3D(), shape);
                if (this.getDrawing().contains((Figure)shape.getFigure())) {
                    shape.getFigure().removeFigureListener(this.controller);
                    this.getDrawing().removeDrawingListener((DrawingListener)this.controller);
                    this.getDrawing().remove((Figure)shape.getFigure());
                    this.getDrawing().addDrawingListener((DrawingListener)this.controller);
                }
                this.model.deleteShape(shape.getID(), shape.getCoord3D());
                if (newShape.getCoord3D().equals(this.model.getCurrentView())) {
                    this.getDrawing().removeDrawingListener((DrawingListener)this.controller);
                    this.getDrawing().add((Figure)newShape.getFigure());
                    newShape.getFigure().addFigureListener(this.controller);
                    this.getDrawing().addDrawingListener((DrawingListener)this.controller);
                }
                this.model.addShape(newROI.getID(), newShape.getCoord3D(), newShape);
            }
        }
        catch (Exception e) {
            if (e instanceof ROICreationException) {
                this.handleROIException(e, CREATE_MSG);
            }
            if (e instanceof NoSuchROIException) {
                this.handleROIException(e, RETRIEVE_MSG);
            }
            this.handleROIException(e, "An unknown, unexpected error occurred in Merging ROI");
        }
    }

    void splitROI(long id, ArrayList<ROIShape> shapeList) {
        try {
            this.model.setDataChanged();
            ROI newROI = this.model.cloneROI(id);
            for (ROIShape shape : shapeList) {
                ROIShape newShape = new ROIShape(newROI, shape.getCoord3D(), shape);
                if (this.getDrawing().contains((Figure)shape.getFigure())) {
                    shape.getFigure().removeFigureListener(this.controller);
                    this.getDrawing().removeDrawingListener((DrawingListener)this.controller);
                    this.getDrawing().remove((Figure)shape.getFigure());
                    this.getDrawing().addDrawingListener((DrawingListener)this.controller);
                }
                this.model.deleteShape(shape.getID(), shape.getCoord3D());
                if (newShape.getCoord3D().equals(this.model.getCurrentView())) {
                    this.getDrawing().removeDrawingListener((DrawingListener)this.controller);
                    this.getDrawing().add((Figure)newShape.getFigure());
                    newShape.getFigure().addFigureListener(this.controller);
                    this.getDrawing().addDrawingListener((DrawingListener)this.controller);
                }
                this.model.addShape(newROI.getID(), newShape.getCoord3D(), newShape);
            }
        }
        catch (Exception e) {
            if (e instanceof ROICreationException) {
                this.handleROIException(e, CREATE_MSG);
            }
            if (e instanceof NoSuchROIException) {
                this.handleROIException(e, RETRIEVE_MSG);
            }
            this.handleROIException(e, "An unknown, unexpected error occurred in Splitting ROI.");
        }
    }

    void duplicateROI(long id, ArrayList<ROIShape> shapeList) {
        try {
            this.model.setDataChanged();
            ROI newROI = this.model.cloneROI(id);
            for (ROIShape shape : shapeList) {
                ROIShape newShape = new ROIShape(newROI, shape.getCoord3D(), shape);
                if (newShape.getCoord3D().equals(this.model.getCurrentView())) {
                    this.getDrawing().removeDrawingListener((DrawingListener)this.controller);
                    this.getDrawing().add((Figure)newShape.getFigure());
                    newShape.getFigure().addFigureListener(this.controller);
                    this.getDrawing().addDrawingListener((DrawingListener)this.controller);
                }
                this.model.addShape(newROI.getID(), newShape.getCoord3D(), newShape);
            }
        }
        catch (Exception e) {
            this.handleROIException(e, CREATE_MSG);
        }
    }

    void deleteROIShapes(ArrayList<ROIShape> shapeList) {
        try {
            this.model.setDataChanged();
            for (ROIShape shape : shapeList) {
                if (this.getDrawing().contains((Figure)shape.getFigure())) {
                    shape.getFigure().removeFigureListener(this.controller);
                    this.getDrawing().removeDrawingListener((DrawingListener)this.controller);
                    this.getDrawing().remove((Figure)shape.getFigure());
                    this.getDrawing().addDrawingListener((DrawingListener)this.controller);
                }
                this.model.deleteShape(shape.getID(), shape.getCoord3D());
            }
        }
        catch (Exception e) {
            this.handleROIException(e, DELETE_MSG);
        }
    }

    boolean inDataView() {
        return this.inIntensityView() || this.inGraphView() || this.inCalcWizardView();
    }

    boolean inCalcWizardView() {
        return this.tabs.getTitleAt(this.tabs.getSelectedIndex()).equals(this.calcWizard.getComponentName());
    }

    boolean inGraphView() {
        return this.tabs.getTitleAt(this.tabs.getSelectedIndex()).equals(this.graphPane.getComponentName());
    }

    boolean inIntensityView() {
        return this.tabs.getTitleAt(this.tabs.getSelectedIndex()).equals(this.intensityView.getComponentName());
    }

    boolean inIntensityResultsView() {
        return this.tabs.getTitleAt(this.tabs.getSelectedIndex()).equals(this.intensityResultsView.getComponentName());
    }

    LoadingWindow getLoadingWindow() {
        return this.loadingWindow;
    }

    void setCellColor(Color color) {
        if (this.roiInspector != null) {
            this.roiInspector.setCellColor(color);
        }
    }

    void selectFigure(long ROIid, int t, int z) {
        try {
            ROI roi = this.model.getROI(ROIid);
            ROIFigure fig = roi.getFigure(new Coord3D(z, t));
            this.selectFigure(fig);
        }
        catch (Exception e) {
            this.handleROIException(e, RETRIEVE_MSG);
        }
    }

    public void showROIAssistant() {
        Registry reg = MeasurementAgent.getRegistry();
        UserNotifier un = reg.getUserNotifier();
        if (this.inDataView()) {
            un.notifyInfo("ROI Assistant", "ROI Assistant cannot be used in graph pane or intensity view.");
            return;
        }
        Collection<ROI> roiList = this.model.getSelectedROI();
        if (roiList.size() == 0) {
            un.notifyInfo("ROI Assistant", "Select a Figure to modify using the ROI Assistant.");
            return;
        }
        if (roiList.size() > 1) {
            un.notifyInfo("ROI Assistant", "The ROI Assistant canonly be used on one ROIat a time.");
            return;
        }
        ROI currentROI = roiList.iterator().next();
        ROIAssistant assistant = new ROIAssistant(this.model.getNumTimePoints(), this.model.getNumZSections(), this.model.getCurrentView(), currentROI, this);
        UIUtilities.setLocationRelativeToAndShow(this, assistant);
    }

    void showROIAssistant(ROI roi) {
        Registry reg = MeasurementAgent.getRegistry();
        UserNotifier un = reg.getUserNotifier();
        if (this.inDataView()) {
            un.notifyInfo("ROI Assistant", "ROI Assistant cannot be used in graph pane or intensity view");
            return;
        }
        ROIAssistant assistant = new ROIAssistant(this.model.getNumTimePoints(), this.model.getNumZSections(), this.model.getCurrentView(), roi, this);
        UIUtilities.setLocationRelativeToAndShow(this, assistant);
    }

    void selectFigure(ROIFigure figure) {
        if (figure == null) {
            return;
        }
        Coord3D coord3D = figure.getROIShape().getCoord3D();
        if (coord3D == null) {
            return;
        }
        if (!coord3D.equals(this.model.getCurrentView())) {
            this.model.setPlane(coord3D.getZSection(), coord3D.getTimePoint());
            SelectPlane request = new SelectPlane(this.model.getPixelsID(), coord3D.getZSection(), coord3D.getTimePoint());
            EventBus bus = MeasurementAgent.getRegistry().getEventBus();
            bus.post(request);
            this.updateDrawingArea();
        }
        DrawingCanvasView dv = this.model.getDrawingView();
        dv.clearSelection();
        dv.addToSelection(figure);
        Set figures = dv.getSelectedFigures();
        if (figures == null) {
            return;
        }
        Iterator i = figures.iterator();
        ArrayList<ROIShape> roiShapeList = new ArrayList<ROIShape>();
        try {
            while (i.hasNext()) {
                ROIFigure f = (ROIFigure)i.next();
                ROIShape roiShape = f.getROIShape();
                roiShapeList.add(roiShape);
            }
        }
        catch (Exception e) {
            this.handleROIException(e, RETRIEVE_MSG);
        }
        dv.grabFocus();
        this.roiInspector.setSelectedFigures(roiShapeList);
        this.roiManager.setSelectedFigures(roiShapeList, false);
    }

    void setSelectedFigures(Collection figures) {
        if (this.model.getState() != 5) {
            return;
        }
        if (figures == null) {
            return;
        }
        Iterator i = figures.iterator();
        ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
        try {
            while (i.hasNext()) {
                ROIFigure figure = (ROIFigure)i.next();
                ROIShape shape = figure.getROIShape();
                if (shape == null) continue;
                shapeList.add(shape);
            }
        }
        catch (Exception e) {
            this.handleROIException(e, RETRIEVE_MSG);
        }
        this.roiInspector.setSelectedFigures(shapeList);
        this.roiManager.setSelectedFigures(shapeList, true);
    }

    void removeROI(ROIFigure figure) {
        if (figure == null) {
            return;
        }
        try {
            this.model.removeROIShape(figure.getROI().getID());
            this.roiManager.removeFigure(figure);
            this.roiResults.refreshResults();
        }
        catch (Exception e) {
            this.handleROIException(e, DELETE_MSG);
        }
    }

    void addROI(ROIFigure figure) {
        if (figure == null) {
            return;
        }
        ROI roi = null;
        try {
            roi = this.model.createROI(figure, !this.getDrawingView().isDuplicate());
            this.getDrawingView().unsetDuplicate();
        }
        catch (Exception e) {
            this.handleROIException(e, CREATE_MSG);
        }
        if (roi == null) {
            return;
        }
        ArrayList<ROI> roiList = new ArrayList<ROI>();
        roiList.add(roi);
        this.roiManager.addFigures(roiList);
        this.roiResults.refreshResults();
    }

    void onAttributeChanged(Figure figure) {
        if (this.model.getState() != 5) {
            return;
        }
        if (figure == null) {
            return;
        }
        this.getDrawingView().repaint();
        this.roiInspector.setModelData(figure);
        this.roiManager.update();
        this.roiResults.refreshResults();
    }

    Drawing getDrawing() {
        return this.model.getDrawing();
    }

    DrawingCanvasView getDrawingView() {
        return this.model.getDrawingView();
    }

    void rebuildManagerTable() {
        this.roiManager.rebuildTable();
    }

    void refreshResultsTable() {
        this.roiResults.refreshResults();
    }

    void refreshInspectorTable() {
        this.roiInspector.repaint();
    }

    boolean saveResultsTable() throws IOException {
        return this.roiResults.saveResults();
    }

    void showResultsWizard() {
        this.roiResults.showResultsWizard();
    }

    void handleROIException(Exception e, String text) {
        Registry reg = MeasurementAgent.getRegistry();
        if (e instanceof ROICreationException || e instanceof NoSuchROIException) {
            reg.getLogger().error((Object)this, "Problem while handling ROI " + e.getMessage());
            this.statusBar.setStatus(text);
        } else {
            String s = "An unexpected error occured while handling ROI ";
            reg.getLogger().error((Object)this, s + e.getMessage());
            reg.getUserNotifier().notifyError("ROI", s, e);
        }
    }

    void updateDrawingArea() {
        Drawing drawing = this.model.getDrawing();
        drawing.removeDrawingListener((DrawingListener)this.controller);
        drawing.clear();
        ShapeList list = null;
        try {
            list = this.model.getShapeList();
        }
        catch (Exception e) {
            this.handleROIException(e, RETRIEVE_MSG);
        }
        if (list != null) {
            TreeMap<Long, ROIShape> map = list.getList();
            for (ROIShape shape : map.values()) {
                if (shape == null) continue;
                drawing.add((Figure)shape.getFigure());
                shape.getFigure().removeFigureListener(this.controller);
                shape.getFigure().addFigureListener(this.controller);
            }
        }
        this.setStatus(DEFAULT_MSG);
        this.model.getDrawingView().setDrawing(drawing);
        drawing.addDrawingListener((DrawingListener)this.controller);
    }

    void propagateShape(ROIShape shape, int timePoint, int zSection) {
        try {
            List<ROIShape> addedShapes = this.model.propagateShape(shape, timePoint, zSection);
            ROIFigure figToDelete = null;
            for (ROIShape newShape : addedShapes) {
                if (newShape.getCoord3D().equals(this.model.getCurrentView())) {
                    this.getDrawing().removeDrawingListener((DrawingListener)this.controller);
                    figToDelete = null;
                    for (Figure f : this.getDrawing().getFigures()) {
                        ROIFigure roiFig = (ROIFigure)f;
                        if (roiFig.getROI().getID() != newShape.getID()) continue;
                        figToDelete = roiFig;
                    }
                    if (figToDelete != null) {
                        this.getDrawing().remove(figToDelete);
                    }
                    this.getDrawing().add((Figure)newShape.getFigure());
                    newShape.getFigure().addFigureListener(this.controller);
                    this.getDrawing().addDrawingListener((DrawingListener)this.controller);
                }
                newShape.getFigure().calculateMeasurements();
            }
            this.roiManager.addROIShapes(addedShapes);
        }
        catch (ROICreationException e) {
            this.handleROIException(e, CREATE_MSG);
        }
        catch (NoSuchROIException e) {
            this.handleROIException(e, RETRIEVE_MSG);
        }
        this.setStatus(DEFAULT_MSG);
    }

    void deleteShape(ROIShape shape, int timePoint, int zSection) {
        try {
            this.model.deleteShape(shape, timePoint, zSection);
        }
        catch (Exception e) {
            this.handleROIException(e, RETRIEVE_MSG);
        }
        this.setStatus(DEFAULT_MSG);
        this.rebuildManagerTable();
    }

    void setStatus(String text) {
        this.statusBar.setStatus(text);
    }

    void setReadyStatus() {
        this.setStatus(DEFAULT_MSG);
    }

    void displayAnalysisResults() {
        if (this.inGraphView()) {
            this.graphPane.displayAnalysisResults();
        } else if (this.inIntensityView()) {
            this.intensityView.displayAnalysisResults();
        } else if (this.inIntensityResultsView()) {
            this.intensityResultsView.displayAnalysisResults();
        }
    }

    void createSingleFigure(boolean createSingleFig) {
        if (createSingleFig) {
            this.createSingleFigure.setSelected(true);
            this.createMultipleFigure.setSelected(false);
        } else {
            this.createSingleFigure.setSelected(false);
            this.createMultipleFigure.setSelected(true);
        }
        this.toolBar.createSingleFigure(createSingleFig);
    }

    boolean isCreateSingleFigure() {
        return this.createSingleFigure.isSelected();
    }

    long getPixelsID() {
        return this.model.getPixelsID();
    }

    void calculateStats(List<ROIShape> shapeList) {
        if (this.model.getState() != 5) {
            return;
        }
        this.model.calculateStats(shapeList);
    }

    @Override
    public void setOnScreen() {
        if (this.model != null) {
            this.setSize(DEFAULT_SIZE);
            UIUtilities.setLocationRelativeToAndSizeToWindow(this.model.getRequesterBounds(), (Component)this, MAXIMUM_SIZE);
        } else {
            this.pack();
            UIUtilities.incrementRelativeToAndShow(null, this);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        Cursor cursor = this.model.getDrawingEditor().getTool() instanceof DelegationSelectionTool ? Cursor.getPredefinedCursor(0) : Cursor.getPredefinedCursor(1);
        this.getDrawingView().setCursor(cursor);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

