/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.agents.events.SaveData;
import org.openmicroscopy.shoola.agents.events.iviewer.SaveRelatedData;
import org.openmicroscopy.shoola.agents.measurement.Analyser;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.MeasurementViewerLoader;
import org.openmicroscopy.shoola.agents.measurement.util.FileMap;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.log.Logger;
import org.openmicroscopy.shoola.util.file.IOUtil;
import org.openmicroscopy.shoola.util.roi.ROIComponent;
import org.openmicroscopy.shoola.util.roi.exception.NoSuchROIException;
import org.openmicroscopy.shoola.util.roi.exception.ParsingException;
import org.openmicroscopy.shoola.util.roi.exception.ROICreationException;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.ShapeList;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.roi.model.util.MeasurementUnits;
import org.openmicroscopy.shoola.util.ui.drawingtools.DrawingComponent;
import org.openmicroscopy.shoola.util.ui.drawingtools.canvas.DrawingCanvasView;
import pojos.ChannelData;
import pojos.PixelsData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MeasurementViewerModel {
    private long imageID;
    private String name;
    private Rectangle requesterBounds;
    private int state;
    private DrawingComponent drawingComponent;
    private ROIComponent roiComponent;
    private Coord3D currentPlane;
    private PixelsData pixels;
    private double magnification;
    private Map activeChannels;
    private Map analysisResults;
    private List<ChannelData> metadata;
    private MeasurementViewerLoader currentLoader;
    private MeasurementViewer component;
    private SaveRelatedData event;
    private BufferedImage rndImage;
    private String fileSaved;

    private List sortROIShape(List nodes) {
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                long i1 = ((ROIShape)o1).getID();
                long i2 = ((ROIShape)o2).getID();
                int v = 0;
                if (i1 < i2) {
                    v = -1;
                } else if (i1 > i2) {
                    v = 1;
                }
                return v;
            }
        };
        Collections.sort(nodes, c);
        return nodes;
    }

    MeasurementViewerModel(long imageID, PixelsData pixels, String name, Rectangle bounds, List<ChannelData> channelsData) {
        this.metadata = channelsData;
        this.imageID = imageID;
        this.pixels = pixels;
        this.name = name;
        this.requesterBounds = bounds;
        this.state = 1;
        this.drawingComponent = new DrawingComponent();
        this.roiComponent = new ROIComponent();
        this.fileSaved = null;
        this.roiComponent.setMicronsPixelX(this.getPixelSizeX());
        this.roiComponent.setMicronsPixelY(this.getPixelSizeY());
        this.roiComponent.setMicronsPixelZ(this.getPixelSizeZ());
    }

    void initialize(MeasurementViewer component) {
        this.component = component;
    }

    ROIComponent getROIComponent() {
        return this.roiComponent;
    }

    String getUserName() {
        return MeasurementAgent.getRegistry().getDataService().getLoggingName();
    }

    String getServerName() {
        return MeasurementAgent.getRegistry().getDataService().getServerName();
    }

    void setPlane(int z, int t) {
        this.currentPlane = new Coord3D(z, t);
    }

    boolean isSameDisplay(MeasurementViewerModel other) {
        if (other == null) {
            return false;
        }
        return other.pixels.getId() == this.getPixelsID() && other.imageID == this.imageID;
    }

    long getImageID() {
        return this.imageID;
    }

    long getPixelsID() {
        return this.pixels.getId();
    }

    String getImageName() {
        return this.name;
    }

    String getImageTitle() {
        return "[ID: " + this.getImageID() + "] " + EditorUtil.getPartialName(this.getImageName());
    }

    Rectangle getRequesterBounds() {
        return this.requesterBounds;
    }

    int getState() {
        return this.state;
    }

    DrawingEditor getDrawingEditor() {
        return this.drawingComponent.getEditor();
    }

    Drawing getDrawing() {
        return this.drawingComponent.getDrawing();
    }

    void discard() {
        this.cancel();
        this.state = 6;
    }

    void cancel() {
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
        }
        this.state = 5;
    }

    int getDefaultZ() {
        return this.currentPlane.getZSection();
    }

    int getDefaultT() {
        return this.currentPlane.getTimePoint();
    }

    double getMagnification() {
        return this.magnification;
    }

    void setMagnification(double magnification) {
        this.magnification = magnification;
        if (this.state != 1) {
            this.getDrawingView().setScaleFactor(magnification, new Dimension(this.getSizeX(), this.getSizeY()));
        } else {
            this.getDrawingView().setScaleFactor(magnification);
        }
    }

    void setAttributes(AttributeKey key, Object value) {
        List figures = this.getDrawing().getFigures();
        for (Figure f : figures) {
            f.setAttribute(key, value);
        }
        this.getDrawingView().repaint();
    }

    boolean setROI(InputStream input) throws ROICreationException, NoSuchROIException, ParsingException {
        List<ROI> roiList = this.roiComponent.loadROI(input);
        if (roiList == null) {
            return false;
        }
        Iterator<ROI> i = roiList.iterator();
        int sizeZ = this.pixels.getSizeZ();
        int sizeT = this.pixels.getSizeT();
        this.state = 5;
        while (i.hasNext()) {
            ROI roi = i.next();
            TreeMap<Coord3D, ROIShape> shapeList = roi.getShapes();
            for (ROIShape shape : shapeList.values()) {
                Coord3D c = shape.getCoord3D();
                if (c.getTimePoint() > sizeT) {
                    return false;
                }
                if (c.getZSection() <= sizeZ) continue;
                return false;
            }
        }
        this.component.attachListeners(roiList);
        return true;
    }

    TreeMap getROI() {
        return this.roiComponent.getROIMap();
    }

    Coord3D getCurrentView() {
        return this.currentPlane;
    }

    double getPixelSizeX() {
        return this.pixels.getPixelSizeX();
    }

    double getPixelSizeY() {
        return this.pixels.getPixelSizeY();
    }

    double getPixelSizeZ() {
        return this.pixels.getPixelSizeZ();
    }

    int getNumZSections() {
        return this.pixels.getSizeZ();
    }

    int getNumTimePoints() {
        return this.pixels.getSizeT();
    }

    int getSizeX() {
        return this.pixels.getSizeX();
    }

    int getSizeY() {
        return this.pixels.getSizeY();
    }

    DrawingCanvasView getDrawingView() {
        return this.drawingComponent.getDrawingView();
    }

    Collection<ROI> getSelectedROI() {
        Set selectedFigs = this.getDrawingView().getSelectedFigures();
        ArrayList<ROI> roiList = new ArrayList<ROI>();
        for (ROIFigure fig : selectedFigs) {
            roiList.add(fig.getROI());
        }
        return roiList;
    }

    void removeROIShape(long id) throws NoSuchROIException {
        ROIShape shape = this.roiComponent.getShape(id, this.getCurrentView());
        if (shape != null) {
            if (this.drawingComponent.contains(shape.getFigure())) {
                this.drawingComponent.removeFigure(shape.getFigure());
            } else {
                this.roiComponent.deleteShape(id, this.getCurrentView());
            }
        }
    }

    void removeROIShape(long id, Coord3D coord) throws NoSuchROIException {
        ROIShape shape = this.roiComponent.getShape(id, coord);
        if (shape != null) {
            if (this.drawingComponent.contains(shape.getFigure())) {
                this.drawingComponent.removeFigure(shape.getFigure());
            } else {
                this.roiComponent.deleteShape(id, coord);
            }
        }
    }

    void removeROI(long id) throws NoSuchROIException {
        ROIShape shape = this.roiComponent.getShape(id, this.getCurrentView());
        if (shape != null && this.drawingComponent.contains(shape.getFigure())) {
            this.drawingComponent.removeFigure(shape.getFigure());
        }
        if (this.roiComponent.containsROI(id)) {
            this.roiComponent.deleteROI(id);
        }
    }

    ROI getROI(long id) throws NoSuchROIException {
        return this.roiComponent.getROI(id);
    }

    ROI createROI(ROIFigure figure) throws ROICreationException, NoSuchROIException {
        return this.roiComponent.addROI(figure, this.getCurrentView());
    }

    ROI createROI(ROIFigure figure, boolean addAttribs) throws ROICreationException, NoSuchROIException {
        return this.roiComponent.addROI(figure, this.getCurrentView(), addAttribs);
    }

    ShapeList getShapeList() throws NoSuchROIException {
        return this.roiComponent.getShapeList(this.currentPlane);
    }

    void figureAttributeChanged(AttributeKey attribute, ROIFigure figure) {
        this.mapFigureAttributeToROIAnnotation(attribute, figure);
    }

    private void mapFigureAttributeToROIAnnotation(AttributeKey attribute, ROIFigure figure) {
        if (attribute.getKey().equals(MeasurementAttributes.TEXT.getKey())) {
            ROIShape shape = figure.getROIShape();
            AnnotationKeys.TEXT.set(shape, (String)MeasurementAttributes.TEXT.get((Figure)figure));
        }
    }

    void fireROILoading(String fileName) {
        Logger log;
        this.state = 3;
        InputStream stream = null;
        try {
            if (fileName == null) {
                fileName = FileMap.getSavedFile(this.getServerName(), this.getUserName(), this.getPixelsID());
            }
            this.fileSaved = fileName;
            stream = IOUtil.readFile(fileName);
        }
        catch (Exception e) {
            log = MeasurementAgent.getRegistry().getLogger();
            log.warn((Object)this, "Cannot load the ROI " + e.getMessage());
        }
        this.component.setROI(stream);
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (Exception e) {
            log = MeasurementAgent.getRegistry().getLogger();
            log.warn((Object)this, "Cannot close the stream " + e.getMessage());
        }
    }

    String getFileSaved() {
        return this.fileSaved;
    }

    void saveROI(String fileName, boolean post) throws ParsingException {
        Logger log;
        OutputStream stream = null;
        try {
            stream = IOUtil.writeFile(fileName);
        }
        catch (Exception e) {
            log = MeasurementAgent.getRegistry().getLogger();
            log.warn((Object)this, "Cannot save the ROI " + e.getMessage());
        }
        this.roiComponent.saveROI(stream);
        try {
            if (stream != null) {
                stream.close();
            }
            FileMap.setSavedFile(this.getServerName(), this.getUserName(), this.getPixelsID(), fileName);
            if (!post) {
                this.event = null;
            }
            this.setDataDiscarded();
        }
        catch (Exception e) {
            log = MeasurementAgent.getRegistry().getLogger();
            log.warn((Object)this, "Cannot close the stream " + e.getMessage());
        }
    }

    List<ROIShape> propagateShape(ROIShape shape, int timePoint, int zSection) throws ROICreationException, NoSuchROIException {
        this.setDataChanged();
        Coord3D coord = new Coord3D(zSection, timePoint);
        return this.roiComponent.propagateShape(shape.getID(), shape.getCoord3D(), shape.getCoord3D(), coord);
    }

    void deleteShape(ROIShape shape, int timePoint, int zSection) throws NoSuchROIException {
        if (this.drawingComponent.contains(shape.getFigure())) {
            this.drawingComponent.getDrawing().remove((Figure)shape.getFigure());
        } else {
            this.setDataChanged();
            this.roiComponent.deleteShape(shape.getID(), shape.getCoord3D(), new Coord3D(zSection, timePoint));
        }
    }

    void showMeasurementsInMicrons(boolean inMicrons) {
        this.roiComponent.showMeasurementsInMicrons(inMicrons);
    }

    MeasurementUnits getMeasurementUnits() {
        return this.roiComponent.getMeasurementUnits();
    }

    void setActiveChannels(Map activeChannels) {
        this.activeChannels = activeChannels;
    }

    void fireAnalyzeShape(List<ROIShape> shapeList) {
        this.state = 4;
        ArrayList channels = new ArrayList(this.activeChannels.size());
        channels.addAll(this.activeChannels.keySet());
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
        }
        this.currentLoader = new Analyser(this.component, this.pixels, channels, shapeList);
        this.currentLoader.load();
    }

    List<ChannelData> getMetadata() {
        return this.metadata;
    }

    ChannelData getMetadata(int index) {
        if (index < 0 || index >= this.metadata.size()) {
            return null;
        }
        for (ChannelData d : this.metadata) {
            if (d.getIndex() != index) continue;
            return d;
        }
        return null;
    }

    void setAnalysisResults(Map analysisResults) {
        this.analysisResults = analysisResults;
        if (analysisResults != null) {
            Iterator i = analysisResults.entrySet().iterator();
            ArrayList<ROIShape> l = new ArrayList<ROIShape>(analysisResults.size());
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                ROIShape shape = (ROIShape)entry.getKey();
                l.add(shape);
            }
            List newList = this.sortROIShape(l);
            LinkedHashMap m = new LinkedHashMap(analysisResults.size());
            for (ROIShape shape : newList) {
                m.put(shape, analysisResults.get(shape));
            }
            this.analysisResults = m;
        }
        this.state = 5;
    }

    Map getAnalysisResults() {
        return this.analysisResults;
    }

    Map getActiveChannels() {
        return this.activeChannels;
    }

    Color getActiveChannelColor(int index) {
        return (Color)this.activeChannels.get(index);
    }

    Collection<Figure> getSelectedFigures() {
        return this.getDrawingView().getSelectedFigures();
    }

    boolean isChannelActive(int index) {
        return this.activeChannels.get(index) != null;
    }

    void setDataDiscarded() {
        EventBus bus = MeasurementAgent.getRegistry().getEventBus();
        this.event = new SaveRelatedData(this.getPixelsID(), new SaveData(this.getPixelsID(), 0), "The ROI", false);
        bus.post(this.event);
        this.event = null;
    }

    void setDataChanged() {
        if (this.event != null) {
            return;
        }
        EventBus bus = MeasurementAgent.getRegistry().getEventBus();
        this.event = new SaveRelatedData(this.getPixelsID(), new SaveData(this.getPixelsID(), 0), "The ROI", true);
        bus.post(this.event);
    }

    void calculateStats(List<ROIShape> shapeList) {
        this.component.analyseShapeList(shapeList);
    }

    ROI cloneROI(long id) throws ROICreationException, NoSuchROIException {
        return this.roiComponent.cloneROI(id);
    }

    void deleteShape(long id, Coord3D coord) throws NoSuchROIException {
        this.roiComponent.deleteShape(id, coord);
    }

    void addShape(long id, Coord3D coord, ROIShape shape) throws ROICreationException, NoSuchROIException {
        this.roiComponent.addShape(id, coord, shape);
    }

    void setRenderedImage(BufferedImage rndImage) {
        this.rndImage = rndImage;
    }

    BufferedImage getRenderedImage() {
        return this.rndImage;
    }

    boolean hasROIToSave() {
        return this.event != null;
    }
}

