/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Rectangle;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.events.iviewer.MeasurementTool;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerComponent;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import pojos.ChannelData;
import pojos.PixelsData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasurementViewerFactory
implements ChangeListener {
    private static final MeasurementViewerFactory singleton = new MeasurementViewerFactory();
    private Set<MeasurementViewer> viewers = new HashSet<MeasurementViewer>();
    private Set<MeasurementTool> requests = new HashSet<MeasurementTool>();

    public static MeasurementViewer getViewer(PixelsData pixels, long imageID, String name, Rectangle bounds, int z, int t, double magnification, Map activeChannels, List<ChannelData> channelsData) {
        MeasurementViewerModel model = new MeasurementViewerModel(imageID, pixels, name, bounds, channelsData);
        model.setPlane(z, t);
        model.setMagnification(magnification);
        model.setActiveChannels(activeChannels);
        return singleton.createROIViewer(model);
    }

    public static MeasurementViewer getViewer(long pixelsID) {
        for (MeasurementViewerComponent measurementViewerComponent : MeasurementViewerFactory.singleton.viewers) {
            if (measurementViewerComponent.getModel().getPixelsID() != pixelsID) continue;
            return measurementViewerComponent;
        }
        return null;
    }

    public static void addRequest(MeasurementTool request) {
        if (request == null) {
            return;
        }
        MeasurementViewerFactory.singleton.requests.add(request);
    }

    public static MeasurementTool getRequest(long pixelsID) {
        for (MeasurementTool request : MeasurementViewerFactory.singleton.requests) {
            PixelsData pixels = request.getPixels();
            if (pixels == null || pixels.getId() != pixelsID) continue;
            return request;
        }
        return null;
    }

    private MeasurementViewerFactory() {
    }

    private MeasurementViewer createROIViewer(MeasurementViewerModel model) {
        for (MeasurementViewerComponent measurementViewerComponent : this.viewers) {
            if (!model.isSameDisplay(measurementViewerComponent.getModel())) continue;
            return measurementViewerComponent;
        }
        MeasurementViewerComponent measurementViewerComponent = new MeasurementViewerComponent(model);
        measurementViewerComponent.initialize();
        measurementViewerComponent.addChangeListener(this);
        this.viewers.add(measurementViewerComponent);
        return measurementViewerComponent;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        MeasurementViewerComponent comp = (MeasurementViewerComponent)e.getSource();
        if (comp.getState() == 6) {
            this.viewers.remove(comp);
        }
    }
}

