/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jhotdraw.draw.DrawingEvent;
import org.jhotdraw.draw.DrawingListener;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.FigureSelectionListener;
import org.openmicroscopy.shoola.agents.measurement.actions.CreateFigureAction;
import org.openmicroscopy.shoola.agents.measurement.actions.LoadROIAction;
import org.openmicroscopy.shoola.agents.measurement.actions.MeasurementViewerAction;
import org.openmicroscopy.shoola.agents.measurement.actions.RefreshResultsTableAction;
import org.openmicroscopy.shoola.agents.measurement.actions.ResultsWizardAction;
import org.openmicroscopy.shoola.agents.measurement.actions.SaveROIAction;
import org.openmicroscopy.shoola.agents.measurement.actions.SaveResultsAction;
import org.openmicroscopy.shoola.agents.measurement.actions.ShowROIAssistant;
import org.openmicroscopy.shoola.agents.measurement.actions.UnitsAction;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.util.roi.figures.MeasureLineFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasurePointFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureTextFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.LoadingWindow;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourPicker;

class MeasurementViewerControl
implements ChangeListener,
DrawingListener,
FigureListener,
FigureSelectionListener,
PropertyChangeListener,
WindowFocusListener,
KeyListener {
    static final Integer SAVE = 0;
    static final Integer LOAD = 1;
    static final Integer SAVE_RESULTS = 2;
    static final Integer REFRESH_RESULTS = 3;
    static final Integer RESULTS_WIZARD = 4;
    static final Integer ROI_ASSISTANT = 5;
    static final Integer IN_MICRONS = 6;
    static final Integer IN_PIXELS = 7;
    static final Integer CREATESINGLEFIGURE = 8;
    static final Integer CREATEMULTIPLEFIGURE = 9;
    private MeasurementViewer model;
    private MeasurementViewerUI view;
    private Map<Integer, MeasurementViewerAction> actionsMap;

    private void createActions() {
        this.actionsMap.put(SAVE, new SaveROIAction(this.model));
        this.actionsMap.put(LOAD, new LoadROIAction(this.model));
        this.actionsMap.put(SAVE_RESULTS, new SaveResultsAction(this.model));
        this.actionsMap.put(REFRESH_RESULTS, new RefreshResultsTableAction(this.model));
        this.actionsMap.put(RESULTS_WIZARD, new ResultsWizardAction(this.model));
        this.actionsMap.put(ROI_ASSISTANT, new ShowROIAssistant(this.model));
        this.actionsMap.put(IN_MICRONS, new UnitsAction(this.model, true));
        this.actionsMap.put(IN_PIXELS, new UnitsAction(this.model, false));
        this.actionsMap.put(CREATESINGLEFIGURE, new CreateFigureAction(this.model, true));
        this.actionsMap.put(CREATEMULTIPLEFIGURE, new CreateFigureAction(this.model, false));
    }

    private void setROIFigureStatus(int status) {
        Set selectedFigures = this.view.getDrawingView().getSelectedFigures();
        if (selectedFigures.size() != 1) {
            return;
        }
        for (Figure fig : selectedFigures) {
            if (!(fig instanceof ROIFigure)) continue;
            ROIFigure roiFigure = (ROIFigure)fig;
            roiFigure.setStatus(status);
            this.handleFigureChange(roiFigure);
        }
    }

    private void handleFigureChange(ROIFigure figure) {
        if (figure instanceof MeasureLineFigure || figure instanceof MeasurePointFigure) {
            figure.calculateMeasurements();
            this.view.refreshResultsTable();
            this.model.setDataChanged();
            if (!this.view.inDataView()) {
                return;
            }
            ROIShape shape = figure.getROIShape();
            ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
            ROI roi = shape.getROI();
            TreeMap<Coord3D, ROIShape> shapeMap = roi.getShapes();
            Iterator<Coord3D> shapeIterator = shapeMap.keySet().iterator();
            while (shapeIterator.hasNext()) {
                shapeList.add(shapeMap.get(shapeIterator.next()));
            }
            if (shapeList.size() != 0) {
                this.model.analyseShapeList(shapeList);
            }
            return;
        }
        if (figure.getStatus() != 0) {
            return;
        }
        figure.calculateMeasurements();
        this.view.refreshResultsTable();
        this.model.setDataChanged();
        if (!this.view.inDataView()) {
            return;
        }
        ROIShape shape = figure.getROIShape();
        ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
        ROI roi = shape.getROI();
        TreeMap<Coord3D, ROIShape> shapeMap = roi.getShapes();
        Iterator<Coord3D> shapeIterator = shapeMap.keySet().iterator();
        while (shapeIterator.hasNext()) {
            ROIShape thisShape = shapeMap.get(shapeIterator.next());
            shapeList.add(thisShape);
        }
        if (shapeList.size() != 0) {
            this.model.analyseShapeList(shapeList);
        }
    }

    MeasurementViewerControl() {
    }

    void initialize(MeasurementViewer model, MeasurementViewerUI view) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.model = model;
        this.view = view;
        model.addChangeListener(this);
        model.addPropertyChangeListener(this);
        this.actionsMap = new HashMap<Integer, MeasurementViewerAction>();
        this.createActions();
    }

    void attachListeners() {
        this.view.getLoadingWindow().addPropertyChangeListener("closed", this);
        this.view.getDrawing().addDrawingListener((DrawingListener)this);
        this.view.getDrawingView().addFigureSelectionListener(this);
        this.view.getDrawingView().addKeyListener(this);
        this.view.setDefaultCloseOperation(0);
        this.view.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MeasurementViewerControl.this.model.close();
            }

            public void windowOpened(WindowEvent e) {
                MeasurementViewerControl.this.view.addWindowFocusListener(this);
            }
        });
        this.view.getDrawingView().addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                MeasurementViewerControl.this.setROIFigureStatus(0);
            }
        });
        this.view.getDrawingView().addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                MeasurementViewerControl.this.setROIFigureStatus(1);
            }
        });
    }

    void toFront() {
        if (this.view.getExtendedState() != 0) {
            return;
        }
        if (!this.view.isFocused()) {
            this.view.removeWindowFocusListener(this);
            if (this.view.isVisible()) {
                this.view.setVisible(true);
            }
        }
    }

    MeasurementViewerAction getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    void showColorPicker(Color color) {
        if (color == null) {
            return;
        }
        ColourPicker colourPicker = new ColourPicker(this.view, color);
        colourPicker.addPropertyChangeListener("colour", this);
        UIUtilities.setLocationRelativeTo(this.view, (Component)colourPicker);
    }

    void analyseSelectedFigures() {
        Collection figures = this.model.getSelectedFigures();
        if (figures.size() == 1) {
            ROIFigure figure = (ROIFigure)figures.iterator().next();
            ROIShape shape = figure.getROIShape();
            if (this.view.inDataView()) {
                ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
                ROI roi = shape.getROI();
                TreeMap<Coord3D, ROIShape> shapeMap = roi.getShapes();
                Iterator<Coord3D> shapeIterator = shapeMap.keySet().iterator();
                while (shapeIterator.hasNext()) {
                    shapeList.add(shapeMap.get(shapeIterator.next()));
                }
                if (shapeList.size() != 0) {
                    this.model.analyseShapeList(shapeList);
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("colour".equals(name)) {
            this.view.setCellColor((Color)evt.getNewValue());
        } else if ("closed".equals(name)) {
            this.model.discard();
        }
    }

    public void stateChanged(ChangeEvent e) {
        int state = this.model.getState();
        switch (state) {
            case 4: {
                this.view.setStatus("Analysing Shape.");
                break;
            }
            case 2: {
                LoadingWindow w = this.view.getLoadingWindow();
                if (!w.isVisible()) {
                    UIUtilities.centerAndShow(w);
                }
                this.view.setStatus("Loading.");
                break;
            }
            case 5: {
                this.view.getLoadingWindow().setVisible(false);
                this.view.setStatus("Ready.");
                if (this.view.isVisible()) break;
                this.view.setOnScreen();
                break;
            }
            case 6: {
                LoadingWindow window = this.view.getLoadingWindow();
                window.setVisible(false);
                window.dispose();
                this.view.setVisible(false);
                this.view.dispose();
            }
        }
    }

    public void figureAdded(DrawingEvent e) {
        Figure f = e.getFigure();
        if (!(f instanceof ROIFigure)) {
            return;
        }
        ROIFigure roiFigure = (ROIFigure)f;
        roiFigure.setStatus(1);
        this.view.addROI(roiFigure);
        roiFigure.addFigureListener(this);
        this.model.setDataChanged();
        if (!this.view.inDataView()) {
            return;
        }
        ROIShape shape = roiFigure.getROIShape();
        ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
        ROI roi = shape.getROI();
        TreeMap<Coord3D, ROIShape> shapeMap = roi.getShapes();
        Iterator<Coord3D> shapeIterator = shapeMap.keySet().iterator();
        while (shapeIterator.hasNext()) {
            shapeList.add(shapeMap.get(shapeIterator.next()));
        }
        if (shapeList.size() == 0) {
            return;
        }
        if (f instanceof MeasureLineFigure || f instanceof MeasurePointFigure) {
            roiFigure.setStatus(0);
            this.model.analyseShapeList(shapeList);
        }
    }

    public void figureRemoved(DrawingEvent e) {
        if (this.model.getState() != 5) {
            return;
        }
        Figure f = e.getFigure();
        if (f instanceof ROIFigure) {
            this.view.removeROI((ROIFigure)f);
        }
        this.model.setDataChanged();
    }

    public void selectionChanged(FigureSelectionEvent evt) {
        Set figures = evt.getView().getSelectedFigures();
        if (figures == null) {
            return;
        }
        if (this.view.inDataView() && figures.size() == 1) {
            ROIFigure figure = (ROIFigure)figures.iterator().next();
            if (figure == null) {
                return;
            }
            ROIShape shape = figure.getROIShape();
            if (shape == null) {
                return;
            }
            ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
            ROI roi = shape.getROI();
            if (roi == null) {
                return;
            }
            TreeMap<Coord3D, ROIShape> shapeMap = roi.getShapes();
            Iterator<Coord3D> shapeIterator = shapeMap.keySet().iterator();
            while (shapeIterator.hasNext()) {
                shapeList.add(shapeMap.get(shapeIterator.next()));
            }
            if (shapeList.size() != 0) {
                this.model.analyseShapeList(shapeList);
            }
        }
        this.view.setSelectedFigures(figures);
    }

    public void figureAttributeChanged(FigureEvent e) {
        Figure f = e.getFigure();
        if (f instanceof ROIFigure) {
            ROIFigure fig = (ROIFigure)f;
            this.view.onAttributeChanged(fig);
            this.view.refreshInspectorTable();
            this.model.figureAttributeChanged(e.getAttribute(), fig);
            this.model.setDataChanged();
        }
    }

    public void figureChanged(FigureEvent e) {
        Figure f = e.getFigure();
        if (f instanceof ROIFigure) {
            ROIFigure roiFigure = (ROIFigure)f;
            this.handleFigureChange(roiFigure);
        }
    }

    public void keyTyped(KeyEvent e) {
        char ANALYSECHAR = 'a';
        if (e.getKeyChar() == ANALYSECHAR) {
            Set selectedFigures = this.view.getDrawingView().getSelectedFigures();
            if (selectedFigures.size() != 1) {
                return;
            }
            Iterator iterator = selectedFigures.iterator();
            ROIFigure fig = (ROIFigure)iterator.next();
            if (fig instanceof MeasureTextFigure) {
                return;
            }
            ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
            shapeList.add(fig.getROIShape());
            this.view.calculateStats(shapeList);
        }
    }

    public void windowGainedFocus(WindowEvent e) {
    }

    public void windowLostFocus(WindowEvent e) {
    }

    public void areaInvalidated(DrawingEvent e) {
    }

    public void figureAdded(FigureEvent e) {
    }

    public void figureAreaInvalidated(FigureEvent e) {
    }

    public void figureRemoved(FigureEvent e) {
    }

    public void figureRequestRemove(FigureEvent e) {
    }

    public void figureHandlesChanged(FigureEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }
}

