/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingListener;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.agents.events.measurement.MeasurementToolLoaded;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.util.FileMap;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewer;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerControl;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerFactory;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.log.Logger;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.filter.file.XMLFilter;
import org.openmicroscopy.shoola.util.roi.exception.ParsingException;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.ShapeList;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MeasurementViewerComponent
extends AbstractComponent
implements MeasurementViewer {
    private MeasurementViewerModel model;
    private MeasurementViewerControl controller;
    private MeasurementViewerUI view;

    private void postEvent(int index) {
        MeasurementToolLoaded response = new MeasurementToolLoaded(MeasurementViewerFactory.getRequest(this.model.getPixelsID()), (JComponent)((Object)this.model.getDrawingView()), index);
        EventBus bus = MeasurementAgent.getRegistry().getEventBus();
        bus.post(response);
    }

    private FileChooser createChooserDialog(int type) {
        String word = "Save ";
        if (type == 0) {
            word = "Load ";
        }
        String title = word + "the ROI File";
        String text = word + "the ROI data in the file associate with the image.";
        ArrayList<FileFilter> filters = new ArrayList<FileFilter>();
        filters.add(new XMLFilter());
        FileChooser chooser = new FileChooser(this.view, type, title, text, filters);
        File f = UIUtilities.getDefaultFolder();
        if (f != null) {
            chooser.setCurrentDirectory(f);
        }
        try {
            String s = FileMap.getSavedFile(this.model.getServerName(), this.model.getUserName(), this.model.getPixelsID());
            if (s != null) {
                File savedFile = new File(s);
                chooser.setCurrentDirectory(savedFile);
                chooser.setSelectedFile(savedFile);
            } else if (type == 1) {
                s = this.model.getImageName();
                File savedFile = new File(s);
                chooser.setSelectedFile(savedFile.getName());
            }
        }
        catch (ParsingException e) {
            // empty catch block
        }
        return chooser;
    }

    MeasurementViewerComponent(MeasurementViewerModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new MeasurementViewerControl();
        this.view = new MeasurementViewerUI(model.getImageTitle());
    }

    void initialize() {
        this.model.initialize(this);
        this.controller.initialize(this, this.view);
        this.view.initialize(this, this.controller, this.model);
    }

    MeasurementViewerModel getModel() {
        return this.model;
    }

    @Override
    public void activate() {
        int state = this.model.getState();
        switch (state) {
            case 1: {
                double f = this.model.getMagnification();
                Dimension d = new Dimension((int)((double)this.model.getSizeX() * f), (int)((double)this.model.getSizeY() * f));
                UIUtilities.setDefaultSize((Component)((Object)this.model.getDrawingView()), d);
                this.model.getDrawingView().setSize(d);
                this.model.fireROILoading(null);
                this.fireStateChange();
                break;
            }
            case 6: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
            default: {
                if (!this.view.isVisible()) {
                    this.postEvent(0);
                }
                this.view.deIconify();
                this.view.setVisible(true);
            }
        }
    }

    @Override
    public JFrame getUI() {
        return this.view;
    }

    @Override
    public void discard() {
        if (this.model.getState() != 6) {
            this.model.discard();
            this.fireStateChange();
        }
    }

    @Override
    public void setDataChanged() {
        this.model.setDataChanged();
        this.firePropertyChange("roiChanged", Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public void cancel() {
        this.model.cancel();
        this.view.setReadyStatus();
        this.fireStateChange();
    }

    @Override
    public int getState() {
        return this.model.getState();
    }

    @Override
    public void setROI(InputStream input) {
        block8: {
            if (this.model.getState() != 3 || input == null) {
                return;
            }
            Registry reg = MeasurementAgent.getRegistry();
            Logger log = reg.getLogger();
            try {
                boolean valid = this.model.setROI(input);
                if (valid) break block8;
                reg.getUserNotifier().notifyInfo("ROI", "The ROI are not compatible with the image.");
                try {
                    input.close();
                }
                catch (Exception io) {
                    log.warn((Object)this, "Cannot close the stream " + io.getMessage());
                }
                this.fireStateChange();
                return;
            }
            catch (Exception e) {
                if (e instanceof ParsingException) {
                    log.error((Object)this, "Cannot parse the ROI for " + this.model.getImageID());
                }
                try {
                    input.close();
                }
                catch (Exception io) {
                    log.warn((Object)this, "Cannot close the stream " + io.getMessage());
                }
                return;
            }
        }
        this.view.rebuildManagerTable();
        this.view.updateDrawingArea();
        this.view.setReadyStatus();
        this.fireStateChange();
        this.postEvent(0);
    }

    @Override
    public void setMagnifiedPlane(int defaultZ, int defaultT, double magnification) {
        int z = this.model.getDefaultZ();
        int t = this.model.getDefaultT();
        double f = this.model.getMagnification();
        if (z == defaultZ && t == defaultT) {
            if (f != magnification) {
                this.model.setMagnification(magnification);
            }
        } else {
            this.model.setPlane(defaultZ, defaultT);
            Drawing drawing = this.model.getDrawing();
            drawing.removeDrawingListener((DrawingListener)this.controller);
            drawing.clear();
            ShapeList list = null;
            try {
                list = this.model.getShapeList();
            }
            catch (Exception e) {
                this.view.handleROIException(e, "Cannot retrieve the ROI");
            }
            this.view.setStatus("");
            if (list != null) {
                TreeMap<Long, ROIShape> map = list.getList();
                for (ROIShape shape : map.values()) {
                    if (shape == null) continue;
                    drawing.add((Figure)shape.getFigure());
                    shape.getFigure().addFigureListener(this.controller);
                }
            }
            this.model.getDrawingView().setDrawing(drawing);
            drawing.addDrawingListener((DrawingListener)this.controller);
            if (f != magnification) {
                this.model.setMagnification(magnification);
            }
        }
    }

    @Override
    public void close() {
        if (this.model.getState() == 6) {
            return;
        }
        this.postEvent(1);
        this.view.setVisible(false);
    }

    @Override
    public void iconified(boolean b) {
        if (this.model.getState() == 6) {
            throw new IllegalStateException("This method shouldn't be invoked in the DISCARDED state:" + this.model.getState());
        }
        this.view.setVisible(b);
    }

    @Override
    public void loadROI() {
        FileChooser chooser = this.createChooserDialog(0);
        if (chooser.showDialog() != 0) {
            return;
        }
        File f = chooser.getSelectedFile();
        if (f == null) {
            return;
        }
        this.model.fireROILoading(f.getAbsolutePath());
        this.fireStateChange();
        this.view.updateDrawingArea();
    }

    @Override
    public void saveROI() {
        FileChooser chooser = this.createChooserDialog(1);
        if (chooser.showDialog() != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (file == null) {
            return;
        }
        String s = file.getAbsolutePath();
        if (s == null || s.trim().length() == 0) {
            return;
        }
        if (!s.endsWith("xml")) {
            String fileName = s + "." + "xml";
            file = new File(fileName);
        }
        this.saveBackROI(file.getAbsolutePath());
    }

    @Override
    public void refreshResultsTable() {
        this.view.refreshResultsTable();
    }

    @Override
    public void rebuildManagerTable() {
        this.view.rebuildManagerTable();
    }

    @Override
    public void saveResultsTable() {
        Registry reg = MeasurementAgent.getRegistry();
        UserNotifier un = reg.getUserNotifier();
        boolean saved = false;
        try {
            saved = this.view.saveResultsTable();
        }
        catch (Exception e) {
            reg.getLogger().error((Object)this, "Cannot save the results " + e.getMessage());
            un.notifyInfo("Save ROI results", "Cannot save the ROI results");
        }
        if (saved) {
            un.notifyInfo("Save ROI results", "The ROI results have been successfully saved.");
        }
    }

    @Override
    public void figureAttributeChanged(AttributeKey key, ROIFigure figure) {
        this.model.figureAttributeChanged(key, figure);
    }

    @Override
    public void showResultsWizard() {
        this.view.showResultsWizard();
    }

    @Override
    public void showROIAssistant() {
        this.view.showROIAssistant();
    }

    @Override
    public void showROIAssistant(ROI roi) {
        this.view.showROIAssistant(roi);
    }

    @Override
    public void showMeasurementsInMicrons(boolean inMicrons) {
        this.model.showMeasurementsInMicrons(inMicrons);
        this.view.updateDrawingArea();
        this.refreshResultsTable();
    }

    @Override
    public void setActiveChannels(Map activeChannels) {
        int state = this.model.getState();
        switch (this.model.getState()) {
            case 2: 
            case 6: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, LOADING_DATA state: " + state);
            }
        }
        this.model.setActiveChannels(activeChannels);
        if (!this.view.inDataView() || !this.view.isVisible()) {
            return;
        }
        Collection collection = this.getSelectedFigures();
        if (collection.size() != 1) {
            return;
        }
        ROIFigure figure = (ROIFigure)collection.iterator().next();
        ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
        ROI roi = figure.getROI();
        TreeMap<Coord3D, ROIShape> shapeMap = roi.getShapes();
        Iterator<Coord3D> shapeIterator = shapeMap.keySet().iterator();
        while (shapeIterator.hasNext()) {
            shapeList.add(shapeMap.get(shapeIterator.next()));
        }
        if (shapeList.size() != 0) {
            this.analyseShapeList(shapeList);
        }
    }

    @Override
    public void setActiveChannelsColor(Map channels) {
        int state = this.model.getState();
        switch (this.model.getState()) {
            case 2: 
            case 6: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, LOADING_DATA state: " + state);
            }
        }
        this.model.setActiveChannels(channels);
        if (!this.view.inDataView() || !this.view.isVisible()) {
            return;
        }
        Collection collection = this.getSelectedFigures();
        if (collection.size() != 1) {
            return;
        }
        ROIFigure figure = (ROIFigure)collection.iterator().next();
        ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
        ROI roi = figure.getROI();
        TreeMap<Coord3D, ROIShape> shapeMap = roi.getShapes();
        Iterator<Coord3D> shapeIterator = shapeMap.keySet().iterator();
        while (shapeIterator.hasNext()) {
            shapeList.add(shapeMap.get(shapeIterator.next()));
        }
        if (shapeList.size() != 0) {
            this.analyseShapeList(shapeList);
        }
    }

    @Override
    public void setStatsShapes(Map result) {
        int state = this.model.getState();
        if (state != 4) {
            MeasurementAgent.getRegistry().getLogger().debug((Object)this, "This method can only be invoked in the ANALYSE_SHAPE state: " + state);
            return;
        }
        if (result == null || result.size() == 0) {
            UserNotifier un = MeasurementAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Sets stats results", "No result to display.");
            return;
        }
        this.model.setAnalysisResults(result);
        this.view.displayAnalysisResults();
        this.fireStateChange();
    }

    @Override
    public void analyseShapeList(List<ROIShape> shapeList) {
        if (shapeList == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        int state = this.model.getState();
        switch (this.model.getState()) {
            case 2: 
            case 3: 
            case 6: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED, LOADING_DATA or LOADING_ROI state: " + state);
            }
            case 4: {
                return;
            }
        }
        if (this.model.getActiveChannels().size() == 0) {
            this.view.displayAnalysisResults();
        } else {
            this.model.fireAnalyzeShape(shapeList);
            this.fireStateChange();
        }
    }

    @Override
    public Collection getSelectedFigures() {
        return this.model.getSelectedFigures();
    }

    @Override
    public void attachListeners(List<ROI> roiList) {
        for (int i = 0; i < roiList.size(); ++i) {
            ROI roi = roiList.get(i);
            for (ROIShape shape : roi.getShapes().values()) {
                shape.getFigure().addFigureListener(this.controller);
            }
        }
    }

    @Override
    public void createSingleFigure(boolean createSingleFig) {
        this.view.createSingleFigure(createSingleFig);
    }

    private void saveBackROI(String path) {
        Registry reg = MeasurementAgent.getRegistry();
        UserNotifier un = reg.getUserNotifier();
        try {
            this.model.saveROI(path, false);
        }
        catch (ParsingException e) {
            reg.getLogger().error((Object)this, "Cannot save the ROI " + e.getMessage());
            un.notifyInfo("Save ROI", "Cannot save ROI for " + this.model.getImageID());
        }
        un.notifyInfo("Save ROI", "The Regions of Interests have been successfully saved. ");
        this.firePropertyChange("roiChanged", Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public void saveAndDiscard() {
        String fileSaved = this.model.getFileSaved();
        if (fileSaved != null) {
            this.saveBackROI(fileSaved);
            return;
        }
        ArrayList<FileFilter> filterList = new ArrayList<FileFilter>();
        filterList.add(new XMLFilter());
        FileChooser chooser = new FileChooser(this.view, 1, "Save the ROI File", "Save the ROI data in the file associate with this image.", filterList);
        File f = UIUtilities.getDefaultFolder();
        if (f != null) {
            chooser.setCurrentDirectory(f);
        }
        try {
            File savedFile;
            String savedFileString = FileMap.getSavedFile(this.model.getServerName(), this.model.getUserName(), this.model.getPixelsID());
            if (savedFileString == null) {
                savedFileString = this.model.getImageName();
                savedFile = new File(savedFileString);
                chooser.setSelectedFile(savedFile.getName());
            } else {
                savedFile = new File(savedFileString);
                chooser.setCurrentDirectory(savedFile);
                chooser.setSelectedFile(savedFile);
            }
        }
        catch (ParsingException e) {
            // empty catch block
        }
        int results = chooser.showDialog();
        if (results != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (!"xml".endsWith(file.getAbsolutePath())) {
            String fileName = file.getAbsolutePath() + "." + "xml";
            file = new File(fileName);
        }
        this.saveBackROI(file.getAbsolutePath());
        this.discard();
    }

    @Override
    public void toFront() {
        if (this.model.getState() == 6) {
            return;
        }
        this.controller.toFront();
    }

    @Override
    public void setIconImage(BufferedImage thumbnail) {
        if (this.model.getState() == 6) {
            return;
        }
        this.view.setIconImage(thumbnail);
    }

    @Override
    public void setRndImage(BufferedImage rndImage) {
        if (this.model.getState() == 6) {
            return;
        }
        this.model.setRenderedImage(rndImage);
    }

    @Override
    public boolean hasROIToSave() {
        if (this.model.getState() == 6) {
            return false;
        }
        return this.model.hasROIToSave();
    }
}

