/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.util.TabPaneInterface;
import org.openmicroscopy.shoola.agents.measurement.util.model.AnnotationDescription;
import org.openmicroscopy.shoola.agents.measurement.util.model.AnnotationField;
import org.openmicroscopy.shoola.agents.measurement.util.model.MeasurementObject;
import org.openmicroscopy.shoola.agents.measurement.util.ui.AttributeUnits;
import org.openmicroscopy.shoola.agents.measurement.util.ui.ResultsCellRenderer;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerControl;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.agents.measurement.view.ResultsWizard;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.util.file.ExcelWriter;
import org.openmicroscopy.shoola.util.filter.file.ExcelFilter;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKey;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.roi.model.util.MeasurementUnits;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;

class MeasurementResults
extends JPanel
implements TabPaneInterface {
    public static final int INDEX = 2;
    private static final int COLUMNWIDTH = 64;
    private static final int ROIID_COLUMN = 0;
    private static final int TIME_COLUMN = 1;
    private static final int Z_COLUMN = 2;
    private static final String NAME = "Results";
    private List<KeyDescription> columnNames;
    private List<AnnotationField> fields;
    private List<AnnotationField> allFields;
    private JButton saveButton;
    private JButton refreshButton;
    private JButton resultsWizardButton;
    private ResultsTable results;
    private JScrollPane scrollPane;
    private MeasurementViewerControl controller;
    private MeasurementViewerModel model;
    private MeasurementViewerUI view;
    private ListSelectionListener listener;

    public int getIndex() {
        return 2;
    }

    private void initComponents() {
        this.saveButton = new JButton(this.controller.getAction(MeasurementViewerControl.SAVE_RESULTS));
        this.resultsWizardButton = new JButton(this.controller.getAction(MeasurementViewerControl.RESULTS_WIZARD));
        this.refreshButton = new JButton(this.controller.getAction(MeasurementViewerControl.REFRESH_RESULTS));
        this.createAllFields();
        this.createDefaultFields();
        this.results = new ResultsTable();
        this.results.getTableHeader().setReorderingAllowed(false);
        MeasurementTableModel tm = new MeasurementTableModel(this.columnNames, this.model.getMeasurementUnits());
        this.results.setModel(tm);
        this.results.setSelectionMode(0);
        this.results.setRowSelectionAllowed(true);
        this.results.setColumnSelectionAllowed(false);
        this.listener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int index = lsm.getMinSelectionIndex();
                    if (index < 0) {
                        return;
                    }
                    MeasurementTableModel m = (MeasurementTableModel)MeasurementResults.this.results.getModel();
                    try {
                        long ROIID = (Long)m.getValueAt(index, 0);
                        int t = (Integer)m.getValueAt(index, 1) - 1;
                        int z = (Integer)m.getValueAt(index, 2) - 1;
                        ROI roi = MeasurementResults.this.model.getROI(ROIID);
                        if (roi == null) {
                            return;
                        }
                        MeasurementResults.this.view.selectFigure(ROIID, t, z);
                    }
                    catch (Exception exception) {
                        Registry reg = MeasurementAgent.getRegistry();
                        reg.getUserNotifier().notifyWarning("ROI does not exist", "ROI does not exist. Results may be out of date, try refreshing results.");
                    }
                }
            }
        };
        this.results.getSelectionModel().addListSelectionListener(this.listener);
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.results);
        this.add((Component)this.scrollPane, "Center");
        this.scrollPane.setVerticalScrollBar(this.scrollPane.createVerticalScrollBar());
        this.scrollPane.setHorizontalScrollBar(this.scrollPane.createHorizontalScrollBar());
        JPanel panel = new JPanel();
        panel.add(this.resultsWizardButton);
        panel.add(this.refreshButton);
        panel.add(this.saveButton);
        this.add((Component)panel, "South");
    }

    private void createAllFields() {
        this.allFields = new ArrayList<AnnotationField>();
        this.allFields.add(new AnnotationField(AnnotationKeys.TEXT, AnnotationDescription.annotationDescription.get(AnnotationKeys.TEXT), false));
        this.allFields.add(new AnnotationField(AnnotationKeys.CENTREX, AnnotationDescription.annotationDescription.get(AnnotationKeys.CENTREX), false));
        this.allFields.add(new AnnotationField(AnnotationKeys.CENTREY, AnnotationDescription.annotationDescription.get(AnnotationKeys.CENTREY), false));
        this.allFields.add(new AnnotationField(AnnotationKeys.AREA, AnnotationDescription.annotationDescription.get(AnnotationKeys.AREA), false));
        this.allFields.add(new AnnotationField(AnnotationKeys.PERIMETER, AnnotationDescription.annotationDescription.get(AnnotationKeys.PERIMETER), false));
        this.allFields.add(new AnnotationField(AnnotationKeys.LENGTH, AnnotationDescription.annotationDescription.get(AnnotationKeys.LENGTH), false));
        this.allFields.add(new AnnotationField(AnnotationKeys.WIDTH, AnnotationDescription.annotationDescription.get(AnnotationKeys.WIDTH), false));
        this.allFields.add(new AnnotationField(AnnotationKeys.HEIGHT, AnnotationDescription.annotationDescription.get(AnnotationKeys.HEIGHT), false));
        this.allFields.add(new AnnotationField(AnnotationKeys.ANGLE, AnnotationDescription.annotationDescription.get(AnnotationKeys.ANGLE), false));
        this.allFields.add(new AnnotationField(AnnotationKeys.POINTARRAYX, AnnotationDescription.annotationDescription.get(AnnotationKeys.POINTARRAYX), false));
        this.allFields.add(new AnnotationField(AnnotationKeys.POINTARRAYY, AnnotationDescription.annotationDescription.get(AnnotationKeys.POINTARRAYY), false));
        this.allFields.add(new AnnotationField(AnnotationKeys.STARTPOINTX, AnnotationDescription.annotationDescription.get(AnnotationKeys.STARTPOINTX), false));
        this.allFields.add(new AnnotationField(AnnotationKeys.STARTPOINTY, AnnotationDescription.annotationDescription.get(AnnotationKeys.STARTPOINTY), false));
        this.allFields.add(new AnnotationField(AnnotationKeys.ENDPOINTX, AnnotationDescription.annotationDescription.get(AnnotationKeys.ENDPOINTX), false));
        this.allFields.add(new AnnotationField(AnnotationKeys.ENDPOINTY, AnnotationDescription.annotationDescription.get(AnnotationKeys.ENDPOINTY), false));
    }

    private void createDefaultFields() {
        this.fields = new ArrayList<AnnotationField>();
        this.fields.add(new AnnotationField(AnnotationKeys.TEXT, AnnotationDescription.annotationDescription.get(AnnotationKeys.TEXT), false));
        this.fields.add(new AnnotationField(AnnotationKeys.CENTREX, AnnotationDescription.annotationDescription.get(AnnotationKeys.CENTREX), false));
        this.fields.add(new AnnotationField(AnnotationKeys.CENTREY, AnnotationDescription.annotationDescription.get(AnnotationKeys.CENTREY), false));
        this.fields.add(new AnnotationField(AnnotationKeys.AREA, AnnotationDescription.annotationDescription.get(AnnotationKeys.AREA), false));
        this.fields.add(new AnnotationField(AnnotationKeys.LENGTH, AnnotationDescription.annotationDescription.get(AnnotationKeys.LENGTH), false));
        this.fields.add(new AnnotationField(AnnotationKeys.WIDTH, AnnotationDescription.annotationDescription.get(AnnotationKeys.WIDTH), false));
        this.fields.add(new AnnotationField(AnnotationKeys.HEIGHT, AnnotationDescription.annotationDescription.get(AnnotationKeys.HEIGHT), false));
        this.fields.add(new AnnotationField(AnnotationKeys.ANGLE, AnnotationDescription.annotationDescription.get(AnnotationKeys.ANGLE), false));
        this.columnNames = new ArrayList<KeyDescription>();
        this.columnNames.add(new KeyDescription("id", "id"));
        this.columnNames.add(new KeyDescription("T", "T"));
        this.columnNames.add(new KeyDescription("Z", "Z"));
        this.columnNames.add(new KeyDescription("Type", "Type"));
        for (int i = 0; i < this.fields.size(); ++i) {
            this.columnNames.add(new KeyDescription(this.fields.get(i).getKey().toString(), this.fields.get(i).getName()));
        }
    }

    MeasurementResults(MeasurementViewerControl controller, MeasurementViewerModel model, MeasurementViewerUI view) {
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        this.controller = controller;
        this.model = model;
        this.view = view;
        this.initComponents();
        this.buildGUI();
    }

    void populate() {
        TreeMap map = this.model.getROI();
        Iterator i = map.keySet().iterator();
        MeasurementTableModel tm = new MeasurementTableModel(this.columnNames, this.model.getMeasurementUnits());
        while (i.hasNext()) {
            ROI roi = (ROI)map.get(i.next());
            TreeMap<Coord3D, ROIShape> shapes = roi.getShapes();
            Iterator<Coord3D> j = shapes.keySet().iterator();
            while (j.hasNext()) {
                ROIShape shape = shapes.get(j.next());
                ROIFigure figure = shape.getFigure();
                figure.calculateMeasurements();
                MeasurementObject row = new MeasurementObject();
                row.addElement(shape.getROI().getID());
                row.addElement(shape.getCoord3D().getTimePoint() + 1);
                row.addElement(shape.getCoord3D().getZSection() + 1);
                row.addElement(shape.getFigure().getType());
                for (int k = 0; k < this.fields.size(); ++k) {
                    AnnotationKey key = this.fields.get(k).getKey();
                    Object value = key.get(shape);
                    if (value instanceof List) {
                        List valueArray = (List)value;
                        ArrayList arrayList = new ArrayList(valueArray);
                        row.addElement(arrayList);
                        continue;
                    }
                    row.addElement(value);
                }
                tm.addRow(row);
            }
        }
        this.results.setModel(tm);
        this.resizeTableColumns();
    }

    private void resizeTableColumns() {
        int columnWidth = 0;
        Font font = this.getFont();
        FontMetrics metrics = this.getFontMetrics(font);
        MeasurementTableModel tm = (MeasurementTableModel)this.results.getModel();
        for (int i = 0; i < this.results.getColumnCount(); ++i) {
            TableColumn col = this.results.getColumnModel().getColumn(i);
            int w = metrics.stringWidth(tm.getColumnName(i));
            columnWidth = Math.max(w, 64);
            col.setMinWidth(columnWidth);
            col.setPreferredWidth(columnWidth);
        }
    }

    String getComponentName() {
        return NAME;
    }

    Icon getComponentIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(3);
    }

    boolean saveResults() throws IOException {
        int choice;
        ArrayList<FileFilter> filterList = new ArrayList<FileFilter>();
        ExcelFilter filter = new ExcelFilter();
        filterList.add(filter);
        FileChooser chooser = new FileChooser(this.view, 1, "Save the Results", "Save the Results data to a file which can be loaded by a spreadsheet.", filterList);
        File f = UIUtilities.getDefaultFolder();
        if (f != null) {
            chooser.setCurrentDirectory(f);
        }
        if ((choice = chooser.showDialog()) != 0) {
            return false;
        }
        File file = chooser.getSelectedFile();
        if (!file.getAbsolutePath().endsWith("xls")) {
            String fileName = file.getAbsolutePath() + "." + "xls";
            file = new File(fileName);
        }
        String filename = file.getAbsolutePath();
        ExcelWriter writer = new ExcelWriter(filename);
        writer.openFile();
        writer.createSheet("Measurement Results");
        writer.writeTableToSheet(0, 0, this.results.getModel());
        BufferedImage originalImage = this.model.getRenderedImage();
        BufferedImage image = Factory.copyBufferedImage(originalImage);
        this.model.setAttributes(MeasurementAttributes.SHOWID, true);
        this.model.getDrawingView().print(image.getGraphics());
        this.model.setAttributes(MeasurementAttributes.SHOWID, false);
        String imageName = "ROIImage";
        try {
            writer.addImageToWorkbook(imageName, image);
        }
        catch (Exception e) {
            // empty catch block
        }
        int col = writer.getMaxColumn(0);
        writer.writeImage(0, col + 1, 256, 256, imageName);
        writer.close();
        return true;
    }

    public void refreshResults() {
        this.populate();
    }

    void showResultsWizard() {
        ResultsWizard resultsWizard = new ResultsWizard(this.fields, this.allFields);
        resultsWizard.pack();
        UIUtilities.setLocationRelativeToAndShow(this, resultsWizard);
        this.columnNames.clear();
        this.columnNames = new ArrayList<KeyDescription>();
        this.columnNames.add(new KeyDescription("id", "id"));
        this.columnNames.add(new KeyDescription("T", "T"));
        this.columnNames.add(new KeyDescription("Z", "Z"));
        this.columnNames.add(new KeyDescription("Type", "Type"));
        for (int i = 0; i < this.fields.size(); ++i) {
            this.columnNames.add(new KeyDescription(this.fields.get(i).getKey().toString(), this.fields.get(i).getName()));
        }
        this.populate();
        this.results.repaint();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MeasurementTableModel
    extends AbstractTableModel {
        private MeasurementUnits unitsType;
        private List<KeyDescription> columnNames;
        private List<MeasurementObject> values;

        MeasurementTableModel(List<KeyDescription> colNames, MeasurementUnits units) {
            if (colNames == null) {
                throw new IllegalArgumentException("No column's names specified.");
            }
            this.columnNames = colNames;
            this.values = new ArrayList<MeasurementObject>();
            this.unitsType = units;
        }

        void addRow(MeasurementObject row) {
            this.values.add(row);
            this.fireTableStructureChanged();
        }

        MeasurementObject getRow(int index) {
            if (index < this.values.size()) {
                return this.values.get(index);
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < 0 || row > this.values.size()) {
                return null;
            }
            MeasurementObject rowData = this.values.get(row);
            return rowData.getElement(col);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }

        @Override
        public String getColumnName(int col) {
            if (AttributeUnits.getUnits(this.columnNames.get(col).getKey(), this.unitsType).equals("")) {
                return this.columnNames.get(col).getDescription();
            }
            return this.columnNames.get(col).getDescription() + " (" + AttributeUnits.getUnits(this.columnNames.get(col).getKey(), this.unitsType) + ")";
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.size();
        }

        @Override
        public int getRowCount() {
            return this.values.size();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class ResultsTable
    extends JTable {
        ResultsTable() {
            this.setAutoResizeMode(0);
            int columnWidth = 0;
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            for (int i = 0; i < this.getColumnCount(); ++i) {
                int w = metrics.stringWidth(this.getColumnName(i));
                columnWidth = Math.max(w, 64);
                TableColumn col = this.getColumnModel().getColumn(i);
                col.setMinWidth(columnWidth);
                col.setPreferredWidth(columnWidth);
            }
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            return new ResultsCellRenderer();
        }
    }

    class KeyDescription {
        String key;
        String description;

        public KeyDescription(String key, String description) {
            this.key = key;
            this.description = description;
        }

        public String getKey() {
            return this.key;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

