/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.util.TabPaneInterface;
import org.openmicroscopy.shoola.agents.measurement.util.model.AnalysisStatsWrapper;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.log.Logger;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.file.ExcelWriter;
import org.openmicroscopy.shoola.util.filter.file.ExcelFilter;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.roi.figures.MeasureTextFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;
import pojos.ChannelData;

class IntensityResultsView
extends JPanel
implements ActionListener,
TabPaneInterface {
    public static final int INDEX = 6;
    private static final String ADD_NAME = "Add";
    private static final String ADD_DESCRIPTION = "Add Intensities for selected ROI to results table.";
    private static final String REMOVE_NAME = "Remove";
    private static final String REMOVE_DESCRIPTION = "Remove Results in selected row from table.";
    private static final String REMOVE_ALL_NAME = "Remove All";
    private static final String REMOVE_ALL_DESCRIPTION = "Remove all the Results from table.";
    private static final String SAVE_NAME = "Export to Excel";
    private static final String SAVE_DESCRIPTION = "Save Intensities to Excel File.";
    private MeasurementViewerUI view;
    private JTable results;
    private ResultsTableModel resultsModel;
    private JButton removeButton;
    private JButton saveButton;
    private JButton addButton;
    private JButton removeAllButton;
    private State state = State.READY;
    private static final String NAME = "Intensity Results View";
    private static final int REMOVE = 0;
    private static final int ADD = 1;
    private static final int REMOVE_ALL = 2;
    private static final int SAVE = 3;
    private MeasurementViewerModel model;
    private Map ROIStats;
    private Map<Integer, String> channelName = new TreeMap<Integer, String>();
    private Map<Integer, Color> channelColour = new TreeMap<Integer, Color>();
    private Map<Integer, Double> channelSum = new TreeMap<Integer, Double>();
    private Map<Integer, Double> channelMin = new TreeMap<Integer, Double>();
    private Map<Integer, Double> channelMax = new TreeMap<Integer, Double>();
    private Map<Integer, Double> channelMean = new TreeMap<Integer, Double>();
    private Map<Integer, Double> channelStdDev = new TreeMap<Integer, Double>();
    private Map<String, Integer> nameMap = new HashMap<String, Integer>();
    private Map<Coord3D, Map<Integer, Double>> minStats;
    private Map<Coord3D, Map<Integer, Double>> maxStats;
    private Map<Coord3D, Map<Integer, Double>> meanStats;
    private Map<Coord3D, Map<Integer, Double>> stdDevStats;
    private Map<Coord3D, Map<Integer, Double>> sumStats;
    private Map<Coord3D, ROIShape> shapeMap;
    Coord3D coord;
    private ROIShape shape;

    public int getIndex() {
        return 6;
    }

    private void initComponents() {
        this.state = State.READY;
        this.removeButton = new JButton(REMOVE_NAME);
        this.removeButton.setToolTipText(UIUtilities.formatToolTipText(REMOVE_DESCRIPTION));
        this.removeButton.setActionCommand("0");
        this.removeButton.addActionListener(this);
        this.saveButton = new JButton(SAVE_NAME);
        this.saveButton.setToolTipText(UIUtilities.formatToolTipText(SAVE_DESCRIPTION));
        this.saveButton.setActionCommand("3");
        this.saveButton.addActionListener(this);
        this.setButtonsEnabled(false);
        this.addButton = new JButton(ADD_NAME);
        this.addButton.setToolTipText(UIUtilities.formatToolTipText(ADD_DESCRIPTION));
        this.addButton.setActionCommand("1");
        this.addButton.addActionListener(this);
        this.removeAllButton = new JButton(REMOVE_ALL_NAME);
        this.removeAllButton.setToolTipText(UIUtilities.formatToolTipText(REMOVE_ALL_DESCRIPTION));
        this.removeAllButton.setActionCommand("2");
        this.removeAllButton.addActionListener(this);
    }

    private void setButtonsEnabled(boolean enabled) {
        this.saveButton.setEnabled(enabled);
    }

    private void buildGUI() {
        this.resultsModel = new ResultsTableModel();
        this.resultsModel.addColumn("id");
        this.resultsModel.addColumn("Z");
        this.resultsModel.addColumn("T");
        this.resultsModel.addColumn("Channel");
        this.resultsModel.addColumn("Annotation");
        this.resultsModel.addColumn("Min");
        this.resultsModel.addColumn("Max");
        this.resultsModel.addColumn("Sum");
        this.resultsModel.addColumn("Mean");
        this.resultsModel.addColumn("stdDev");
        this.results = new JTable(this.resultsModel);
        JPanel centrePanel = new JPanel();
        centrePanel.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.results);
        centrePanel.add((Component)scrollPane, "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout());
        bottomPanel.add(this.addButton);
        bottomPanel.add(this.removeButton);
        bottomPanel.add(this.removeAllButton);
        bottomPanel.add(this.saveButton);
        JPanel containerPanel = new JPanel();
        containerPanel.setLayout(new BorderLayout());
        containerPanel.add((Component)centrePanel, "Center");
        containerPanel.add((Component)bottomPanel, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)containerPanel, "Center");
    }

    private void getResults(ROIShape shape) {
        Vector rows = new Vector();
        Iterator<String> channelIterator = this.channelName.values().iterator();
        this.channelMin = this.minStats.get(this.coord);
        this.channelMax = this.maxStats.get(this.coord);
        this.channelMean = this.meanStats.get(this.coord);
        this.channelStdDev = this.stdDevStats.get(this.coord);
        this.channelSum = this.sumStats.get(this.coord);
        while (channelIterator.hasNext()) {
            String cName = channelIterator.next();
            int channel = this.nameMap.get(cName);
            Vector<Object> rowData = new Vector<Object>();
            rowData.add(shape.getID());
            rowData.add(shape.getCoord3D().getZSection() + 1);
            rowData.add(shape.getCoord3D().getTimePoint() + 1);
            rowData.add(cName);
            rowData.add(AnnotationKeys.TEXT.get(shape));
            rowData.add(this.channelMin.get(channel));
            rowData.add(this.channelMax.get(channel));
            rowData.add(this.channelSum.get(channel));
            rowData.add(this.channelMean.get(channel));
            rowData.add(this.channelStdDev.get(channel));
            rows.add(rowData);
        }
        for (Vector vector : rows) {
            this.resultsModel.addRow(vector);
        }
        this.results.repaint();
    }

    private void saveResults() {
        int option;
        ArrayList<FileFilter> filterList = new ArrayList<FileFilter>();
        ExcelFilter filter = new ExcelFilter();
        filterList.add(filter);
        FileChooser chooser = new FileChooser(this.view, 1, "Save Results to Excel", "Save the Results data to a file which can be loaded by a spreadsheet.", filterList);
        File f = UIUtilities.getDefaultFolder();
        if (f != null) {
            chooser.setCurrentDirectory(f);
        }
        if ((option = chooser.showDialog()) != 0) {
            return;
        }
        File file = chooser.getFormattedSelectedFile();
        try {
            String filename = file.getAbsolutePath();
            ExcelWriter writer = new ExcelWriter(filename);
            writer.openFile();
            writer.createSheet("Intensity Results");
            writer.writeTableToSheet(0, 0, this.resultsModel);
            BufferedImage originalImage = this.model.getRenderedImage();
            BufferedImage image = Factory.copyBufferedImage(originalImage);
            this.model.setAttributes(MeasurementAttributes.SHOWID, true);
            this.model.getDrawingView().print(image.getGraphics());
            this.model.setAttributes(MeasurementAttributes.SHOWID, false);
            try {
                writer.addImageToWorkbook("ThumbnailImage", image);
            }
            catch (Exception e) {
                // empty catch block
            }
            int col = writer.getMaxColumn(0);
            writer.writeImage(0, col + 1, 256, 256, "ThumbnailImage");
            writer.close();
        }
        catch (IOException e) {
            Logger logger = MeasurementAgent.getRegistry().getLogger();
            logger.error((Object)this, "Cannot save ROI results: " + e.toString());
            UserNotifier un = MeasurementAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Save Results", "An error occured while trying to save the data.\nPlease try again.");
        }
        Registry reg = MeasurementAgent.getRegistry();
        UserNotifier un = reg.getUserNotifier();
        un.notifyInfo("Save ROI results", "The ROI results have been successfully saved.");
    }

    private void removeResults() {
        int[] rows = this.results.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            this.resultsModel.removeRow(rows[i]);
        }
        this.setButtonsEnabled(this.results.getRowCount() > 0);
    }

    private void removeAllResults() {
        int count = this.results.getRowCount();
        for (int i = count - 1; i >= 0; --i) {
            this.resultsModel.removeRow(i);
        }
        this.setButtonsEnabled(this.results.getRowCount() > 0);
    }

    private void addResults() {
        Set selectedFigures = this.view.getDrawingView().getSelectedFigures();
        if (selectedFigures.size() == 0 || this.state == State.ANALYSING) {
            return;
        }
        this.state = State.ANALYSING;
        ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
        for (ROIFigure fig : selectedFigures) {
            if (fig instanceof MeasureTextFigure) continue;
            shapeList.add(fig.getROIShape());
        }
        this.view.calculateStats(shapeList);
        this.state = State.READY;
        this.setButtonsEnabled(true);
    }

    IntensityResultsView(MeasurementViewerUI view, MeasurementViewerModel model) {
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.view = view;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    String getComponentName() {
        return NAME;
    }

    Icon getComponentIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(27);
    }

    void displayAnalysisResults() {
        this.ROIStats = this.model.getAnalysisResults();
        if (this.ROIStats == null || this.ROIStats.size() == 0) {
            return;
        }
        this.shapeMap = new LinkedHashMap<Coord3D, ROIShape>();
        this.minStats = new HashMap<Coord3D, Map<Integer, Double>>();
        this.maxStats = new HashMap<Coord3D, Map<Integer, Double>>();
        this.meanStats = new HashMap<Coord3D, Map<Integer, Double>>();
        this.sumStats = new HashMap<Coord3D, Map<Integer, Double>>();
        this.stdDevStats = new HashMap<Coord3D, Map<Integer, Double>>();
        Iterator j = this.ROIStats.entrySet().iterator();
        this.channelName = new TreeMap<Integer, String>();
        this.nameMap = new HashMap<String, Integer>();
        List<ChannelData> metadata = this.model.getMetadata();
        while (j.hasNext()) {
            Map.Entry entry = j.next();
            this.shape = (ROIShape)entry.getKey();
            this.shapeMap.put(this.shape.getCoord3D(), this.shape);
            if (this.shape.getFigure() instanceof MeasureTextFigure) {
                this.state = State.READY;
                return;
            }
            Coord3D c3D = this.shape.getCoord3D();
            Map<AnalysisStatsWrapper.StatsType, Map> shapeStats = AnalysisStatsWrapper.convertStats((Map)entry.getValue());
            this.minStats.put(c3D, shapeStats.get((Object)AnalysisStatsWrapper.StatsType.MIN));
            this.maxStats.put(c3D, shapeStats.get((Object)AnalysisStatsWrapper.StatsType.MAX));
            this.meanStats.put(c3D, shapeStats.get((Object)AnalysisStatsWrapper.StatsType.MEAN));
            this.sumStats.put(c3D, shapeStats.get((Object)AnalysisStatsWrapper.StatsType.SUM));
            this.stdDevStats.put(c3D, shapeStats.get((Object)AnalysisStatsWrapper.StatsType.STDDEV));
            this.channelName.clear();
            this.nameMap.clear();
            this.channelColour.clear();
            for (ChannelData channelData : metadata) {
                int channel = channelData.getIndex();
                if (!this.model.isChannelActive(channel)) continue;
                this.channelName.put(channel, channelData.getChannelLabeling());
                this.nameMap.put(this.channelName.get(channel), channel);
                this.channelColour.put(channel, (Color)this.model.getActiveChannels().get(channel));
            }
            if (this.channelName.size() == 0 || this.nameMap.size() == 0 || this.channelColour.size() == 0) {
                this.state = State.READY;
                return;
            }
            this.coord = c3D;
            this.getResults(this.shape);
        }
        this.state = State.READY;
    }

    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 1: {
                this.addResults();
                break;
            }
            case 3: {
                this.saveResults();
                break;
            }
            case 0: {
                this.removeResults();
                break;
            }
            case 2: {
                this.removeAllResults();
            }
        }
    }

    class ResultsTableModel
    extends DefaultTableModel {
        ResultsTableModel() {
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        ANALYSING,
        READY;

    }
}

