/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.util.TabPaneInterface;
import org.openmicroscopy.shoola.agents.measurement.util.model.AnalysisStatsWrapper;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerControl;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.util.roi.figures.MeasureBezierFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureLineFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureTextFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.graphutils.HistogramPlot;
import org.openmicroscopy.shoola.util.ui.graphutils.LinePlot;
import org.openmicroscopy.shoola.util.ui.slider.OneKnobSlider;
import pojos.ChannelData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GraphPane
extends JPanel
implements TabPaneInterface {
    static final int READY = 1;
    static final int ANALYSING = 0;
    public static final int INDEX = 3;
    private static final String NAME = "Graph Pane";
    private MeasurementViewerModel model;
    private Map ROIStats;
    private OneKnobSlider zSlider;
    private OneKnobSlider tSlider;
    private JPanel mainPanel;
    private HashMap<Coord3D, Map<AnalysisStatsWrapper.StatsType, Map>> shapeStatsList;
    private Map<Coord3D, Map<Integer, double[]>> pixelStats;
    private Map<Coord3D, ROIShape> shapeMap;
    private List<String> channelName;
    private List<Color> channelColour;
    private Coord3D coord;
    private LinePlot lineProfileChart;
    private HistogramPlot histogramChart;
    private int state = 1;
    private MeasurementViewerUI view;
    private ROIShape shape;

    @Override
    public int getIndex() {
        return 3;
    }

    private boolean lineProfileFigure(ROIShape shape) {
        MeasureBezierFigure fig;
        ROIFigure f = shape.getFigure();
        if (f instanceof MeasureLineFigure) {
            return true;
        }
        return f instanceof MeasureBezierFigure && !(fig = (MeasureBezierFigure)f).isClosed();
    }

    private double channelMinValue() {
        Map channels = this.model.getActiveChannels();
        Iterator i = channels.entrySet().iterator();
        double value = 0.0;
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            int channel = (Integer)entry.getKey();
            value = Math.min(value, this.model.getMetadata(channel).getGlobalMin());
        }
        return value;
    }

    private double channelMaxValue() {
        Map channels = this.model.getActiveChannels();
        Iterator i = channels.entrySet().iterator();
        double value = 0.0;
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            int channel = (Integer)entry.getKey();
            value = Math.max(value, this.model.getMetadata(channel).getGlobalMax());
        }
        return value;
    }

    private void handleSliderReleased() {
        if (this.zSlider == null || this.tSlider == null) {
            return;
        }
        if (this.coord == null) {
            return;
        }
        if (this.state == 0) {
            return;
        }
        Coord3D thisCoord = new Coord3D(this.zSlider.getValue() - 1, this.tSlider.getValue() - 1);
        if (this.coord.equals(thisCoord)) {
            return;
        }
        if (!this.pixelStats.containsKey(thisCoord)) {
            return;
        }
        this.state = 0;
        this.buildGraphsAndDisplay();
        this.state = 1;
        if (this.shape != null) {
            this.view.selectFigure(this.shape.getFigure());
        }
    }

    private void initComponents() {
        this.zSlider = new OneKnobSlider();
        this.zSlider.setOrientation(1);
        this.zSlider.setPaintTicks(false);
        this.zSlider.setPaintLabels(false);
        this.zSlider.setMajorTickSpacing(1);
        this.zSlider.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                GraphPane.this.handleSliderReleased();
            }
        });
        this.zSlider.setShowArrows(true);
        this.zSlider.setVisible(false);
        this.zSlider.setEndLabel("Z");
        this.zSlider.setShowEndLabel(true);
        this.tSlider = new OneKnobSlider();
        this.tSlider.setPaintTicks(false);
        this.tSlider.setPaintLabels(false);
        this.tSlider.setMajorTickSpacing(1);
        this.tSlider.setSnapToTicks(true);
        this.tSlider.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                GraphPane.this.handleSliderReleased();
            }
        });
        this.tSlider.setShowArrows(true);
        this.tSlider.setVisible(false);
        this.tSlider.setEndLabel("T");
        this.tSlider.setShowEndLabel(true);
        this.mainPanel = new JPanel();
    }

    private void buildGUI() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel centrePanel = new JPanel();
        centrePanel.setLayout(new BoxLayout(centrePanel, 0));
        centrePanel.add(this.zSlider);
        centrePanel.add(Box.createHorizontalStrut(5));
        centrePanel.add(this.mainPanel);
        this.add(centrePanel);
        this.add(this.tSlider);
    }

    private LinePlot drawLineplot(String title, List<String> channelNames, List<double[][]> data, List<Color> channelColours) {
        if (channelNames.size() == 0 || data.size() == 0 || channelColours.size() == 0) {
            return null;
        }
        LinePlot plot = new LinePlot(title, channelNames, data, channelColours, this.channelMinValue(), this.channelMaxValue());
        plot.setYAxisName("Intensity");
        plot.setXAxisName("Pixel");
        return plot;
    }

    private HistogramPlot drawHistogram(String title, List<String> channelNames, List<double[]> data, List<Color> channelColours, int bins) {
        HistogramPlot plot = new HistogramPlot(title, channelNames, data, channelColours, bins, this.channelMinValue(), this.channelMaxValue());
        plot.setXAxisName("Intensity");
        plot.setYAxisName("Frequency");
        return plot;
    }

    private void buildGraphsAndDisplay() {
        this.coord = new Coord3D(this.zSlider.getValue() - 1, this.tSlider.getValue() - 1);
        Map<Integer, double[]> data = this.pixelStats.get(this.coord);
        if (data == null) {
            return;
        }
        this.shape = this.shapeMap.get(this.coord);
        ArrayList<double[]> channelData = new ArrayList<double[]>();
        ArrayList<double[][]> channelXYData = new ArrayList<double[][]>();
        this.channelName.clear();
        this.channelColour.clear();
        channelXYData.clear();
        channelData.clear();
        List<ChannelData> metadata = this.model.getMetadata();
        for (ChannelData cData : metadata) {
            Color c;
            int channel = cData.getIndex();
            if (!this.model.isChannelActive(channel)) continue;
            cData = this.model.getMetadata(channel);
            if (cData != null) {
                this.channelName.add(cData.getChannelLabeling());
            }
            if ((c = this.model.getActiveChannelColor(channel)) == null) {
                c = Color.WHITE;
            }
            this.channelColour.add(c);
            double[] values = data.get(channel);
            if (values == null || values.length == 0) continue;
            channelData.add(values);
            if (!this.lineProfileFigure(this.shape)) continue;
            double[][] dataXY = new double[2][values.length];
            for (int i = 0; i < values.length; ++i) {
                dataXY[0][i] = i;
                dataXY[1][i] = values[i];
            }
            channelXYData.add(dataXY);
        }
        this.mainPanel.removeAll();
        this.lineProfileChart = null;
        this.histogramChart = null;
        if (this.lineProfileFigure(this.shape)) {
            this.lineProfileChart = this.drawLineplot("Line Profile", this.channelName, channelXYData, this.channelColour);
        }
        this.histogramChart = this.drawHistogram("Histogram", this.channelName, channelData, this.channelColour, 1001);
        if (this.lineProfileChart == null && this.histogramChart != null) {
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.add((Component)this.histogramChart.getChart(), "Center");
        }
        if (this.lineProfileChart != null && this.histogramChart != null) {
            this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
            this.mainPanel.add(this.lineProfileChart.getChart());
            this.mainPanel.add(this.histogramChart.getChart());
        }
        this.mainPanel.validate();
        this.mainPanel.repaint();
    }

    GraphPane(MeasurementViewerUI view, MeasurementViewerControl controller, MeasurementViewerModel model) {
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.view = view;
        this.initComponents();
        this.buildGUI();
    }

    String getComponentName() {
        return NAME;
    }

    Icon getComponentIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(26);
    }

    void displayAnalysisResults() {
        this.ROIStats = this.model.getAnalysisResults();
        if (this.ROIStats == null) {
            return;
        }
        this.shapeStatsList = new HashMap();
        this.pixelStats = new HashMap<Coord3D, Map<Integer, double[]>>();
        this.shapeMap = new HashMap<Coord3D, ROIShape>();
        this.channelName = new ArrayList<String>();
        this.channelColour = new ArrayList<Color>();
        Iterator i = this.ROIStats.entrySet().iterator();
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int minT = Integer.MAX_VALUE;
        int maxT = Integer.MIN_VALUE;
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            this.shape = (ROIShape)entry.getKey();
            Coord3D c3D = this.shape.getCoord3D();
            minT = Math.min(minT, c3D.getTimePoint());
            maxT = Math.max(maxT, c3D.getTimePoint());
            minZ = Math.min(minZ, c3D.getZSection());
            maxZ = Math.max(maxZ, c3D.getZSection());
            this.shapeMap.put(c3D, this.shape);
            if (this.shape.getFigure() instanceof MeasureTextFigure) {
                return;
            }
            Map<AnalysisStatsWrapper.StatsType, Map> shapeStats = AnalysisStatsWrapper.convertStats((Map)entry.getValue());
            this.shapeStatsList.put(c3D, shapeStats);
            Map data = shapeStats.get((Object)AnalysisStatsWrapper.StatsType.PIXELDATA);
            this.pixelStats.put(c3D, data);
        }
        this.zSlider.setMaximum(++maxZ);
        this.zSlider.setMinimum(++minZ);
        this.tSlider.setMaximum(++maxT);
        this.tSlider.setMinimum(++minT);
        this.zSlider.setVisible(maxZ != minZ);
        this.tSlider.setVisible(maxT != minT);
        this.tSlider.setValue(this.model.getCurrentView().getTimePoint() + 1);
        this.zSlider.setValue(this.model.getCurrentView().getZSection() + 1);
        this.buildGraphsAndDisplay();
    }
}

