/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import org.openmicroscopy.shoola.agents.measurement.util.model.AttributeField;
import org.openmicroscopy.shoola.agents.measurement.util.model.ValueType;
import org.openmicroscopy.shoola.agents.measurement.util.ui.FigureTable;
import org.openmicroscopy.shoola.agents.measurement.util.ui.RendererUtils;
import org.openmicroscopy.shoola.util.roi.model.util.FigureType;
import org.openmicroscopy.shoola.util.ui.PaintPot;

public class InspectorCellRenderer
extends JComponent
implements TableCellRenderer {
    private static final float FONTSIZE = 10.0f;

    public InspectorCellRenderer() {
        this.setOpaque(true);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        FigureTable figureTable = (FigureTable)table;
        JComponent thisComponent = new JLabel();
        AttributeField field = figureTable.getFieldAt(row);
        if (column == 0) {
            JLabel label = new JLabel();
            label.setOpaque(true);
            label.setText(value + "");
            label.setFont(label.getFont().deriveFont(10.0f));
            thisComponent = label;
        } else if (field.getValueType() == ValueType.DEFAULT) {
            if (value instanceof Double || value instanceof String || value instanceof FigureType || value instanceof Integer || value instanceof Long) {
                JTextField text = new JTextField();
                text.setOpaque(false);
                text.setBorder(BorderFactory.createEmptyBorder());
                text.setText(value + "");
                text.setFont(text.getFont().deriveFont(10.0f));
                thisComponent = text;
            } else if (value instanceof Color) {
                PaintPot paintPot = new PaintPot((Color)value);
                thisComponent = paintPot;
            } else if (value instanceof Boolean) {
                JCheckBox checkBox = new JCheckBox();
                checkBox.setSelected((Boolean)value);
                thisComponent = checkBox;
            }
            if (!(value instanceof Color)) {
                RendererUtils.setRowColor((Component)thisComponent, table.getSelectedRow(), row);
            }
        } else if (field.getValueType() == ValueType.ENUM) {
            JComboBox comboBox = new JComboBox();
            ArrayList valueRange = field.getValueRange();
            int index = 0;
            for (int i = 0; i < valueRange.size(); ++i) {
                comboBox.addItem(valueRange.get(i));
                if (!value.equals(valueRange.get(i))) continue;
                index = i;
            }
            comboBox.setFont(comboBox.getFont().deriveFont(10.0f));
            comboBox.setSelectedIndex(index);
            thisComponent = comboBox;
        }
        return thisComponent;
    }
}

