/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.ui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.openmicroscopy.shoola.util.ui.ColourIcon;

public class ColourListRenderer
extends JLabel
implements ListCellRenderer {
    private static final int GAP = 20;
    private static ColourIcon icon;
    private Border lineBorder;
    private Border emptyBorder;

    public ColourListRenderer() {
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        icon = new ColourIcon(12, 12);
        this.lineBorder = BorderFactory.createLineBorder(Color.gray, 1);
        this.emptyBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        if (value == null) {
            return this;
        }
        Object[] array = (Object[])value;
        if (array.length != 2) {
            return this;
        }
        Color c = (Color)array[0];
        if (c != null) {
            icon.setColour(new Color(c.getRed(), c.getGreen(), c.getBlue()));
        }
        this.setIcon(icon);
        this.setVerticalAlignment(0);
        this.setIconTextGap(20);
        this.setText((String)array[1]);
        if (isSelected) {
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setForeground(list.getForeground());
            this.setBackground(list.getBackground());
        }
        if (hasFocus) {
            this.setBorder(this.lineBorder);
        } else {
            this.setBorder(this.emptyBorder);
        }
        return this;
    }
}

