/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.roitable;

import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.openmicroscopy.shoola.agents.measurement.util.model.AnnotationField;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROITreeNode;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROITreeTableCellRenderer;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROITreeTableModel;
import org.openmicroscopy.shoola.agents.measurement.util.ui.ShapeRenderer;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.graphutils.ShapeType;
import org.openmicroscopy.shoola.util.ui.treetable.OMETreeTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROITreeTable
extends OMETreeTable {
    private ROITreeNode root;
    private Vector<String> columnNames;
    private List<AnnotationField> fields;
    private HashMap<ROI, ROITreeNode> ROIMap;
    private ROITreeTableModel model;

    public ROITreeTable(ROITreeTableModel model, Vector columnNames, List<AnnotationField> fields) {
        super((TreeTableModel)model);
        this.model = model;
        this.root = (ROITreeNode)model.getRoot();
        this.fields = fields;
        this.columnNames = columnNames;
        this.setAutoResizeMode(4);
        this.ROIMap = new HashMap();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            TableColumn column = this.getColumn(i);
            column.setResizable(true);
        }
        this.setDefaultRenderer(ShapeType.class, new ShapeRenderer());
        this.setTreeCellRenderer(new ROITreeTableCellRenderer());
    }

    public void setFields(Vector<String> columnNames, List<AnnotationField> newFields) {
        this.fields = newFields;
    }

    public void addROI(ROI roi) {
        TreeMap<Coord3D, ROIShape> shapeMap = roi.getShapes();
        ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
        Iterator<ROIShape> shapeIterator = shapeMap.values().iterator();
        while (shapeIterator.hasNext()) {
            shapeList.add(shapeIterator.next());
        }
        if (shapeList.size() == 0) {
            return;
        }
        this.addROIShapeList(shapeList);
    }

    public void addROIShape(ROIShape shape) {
        ArrayList<ROIShape> shapeList = new ArrayList<ROIShape>();
        shapeList.add(shape);
        this.addROIShapeList(shapeList);
    }

    public void addROIShapeList(ArrayList<ROIShape> shapeList) {
        ROITreeNode parent = null;
        for (ROIShape shape : shapeList) {
            parent = this.findParent(shape.getROI());
            if (parent == null) {
                parent = new ROITreeNode(shape.getROI());
                parent.setExpanded(true);
                this.ROIMap.put(shape.getROI(), parent);
                int childCount = this.root.getChildCount();
                this.root.insert(parent, childCount);
            }
            ROITreeNode roiShapeNode = parent.findChild(shape.getCoord3D());
            ROITreeNode newNode = new ROITreeNode(shape);
            newNode.setExpanded(true);
            if (roiShapeNode != null) {
                int index = parent.getIndex((TreeNode)((Object)roiShapeNode));
                parent.remove(shape.getCoord3D());
                parent.insert(newNode, index);
                continue;
            }
            parent.insert(newNode, parent.getInsertionPoint(shape.getCoord3D()));
        }
        this.setTreeTableModel((TreeTableModel)new ROITreeTableModel(this.root, this.columnNames, this.fields));
        if (parent != null) {
            this.expandROIRow(parent);
        }
    }

    public void clear() {
        int childCount = this.root.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.root.remove(0);
        }
        this.setTreeTableModel((TreeTableModel)new ROITreeTableModel(this.root, this.columnNames, this.fields));
        this.ROIMap = new HashMap();
        this.invalidate();
        this.repaint();
    }

    public void removeROIShape(ROIShape shape) {
        ROITreeNode parent = this.findParent(shape.getROI());
        if (parent == null) {
            return;
        }
        ROITreeNode child = parent.findChild(shape);
        parent.remove(child);
        if (parent.getChildCount() == 0) {
            this.root.remove(parent);
        }
        this.setTreeTableModel((TreeTableModel)new ROITreeTableModel(this.root, this.columnNames, this.fields));
    }

    public void removeROI(ROI roi) {
        ROITreeNode ROITreeNode2 = this.findParent(roi);
        this.root.remove(ROITreeNode2);
        this.setTreeTableModel((TreeTableModel)new ROITreeTableModel(this.root, this.columnNames, this.fields));
    }

    public ROITreeNode findParent(ROI roi) {
        if (this.ROIMap.containsKey(roi)) {
            return this.ROIMap.get(roi);
        }
        return null;
    }

    public ROIShape getROIShapeAtRow(int index) {
        TreePath path = this.getPathForRow(index);
        if (path == null) {
            return null;
        }
        ROITreeNode node = (ROITreeNode)((Object)path.getLastPathComponent());
        if (node.getUserObject() instanceof ROIShape) {
            return (ROIShape)node.getUserObject();
        }
        return null;
    }

    public ROI getROIAtRow(int index) {
        TreePath path = this.getPathForRow(index);
        ROITreeNode node = (ROITreeNode)((Object)path.getLastPathComponent());
        if (node.getUserObject() instanceof ROI) {
            return (ROI)node.getUserObject();
        }
        return null;
    }

    public boolean isShapeTypeColumn(int column) {
        TableColumn col = this.getColumn(column);
        return this.model.isShapeColumn(col.getModelIndex());
    }

    public void setValueAt(Object obj, int row, int column) {
        ROITreeNode node = (ROITreeNode)this.getNodeAtRow(row);
        super.setValueAt(obj, row, column);
        if (node.getUserObject() instanceof ROI) {
            ROI roi = (ROI)node.getUserObject();
            ROITreeNode expandNode = node;
            if (roi.isVisible()) {
                this.expandROIRow(expandNode);
            } else {
                this.collapseROIRow(expandNode);
            }
        } else {
            ROITreeNode expandNode = (ROITreeNode)node.getParent();
            ROIShape roiShape = (ROIShape)node.getUserObject();
            if (roiShape.getROI().isVisible()) {
                this.expandROIRow(expandNode);
            } else {
                this.collapseROIRow(expandNode);
            }
        }
    }

    public void expandNode(ROITreeNode node) {
        if (node.getUserObject() instanceof ROI) {
            this.expandROIRow((ROI)node.getUserObject());
        }
    }

    public void expandROIRow(ROITreeNode parent) {
        int addedNodeIndex = this.root.getIndex((TreeNode)((Object)parent));
        parent.setExpanded(true);
        this.expandRow(addedNodeIndex);
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            ROITreeNode node = (ROITreeNode)this.root.getChildAt(i);
            if (!node.isExpanded()) continue;
            this.expandPath(node.getPath());
        }
    }

    public void collapseROIRow(ROITreeNode parent) {
        int addedNodeIndex = this.root.getIndex((TreeNode)((Object)parent));
        this.collapseRow(addedNodeIndex);
        parent.setExpanded(false);
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            ROITreeNode node = (ROITreeNode)this.root.getChildAt(i);
            if (!node.isExpanded()) continue;
            this.expandROIRow(node);
        }
    }

    public void expandROIRow(ROI roi) {
        ROITreeNode selectedNode = this.findParent(roi);
        this.expandROIRow(selectedNode);
    }

    public void scrollToROIShape(ROIShape shape) {
        ROITreeNode parent = this.findParent(shape.getROI());
        if (parent == null) {
            return;
        }
        this.expandROIRow(parent);
        ROITreeNode child = parent.findChild(shape);
        this.scrollPathToVisible(child.getPath());
    }

    @Override
    protected void onMousePressed(MouseEvent e) {
    }

    public void refresh() {
        this.setTreeTableModel((TreeTableModel)new ROITreeTableModel(this.root, this.columnNames, this.fields));
    }

    public void setROIAttributesChanged(ROIShape shape) {
        ROITreeNode parent = this.findParent(shape.getROI());
        ROITreeNode child = parent.findChild(shape);
        this.model.nodeUpdated(child);
    }

    public void selectROIShape(ROIShape shape) {
        ROITreeNode parent = this.findParent(shape.getROI());
        if (parent == null) {
            return;
        }
        this.expandROIRow(parent);
        ROITreeNode child = parent.findChild(shape);
        int row = this.getRowForPath(child.getPath());
        this.selectionModel.addSelectionInterval(row, row);
    }

    public void selectROI(ROI roi) {
        ROITreeNode parent = this.findParent(roi);
        if (parent == null) {
            return;
        }
        this.expandROIRow(parent);
        List<MutableTreeTableNode> childList = parent.getChildList();
        for (MutableTreeTableNode child : childList) {
            this.selectROIShape((ROIShape)((ROITreeNode)child).getUserObject());
        }
    }

    public ArrayList getSelectedObjects() {
        Object nodeObject;
        int i;
        int[] selectedRows = this.getSelectedRows();
        TreeMap<Long, ROI> roiMap = new TreeMap<Long, ROI>();
        ArrayList<Object> selectedList = new ArrayList<Object>();
        for (i = 0; i < selectedRows.length; ++i) {
            nodeObject = this.getNodeAtRow(selectedRows[i]).getUserObject();
            if (!(nodeObject instanceof ROI)) continue;
            ROI roi = (ROI)nodeObject;
            roiMap.put(roi.getID(), roi);
            selectedList.add(roi);
        }
        for (i = 0; i < selectedRows.length; ++i) {
            ROIShape roiShape;
            nodeObject = this.getNodeAtRow(selectedRows[i]).getUserObject();
            if (!(nodeObject instanceof ROIShape) || roiMap.containsKey((roiShape = (ROIShape)nodeObject).getID())) continue;
            selectedList.add(roiShape);
        }
        return selectedList;
    }

    public ArrayList<ROIShape> getSelectedROIShapes() {
        Object nodeObject;
        int i;
        int[] selectedRows = this.getSelectedRows();
        TreeMap<Long, ROI> roiMap = new TreeMap<Long, ROI>();
        ArrayList<ROIShape> selectedList = new ArrayList<ROIShape>();
        for (i = 0; i < selectedRows.length; ++i) {
            nodeObject = this.getNodeAtRow(selectedRows[i]).getUserObject();
            if (!(nodeObject instanceof ROI)) continue;
            ROI roi = (ROI)nodeObject;
            roiMap.put(roi.getID(), roi);
            Iterator<ROIShape> shapeIterator = roi.getShapes().values().iterator();
            while (shapeIterator.hasNext()) {
                selectedList.add(shapeIterator.next());
            }
        }
        for (i = 0; i < selectedRows.length; ++i) {
            ROIShape roiShape;
            nodeObject = this.getNodeAtRow(selectedRows[i]).getUserObject();
            if (!(nodeObject instanceof ROIShape) || roiMap.containsKey((roiShape = (ROIShape)nodeObject).getID())) continue;
            selectedList.add(roiShape);
        }
        return selectedList;
    }

    public TreeMap<Coord3D, ROIShape> buildPlaneMap(ArrayList objectList) {
        TreeMap<Coord3D, ROIShape> planeMap = new TreeMap<Coord3D, ROIShape>(new Coord3D());
        for (Object node : objectList) {
            if (node instanceof ROI) {
                ROI roi = (ROI)node;
                TreeMap<Coord3D, ROIShape> shapeMap = roi.getShapes();
                for (Coord3D coord : shapeMap.keySet()) {
                    if (planeMap.containsKey(coord)) {
                        return null;
                    }
                    planeMap.put(coord, shapeMap.get(coord));
                }
                continue;
            }
            if (!(node instanceof ROIShape)) continue;
            ROIShape shape = (ROIShape)node;
            if (planeMap.containsKey(shape.getCoord3D())) {
                return null;
            }
            planeMap.put(shape.getCoord3D(), shape);
        }
        return planeMap;
    }

    public ArrayList<Long> getIDList(ArrayList selectedObjects) {
        TreeMap<Long, ROI> idMap = new TreeMap<Long, ROI>();
        ArrayList<Long> idList = new ArrayList<Long>();
        for (Object node : selectedObjects) {
            ROI roi = node instanceof ROI ? (ROI)node : ((ROIShape)node).getROI();
            if (idMap.containsKey(roi.getID())) continue;
            idMap.put(roi.getID(), roi);
            idList.add(roi.getID());
        }
        return idList;
    }

    public boolean onSeparatePlanes(ArrayList<ROIShape> shapeList) {
        TreeMap<Coord3D, ROIShape> shapeMap = new TreeMap<Coord3D, ROIShape>(new Coord3D());
        for (ROIShape shape : shapeList) {
            if (shapeMap.containsKey(shape.getCoord3D())) {
                return false;
            }
            shapeMap.put(shape.getCoord3D(), shape);
        }
        return true;
    }

    public boolean haveSameID(ArrayList<ROIShape> shapeList) {
        TreeMap<Long, ROIShape> shapeMap = new TreeMap<Long, ROIShape>();
        for (ROIShape shape : shapeList) {
            if (shapeMap.containsKey(shape.getID())) continue;
            if (shapeMap.size() == 0) {
                shapeMap.put(shape.getID(), shape);
                continue;
            }
            return false;
        }
        return true;
    }

    public long getSameID(ArrayList<ROIShape> shapeList) {
        TreeMap<Long, ROIShape> shapeMap = new TreeMap<Long, ROIShape>();
        if (shapeList.size() == 0) {
            return -1L;
        }
        for (ROIShape shape : shapeList) {
            if (shapeMap.containsKey(shape.getID())) continue;
            if (shapeMap.size() == 0) {
                shapeMap.put(shape.getID(), shape);
                continue;
            }
            return -1L;
        }
        return shapeList.get(0).getID();
    }

    public boolean shapesInSameROI(ArrayList shapeList) {
        long id = -1L;
        if (shapeList.size() == 0) {
            return false;
        }
        boolean first = true;
        for (Object node : shapeList) {
            if (node instanceof ROI) {
                return false;
            }
            if (!(node instanceof ROIShape)) continue;
            ROIShape shape = (ROIShape)node;
            if (first) {
                id = shape.getID();
                first = false;
            }
            if (id == shape.getID()) continue;
            return false;
        }
        return true;
    }
}

