/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.roitable;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.treetable.model.OMETreeNode;

public class ROITreeNode
extends OMETreeNode {
    HashMap<ROIShape, ROITreeNode> childMap;
    TreeMap<Coord3D, ROITreeNode> childCoordMap;

    public ROITreeNode(String str) {
        super(str);
        this.initMaps();
    }

    public ROITreeNode(ROI nodeName) {
        super(nodeName);
        this.initMaps();
    }

    public ROITreeNode(ROIShape nodeName) {
        super(nodeName);
        this.initMaps();
    }

    public int getInsertionPoint(Coord3D coord) {
        Iterator<Coord3D> i = this.childCoordMap.keySet().iterator();
        int index = 0;
        while (i.hasNext()) {
            Coord3D nodeCoord = i.next();
            if (nodeCoord.compare(nodeCoord, coord) != -1) {
                return index;
            }
            ++index;
        }
        return index;
    }

    private void initMaps() {
        this.childMap = new HashMap();
        this.childCoordMap = new TreeMap(new Coord3D());
    }

    public ROITreeNode findChild(ROIShape shape) {
        if (this.childMap.containsKey(shape)) {
            return this.childMap.get(shape);
        }
        return null;
    }

    public ROITreeNode findChild(Coord3D shapeCoord) {
        if (this.childCoordMap.containsKey(shapeCoord)) {
            return this.childCoordMap.get(shapeCoord);
        }
        return null;
    }

    public boolean isEditable(int column) {
        return false;
    }

    public void insert(ROITreeNode child, int index) {
        super.insert((MutableTreeTableNode)child, index);
        Object userObject = child.getUserObject();
        if (userObject instanceof ROIShape) {
            ROIShape shape = (ROIShape)userObject;
            child.setExpanded(true);
            this.childMap.put(shape, child);
            this.childCoordMap.put(shape.getCoord3D(), child);
        }
    }

    public void remove(ROITreeNode child) {
        super.remove((MutableTreeTableNode)child);
        Object userObject = child.getUserObject();
        if (userObject instanceof ROIShape) {
            ROIShape shape = (ROIShape)userObject;
            this.childMap.remove(shape);
            this.childCoordMap.remove(shape.getCoord3D());
        }
    }

    public void remove(Coord3D childCoord) {
        ROITreeNode childNode = this.childCoordMap.get(childCoord);
        super.remove((MutableTreeTableNode)childNode);
        Object userObject = childNode.getUserObject();
        if (userObject instanceof ROIShape) {
            ROIShape shape = (ROIShape)userObject;
            this.childMap.remove(shape);
            this.childCoordMap.remove(shape.getCoord3D());
        }
    }

    public Object getValueAt(int column) {
        Object userObject = this.getUserObject();
        if (userObject instanceof ROI || userObject instanceof ROIShape) {
            return userObject;
        }
        return null;
    }

    public void setValueAt(Object value, int column) {
    }
}

