/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.roimenu;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.openmicroscopy.shoola.agents.measurement.util.actions.ROIAction;
import org.openmicroscopy.shoola.agents.measurement.util.actions.ROIStatsAction;
import org.openmicroscopy.shoola.agents.measurement.util.roitable.ROIActionController;

public class ROIPopupMenu {
    static final String POPUP_MENU_DESCRIPTION = "Manager Options";
    static final String ROI_CREATION_OPTIONS = "ROI Management Options";
    static final String ROI_STATS_OPTIONS = "ROI Stats Options";
    private JPopupMenu popupMenu;
    private ROIActionController controller;

    public ROIPopupMenu(ROIActionController controller) {
        this.controller = controller;
        this.createPopupMenu();
    }

    private JMenu createROICreationOptions() {
        JMenu roiOptionsParent = new JMenu(ROI_CREATION_OPTIONS);
        for (int indexCnt = 0; indexCnt < ROIActionController.CreationActionType.values().length; ++indexCnt) {
            JMenuItem roiOption = new JMenuItem(new ROIAction(this.controller, ROIActionController.CreationActionType.values()[indexCnt]));
            roiOptionsParent.add(roiOption);
        }
        return roiOptionsParent;
    }

    private JMenu createROIStatsOptions() {
        JMenu roiOptionsParent = new JMenu(ROI_STATS_OPTIONS);
        for (int indexCnt = 0; indexCnt < ROIActionController.StatsActionType.values().length; ++indexCnt) {
            JMenuItem roiOption = new JMenuItem(new ROIStatsAction(this.controller, ROIActionController.StatsActionType.values()[indexCnt]));
            roiOptionsParent.add(roiOption);
        }
        return roiOptionsParent;
    }

    private void createPopupMenu() {
        this.popupMenu = new JPopupMenu(POPUP_MENU_DESCRIPTION);
        JMenuItem topOption = new JMenuItem(POPUP_MENU_DESCRIPTION);
        this.popupMenu.add(topOption);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createROICreationOptions());
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }
}

