/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.util.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.agents.measurement.util.model.AttributeField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FigureTableModel
extends AbstractTableModel {
    private static final String NA = "N/A";
    private Figure figure;
    private List<String> columnNames;
    private List<AttributeKey> keys;
    private List values;
    private List<AttributeField> fieldList;

    public FigureTableModel(List<AttributeField> fieldList, List<String> columnNames) {
        if (fieldList == null) {
            throw new IllegalArgumentException("No fields specified.");
        }
        if (columnNames == null) {
            throw new IllegalArgumentException("No column's names specified.");
        }
        this.fieldList = fieldList;
        this.columnNames = columnNames;
        this.keys = new ArrayList<AttributeKey>();
        this.values = new ArrayList();
    }

    public void setData(Figure figure) {
        if (figure == null) {
            throw new IllegalArgumentException("No figure.");
        }
        this.figure = figure;
        this.keys.clear();
        this.values.clear();
        for (AttributeField fieldName : this.fieldList) {
            boolean found = false;
            for (AttributeKey key : figure.getAttributes().keySet()) {
                if (!key.equals((Object)fieldName.getKey())) continue;
                this.keys.add(key);
                this.values.add(figure.getAttribute(key));
                found = true;
                break;
            }
            if (found) continue;
            this.keys.add(fieldName.getKey());
            this.values.add(NA);
        }
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames.get(col);
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public int getRowCount() {
        return this.keys.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.fieldList.get(rowIndex).getName();
        }
        return this.values.get(rowIndex);
    }

    public AttributeField getFieldAt(int rowIndex) {
        return this.fieldList.get(rowIndex);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            return;
        }
        AttributeKey key = this.keys.get(row);
        if (this.figure.getAttribute(key) instanceof Double) {
            if (value instanceof Double) {
                this.figure.setAttribute(this.keys.get(row), (Object)((Double)value));
            }
            if (value instanceof String) {
                this.figure.setAttribute(this.keys.get(row), (Object)new Double((String)value));
            }
        } else {
            this.figure.setAttribute(this.keys.get(row), value);
        }
        this.values.set(row, value);
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 0) {
            return false;
        }
        if (this.values.get(row) instanceof String && this.values.get(row).equals(NA)) {
            return false;
        }
        return this.fieldList.get(row).isEditable();
    }
}

