/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.jdesktop.swingx.JXBusyLabel;
import org.openmicroscopy.shoola.agents.imviewer.actions.UserAction;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerControl;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerFactory;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerUI;
import org.openmicroscopy.shoola.agents.imviewer.view.ViewerPreferences;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ToolBar
extends JPanel {
    static final int UNCOMPRESSED = 0;
    static final int MEDIUM = 1;
    static final int LOW = 2;
    private static final Dimension H_SPACE = new Dimension(2, 5);
    private static final String[] compression = new String[3];
    private ImViewerControl controller;
    private ImViewerUI view;
    private JToolBar bar;
    private JToggleButton rndButton;
    private JToggleButton metadataButton;
    private JToggleButton historyButton;
    private JComboBox compressionBox;
    private JButton pasteButton;
    private JXBusyLabel busyLabel;

    private void createControlsBar() {
        this.bar = new JToolBar();
        this.bar.setFloatable(false);
        this.bar.setRollover(true);
        this.bar.setBorder(null);
        this.pasteButton = new JButton(this.controller.getAction(ImViewerControl.PASTE_RND_SETTINGS));
        UIUtilities.unifiedButtonLookAndFeel(this.pasteButton);
        this.pasteButton.setEnabled(this.view.hasSettingsToPaste());
        this.rndButton = new JToggleButton();
        this.rndButton.setSelected(this.view.isRendererShown());
        this.rndButton.setAction(this.controller.getAction(ImViewerControl.RENDERER));
        this.bar.add(this.rndButton);
        this.metadataButton = new JToggleButton();
        this.metadataButton.setSelected(this.view.isRendererShown());
        this.metadataButton.setAction(this.controller.getAction(ImViewerControl.METADATA));
        this.bar.add(this.metadataButton);
        this.historyButton = new JToggleButton();
        this.historyButton.setSelected(this.view.isHistoryShown());
        this.historyButton.setAction(this.controller.getAction(ImViewerControl.HISTORY));
        this.bar.add(Box.createRigidArea(H_SPACE));
        this.bar.add(new JSeparator(1));
        this.bar.add(Box.createRigidArea(H_SPACE));
        JButton button = new JButton(this.controller.getAction(ImViewerControl.COPY_RND_SETTINGS));
        UIUtilities.unifiedButtonLookAndFeel(button);
        this.bar.add(button);
        this.bar.add(this.pasteButton);
        button = new JButton(this.controller.getAction(ImViewerControl.RESET_RND_SETTINGS));
        UIUtilities.unifiedButtonLookAndFeel(button);
        this.bar.add(button);
        button = new JButton(this.controller.getAction(ImViewerControl.SET_ORIGINAL_RND_SETTINGS));
        UIUtilities.unifiedButtonLookAndFeel(button);
        this.bar.add(button);
        button = new JButton(this.controller.getAction(ImViewerControl.SAVE_RND_SETTINGS));
        UIUtilities.unifiedButtonLookAndFeel(button);
        this.bar.add(button);
        this.bar.add(new JSeparator(1));
        button = new JButton(this.controller.getAction(ImViewerControl.MOVIE));
        UIUtilities.unifiedButtonLookAndFeel(button);
        this.bar.add(button);
        button = new JButton(this.controller.getAction(ImViewerControl.LENS));
        UIUtilities.unifiedButtonLookAndFeel(button);
        this.bar.add(button);
        this.bar.add(new JSeparator(1));
        button = new JButton(this.controller.getAction(ImViewerControl.MEASUREMENT_TOOL));
        UIUtilities.unifiedButtonLookAndFeel(button);
        this.bar.add(button);
        this.bar.add(new JSeparator(1));
        button = new JButton(this.controller.getAction(ImViewerControl.SAVE));
        UIUtilities.unifiedButtonLookAndFeel(button);
        this.bar.add(button);
        UserAction a = (UserAction)this.controller.getAction(ImViewerControl.USER);
        button = new JButton(a);
        button.addMouseListener(a);
        UIUtilities.unifiedButtonLookAndFeel(button);
        this.bar.add(button);
        this.busyLabel = new JXBusyLabel();
        this.busyLabel.setEnabled(true);
        this.busyLabel.setVisible(false);
    }

    private void initComponents() {
        this.compressionBox = EditorUtil.createComboBox(compression, 0, this.getBackground());
        this.compressionBox.setBackground(this.getBackground());
        this.createControlsBar();
    }

    private void buildGUI() {
        this.setBorder(null);
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = new JPanel();
        p.setBorder(null);
        p.setLayout(new BoxLayout(p, 0));
        p.add(UIUtilities.buildComponentPanel(this.bar));
        p.add(UIUtilities.buildComponentPanelRight((JComponent)this.busyLabel));
        this.add(p);
    }

    ToolBar(ImViewerUI view, ImViewerControl controller) {
        if (view == null) {
            throw new NullPointerException("No View.");
        }
        if (controller == null) {
            throw new NullPointerException("No Control.");
        }
        this.view = view;
        this.controller = controller;
        this.initComponents();
    }

    void buildComponent() {
        ViewerPreferences pref = ImViewerFactory.getPreferences();
        if (pref != null) {
            this.rndButton.setSelected(pref.isRenderer());
        }
        this.bar.add(new JSeparator(1));
        JPanel p = new JPanel();
        JLabel l = new JLabel("Compression:");
        p.add(l);
        p.add(this.compressionBox);
        this.bar.add(UIUtilities.buildComponentPanel(p));
        this.compressionBox.setSelectedIndex(this.view.convertCompressionLevel());
        this.compressionBox.addActionListener(this.controller.getAction(ImViewerControl.COMPRESSION));
        this.buildGUI();
    }

    void displayRenderer() {
        this.rndButton.setSelected(this.view.isRendererShown());
        this.metadataButton.setSelected(this.view.isRendererShown());
    }

    void displayHistory() {
        this.historyButton.setSelected(this.view.isHistoryShown());
    }

    void enablePasteButton(boolean b) {
        this.pasteButton.setEnabled(b);
    }

    void setStatus(boolean busy) {
        this.busyLabel.setBusy(busy);
        this.busyLabel.setVisible(busy);
    }

    void onStateChange(boolean b) {
        if (this.compressionBox != null) {
            this.compressionBox.setEnabled(b);
        }
    }

    int getUICompressionLevel() {
        return this.compressionBox.getSelectedIndex();
    }

    static {
        ToolBar.compression[0] = "None";
        ToolBar.compression[1] = "Medium";
        ToolBar.compression[2] = "High";
    }
}

