/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import omero.model.PlaneInfo;
import omero.romio.PlaneDef;
import org.openmicroscopy.shoola.agents.events.iviewer.CopyRndSettings;
import org.openmicroscopy.shoola.agents.imviewer.ContainerLoader;
import org.openmicroscopy.shoola.agents.imviewer.DataLoader;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.ImageDataLoader;
import org.openmicroscopy.shoola.agents.imviewer.PlaneInfoLoader;
import org.openmicroscopy.shoola.agents.imviewer.ProjectionSaver;
import org.openmicroscopy.shoola.agents.imviewer.RenderingControlLoader;
import org.openmicroscopy.shoola.agents.imviewer.RenderingSettingsCreator;
import org.openmicroscopy.shoola.agents.imviewer.RenderingSettingsLoader;
import org.openmicroscopy.shoola.agents.imviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.imviewer.rnd.Renderer;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererFactory;
import org.openmicroscopy.shoola.agents.imviewer.util.HistoryItem;
import org.openmicroscopy.shoola.agents.imviewer.util.player.ChannelPlayer;
import org.openmicroscopy.shoola.agents.imviewer.util.proj.ProjectionRef;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerFactory;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerFactory;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.model.ProjectionParam;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.rnd.RenderingServiceException;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import pojos.ChannelData;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.PixelsData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImViewerModel {
    static final int UNCOMPRESSED = 0;
    static final int MEDIUM = 1;
    static final int LOW = 2;
    private static final int MAX_HISTORY = 10;
    private static final int THUMB_MAX_WIDTH = 24;
    private static final int THUMB_MAX_HEIGHT = 24;
    private static final int IMAGE_MAX_WIDTH = 512;
    private static final int IMAGE_MAX_HEIGHT = 512;
    private static final int SETTINGS = 0;
    private static final int RND = 1;
    private ImageData image;
    private int state;
    private ImViewer component;
    private Map<Integer, DataLoader> loaders;
    private Browser browser;
    private Renderer renderer;
    private ChannelPlayer player;
    private int sizeX;
    private int sizeY;
    private double factor;
    private BufferedImage imageIcon;
    private Rectangle requesterBounds;
    private int tabbedIndex;
    private boolean textVisible;
    private boolean playingMovie;
    private boolean playingChannelMovie;
    private List<HistoryItem> historyItems;
    private int movieIndex;
    private Map renderingSettings;
    private MetadataViewer metadataViewer;
    private boolean metadataLoaded;
    private long currentPixelsID;
    private RenderingControl currentRndControl;
    private RndProxyDef alternativeSettings;
    private long selectedUserID;
    private boolean initMagnificationFactor;
    private DataObject parent;
    private DataObject grandParent;
    private Map<Integer, PlaneInfo> planeInfos;
    private long imageID;
    private RndProxyDef originalDef;
    private RndProxyDef lastMainDef;
    private RndProxyDef lastProjDef;
    private ProjectionParam lastProjRef;
    private int lastProjTime;
    private Collection containers;
    private List<ChannelData> sortedChannels;

    private Integer linearize(int z, int c, int t) {
        int sizeZ = this.currentRndControl.getPixelsDimensionsZ();
        int sizeC = this.currentRndControl.getPixelsDimensionsC();
        int sizeT = this.currentRndControl.getPixelsDimensionsT();
        if (z < 0 || sizeZ <= z) {
            return -1;
        }
        if (c < 0 || sizeC <= c) {
            return -1;
        }
        if (t < 0 || sizeT <= t) {
            return -1;
        }
        return sizeZ * sizeC * t + sizeZ * c + z;
    }

    private void computeSizes() {
        if (this.sizeX == -1 && this.sizeY == -1) {
            double y;
            this.sizeX = 24;
            this.sizeY = 24;
            double x = (double)this.sizeX / (double)this.getMaxX();
            this.factor = x > (y = (double)this.sizeY / (double)this.getMaxY()) ? x : y;
            double ratio = (double)this.getMaxX() / (double)this.getMaxY();
            if (ratio < 1.0) {
                this.sizeX = (int)((double)this.sizeX * ratio);
            } else if (ratio > 1.0 && ratio != 0.0) {
                this.sizeY = (int)((double)this.sizeY * (1.0 / ratio));
            }
        }
    }

    private double initZoomFactor() {
        return -1.0;
    }

    private void initialize(Rectangle bounds) {
        this.requesterBounds = bounds;
        this.state = 1;
        this.initMagnificationFactor = false;
        this.sizeY = -1;
        this.sizeX = -1;
        this.tabbedIndex = 0;
        this.textVisible = true;
        this.movieIndex = -1;
        this.loaders = new HashMap<Integer, DataLoader>();
        this.metadataViewer = null;
        this.metadataLoaded = false;
        this.currentPixelsID = -1L;
        this.selectedUserID = -1L;
        this.lastProjTime = -1;
        this.lastProjRef = null;
    }

    ImViewerModel(long imageID, Rectangle bounds) {
        this.imageID = imageID;
        this.initialize(bounds);
    }

    ImViewerModel(ImageData image, Rectangle bounds) {
        this.image = image;
        this.initialize(bounds);
        this.metadataViewer = MetadataViewerFactory.getViewer(image, false);
        this.currentPixelsID = image.getDefaultPixels().getId();
    }

    void initialize(ImViewer component) {
        this.component = component;
        this.browser = BrowserFactory.createBrowser(component, this.getImageID(), ImViewerFactory.getPreferences());
    }

    ExperimenterData getUserDetails() {
        return (ExperimenterData)ImViewerAgent.getRegistry().lookup("/current_user/details");
    }

    void setAlternativeSettings(RndProxyDef alternativeSettings, long userID) {
        this.alternativeSettings = alternativeSettings;
        this.selectedUserID = userID;
    }

    long getAlternativeSettingsOwnerId() {
        return this.selectedUserID;
    }

    boolean isSameDisplay(ImViewerModel other) {
        return other != null;
    }

    String getImageName() {
        if (this.image == null) {
            return "";
        }
        return this.image.getName();
    }

    String getImageTitle() {
        return "[ID: " + this.getImageID() + "] " + EditorUtil.getPartialName(this.getImageName());
    }

    int getState() {
        return this.state;
    }

    void discard() {
        this.state = 7;
        if (this.image == null) {
            return;
        }
        OmeroImageService svr = ImViewerAgent.getRegistry().getImageService();
        long pixelsID = this.image.getDefaultPixels().getId();
        svr.shutDown(pixelsID);
        svr.shutDownDataSink(pixelsID);
        for (Integer index : this.loaders.keySet()) {
            this.loaders.get(index).cancel();
        }
        if (this.renderer != null) {
            this.renderer.discard();
        }
        if (this.player == null) {
            return;
        }
        this.player.setPlayerState(1);
        this.player = null;
    }

    int getMaxX() {
        return this.currentRndControl.getPixelsDimensionsX();
    }

    int getMaxY() {
        return this.currentRndControl.getPixelsDimensionsY();
    }

    int getMaxZ() {
        return this.currentRndControl.getPixelsDimensionsZ() - 1;
    }

    int getMaxT() {
        return this.currentRndControl.getPixelsDimensionsT() - 1;
    }

    int getDefaultZ() {
        return this.currentRndControl.getDefaultZ();
    }

    int getDefaultT() {
        return this.currentRndControl.getDefaultT();
    }

    String getColorModel() {
        return this.currentRndControl.getModel();
    }

    List<ChannelData> getChannelData() {
        if (this.sortedChannels == null) {
            Object[] data = this.currentRndControl.getChannelData();
            ViewerSorter sorter = new ViewerSorter();
            List l = sorter.sort(data);
            this.sortedChannels = Collections.unmodifiableList(l);
        }
        return this.sortedChannels;
    }

    ChannelData getChannelData(int index) {
        return this.currentRndControl.getChannelData(index);
    }

    Color getChannelColor(int w) {
        return this.currentRndControl.getRGBA(w);
    }

    boolean isChannelActive(int w) {
        return this.currentRndControl.isActive(w);
    }

    void fireRenderingControlLoading(long pixelsID) {
        this.currentPixelsID = pixelsID;
        RenderingControlLoader loader = new RenderingControlLoader(this.component, pixelsID, 0);
        ((DataLoader)loader).load();
        if (this.loaders.get(1) != null) {
            this.loaders.get(1).cancel();
        }
        this.loaders.put(1, loader);
        this.state = 2;
    }

    void fireRenderingControlReloading() {
        RenderingControlLoader loader = new RenderingControlLoader(this.component, this.image.getDefaultPixels().getId(), 1);
        ((DataLoader)loader).load();
        if (this.loaders.get(1) != null) {
            this.loaders.get(1).cancel();
        }
        this.loaders.put(1, loader);
        this.state = 2;
    }

    void fireRenderingControlResetting() {
        RenderingControlLoader loader = new RenderingControlLoader(this.component, this.image.getDefaultPixels().getId(), 2);
        ((DataLoader)loader).load();
        if (this.loaders.get(1) != null) {
            this.loaders.get(1).cancel();
        }
        this.loaders.put(1, loader);
        this.state = 2;
    }

    void firePlaneInfoRetrieval() {
        PlaneInfoLoader loader = new PlaneInfoLoader(this.component, this.getPixelsID());
        loader.load();
    }

    void fireImageRetrieval() {
        PlaneDef pDef = new PlaneDef();
        pDef.t = this.getDefaultT();
        pDef.z = this.getDefaultZ();
        pDef.slice = 0;
        this.state = 3;
        try {
            this.component.setImage(this.currentRndControl.renderPlane(pDef));
        }
        catch (Exception e) {
            this.component.handleException(e);
        }
    }

    BufferedImage getSplitComponentImage() {
        PlaneDef pDef = new PlaneDef();
        pDef.t = this.getDefaultT();
        pDef.z = this.getDefaultZ();
        pDef.slice = 0;
        try {
            return this.currentRndControl.renderPlane(pDef);
        }
        catch (Exception e) {
            this.component.handleException(e);
            return null;
        }
    }

    void setRenderingControl(RenderingControl rndControl) {
        this.loaders.remove(1);
        this.currentRndControl = rndControl;
        this.originalDef = this.currentRndControl.getRndSettingsCopy();
        if (this.renderer == null) {
            this.renderer = RendererFactory.createRenderer(this.component, rndControl, this.metadataViewer.getEditorUI());
            this.state = 9;
            double f = this.initZoomFactor();
            if (f > 0.0) {
                this.browser.initializeMagnificationFactor(f);
            }
            try {
                if (this.alternativeSettings != null) {
                    this.currentRndControl.resetSettings(this.alternativeSettings);
                }
                this.alternativeSettings = null;
            }
            catch (Exception e) {}
        } else {
            this.renderer.setRenderingControl(rndControl);
        }
    }

    Browser getBrowser() {
        return this.browser;
    }

    void setZoomFactor(double factor, boolean reset) {
        this.browser.setZoomFactor(factor, reset);
    }

    double getZoomFactor() {
        return this.browser.getZoomFactor();
    }

    boolean isZoomFitToWindow() {
        return this.getZoomFactor() == -1.0;
    }

    double setImage(BufferedImage image) {
        this.state = 6;
        this.browser.setRenderedImage(image);
        return this.initZoomFactor();
    }

    void createImageIcon() {
        BufferedImage img = this.browser.getRenderedImage();
        if (img != null) {
            this.computeSizes();
            this.imageIcon = Factory.magnifyImage(this.factor, img);
        }
    }

    boolean isInitMagnificationFactor() {
        return this.initMagnificationFactor;
    }

    void setColorModel(String colorModel) throws RenderingServiceException, DSOutOfServiceException {
        if ("greyscale".equals(colorModel)) {
            this.currentRndControl.setModel(colorModel);
        } else if ("rgb".equals(colorModel)) {
            this.currentRndControl.setModel("rgb");
        }
    }

    void setSelectedXYPlane(int z, int t) throws RenderingServiceException, DSOutOfServiceException {
        if (t >= 0 && t != this.getDefaultT()) {
            this.currentRndControl.setDefaultT(t);
        }
        if (z >= 0 && z != this.getDefaultZ()) {
            this.currentRndControl.setDefaultZ(z);
        }
    }

    void setChannelColor(int index, Color c) throws RenderingServiceException, DSOutOfServiceException {
        this.currentRndControl.setRGBA(index, c);
    }

    void setChannelActive(int index, boolean b) throws RenderingServiceException, DSOutOfServiceException {
        this.currentRndControl.setActive(index, b);
    }

    int getMaxC() {
        return this.currentRndControl.getPixelsDimensionsC();
    }

    int getActiveChannelsCount() {
        return this.getActiveChannels().size();
    }

    List<Integer> getActiveChannels() {
        return this.currentRndControl.getActiveChannels();
    }

    void playMovie(boolean play) throws RenderingServiceException, DSOutOfServiceException {
        if (this.player != null && !play) {
            this.player.setPlayerState(1);
            List l = this.player.getChannels();
            if (l != null) {
                Iterator i = l.iterator();
                while (i.hasNext()) {
                    this.setChannelActive((Integer)i.next(), true);
                }
            }
            this.player = null;
            this.state = 6;
            this.playingChannelMovie = false;
            return;
        }
        this.playingChannelMovie = true;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ImViewerModel.this.player = new ChannelPlayer(ImViewerModel.this.component);
                ImViewerModel.this.player.setPlayerState(0);
            }
        });
        this.state = 8;
    }

    boolean isPlayingChannelMovie() {
        return this.playingChannelMovie;
    }

    void setState(int state) {
        this.state = state;
    }

    Renderer getRenderer() {
        return this.renderer;
    }

    BufferedImage getDisplayedImage() {
        return this.browser.getDisplayedImage();
    }

    BufferedImage getOriginalImage() {
        return this.browser.getRenderedImage();
    }

    BufferedImage getProjectedImage() {
        return this.browser.getProjectedImage();
    }

    BufferedImage getGridImage() {
        return this.browser.getGridImage();
    }

    double getPixelsSizeX() {
        return this.currentRndControl.getPixelsPhysicalSizeX();
    }

    double getPixelsSizeY() {
        return this.currentRndControl.getPixelsPhysicalSizeY();
    }

    double getPixelsSizeZ() {
        return this.currentRndControl.getPixelsPhysicalSizeZ();
    }

    boolean isUnitBar() {
        return this.browser.isUnitBar();
    }

    BufferedImage getImageIcon() {
        return this.imageIcon;
    }

    Rectangle getRequesterBounds() {
        return this.requesterBounds;
    }

    long getPixelsID() {
        return this.currentPixelsID;
    }

    int getTabbedIndex() {
        return this.tabbedIndex;
    }

    void setTabbedIndex(int index) {
        this.tabbedIndex = index;
    }

    boolean[] hasRGB() {
        boolean[] rgb = new boolean[]{this.currentRndControl.hasActiveChannelRed(), this.currentRndControl.hasActiveChannelGreen(), this.currentRndControl.hasActiveChannelBlue()};
        return rgb;
    }

    boolean isTextVisible() {
        return this.textVisible;
    }

    void setTextVisible(boolean textVisible) {
        this.textVisible = textVisible;
    }

    boolean isImageLoaded() {
        return this.image != null;
    }

    long getImageID() {
        if (this.image == null) {
            return this.imageID;
        }
        return this.image.getId();
    }

    void saveRndSettings(boolean reset) throws RenderingServiceException, DSOutOfServiceException {
        if (this.currentRndControl != null) {
            RndProxyDef def = this.currentRndControl.saveCurrentSettings();
            if (reset) {
                this.originalDef = def;
                if (def != null && this.renderingSettings != null) {
                    this.renderingSettings.put(ImViewerAgent.getUserDetails(), def);
                }
            }
        }
    }

    void setPlayingMovie(boolean play, int index) {
        this.playingMovie = play;
        this.movieIndex = index;
    }

    boolean isPlayingMovie() {
        return this.playingMovie;
    }

    boolean isChannelRed(int index) {
        return this.currentRndControl.isChannelRed(index);
    }

    boolean isChannelGreen(int index) {
        return this.currentRndControl.isChannelGreen(index);
    }

    boolean isChannelBlue(int index) {
        return this.currentRndControl.isChannelBlue(index);
    }

    Map<Integer, Color> getActiveChannelsColorMap() {
        List<Integer> l = this.getActiveChannels();
        HashMap<Integer, Color> m = new HashMap<Integer, Color>(l.size());
        for (Integer index : l) {
            m.put(index, this.getChannelColor(index));
        }
        return m;
    }

    void setLastSettingsRef() {
        if (this.getTabbedIndex() != 1) {
            return;
        }
        this.lastMainDef = this.currentRndControl.getRndSettingsCopy();
    }

    HistoryItem createHistoryItem() {
        String title = null;
        BufferedImage img = null;
        Color c = null;
        RndProxyDef def = this.currentRndControl.getRndSettingsCopy();
        switch (this.getTabbedIndex()) {
            case 2: {
                title = "Projection";
                img = this.browser.getProjectedImage();
                this.lastProjDef = def;
                c = Color.GREEN.brighter();
                break;
            }
            case 0: {
                title = "Image";
                img = this.browser.getRenderedImage();
                this.lastMainDef = def;
            }
        }
        if (img == null) {
            return null;
        }
        double ratio = 1.0;
        int w = img.getWidth();
        int h = img.getHeight();
        ratio = w < 96 || h < 96 ? 1.0 : (w >= h ? 96.0 / (double)w : 96.0 / (double)h);
        BufferedImage thumb = Factory.magnifyImage(ratio, img);
        HistoryItem i = new HistoryItem(def, thumb, title);
        i.setHighlight(c);
        i.allowClose(false);
        i.setIndex(this.getTabbedIndex());
        if (this.historyItems == null) {
            this.historyItems = new ArrayList<HistoryItem>();
        }
        if (this.historyItems.size() == 10) {
            this.historyItems.remove(1);
        }
        this.historyItems.add(i);
        return i;
    }

    RndProxyDef getOriginalDef() {
        return this.originalDef;
    }

    RndProxyDef getLastMainDef() {
        return this.lastMainDef;
    }

    RndProxyDef getLastProjDef() {
        return this.lastProjDef;
    }

    void removeHistoryItem(HistoryItem node) {
        if (this.historyItems != null) {
            this.historyItems.remove(node);
        }
    }

    void clearHistory() {
        if (this.historyItems == null || this.historyItems.size() == 0) {
            return;
        }
        HistoryItem node = this.historyItems.get(0);
        this.historyItems.clear();
        this.historyItems.add(node);
        this.lastMainDef = node.getRndSettings();
        this.lastProjDef = null;
        this.lastProjTime = -1;
    }

    List<HistoryItem> getHistory() {
        return this.historyItems;
    }

    void resetMappingSettings(RndProxyDef settings, boolean reset) throws RenderingServiceException, DSOutOfServiceException {
        this.currentRndControl.resetSettings(settings);
        if (reset) {
            this.renderer.resetRndSettings();
        }
    }

    void setLastRndDef(RndProxyDef settings) {
        switch (this.getTabbedIndex()) {
            case 2: {
                this.lastProjDef = settings;
                break;
            }
            case 0: {
                this.lastMainDef = settings;
            }
        }
    }

    void fireLoadRndSettingsToPaste() {
        long id = ImViewerFactory.getRefImage().getDefaultPixels().getId();
        if (id < 0L) {
            return;
        }
        RenderingSettingsLoader loader = new RenderingSettingsLoader(this.component, id, true);
        loader.load();
        this.state = 14;
    }

    void resetDefaultRndSettings() throws RenderingServiceException, DSOutOfServiceException {
        this.currentRndControl.resetDefaults();
    }

    void setOriginalRndSettings() throws RenderingServiceException, DSOutOfServiceException {
        this.currentRndControl.setOriginalRndSettings();
    }

    boolean hasRndToPaste() {
        ImageData image = ImViewerFactory.getRefImage();
        if (image == null) {
            return false;
        }
        PixelsData pixels = image.getDefaultPixels();
        if (pixels == null) {
            return false;
        }
        if (this.currentRndControl == null) {
            return false;
        }
        return this.currentRndControl.validatePixels(pixels);
    }

    void copyRenderingSettings() {
        CopyRndSettings evt = new CopyRndSettings(this.image);
        EventBus bus = ImViewerAgent.getRegistry().getEventBus();
        bus.post(evt);
    }

    int getMovieIndex() {
        return this.movieIndex;
    }

    boolean isImageCompressed() {
        return this.currentRndControl.isCompressed();
    }

    void setCompressionLevel(int compressionLevel) {
        this.currentRndControl.setCompression(compressionLevel);
    }

    int getCompressionLevel() {
        return this.currentRndControl.getCompressionLevel();
    }

    void fireRenderingSettingsRetrieval() {
        RenderingSettingsLoader loader = new RenderingSettingsLoader(this.component, this.image.getDefaultPixels().getId());
        ((DataLoader)loader).load();
        if (this.loaders.get(0) != null) {
            this.loaders.get(0).cancel();
        }
        this.loaders.put(0, loader);
    }

    Map getRenderingSettings() {
        return this.renderingSettings;
    }

    void setRenderingSettings(Map map) {
        this.renderingSettings = map;
        this.loaders.remove(0);
    }

    void setUserSettings(ExperimenterData exp) throws RenderingServiceException, DSOutOfServiceException {
        RndProxyDef rndDef = (RndProxyDef)this.renderingSettings.get(exp);
        this.currentRndControl.resetSettings(rndDef);
    }

    long getOwnerID() {
        return this.image.getOwner().getId();
    }

    boolean hasMetadataToSave() {
        if (this.metadataViewer == null) {
            return false;
        }
        return this.metadataViewer.hasDataToSave();
    }

    void saveMetadata() {
        if (this.metadataViewer != null) {
            this.metadataViewer.saveData();
        }
    }

    void loadMetadata() {
        if (!this.metadataLoaded) {
            this.metadataLoaded = true;
            ArrayList<ChannelData> l = new ArrayList<ChannelData>();
            List<ChannelData> sorted = this.getChannelData();
            Iterator<ChannelData> i = sorted.iterator();
            while (i.hasNext()) {
                l.add(i.next());
            }
            this.metadataViewer.activate(l);
        }
    }

    List<PixelsData> getPixelsSets() {
        return this.image.getAllPixels();
    }

    List<Long> getPixelsIDs() {
        Iterator<PixelsData> i = this.getPixelsSets().iterator();
        ArrayList<Long> ids = new ArrayList<Long>();
        while (i.hasNext()) {
            ids.add(i.next().getId());
        }
        return ids;
    }

    void resetHistory() {
        this.historyItems = null;
    }

    void fireRenderProjected(int startZ, int endZ, int stepping, int type) {
        this.state = 12;
        ProjectionParam param = new ProjectionParam(this.getPixelsID(), startZ, endZ, stepping, type);
        param.setChannels(this.getActiveChannels());
        this.lastProjRef = param;
        ProjectionSaver loader = new ProjectionSaver(this.component, param, 0);
        loader.load();
    }

    void fireImageProjection(int startZ, int endZ, int stepping, int type, String typeName, ProjectionRef ref) {
        startZ = ref.getStartZ();
        endZ = ref.getEndZ();
        this.state = 13;
        StringBuffer buf = new StringBuffer();
        buf.append("Original Image: " + this.getImageName());
        buf.append("\n");
        buf.append("Projection type: " + typeName);
        buf.append("\n");
        buf.append("z-sections: " + (startZ + 1) + "-" + (endZ + 1));
        buf.append("\n");
        buf.append("timepoints: " + (ref.getStartT() + 1) + "-" + (ref.getEndT() + 1));
        List<Integer> channels = ref.getChannels();
        ProjectionParam param = new ProjectionParam(this.getPixelsID(), startZ, endZ, stepping, type, ref.getStartT(), ref.getEndT(), channels, ref.getImageName());
        param.setDescription(buf.toString());
        param.setDatasets(ref.getDatasets());
        param.setChannels(this.getActiveChannels());
        ProjectionSaver loader = new ProjectionSaver(this.component, param, 1, ref.isApplySettings());
        loader.load();
    }

    void fireContainersLoading() {
        this.state = 11;
        ContainerLoader loader = new ContainerLoader(this.component, this.getImageID());
        loader.load();
    }

    String getPixelsType() {
        return this.image.getDefaultPixels().getPixelType();
    }

    void fireProjectedRndSettingsCreation(List<Integer> indexes, ImageData image) {
        RndProxyDef def = this.currentRndControl.getRndSettingsCopy();
        RenderingSettingsCreator l = new RenderingSettingsCreator(this.component, image, def, indexes);
        l.load();
    }

    void setContext(DataObject parent, DataObject grandParent) {
        this.parent = parent;
        this.grandParent = grandParent;
    }

    DataObject getParent() {
        return this.parent;
    }

    DataObject getGrandParent() {
        return this.grandParent;
    }

    void setPlaneInfo(Collection objects) {
        if (this.planeInfos == null) {
            this.planeInfos = new HashMap<Integer, PlaneInfo>();
        } else {
            this.planeInfos.clear();
        }
        for (PlaneInfo object : objects) {
            Integer index;
            if (object == null || (index = this.linearize(object.getTheZ().getValue(), object.getTheC().getValue(), object.getTheT().getValue())) < 0) continue;
            this.planeInfos.put(index, object);
        }
    }

    PlaneInfo getPlane(int z, int c, int t) {
        Integer index = null;
        try {
            index = this.linearize(z, c, t);
            if (index < 0) {
                return null;
            }
            return this.planeInfos.get(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    void fireImageLoading() {
        ImageDataLoader loader = new ImageDataLoader(this.component, this.getImageID());
        loader.load();
        this.state = 10;
    }

    void setImageData(ImageData image) {
        this.image = image;
        this.metadataViewer = MetadataViewerFactory.getViewer(image, false);
        this.currentPixelsID = image.getDefaultPixels().getId();
    }

    boolean isOriginalSettings() {
        return this.isSameSettings(this.originalDef);
    }

    boolean isSameSettings(RndProxyDef def) {
        if (this.currentRndControl == null) {
            return true;
        }
        return this.currentRndControl.isSameSettings(def, false);
    }

    void setRenderProjected(BufferedImage image) {
        this.state = 6;
        this.browser.setRenderProjected(image);
    }

    void setContainers(Collection containers) {
        this.containers = containers;
        this.state = 6;
    }

    Collection getContainers() {
        return this.containers;
    }

    PixelsData getPixelsData() {
        if (this.image == null) {
            return null;
        }
        return this.image.getDefaultPixels();
    }

    ProjectionParam getLastProjRef() {
        return this.lastProjRef;
    }

    void setLastProjectionRef(ProjectionParam ref) {
        this.lastProjRef = ref;
    }

    int getLastProjectionTime() {
        return this.lastProjTime;
    }

    void setLastProjectionTime(int time) {
        this.lastProjTime = time;
    }
}

