/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.events.iviewer.ChannelSelection;
import org.openmicroscopy.shoola.agents.events.iviewer.ImageRendered;
import org.openmicroscopy.shoola.agents.events.iviewer.MeasurePlane;
import org.openmicroscopy.shoola.agents.events.iviewer.MeasurementTool;
import org.openmicroscopy.shoola.agents.events.iviewer.RndSettingsCopied;
import org.openmicroscopy.shoola.agents.events.iviewer.SaveRelatedData;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewerState;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.rnd.Renderer;
import org.openmicroscopy.shoola.agents.imviewer.util.PreferencesDialog;
import org.openmicroscopy.shoola.agents.imviewer.util.UnitBarSizeDialog;
import org.openmicroscopy.shoola.agents.imviewer.util.player.MoviePlayerDialog;
import org.openmicroscopy.shoola.agents.imviewer.util.proj.ProjSavingDialog;
import org.openmicroscopy.shoola.agents.imviewer.util.proj.ProjectionRef;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerControl;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerFactory;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerModel;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerRecentObject;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerUI;
import org.openmicroscopy.shoola.agents.imviewer.view.ViewerPreferences;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.model.ProjectionParam;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.log.LogMessage;
import org.openmicroscopy.shoola.env.log.Logger;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.rnd.RenderingServiceException;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.env.ui.SaveEventBox;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import pojos.ChannelData;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImViewerComponent
extends AbstractComponent
implements ImViewer {
    static final String RND = "The last rendering settings";
    static final String ANNOTATION = "The annotations";
    private ImViewerModel model;
    private ImViewerControl controller;
    private ImViewerUI view;
    private List historyActiveChannels;
    private Map<String, SaveRelatedData> events;
    private boolean newPlane;
    private boolean saveBeforeCopy;
    private String colorModel;

    private void showProjectionDialog() {
        ProjSavingDialog dialog = new ProjSavingDialog(this.view);
        dialog.initialize(this.view.getProjectionType(), this.model.getMaxT() + 1, this.model.getPixelsType(), this.model.getImageName(), this.model.getContainers(), this.model.getMaxZ() + 1, this.view.getProjectionStartZ() + 1, this.view.getProjectionEndZ() + 1);
        dialog.addPropertyChangeListener(this.controller);
        dialog.pack();
        UIUtilities.centerAndShow(dialog);
    }

    private void postMeasurePlane() {
        EventBus bus = ImViewerAgent.getRegistry().getEventBus();
        MeasurePlane event = new MeasurePlane(this.model.getPixelsID(), this.model.getDefaultZ(), this.model.getDefaultT(), this.model.getZoomFactor());
        bus.post(event);
    }

    private void postViewerState(int index) {
        EventBus bus = ImViewerAgent.getRegistry().getEventBus();
        ViewerState event = new ViewerState(this.model.getPixelsID(), index);
        bus.post(event);
    }

    private void postActiveChannelSelection(int index) {
        EventBus bus = ImViewerAgent.getRegistry().getEventBus();
        ChannelSelection event = new ChannelSelection(this.model.getPixelsID(), this.model.getActiveChannelsColorMap(), index);
        bus.post(event);
        this.view.setPlaneInfoStatus();
    }

    private boolean saveOnClose() {
        SaveEventBox box;
        Iterator<String> j;
        if (this.saveBeforeCopy) {
            try {
                this.model.saveRndSettings(false);
            }
            catch (Exception e) {
                LogMessage logMsg = new LogMessage();
                logMsg.println("Cannot save rendering settings. ");
                logMsg.print(e);
                ImViewerAgent.getRegistry().getLogger().error((Object)this, logMsg);
            }
        }
        boolean showBox = false;
        MessageBox msg = new MessageBox(this.view, "Save Data", "Before closing the viewer, do you want to save: ");
        msg.addCancelButton();
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JCheckBox rndBox = null;
        if (!this.model.isOriginalSettings()) {
            rndBox = new JCheckBox(RND);
            rndBox.setSelected(true);
            p.add(rndBox);
            showBox = true;
        }
        JCheckBox annotationBox = null;
        if (this.model.hasMetadataToSave()) {
            annotationBox = new JCheckBox(ANNOTATION);
            annotationBox.setSelected(true);
            p.add(annotationBox);
            showBox = true;
        }
        msg.addBodyComponent(p);
        ArrayList<SaveEventBox> boxes = null;
        if (this.events != null) {
            boxes = new ArrayList<SaveEventBox>(this.events.size());
            j = this.events.keySet().iterator();
            while (j.hasNext()) {
                SaveRelatedData value = this.events.get(j.next());
                if (!value.isToSave()) continue;
                showBox = true;
                box = new SaveEventBox(value);
                boxes.add(box);
                p.add(box);
            }
        }
        if (!showBox) {
            return true;
        }
        int option = msg.centerMsgBox();
        if (option == 1) {
            if (rndBox != null && rndBox.isSelected()) {
                try {
                    this.saveRndSettings();
                }
                catch (Exception e) {
                    LogMessage logMsg = new LogMessage();
                    logMsg.println("Cannot save rendering settings. ");
                    logMsg.print(e);
                    ImViewerAgent.getRegistry().getLogger().error((Object)this, logMsg);
                }
            }
            if (annotationBox != null && annotationBox.isSelected()) {
                this.model.saveMetadata();
            }
            if (boxes != null) {
                j = boxes.iterator();
                EventBus bus = ImViewerAgent.getRegistry().getEventBus();
                while (j.hasNext()) {
                    SaveRelatedData event;
                    box = (SaveEventBox)((Object)j.next());
                    if (!box.isSelected() || !(event = (SaveRelatedData)box.getEvent()).isToSave()) continue;
                    bus.post(event.getSaveEvent());
                }
            }
            return true;
        }
        return option != 2;
    }

    private void notifyProjection(String message, ImageData image) {
        this.model.setState(6);
        String text = message;
        text = text + "\n";
        text = text + "Do you want to launch a viewer for the projected image?";
        MessageBox msg = new MessageBox(this.view, "Projection", text);
        int option = msg.centerMsgBox();
        if (option == 1) {
            EventBus bus = ImViewerAgent.getRegistry().getEventBus();
            bus.post(new ViewImage(image, null));
        }
    }

    private void previewProjection() {
        switch (this.model.getState()) {
            case 7: 
            case 12: 
            case 13: {
                return;
            }
        }
        this.model.fireRenderProjected(this.view.getProjectionStartZ(), this.view.getProjectionEndZ(), this.view.getProjectionStepping(), this.view.getProjectionType());
        this.fireStateChange();
    }

    private boolean isSameProjectionParam() {
        ProjectionParam ref = this.model.getLastProjRef();
        if (ref == null) {
            return true;
        }
        if (ref.getStartZ() != this.view.getProjectionStartZ()) {
            return false;
        }
        if (ref.getEndZ() != this.view.getProjectionEndZ()) {
            return false;
        }
        if (ref.getAlgorithm() != this.view.getProjectionType()) {
            return false;
        }
        return ref.getStepping() == this.view.getProjectionStepping();
    }

    ImViewerComponent(ImViewerModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new ImViewerControl();
        this.view = new ImViewerUI(model.getImageTitle());
    }

    void initialize() {
        this.model.initialize(this);
        this.controller.initialize(this, this.view);
        this.view.initialize(this.controller, this.model);
    }

    ImViewerModel getModel() {
        return this.model;
    }

    void copyRndSettings() {
        this.view.enablePasteButton(true);
        this.firePropertyChange("rndSettings", Boolean.FALSE, Boolean.TRUE);
    }

    void storeEvent(SaveRelatedData evt) {
        if (this.events == null) {
            this.events = new HashMap<String, SaveRelatedData>();
        }
        this.events.put(evt.toString(), evt);
    }

    Map<String, SaveRelatedData> getSaveEvents() {
        return this.events;
    }

    boolean hasAnnotationToSave() {
        return this.model.hasMetadataToSave();
    }

    boolean hasRndToSave() {
        return this.model.isOriginalSettings();
    }

    long getPixelsID() {
        return this.model.getPixelsID();
    }

    String getTitle() {
        return this.view.getTitle();
    }

    void reset() {
        this.model.fireRenderingControlResetting();
        this.fireStateChange();
    }

    @Override
    public void activate(RndProxyDef settings, long userID) {
        int state = this.model.getState();
        switch (state) {
            case 1: {
                this.model.setAlternativeSettings(settings, userID);
                if (this.model.isImageLoaded()) {
                    this.model.fireRenderingControlLoading(this.model.getPixelsID());
                } else {
                    this.model.fireImageLoading();
                }
                this.fireStateChange();
                break;
            }
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
            default: {
                if (this.view == null) break;
                UIUtilities.centerOnScreen(this.view);
            }
        }
    }

    @Override
    public void discard() {
        switch (this.model.getState()) {
            case 2: {
                this.model.discard();
                this.fireStateChange();
                break;
            }
            default: {
                this.controller.setPreferences();
                if (!this.saveOnClose()) {
                    return;
                }
                this.postViewerState(0);
                ImViewerRecentObject object = new ImViewerRecentObject(this.model.getImageID(), this.model.getImageTitle(), this.getImageIcon());
                this.firePropertyChange("reventViewer", null, object);
                this.model.discard();
                this.fireStateChange();
            }
        }
    }

    @Override
    public int getState() {
        return this.model.getState();
    }

    @Override
    public void setStatus(String description, int perc) {
        if (this.model.getState() == 7) {
            return;
        }
        this.view.setLeftStatus(description);
    }

    @Override
    public void setZoomFactor(double factor, int zoomIndex) {
        if (factor != -1.0 && (factor > 3.0 || factor < 0.25)) {
            throw new IllegalArgumentException("The zoom factor is value between 0.25 and 3.0");
        }
        double oldFactor = this.model.getZoomFactor();
        if (oldFactor == factor && factor != -1.0) {
            return;
        }
        try {
            this.model.setZoomFactor(factor, false);
        }
        catch (Exception e) {
            Logger logger = ImViewerAgent.getRegistry().getLogger();
            logger.debug((Object)this, "Cannot zoom image. Magnification: " + factor);
            this.model.setZoomFactor(factor, true);
        }
        this.view.setZoomFactor(factor, zoomIndex);
        if (this.view.isLensVisible()) {
            switch (this.model.getTabbedIndex()) {
                case 0: 
                case 2: {
                    this.view.setImageZoomFactor((float)this.model.getZoomFactor());
                    this.view.scrollLens();
                }
            }
        }
        this.controller.setPreferences();
        this.postMeasurePlane();
    }

    @Override
    public boolean isZoomFitToWindow() {
        return this.model.isZoomFitToWindow();
    }

    @Override
    public void setColorModel(int key) {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW or LOADING_RENDERING_CONTROL state.");
            }
        }
        try {
            List<Integer> active = this.model.getActiveChannels();
            switch (key) {
                case 0: {
                    this.historyActiveChannels = this.model.getActiveChannels();
                    this.model.setColorModel("greyscale");
                    if (active != null && active.size() >= 1) {
                        List<ChannelData> channels = this.model.getChannelData();
                        Iterator<Integer> i = channels.iterator();
                        boolean set = false;
                        while (i.hasNext()) {
                            ChannelData channel = (ChannelData)i.next();
                            int index = channel.getIndex();
                            if (!active.contains(index)) continue;
                            if (set) {
                                this.setChannelActive(index, false);
                                continue;
                            }
                            this.setChannelActive(index, true);
                            set = true;
                        }
                    } else if (active == null || active.size() == 0) {
                        this.setChannelActive(0, true);
                    }
                    if (active == null) break;
                    for (int index : active) {
                        this.view.setChannelActive(index, 0);
                    }
                    break;
                }
                case 1: {
                    this.model.setColorModel("rgb");
                    if (this.historyActiveChannels != null && this.historyActiveChannels.size() > 0) {
                        Iterator i = this.historyActiveChannels.iterator();
                        while (i.hasNext()) {
                            int index = (Integer)i.next();
                            this.setChannelActive(index, true);
                        }
                    } else {
                        if (active == null || active.size() == 0) {
                            this.setChannelActive(0, true);
                            break;
                        }
                        for (int index : active) {
                            this.setChannelActive(index, true);
                        }
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Color model not supported");
                }
            }
            this.firePropertyChange("colorModelChanged", 1, -1);
            this.view.setColorModel(key);
            if (this.model.getTabbedIndex() != 1) {
                this.colorModel = this.model.getColorModel();
                this.renderXYPlane();
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void setSelectedXYPlane(int z, int t) {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW or LOADING_RENDERING_CONTROL state.");
            }
        }
        int defaultZ = this.model.getDefaultZ();
        int defaultT = this.model.getDefaultT();
        if (defaultZ == z && defaultT == t) {
            return;
        }
        try {
            if (defaultZ != z) {
                this.firePropertyChange("zSelected", defaultZ, z);
            }
            if (defaultT != t) {
                this.firePropertyChange("tSelected", defaultT, t);
            }
            this.newPlane = true;
            this.model.setSelectedXYPlane(z, t);
            this.renderXYPlane();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void setImage(BufferedImage image) {
        if (this.model.getState() != 3) {
            throw new IllegalStateException("This method can only be invoked in the LOADING_IMAGE state.");
        }
        if (image == null) {
            UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Image retrieval", "An error occured while creating the image.");
            return;
        }
        if (this.newPlane) {
            this.postMeasurePlane();
        }
        this.newPlane = false;
        BufferedImage originalImage = this.model.getOriginalImage();
        this.model.setImage(image);
        this.view.setLeftStatus();
        this.view.setPlaneInfoStatus();
        if (originalImage == null && this.model.isZoomFitToWindow()) {
            this.controller.setZoomFactor(12);
        }
        if (this.model.isPlayingChannelMovie()) {
            this.model.setState(8);
        }
        if (!this.model.isPlayingMovie()) {
            EventBus bus = ImViewerAgent.getRegistry().getEventBus();
            BufferedImage icon = this.model.getImageIcon();
            bus.post(new ImageRendered(this.model.getPixelsID(), icon, this.model.getBrowser().getRenderedImage()));
            if (icon != null) {
                this.view.setIconImage(icon);
            }
        }
        if (!this.model.isPlayingMovie() && !this.model.isPlayingChannelMovie()) {
            if (this.view.isLensVisible()) {
                this.view.setLensPlaneImage();
            }
            this.view.createHistoryItem(null);
        }
        this.view.setCursor(Cursor.getDefaultCursor());
        this.fireStateChange();
    }

    @Override
    public void playChannelMovie(boolean play) {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW or LOADING_RENDERING_CONTROL state.");
            }
        }
        try {
            this.model.playMovie(play);
            this.view.playChannelMovie(!play);
            if (!play) {
                this.displayChannelMovie();
                this.controller.setHistoryState(6);
            }
            this.fireStateChange();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void setChannelColor(int index, Color c) {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW or LOADING_RENDERING_CONTROL state.");
            }
        }
        try {
            this.model.setChannelColor(index, c);
            this.view.setChannelColor(index, c);
            if (!this.model.isChannelActive(index)) {
                this.setChannelActive(index, true);
                this.view.setChannelActive(index, 3);
            }
            if ("greyscale".equals(this.model.getColorModel())) {
                this.setColorModel(1);
            } else {
                this.renderXYPlane();
            }
        }
        catch (Exception e) {
            Registry reg = ImViewerAgent.getRegistry();
            LogMessage msg = new LogMessage();
            msg.println("Cannot set the color of channel " + index);
            msg.print(e);
            reg.getLogger().error((Object)this, msg);
            reg.getUserNotifier().notifyError("Set channel color", "Cannot set the color of channel " + index, e);
        }
        this.firePropertyChange("channelColorChanged", -1, index);
        this.postActiveChannelSelection(0);
    }

    @Override
    public void setChannelSelection(int index, boolean b) {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW or LOADING_RENDERING_CONTROL state.");
            }
        }
        this.model.setLastSettingsRef();
        try {
            int uiIndex = -1;
            if (this.model.getColorModel().equals("greyscale")) {
                if (this.model.getTabbedIndex() == 1) {
                    ArrayList<Integer> l = new ArrayList<Integer>();
                    List selectedChannels = this.view.getActiveChannelsInGrid();
                    for (int i = 0; i < this.model.getMaxC(); ++i) {
                        if (i == index) {
                            if (!b) continue;
                            l.add(i);
                            continue;
                        }
                        if (!selectedChannels.contains(i)) continue;
                        l.add(i);
                    }
                    this.historyActiveChannels = l;
                    this.view.setChannelsSelection(l);
                } else if (this.model.getTabbedIndex() == 2) {
                    if (this.model.isChannelActive(index)) {
                        return;
                    }
                    for (int i = 0; i < this.model.getMaxC(); ++i) {
                        boolean c = i == index;
                        this.model.setChannelActive(i, c);
                        if (!c) continue;
                        this.firePropertyChange("channelActive", new Integer(index - 1), new Integer(index));
                    }
                    uiIndex = 2;
                } else {
                    if (this.model.isChannelActive(index)) {
                        return;
                    }
                    for (int i = 0; i < this.model.getMaxC(); ++i) {
                        boolean c = i == index;
                        this.model.setChannelActive(i, c);
                        if (!c) continue;
                        this.firePropertyChange("channelActive", index - 1, index);
                    }
                    uiIndex = 1;
                }
            } else {
                uiIndex = 3;
                this.model.setChannelActive(index, b);
                this.firePropertyChange("channelActive", index - 1, index);
            }
            this.view.setChannelsSelection(uiIndex);
            this.renderXYPlane();
            this.postActiveChannelSelection(1);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void setRenderingControl(RenderingControl result) {
        if (this.model.getState() != 2) {
            throw new IllegalStateException("This method can't be invoked in the LOADING_RENDERING_CONTROL.");
        }
        Renderer rnd = this.model.getRenderer();
        this.model.setRenderingControl(result);
        this.model.getRenderer().addPropertyChangeListener(this.controller);
        if (rnd == null) {
            this.colorModel = this.model.getColorModel();
            this.view.buildComponents();
            this.view.setOnScreen();
            this.view.toFront();
            if (ImViewerAgent.isFastConnection()) {
                this.model.firePlaneInfoRetrieval();
            }
            this.view.setLeftStatus();
        } else {
            this.model.resetHistory();
            this.view.switchRndControl();
        }
        this.renderXYPlane();
        this.fireStateChange();
    }

    @Override
    public void renderXYPlane() {
        switch (this.model.getState()) {
            case 1: {
                throw new IllegalStateException("This method can't be invoked in the NEW state.");
            }
            case 7: {
                return;
            }
        }
        boolean stop = false;
        int index = this.model.getTabbedIndex();
        if (index == 2) {
            RndProxyDef def = this.model.getLastProjDef();
            boolean b = false;
            if (def != null) {
                b = this.model.isSameSettings(def);
            }
            if (b && this.isSameProjectionParam()) {
                stop = true;
            }
        } else {
            RndProxyDef def = this.model.getLastMainDef();
            if (def != null) {
                stop = this.model.isSameSettings(def);
            }
        }
        if (stop) {
            return;
        }
        if (index == 2) {
            this.previewProjection();
            this.fireStateChange();
        } else {
            this.model.fireImageRetrieval();
            this.newPlane = false;
            this.fireStateChange();
        }
    }

    @Override
    public void setChannelActive(int index, boolean b) {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        try {
            this.model.setChannelActive(index, b);
            if (b) {
                this.firePropertyChange("channelActive", index - 1, index);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void displayChannelMovie() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        this.view.setChannelsSelection(3);
        this.renderXYPlane();
    }

    @Override
    public int getMaxC() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW or LOADING_RENDERING_CONTROL state.");
            }
        }
        return this.model.getMaxC();
    }

    @Override
    public int getMaxT() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        return this.model.getMaxT();
    }

    @Override
    public int getMaxZ() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        return this.model.getMaxZ();
    }

    @Override
    public String getImageName() {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
        }
        return this.model.getImageName();
    }

    @Override
    public String getColorModel() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        return this.model.getColorModel();
    }

    @Override
    public JFrame getUI() {
        switch (this.model.getState()) {
            case 1: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW state.");
            }
        }
        return this.view;
    }

    @Override
    public void iconified(boolean b) {
        switch (this.model.getState()) {
            case 1: 
            case 7: {
                return;
            }
        }
        Boolean newValue = Boolean.FALSE;
        Boolean oldValue = Boolean.TRUE;
        int index = 2;
        if (b) {
            newValue = Boolean.TRUE;
            oldValue = Boolean.FALSE;
            index = 1;
        }
        this.postViewerState(index);
        this.firePropertyChange("iconified", oldValue, newValue);
    }

    @Override
    public int getDefaultZ() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW or LOADING_RENDERING_CONTROL state.");
            }
        }
        return this.model.getDefaultZ();
    }

    @Override
    public int getDefaultT() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW or LOADING_RENDERING_CONTROL state.");
            }
        }
        return this.model.getDefaultT();
    }

    @Override
    public List getImageComponents(String colorModel) {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        if (this.model.getColorModel().equals("greyscale")) {
            return null;
        }
        List<Integer> l = this.model.getActiveChannels();
        int n = l.size();
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(n);
        if (n == 0) {
            return images;
        }
        if (n == 1) {
            images.add(this.model.getDisplayedImage());
            return images;
        }
        Iterator<Integer> i = l.iterator();
        String oldColorModel = this.model.getColorModel();
        HashMap<Integer, BufferedImage> map = new HashMap<Integer, BufferedImage>(n);
        try {
            this.model.setColorModel(colorModel);
            BufferedImage img = null;
            while (i.hasNext()) {
                int index = i.next();
                for (int j = 0; j < this.model.getMaxC(); ++j) {
                    this.model.setChannelActive(j, j == index);
                }
                BufferedImage splitImage = this.model.getSplitComponentImage();
                if (splitImage != null) {
                    img = Factory.magnifyImage(splitImage, this.model.getZoomFactor(), 0);
                }
                map.put(index, img);
            }
            this.model.setColorModel(oldColorModel);
            for (int index : l) {
                this.model.setChannelActive(index, true);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        List<ChannelData> channels = this.model.getChannelData();
        for (ChannelData channel : channels) {
            if (!map.containsKey(channel.getIndex())) continue;
            images.add((BufferedImage)map.get(channel.getIndex()));
        }
        return images;
    }

    @Override
    public List getGridImages() {
        ArrayList<BufferedImage> images;
        block16: {
            switch (this.model.getState()) {
                case 1: 
                case 2: 
                case 7: {
                    throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW or LOADING_RENDERING_CONTROL state.");
                }
            }
            this.view.setCursor(Cursor.getPredefinedCursor(3));
            List<Integer> active = this.model.getActiveChannels();
            int maxC = this.model.getMaxC();
            images = new ArrayList<BufferedImage>(maxC);
            List<ChannelData> list = this.getSortedChannelData();
            Iterator<Object> i = list.iterator();
            try {
                if (this.model.getColorModel().equals("greyscale")) {
                    active = this.view.getActiveChannelsInGrid();
                    while (i.hasNext()) {
                        int k = i.next().getIndex();
                        if (active.contains(k)) {
                            this.model.setChannelActive(k, true);
                            for (int j = 0; j < maxC; ++j) {
                                if (j == k) continue;
                                this.model.setChannelActive(j, false);
                            }
                            images.add(this.model.getSplitComponentImage());
                            continue;
                        }
                        images.add(null);
                    }
                    Iterator w = active.iterator();
                    while (w.hasNext()) {
                        this.model.setChannelActive((Integer)w.next(), true);
                    }
                    if (active.size() != 0) {
                        this.model.setColorModel("rgb");
                        images.add(this.model.getSplitComponentImage());
                        this.model.setColorModel("greyscale");
                    }
                    active = this.model.getActiveChannels();
                    i = active.iterator();
                    while (i.hasNext()) {
                    }
                    break block16;
                }
                while (i.hasNext()) {
                    int k = i.next().getIndex();
                    if (this.model.isChannelActive(k)) {
                        for (int l = 0; l < maxC; ++l) {
                            this.model.setChannelActive(l, k == l);
                        }
                        images.add(this.model.getSplitComponentImage());
                        Iterator<Integer> w = active.iterator();
                        while (w.hasNext()) {
                            this.model.setChannelActive(w.next(), true);
                        }
                        continue;
                    }
                    images.add(null);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.handleException(ex);
            }
        }
        this.view.setCursor(Cursor.getPredefinedCursor(0));
        return images;
    }

    @Override
    public BufferedImage getCombinedGridImage() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW or LOADING_RENDERING_CONTROL state.");
            }
        }
        if (!this.model.getColorModel().equals("greyscale")) {
            return null;
        }
        List<Integer> active = this.view.getActiveChannelsInGrid();
        BufferedImage image = null;
        try {
            int index;
            Iterator<Object> i = active.iterator();
            for (int k = 0; k < this.model.getMaxC(); ++k) {
                this.model.setChannelActive(k, false);
            }
            while (i.hasNext()) {
                index = (Integer)i.next();
                this.model.setChannelActive(index, true);
            }
            if (active.size() != 0) {
                this.model.setColorModel("rgb");
                image = this.model.getSplitComponentImage();
                this.model.setColorModel("greyscale");
            }
            active = this.model.getActiveChannels();
            i = active.iterator();
            while (i.hasNext()) {
                index = (Integer)i.next();
                this.model.setChannelActive(index, true);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return image;
    }

    @Override
    public BufferedImage getDisplayedImage() {
        switch (this.model.getState()) {
            case 1: 
            case 2: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW or LOADING_RENDERING_CONTROL state.");
            }
            case 7: {
                return null;
            }
        }
        return this.model.getDisplayedImage();
    }

    @Override
    public double getPixelsSizeX() {
        switch (this.model.getState()) {
            case 1: 
            case 2: {
                throw new IllegalStateException("This method can't be invoked in the NEW or LOADING_RENDERING_CONTROL state.");
            }
            case 7: {
                return -1.0;
            }
        }
        return this.model.getPixelsSizeX();
    }

    @Override
    public double getPixelsSizeY() {
        switch (this.model.getState()) {
            case 1: 
            case 2: {
                throw new IllegalStateException("This method can't be invoked in the NEW or LOADING_RENDERING_CONTROL state.");
            }
            case 7: {
                return -1.0;
            }
        }
        return this.model.getPixelsSizeY();
    }

    @Override
    public double getPixelsSizeZ() {
        switch (this.model.getState()) {
            case 1: 
            case 2: {
                throw new IllegalStateException("This method can't be invoked in the NEW or LOADING_RENDERING_CONTROL state.");
            }
            case 7: {
                return -1.0;
            }
        }
        return this.model.getPixelsSizeZ();
    }

    @Override
    public String getViewTitle() {
        if (this.model.getState() == 7) {
            return "";
        }
        return this.view.getTitle();
    }

    @Override
    public ChannelData getChannelMetadata(int index) {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
        }
        return this.model.getChannelData(index);
    }

    @Override
    public List getActiveChannels() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW or LOADING_RENDERING_CONTROL state.");
            }
        }
        return this.model.getActiveChannels();
    }

    @Override
    public boolean isUnitBar() {
        if (this.model.getState() == 7) {
            return false;
        }
        return this.model.isUnitBar();
    }

    @Override
    public void setUnitBar(boolean b) {
        if (this.model.getState() == 7) {
            return;
        }
        this.model.getBrowser().setUnitBar(b);
        this.controller.setPreferences();
    }

    @Override
    public int getHistoryState() {
        return this.controller.getHistoryState();
    }

    @Override
    public Color getChannelColor(int index) {
        if (this.model.getState() == 7) {
            return null;
        }
        return this.model.getChannelColor(index);
    }

    @Override
    public void setUnitBarSize(double size) {
        if (this.model.getState() == 7) {
            return;
        }
        this.model.getBrowser().setUnitBarSize(size);
        this.controller.setPreferences();
    }

    @Override
    public void showUnitBarSelection() {
        if (this.model.getState() == 7) {
            return;
        }
        UnitBarSizeDialog d = new UnitBarSizeDialog(this.view);
        d.addPropertyChangeListener(this.controller);
        UIUtilities.centerAndShow(d);
    }

    @Override
    public void resetDefaults() {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("The method cannot be invoked in the DISCARDED state.");
        }
        this.view.setLeftStatus();
        this.view.setPlaneInfoStatus();
        this.view.resetDefaults();
    }

    @Override
    public String getUnitBarValue() {
        if (this.model.getState() == 7) {
            return "";
        }
        return this.model.getBrowser().getUnitBarValue();
    }

    @Override
    public double getUnitBarSize() {
        if (this.model.getState() == 7) {
            return 0.0;
        }
        return this.model.getBrowser().getUnitBarSize();
    }

    @Override
    public Color getUnitBarColor() {
        if (this.model.getState() == 7) {
            return null;
        }
        if (this.model.getBrowser() == null) {
            return null;
        }
        return this.model.getBrowser().getUnitBarColor();
    }

    @Override
    public ImageIcon getImageIcon() {
        BufferedImage img = this.model.getImageIcon();
        if (img == null) {
            return null;
        }
        return new ImageIcon(img);
    }

    @Override
    public void showLens() {
        if (this.model.getState() == 7) {
            return;
        }
        this.view.setLensVisible(!this.view.isLensVisible(), this.model.getTabbedIndex());
    }

    @Override
    public BufferedImage getZoomedLensImage() {
        if (this.model.getState() == 7) {
            return null;
        }
        return this.view.getZoomedLensImage();
    }

    @Override
    public void showMenu(int menuID, Component source, Point location) {
        if (this.model.getState() == 7) {
            return;
        }
        if (source == null) {
            throw new IllegalArgumentException("No component.");
        }
        if (location == null) {
            throw new IllegalArgumentException("No point.");
        }
        switch (menuID) {
            case 0: {
                if (this.model.getMaxC() == 1) {
                    this.showColorPicker(0);
                    break;
                }
                this.view.showMenu(menuID, source, location);
                break;
            }
            default: {
                throw new IllegalArgumentException("Menu not supported.");
            }
        }
    }

    @Override
    public void setRenderingControlReloaded(boolean updateView) {
        if (this.model.getState() != 2) {
            throw new IllegalStateException("The method can only be invoked in the LOADING_RENDERING_CONTROL state.");
        }
        if (updateView) {
            this.model.getRenderer().resetRndSettings();
            this.view.resetDefaults();
        }
        this.renderXYPlane();
    }

    @Override
    public void handleException(Throwable e) {
        Logger logger = ImViewerAgent.getRegistry().getLogger();
        UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
        if (e instanceof RenderingServiceException) {
            RenderingServiceException rse = (RenderingServiceException)e;
            LogMessage logMsg = new LogMessage();
            logMsg.print("Rendering Exception:");
            logMsg.println(rse.getExtendedMessage());
            logMsg.print(rse);
            logger.error((Object)this, logMsg);
            if (this.newPlane) {
                MessageBox msg = new MessageBox(this.view, "Invalid Plane", "The selected plane contains invalid value. Do you want to reload it?");
                if (msg.centerMsgBox() == 1) {
                    logger.debug((Object)this, "Reload rendering Engine.");
                    this.model.fireRenderingControlReloading();
                    this.fireStateChange();
                } else {
                    logger.debug((Object)this, e.getMessage());
                    this.model.discard();
                    this.fireStateChange();
                }
            } else {
                if (e.getCause() instanceof OutOfMemoryError) {
                    un.notifyInfo("Image", "Due to an out of Memory error, \nit is not possible to render the image.");
                } else {
                    un.notifyError(" An error occured while modifying  the rendering settings.", logMsg.toString(), e.getCause());
                }
                this.model.discard();
                this.fireStateChange();
            }
            this.newPlane = false;
        } else if (e instanceof DSOutOfServiceException) {
            logger.debug((Object)this, "Reload rendering Engine.");
            un.notifyError(" An error occured while modifying  the rendering settings.", "Out of service.", e.getCause());
            this.model.discard();
            this.fireStateChange();
        }
    }

    @Override
    public int getMaxX() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW or LOADING_RENDERING_CONTROL state.");
            }
        }
        return this.model.getMaxX();
    }

    @Override
    public int getMaxY() {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        return this.model.getMaxY();
    }

    @Override
    public int getSelectedIndex() {
        return this.model.getTabbedIndex();
    }

    @Override
    public void playMovie(boolean play, boolean visible, int index) {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                return;
            }
        }
        MoviePlayerDialog d = this.controller.getMoviePlayer();
        boolean doClick = false;
        if (visible) {
            if (!d.isVisible()) {
                this.controller.getAction(ImViewerControl.PLAY_MOVIE_T).setEnabled(false);
                this.controller.getAction(ImViewerControl.PLAY_MOVIE_Z).setEnabled(false);
                play = true;
                UIUtilities.setLocationRelativeToAndShow(this.view, d);
            }
        } else if (d.isVisible()) {
            this.controller.getAction(ImViewerControl.PLAY_MOVIE_T).setEnabled(true);
            this.controller.getAction(ImViewerControl.PLAY_MOVIE_Z).setEnabled(true);
            play = false;
            d.setVisible(false);
        } else {
            switch (index) {
                case 300: {
                    this.controller.getAction(ImViewerControl.PLAY_MOVIE_T).setEnabled(!play);
                    break;
                }
                case 301: {
                    this.controller.getAction(ImViewerControl.PLAY_MOVIE_Z).setEnabled(!play);
                    break;
                }
                default: {
                    this.controller.getAction(ImViewerControl.PLAY_MOVIE_T).setEnabled(true);
                    this.controller.getAction(ImViewerControl.PLAY_MOVIE_Z).setEnabled(true);
                }
            }
            doClick = true;
            if (index != -1) {
                d.setMovieIndex(index);
            }
            d.setTimeRange(this.model.getDefaultT(), this.model.getMaxT());
        }
        this.model.setPlayingMovie(play, index);
        this.view.enableSliders(!play);
        this.controller.getAction(ImViewerControl.CHANNEL_MOVIE).setEnabled(!play);
        if (doClick) {
            if (play) {
                d.addPropertyChangeListener("movieStateChanged", this.controller);
                d.doClick(0);
            } else {
                d.removePropertyChangeListener("movieStateChanged", this.controller);
                d.doClick(1);
            }
        } else {
            d.removePropertyChangeListener("movieStateChanged", this.controller);
        }
        if (!play) {
            if (this.view.isLensVisible()) {
                this.view.setLensPlaneImage();
            }
            switch (this.view.getTabbedIndex()) {
                case 0: {
                    this.view.createHistoryItem(null);
                    break;
                }
                case 2: {
                    this.view.createHistoryItem(this.view.getLastProjRef());
                }
            }
            this.model.setState(6);
            this.fireStateChange();
        }
    }

    @Override
    public BufferedImage getGridImage() {
        return this.model.getBrowser().getGridImage();
    }

    @Override
    public List getLensImageComponents(String colorModel) {
        if (!this.view.hasLensImage()) {
            return null;
        }
        if (this.model.getTabbedIndex() != 0) {
            return null;
        }
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW or LOADING_RENDERING_CONTROL state.");
            }
        }
        if (this.model.getColorModel().equals("greyscale")) {
            return null;
        }
        List<Integer> l = this.model.getActiveChannels();
        if (l.size() < 2) {
            return null;
        }
        Iterator<Integer> i = l.iterator();
        String oldColorModel = this.model.getColorModel();
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(l.size());
        try {
            this.model.setColorModel(colorModel);
            while (i.hasNext()) {
                int index = i.next();
                for (int j = 0; j < this.model.getMaxC(); ++j) {
                    this.model.setChannelActive(j, j == index);
                }
                images.add(this.view.createZoomedLensImage(this.model.getSplitComponentImage()));
            }
            this.model.setColorModel(oldColorModel);
            for (int index : l) {
                this.model.setChannelActive(index, true);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        return images;
    }

    @Override
    public boolean isTextVisible() {
        return this.model.isTextVisible();
    }

    @Override
    public void setTextVisible(boolean b) {
        this.model.setTextVisible(b);
        this.model.getBrowser().viewSplitImages();
    }

    @Override
    public void showMeasurementTool() {
        EventBus bus = ImViewerAgent.getRegistry().getEventBus();
        MeasurementTool request = new MeasurementTool(this.model.getImageID(), this.model.getPixelsData(), this.model.getImageName(), this.model.getDefaultZ(), this.model.getDefaultT(), this.model.getActiveChannelsColorMap(), this.model.getZoomFactor(), this.view.getBounds(), this.model.getChannelData());
        request.setThumbnail(this.model.getImageIcon());
        request.setRenderedImage(this.model.getBrowser().getRenderedImage());
        bus.post(request);
        int tabbedIndex = this.model.getTabbedIndex();
        if (tabbedIndex != 0) {
            this.view.selectTabbedPane(0);
            this.renderXYPlane();
        }
    }

    @Override
    public void addToView(JComponent comp) {
        if (this.model.getState() != 6) {
            return;
        }
        if (comp == null) {
            return;
        }
        this.model.getBrowser().addComponent(comp, 0);
        comp.setVisible(true);
        this.view.repaint();
    }

    @Override
    public void removeFromView(JComponent comp) {
        if (this.model.getState() != 6) {
            return;
        }
        if (comp == null) {
            return;
        }
        this.model.getBrowser().removeComponent(comp, 0);
        this.view.repaint();
    }

    @Override
    public boolean hasLens() {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (this.model.getState() != 6) {
            return false;
        }
        return this.view.hasLensImage();
    }

    @Override
    public double getZoomFactor() {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        if (this.model.getState() != 6) {
            return -1.0;
        }
        return this.model.getZoomFactor();
    }

    @Override
    public boolean isPlayingMovie() {
        return this.model.isPlayingMovie();
    }

    @Override
    public boolean isChannelRed(int index) {
        return this.model.isChannelRed(index);
    }

    @Override
    public boolean isChannelGreen(int index) {
        return this.model.isChannelGreen(index);
    }

    @Override
    public boolean isChannelBlue(int index) {
        return this.model.isChannelBlue(index);
    }

    @Override
    public boolean isChannelActive(int index) {
        return this.model.isChannelActive(index);
    }

    @Override
    public void copyRenderingSettings() {
        switch (this.model.getState()) {
            case 1: 
            case 7: {
                return;
            }
        }
        try {
            this.model.saveRndSettings(false);
            this.model.copyRenderingSettings();
            this.saveBeforeCopy = true;
        }
        catch (Exception e) {
            Logger logger = ImViewerAgent.getRegistry().getLogger();
            LogMessage logMsg = new LogMessage();
            logMsg.print("Rendering Exception:");
            logMsg.println(e.getMessage());
            logMsg.print(e);
            logger.error((Object)this, logMsg);
        }
    }

    @Override
    public void pasteRenderingSettings() {
        switch (this.model.getState()) {
            case 1: 
            case 7: {
                return;
            }
        }
        if (!this.model.hasRndToPaste()) {
            UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Paste Image's settings", "No Image's settings to paste.");
            return;
        }
        this.model.fireLoadRndSettingsToPaste();
        this.fireStateChange();
    }

    @Override
    public boolean hasSettingsToPaste() {
        switch (this.model.getState()) {
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
        }
        return this.model.hasRndToPaste();
    }

    @Override
    public boolean isHistoryShown() {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
        }
        return this.view.isHistoryShown();
    }

    @Override
    public void showHistory(boolean b) {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
        }
        this.view.showHistory(b);
        this.controller.setPreferences();
    }

    @Override
    public void resetDefaultRndSettings() {
        if (this.model.getState() == 7) {
            throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
        }
        try {
            this.model.resetDefaultRndSettings();
            this.view.resetDefaults();
            this.model.getRenderer().resetRndSettings();
            this.renderXYPlane();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void saveRndSettings() {
        try {
            this.model.saveRndSettings(true);
            EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
            ArrayList<Long> l = new ArrayList<Long>();
            l.add(this.model.getImageID());
            bus.post(new RndSettingsCopied(l, this.getPixelsID()));
            this.fireStateChange();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void toFront() {
        if (this.model.getState() == 7) {
            return;
        }
        this.controller.toFront();
    }

    @Override
    public int getMovieIndex() {
        if (this.model.getState() == 7 || !this.model.isPlayingMovie() || this.model.isPlayingChannelMovie()) {
            return -1;
        }
        return this.model.getMovieIndex();
    }

    @Override
    public List getActiveChannelsInGrid() {
        if (this.model.getState() == 7) {
            return null;
        }
        return this.view.getActiveChannelsInGrid();
    }

    @Override
    public void showPreferences() {
        ViewerPreferences pref = ImViewerFactory.getPreferences();
        PreferencesDialog d = new PreferencesDialog(this.view, pref);
        d.addPropertyChangeListener(this.controller);
        UIUtilities.centerAndShow(d);
    }

    @Override
    public void setRenderingSettings(Map map) {
        if (this.model.getState() == 7) {
            return;
        }
        this.model.setRenderingSettings(map);
        this.view.showUsersList();
    }

    @Override
    public void retrieveRelatedSettings(Component source, Point location) {
        if (this.model.getState() == 7) {
            return;
        }
        Map m = this.model.getRenderingSettings();
        this.view.setLocationAndSource(source, location);
        if (m == null) {
            this.model.fireRenderingSettingsRetrieval();
        } else {
            this.view.showUsersList();
        }
    }

    @Override
    public void setGridMagnificationFactor(double factor) {
        if (this.model.getTabbedIndex() != 1) {
            return;
        }
        this.view.setGridMagnificationFactor(factor);
        this.model.getBrowser().setGridRatio(factor);
        if (this.view.isLensVisible()) {
            this.view.setImageZoomFactor((float)this.model.getBrowser().getGridRatio());
            this.view.scrollLens();
        }
    }

    @Override
    public void setUserRndSettings(ExperimenterData exp) {
        if (this.model.getState() == 7) {
            throw new IllegalArgumentException("This method cannot be invoked in the DISCARDED state.");
        }
        try {
            this.view.setCursor(Cursor.getPredefinedCursor(3));
            this.model.setUserSettings(exp);
            this.view.resetDefaults();
            this.renderXYPlane();
        }
        catch (Exception e) {
            UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Set User rendering settings", "Could not apply the settings set by " + exp.getFirstName() + " " + exp.getLastName());
        }
    }

    @Override
    public ExperimenterData getUserDetails() {
        if (this.model.getState() == 7) {
            throw new IllegalArgumentException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getUserDetails();
    }

    @Override
    public void showView(int index) {
        switch (this.model.getState()) {
            case 1: 
            case 2: 
            case 7: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED, NEW orLOADING_RENDERING_CONTROL state.");
            }
        }
        if (index == 3 || index == 4) {
            this.view.showRenderer(false, index);
            this.controller.setPreferences();
        } else {
            this.view.showView(index);
            this.setSelectedPane(index);
        }
    }

    @Override
    public void loadRenderingControl(long pixelsID) {
        if (pixelsID == this.model.getPixelsID()) {
            return;
        }
        this.model.fireRenderingControlLoading(pixelsID);
    }

    @Override
    public void setOriginalRndSettings() {
        if (this.model.getState() == 7) {
            throw new IllegalArgumentException("This method cannot be invoked in the DISCARDED state.");
        }
        try {
            this.model.setOriginalRndSettings();
            this.view.resetDefaults();
            this.model.getRenderer().resetRndSettings();
            this.renderXYPlane();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void projectImage(ProjectionRef ref) {
        if (this.model.getState() == 7) {
            throw new IllegalArgumentException("This method cannot be invoked in the DISCARDED state.");
        }
        if (this.model.getTabbedIndex() != 2) {
            return;
        }
        if (ref == null) {
            throw new IllegalArgumentException("No projection object");
        }
        this.model.fireImageProjection(this.view.getProjectionStartZ(), this.view.getProjectionEndZ(), this.view.getProjectionStepping(), this.view.getProjectionType(), this.view.getProjectionTypeName(), ref);
        this.fireStateChange();
    }

    @Override
    public void setProjectionPreview(BufferedImage image) {
        if (image == null) {
            UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Projection preview", "An error has occurred while projecting the data.");
            return;
        }
        if (this.model.getTabbedIndex() != 2) {
            return;
        }
        this.model.setRenderProjected(image);
        this.view.setLeftStatus();
        this.view.setPlaneInfoStatus();
        if (!this.model.isPlayingMovie() && !this.model.isPlayingChannelMovie()) {
            if (this.view.isLensVisible()) {
                this.view.setLensPlaneImage();
            }
            this.view.createHistoryItem(this.model.getLastProjRef());
        }
        this.fireStateChange();
    }

    @Override
    public void setContainers(Collection containers) {
        if (this.model.getState() != 11) {
            throw new IllegalArgumentException("This method can only be invoked in the LOADING_PROJECTION_DATA state.");
        }
        if (this.model.getTabbedIndex() != 2) {
            return;
        }
        this.model.setContainers(containers);
        this.fireStateChange();
        this.showProjectionDialog();
    }

    @Override
    public void loadContainers() {
        if (this.model.getState() == 7) {
            throw new IllegalArgumentException("This method cannot be invoked in the DISCARDED state.");
        }
        if (this.model.getTabbedIndex() != 2) {
            return;
        }
        if (this.model.getContainers() == null) {
            this.model.fireContainersLoading();
            this.fireStateChange();
        } else {
            this.showProjectionDialog();
        }
    }

    @Override
    public void setProjectedImage(ImageData image, List<Integer> indexes, boolean applySettings) {
        UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
        if (image == null) {
            String message = "An error has occurred while creating the projected image.";
            un.notifyInfo("Projection", message);
            this.model.setState(6);
        } else if (applySettings) {
            this.model.fireProjectedRndSettingsCreation(indexes, image);
        } else {
            this.notifyProjection("The projected image has been successfully created.", image);
        }
        this.fireStateChange();
    }

    @Override
    public void setProjectedRenderingSettings(Boolean result, ImageData image) {
        String message = result != false ? "The projected image and the rendering settings\nhave been successfully created." : "An error has occurred while copying the rendering settings of the projected image.";
        this.notifyProjection(message, image);
        this.fireStateChange();
    }

    @Override
    public void setContext(DataObject parent, DataObject grandParent) {
        if (this.model.getState() == 7) {
            return;
        }
        this.model.setContext(parent, grandParent);
    }

    @Override
    public void setPlaneInfo(Collection collection) {
        if (collection == null) {
            return;
        }
        this.model.setPlaneInfo(collection);
        this.view.setPlaneInfoStatus();
    }

    @Override
    public void setImageData(ImageData data) {
        if (this.model.getState() != 10) {
            throw new IllegalArgumentException("This method can only be invoked in the LOADING_IMAGE_DATA.");
        }
        if (data == null) {
            throw new IllegalArgumentException("No image to set.");
        }
        this.model.setImageData(data);
        this.view.setTitle(this.model.getImageTitle());
        this.model.fireRenderingControlLoading(this.model.getPixelsID());
        this.fireStateChange();
    }

    @Override
    public void setSelectedPane(int index) {
        if (this.model.getState() == 7) {
            return;
        }
        int oldIndex = this.model.getTabbedIndex();
        if (oldIndex == index) {
            return;
        }
        this.view.setSelectedPane(index);
        if (oldIndex == 1) {
            int key = 1;
            if ("greyscale".equals(this.colorModel)) {
                key = 0;
            }
            this.setColorModel(key);
        }
        if ((oldIndex == 2 && index == 0 || index == 2 && oldIndex == 0) && this.model.getBrowser().hasProjectedPreview()) {
            this.renderXYPlane();
        }
        this.firePropertyChange("tabSelection", Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public void loadMetadata() {
        if (this.model.getState() == 7) {
            return;
        }
        this.model.loadMetadata();
    }

    @Override
    public void setCompressionLevel() {
        switch (this.model.getState()) {
            case 2: 
            case 7: 
            case 12: {
                throw new IllegalArgumentException("This method cannot be invoked in the DISCARDED or PROJECTION_PREVIEW state.");
            }
        }
        int old = this.view.convertCompressionLevel();
        int index = this.view.getUICompressionLevel();
        if (old == index) {
            return;
        }
        this.view.setCompressionLevel(index);
        this.renderXYPlane();
    }

    @Override
    public void clearHistory() {
        switch (this.model.getState()) {
            case 2: 
            case 7: 
            case 12: {
                throw new IllegalArgumentException("This method cannot be invoked in the DISCARDED, PROJECTION_PREVIEW or LOADING_RENDERING_CONTROL state.");
            }
        }
        this.model.clearHistory();
        this.view.clearHistory();
        this.setSelectedPane(0);
    }

    @Override
    public boolean isOriginalSettings() {
        switch (this.model.getState()) {
            case 2: 
            case 7: {
                throw new IllegalArgumentException("This method cannot be invoked in the DISCARDED or LOADING_RENDERING_CONTROL state.");
            }
        }
        return this.model.isOriginalSettings();
    }

    @Override
    public void setSettingsToPaste(RndProxyDef rndProxyDef) {
        if (this.model.getState() != 14) {
            throw new IllegalArgumentException("This method should be invoked in the PASTING state.");
        }
        try {
            this.model.resetMappingSettings(rndProxyDef, true);
            this.view.resetDefaults();
            this.renderXYPlane();
        }
        catch (Exception e) {
            UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
            Logger logger = ImViewerAgent.getRegistry().getLogger();
            LogMessage logMsg = new LogMessage();
            logMsg.print("Rendering Exception:");
            logMsg.println(e.getMessage());
            logMsg.print(e);
            logger.error((Object)this, logMsg);
            un.notifyError("Paste Rendering settings", "An error occured while pasting the rendering settings.", e);
            this.view.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.fireStateChange();
    }

    @Override
    public List<ChannelData> getSortedChannelData() {
        return this.model.getChannelData();
    }

    @Override
    public void showColorPicker(int index) {
        if (this.model.getState() == 7) {
            return;
        }
        this.controller.showColorPicker(index);
    }
}

