/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import layout.TableLayout;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.actions.ColorPickerAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.util.ChannelButton;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerControl;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerModel;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerUI;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.data.model.ProjectionParam;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.slider.OneKnobSlider;
import org.openmicroscopy.shoola.util.ui.slider.TwoKnobsSlider;
import pojos.ChannelData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ControlPane
extends JPanel
implements ActionListener,
ChangeListener,
MouseWheelListener,
PropertyChangeListener {
    private static final String Z_SLIDER_DESCRIPTION = "Select a z-section.";
    private static final String T_SLIDER_DESCRIPTION = "Select a timepoint.";
    private static final String RATIO_SLIDER_DESCRIPTION = "Select the magnification factor of an image composing the grid.";
    private static final String ZOOM_SLIDER_DESCRIPTION = "Select the magnification factor of the image.";
    private static final String PROJECTION_SLIDER_DESCRIPTION = "Select the interval of z-sections to project.";
    private static final String Z_SLIDER_TIPSTRING = "Z";
    private static final String T_SLIDER_TIPSTRING = "T";
    private static final int SLIDER_HEIGHT = 100;
    private static final int FREQUENCY = 0;
    private static final int TYPE = 1;
    private static final String PROJECTION_DESCRIPTION = "Select the type of projection.";
    private static final int MAX_NO_TICKS = 10;
    private static final Dimension VBOX = new Dimension(1, 10);
    private static final Map<Integer, String> projections = new LinkedHashMap<Integer, String>();
    private ImViewerControl controller;
    private ImViewerModel model;
    private ImViewerUI view;
    private OneKnobSlider zSlider;
    private OneKnobSlider tSlider;
    private OneKnobSlider zSliderGrid;
    private OneKnobSlider tSliderGrid;
    private OneKnobSlider tSliderProjection;
    private TwoKnobsSlider projectionRange;
    private OneKnobSlider gridRatioSlider;
    private OneKnobSlider ratioSlider;
    private OneKnobSlider projectionRatioSlider;
    private List<ChannelButton> channelButtons;
    private List<ChannelButton> channelButtonsGrid;
    private List<ChannelButton> channelButtonsProjection;
    private JButton channelMovieButton;
    private JButton colorModelButton;
    private JButton colorModelButtonGrid;
    private JButton colorModelButtonProjection;
    private JButton colorPickerButton;
    private JToggleButton textVisibleButton;
    private JButton playTMovie;
    private JButton playTMovieGrid;
    private JButton playZMovie;
    private JButton playZMovieGrid;
    private JButton projectionProject;
    private JComboBox projectionTypesBox;
    private Map<Integer, Integer> projectionTypes;
    private JSpinner projectionFrequency;
    private IconManager icons;

    private void mouseWheelMovedZ(MouseWheelEvent e) {
        boolean up = true;
        if (e.getWheelRotation() > 0) {
            up = false;
        }
        if (e.getScrollType() == 0) {
            int v = this.model.getDefaultZ() - e.getWheelRotation();
            if (up) {
                if (v <= this.model.getMaxZ()) {
                    this.controller.setSelectedXYPlane(v, this.model.getDefaultT());
                }
            } else if (v >= 0) {
                this.controller.setSelectedXYPlane(v, this.model.getDefaultT());
            }
        }
    }

    private void mouseWheelMovedT(MouseWheelEvent e) {
        boolean up = true;
        if (e.getWheelRotation() > 0) {
            up = false;
        }
        if (e.getScrollType() == 0) {
            int v = this.model.getDefaultT() - e.getWheelRotation();
            if (up) {
                if (v <= this.model.getMaxT()) {
                    this.controller.setSelectedXYPlane(this.model.getDefaultZ(), v);
                }
            } else if (v >= 0) {
                this.controller.setSelectedXYPlane(this.model.getDefaultZ(), v);
            }
        }
    }

    private String getColorModelDescription(String model) {
        if ("greyscale".equals(model)) {
            return "Switch between color and monochrome.";
        }
        if ("rgb".equals(model)) {
            return "Switch between color and monochrome.";
        }
        return null;
    }

    private Icon getColorModelIcon(String model) {
        if ("greyscale".equals(model)) {
            return this.icons.getIcon(23);
        }
        if ("rgb".equals(model)) {
            return this.icons.getIcon(24);
        }
        return null;
    }

    private void initComponents() {
        this.channelButtons = new ArrayList<ChannelButton>();
        this.channelButtonsGrid = new ArrayList<ChannelButton>();
        this.channelButtonsProjection = new ArrayList<ChannelButton>();
        this.projectionRange = new TwoKnobsSlider(0, 1, 0, 1);
        this.projectionRange.setOrientation(101);
        this.projectionRange.setEnabled(false);
        this.projectionRange.setToolTipText(PROJECTION_SLIDER_DESCRIPTION);
        this.zSlider = new OneKnobSlider(1, 0, 1, 0);
        this.zSlider.setEnabled(false);
        this.tSlider = new OneKnobSlider(0, 0, 1, 0);
        this.tSlider.setEnabled(false);
        this.zSliderGrid = new OneKnobSlider(1, 0, 1, 0);
        this.zSliderGrid.setEnabled(false);
        this.tSliderGrid = new OneKnobSlider(0, 0, 1, 0);
        this.tSliderGrid.setEnabled(false);
        this.tSliderProjection = new OneKnobSlider(0, 0, 1, 0);
        this.tSliderProjection.setEnabled(false);
        IconManager icons = IconManager.getInstance();
        this.gridRatioSlider = new OneKnobSlider(1, 1, 10, 5);
        this.gridRatioSlider.setEnabled(true);
        this.gridRatioSlider.setShowArrows(true);
        this.gridRatioSlider.setToolTipText(RATIO_SLIDER_DESCRIPTION);
        this.gridRatioSlider.setArrowsImageIcon(icons.getImageIcon(49), icons.getImageIcon(48));
        this.ratioSlider = new OneKnobSlider(1, 0, 11, 3);
        this.ratioSlider.setEnabled(true);
        this.ratioSlider.setShowArrows(true);
        this.ratioSlider.setToolTipText(ZOOM_SLIDER_DESCRIPTION);
        this.ratioSlider.setArrowsImageIcon(icons.getImageIcon(49), icons.getImageIcon(48));
        this.projectionRatioSlider = new OneKnobSlider(1, 0, 11, 3);
        this.projectionRatioSlider.setEnabled(true);
        this.projectionRatioSlider.setShowArrows(true);
        this.projectionRatioSlider.setToolTipText(ZOOM_SLIDER_DESCRIPTION);
        this.projectionRatioSlider.setArrowsImageIcon(icons.getImageIcon(49), icons.getImageIcon(48));
        this.channelMovieButton = new JButton(this.controller.getAction(ImViewerControl.CHANNEL_MOVIE));
        UIUtilities.unifiedButtonLookAndFeel(this.channelMovieButton);
        this.colorModelButton = new JButton();
        UIUtilities.unifiedButtonLookAndFeel(this.colorModelButton);
        this.colorModelButton.addActionListener(this.controller);
        this.colorModelButtonGrid = new JButton();
        UIUtilities.unifiedButtonLookAndFeel(this.colorModelButtonGrid);
        this.colorModelButtonGrid.addActionListener(this.controller);
        this.colorModelButtonProjection = new JButton();
        UIUtilities.unifiedButtonLookAndFeel(this.colorModelButtonProjection);
        this.colorModelButtonProjection.addActionListener(this.controller);
        ViewerAction a = this.controller.getAction(ImViewerControl.COLOR_PICKER);
        this.colorPickerButton = new JButton(a);
        this.colorPickerButton.addMouseListener((ColorPickerAction)a);
        UIUtilities.unifiedButtonLookAndFeel(this.colorPickerButton);
        this.textVisibleButton = new JToggleButton();
        this.textVisibleButton.setSelected(this.model.isTextVisible());
        this.textVisibleButton.setAction(this.controller.getAction(ImViewerControl.TEXT_VISIBLE));
        this.playTMovie = new JButton(this.controller.getAction(ImViewerControl.PLAY_MOVIE_T));
        UIUtilities.unifiedButtonLookAndFeel(this.playTMovie);
        this.playTMovieGrid = new JButton(this.controller.getAction(ImViewerControl.PLAY_MOVIE_T));
        UIUtilities.unifiedButtonLookAndFeel(this.playTMovieGrid);
        this.playZMovie = new JButton(this.controller.getAction(ImViewerControl.PLAY_MOVIE_Z));
        UIUtilities.unifiedButtonLookAndFeel(this.playZMovie);
        this.playZMovieGrid = new JButton(this.controller.getAction(ImViewerControl.PLAY_MOVIE_Z));
        UIUtilities.unifiedButtonLookAndFeel(this.playZMovieGrid);
        this.projectionProject = new JButton(this.controller.getAction(ImViewerControl.PROJECTION_PROJECT));
        this.projectionFrequency = new JSpinner(new SpinnerNumberModel(1, 1, 1, 1));
        JComponent comp = this.projectionFrequency.getEditor();
        if (comp instanceof JSpinner.NumberEditor) {
            JFormattedTextField field = ((JSpinner.NumberEditor)comp).getTextField();
            field.addActionListener(this);
            field.setActionCommand("0");
        }
        Object[] names = new String[projections.size()];
        int index = 0;
        Iterator<Map.Entry<Integer, String>> i = projections.entrySet().iterator();
        this.projectionTypes = new HashMap<Integer, Integer>();
        while (i.hasNext()) {
            Map.Entry<Integer, String> entry = i.next();
            int j = entry.getKey();
            this.projectionTypes.put(index, j);
            names[index] = entry.getValue();
            ++index;
        }
        this.projectionTypesBox = EditorUtil.createComboBox(names, 0, this.getBackground());
        this.projectionTypesBox.setBackground(this.getBackground());
        this.projectionTypesBox.setToolTipText(PROJECTION_DESCRIPTION);
        this.projectionTypesBox.setActionCommand("1");
        this.projectionTypesBox.addActionListener(this);
    }

    private void initSlider(OneKnobSlider slider, int max, int v, String toolTip, String endLabel) {
        slider.setVisible(max != 0);
        slider.setMaximum(max);
        slider.setValue(v);
        slider.addChangeListener(this);
        slider.addMouseWheelListener(this);
        slider.setToolTipText(toolTip);
        slider.setEndLabel(endLabel);
        slider.setShowEndLabel(true);
        slider.setShowTipLabel(true);
        if (max > 0 && max <= 10) {
            slider.setPaintTicks(true);
            slider.setMajorTickSpacing(1);
        }
    }

    private void initializeValues() {
        int maxZ = this.model.getMaxZ();
        int maxT = this.model.getMaxT();
        this.projectionRange.setValues(maxZ + 1, 1, maxZ + 1, 1, 1, maxZ + 1);
        this.projectionRange.addPropertyChangeListener(this);
        this.projectionRange.addMouseWheelListener(this);
        this.projectionRange.setToolTipText(PROJECTION_SLIDER_DESCRIPTION);
        this.initSlider(this.tSliderProjection, maxT, this.model.getDefaultT(), T_SLIDER_DESCRIPTION, T_SLIDER_TIPSTRING);
        this.initSlider(this.zSlider, maxZ, this.model.getDefaultZ(), Z_SLIDER_DESCRIPTION, Z_SLIDER_TIPSTRING);
        this.initSlider(this.zSliderGrid, maxZ, this.model.getDefaultZ(), Z_SLIDER_DESCRIPTION, Z_SLIDER_TIPSTRING);
        this.initSlider(this.tSlider, maxT, this.model.getDefaultT(), T_SLIDER_DESCRIPTION, T_SLIDER_TIPSTRING);
        this.initSlider(this.tSliderGrid, maxT, this.model.getDefaultT(), T_SLIDER_DESCRIPTION, T_SLIDER_TIPSTRING);
        this.gridRatioSlider.addChangeListener(this);
        this.ratioSlider.addChangeListener(this);
        this.projectionRatioSlider.addChangeListener(this);
        this.playTMovie.setVisible(maxT != 0);
        this.playTMovieGrid.setVisible(maxT != 0);
        this.playZMovie.setVisible(maxZ != 0);
        this.playZMovieGrid.setVisible(maxZ != 0);
        this.colorModelButton.setIcon(this.getColorModelIcon(this.model.getColorModel()));
        this.colorModelButton.setToolTipText(this.getColorModelDescription(this.model.getColorModel()));
        this.colorModelButtonGrid.setIcon(this.getColorModelIcon(this.model.getColorModel()));
        this.colorModelButtonGrid.setToolTipText(this.getColorModelDescription(this.model.getColorModel()));
        this.colorModelButtonProjection.setIcon(this.getColorModelIcon(this.model.getColorModel()));
        this.colorModelButtonProjection.setToolTipText(this.getColorModelDescription(this.model.getColorModel()));
        SpinnerNumberModel m = (SpinnerNumberModel)this.projectionFrequency.getModel();
        m.setMaximum(Integer.valueOf(this.view.getMaxZ() + 1));
        this.projectionFrequency.addChangeListener(this);
    }

    private JPanel layoutSlider(JComponent slider) {
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        pane.add(slider);
        return pane;
    }

    private JToolBar createMovieButtonBar(JButton button) {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.add(button);
        return bar;
    }

    private JPanel createZSliderPane() {
        JPanel pane = new JPanel();
        double[][] tl = new double[][]{{-1.0}, {-1.0, -2.0}};
        pane.setLayout((LayoutManager)new TableLayout((double[][])tl));
        pane.add((Component)this.zSlider, "0, 0");
        pane.add((Component)this.createMovieButtonBar(this.playZMovie), "0, 1");
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(pane);
        return p;
    }

    private JPanel createZGridSliderPane() {
        JPanel pane = new JPanel();
        double[][] tl = new double[][]{{-1.0}, {-1.0, -2.0}};
        pane.setLayout((LayoutManager)new TableLayout((double[][])tl));
        pane.add((Component)this.zSliderGrid, "0, 0");
        pane.add((Component)this.createMovieButtonBar(this.playZMovieGrid), "0, 1");
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(pane);
        return p;
    }

    private JToolBar buildToolBar() {
        JToolBar bar = new JToolBar(1);
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.add(this.colorModelButton);
        bar.add(Box.createRigidArea(VBOX));
        bar.add(this.channelMovieButton);
        bar.add(Box.createRigidArea(VBOX));
        bar.add(this.colorPickerButton);
        return bar;
    }

    private JToolBar buildGridBar(JComponent button) {
        JToolBar bar = new JToolBar(1);
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.add(button);
        return bar;
    }

    private JToolBar buildProjectionBar() {
        JToolBar bar = new JToolBar(1);
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.add(this.colorModelButtonProjection);
        return bar;
    }

    private JPanel createChannelsPane() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(Box.createRigidArea(VBOX));
        this.channelButtons = this.createChannelButtons();
        for (ChannelButton button : this.channelButtons) {
            button.addPropertyChangeListener(this.controller);
            p.add(button);
            p.add(Box.createRigidArea(VBOX));
        }
        JPanel controls = new JPanel();
        double[][] size = new double[][]{{-2.0}, {-2.0, -2.0, -2.0, 100.0}};
        controls.setLayout((LayoutManager)new TableLayout((double[][])size));
        controls.add(Box.createVerticalStrut(20), "0, 0");
        int k = 1;
        controls.add((Component)this.buildToolBar(), "0, " + k + ", c, c");
        ++k;
        if (this.channelButtons.size() > 10) {
            controls.add((Component)new JScrollPane(p), "0, " + k);
        } else {
            controls.add((Component)p, "0, " + k);
        }
        controls.add((Component)this.ratioSlider, "0, " + ++k + ", c, c");
        return UIUtilities.buildComponentPanel(controls);
    }

    private void buildGUI() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.createChannelsPane());
        this.add(this.createZSliderPane());
    }

    private void updateSlider(JSlider slider, int v) {
        slider.removeChangeListener(this);
        slider.setValue(v);
        slider.addChangeListener(this);
    }

    private void setSliderMax(JSlider slider, int max) {
        slider.removeChangeListener(this);
        slider.setMaximum(max);
        slider.addChangeListener(this);
    }

    ControlPane(ImViewerControl controller, ImViewerModel model, ImViewerUI view) {
        if (controller == null) {
            throw new NullPointerException("No control.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.controller = controller;
        this.model = model;
        this.view = view;
        this.icons = IconManager.getInstance();
        this.initComponents();
    }

    List<ChannelButton> createChannelButtons() {
        ArrayList<ChannelButton> channelButtons = new ArrayList<ChannelButton>();
        List<ChannelData> data = this.model.getChannelData();
        boolean gs = this.model.getColorModel().equals("greyscale");
        Dimension dimMax = ChannelButton.DEFAULT_MIN_SIZE;
        for (ChannelData d : data) {
            int k = d.getIndex();
            ChannelButton button = new ChannelButton("" + d.getChannelLabeling(), this.model.getChannelColor(k), k, this.model.isChannelActive(k));
            if (gs) {
                button.setGrayedOut(gs);
            }
            channelButtons.add(button);
            Dimension dim = button.getPreferredSize();
            if (dim.width <= dimMax.width) continue;
            dimMax = new Dimension(dim.width, dimMax.height);
        }
        Iterator j = channelButtons.iterator();
        while (j.hasNext()) {
            ((ChannelButton)j.next()).setPreferredSize(dimMax);
        }
        return channelButtons;
    }

    void buildComponent() {
        this.initializeValues();
        this.buildGUI();
    }

    JPanel buildGridComponent() {
        JPanel p = this.createZGridSliderPane();
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 1));
        buttons.add(Box.createRigidArea(VBOX));
        this.channelButtonsGrid = this.createChannelButtons();
        for (ChannelButton button : this.channelButtonsGrid) {
            buttons.add(button);
            buttons.add(Box.createRigidArea(VBOX));
            button.addPropertyChangeListener(this.controller);
        }
        JPanel controls = new JPanel();
        double[][] size = new double[][]{{-2.0}, {-2.0, -2.0, -2.0, -2.0, 100.0}};
        controls.setLayout((LayoutManager)new TableLayout((double[][])size));
        controls.add(Box.createVerticalStrut(20), "0, 0");
        JToolBar bar = this.buildGridBar(this.colorModelButtonGrid);
        bar.add(Box.createRigidArea(VBOX));
        controls.add((Component)bar, "0, 1, c, c");
        controls.add((Component)this.buildGridBar(this.textVisibleButton), "0, 2, c, c");
        if (this.channelButtonsGrid.size() > 10) {
            controls.add((Component)new JScrollPane(buttons), "0, 3");
        } else {
            controls.add((Component)buttons, "0, 3");
        }
        controls.add((Component)this.gridRatioSlider, "0, 4, c, c");
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 0));
        content.add(UIUtilities.buildComponentPanel(controls));
        content.add(p);
        return content;
    }

    JPanel buildProjectionToolBar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(new JLabel("Intensity: "));
        bar.add(this.projectionTypesBox);
        bar.add(new JLabel(" Every n-th slice: "));
        bar.add(this.projectionFrequency);
        bar.add(Box.createRigidArea(VBOX));
        bar.add(this.projectionProject);
        JPanel projectionBar = new JPanel();
        projectionBar.setLayout(new FlowLayout(0, 0, 0));
        projectionBar.add(bar);
        return projectionBar;
    }

    JPanel buildProjectionComponent() {
        JPanel p = this.layoutSlider(this.projectionRange);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 1));
        buttons.add(Box.createRigidArea(VBOX));
        this.channelButtonsProjection = this.createChannelButtons();
        for (ChannelButton button : this.channelButtonsProjection) {
            buttons.add(button);
            buttons.add(Box.createRigidArea(VBOX));
            button.addPropertyChangeListener(this.controller);
        }
        JPanel controls = new JPanel();
        double[][] size = new double[][]{{-2.0}, {-2.0, -2.0, -2.0, 100.0}};
        controls.setLayout((LayoutManager)new TableLayout((double[][])size));
        controls.add(Box.createVerticalStrut(20), "0, 0");
        int k = 1;
        controls.add((Component)this.buildProjectionBar(), "0, " + k + ", c, c");
        ++k;
        if (this.channelButtonsProjection.size() > 10) {
            controls.add((Component)new JScrollPane(buttons), "0, " + k + ", c, c");
        } else {
            controls.add((Component)buttons, "0, " + k + ", c, c");
        }
        controls.add((Component)this.projectionRatioSlider, "0, " + ++k + ", c, c");
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 0));
        content.add(UIUtilities.buildComponentPanel(controls));
        content.add(p);
        return content;
    }

    void setTimepoint(int t) {
        this.updateSlider(this.tSlider, t);
        this.updateSlider(this.tSliderGrid, t);
        this.updateSlider(this.tSliderProjection, t);
    }

    void setZSection(int z) {
        this.updateSlider(this.zSlider, z);
        this.updateSlider(this.zSliderGrid, z);
    }

    void setColorModel() {
        boolean gs = this.model.getColorModel().equals("greyscale");
        for (ChannelButton button : this.channelButtons) {
            button.setSelected(this.model.isChannelActive(button.getChannelIndex()));
            button.setGrayedOut(gs);
        }
        for (ChannelButton button : this.channelButtonsGrid) {
            if (!gs) {
                button.setSelected(this.model.isChannelActive(button.getChannelIndex()));
            }
            button.setGrayedOut(gs);
        }
        for (ChannelButton button : this.channelButtonsProjection) {
            button.setSelected(this.model.isChannelActive(button.getChannelIndex()));
            button.setGrayedOut(gs);
        }
        this.colorModelButton.setIcon(this.getColorModelIcon(this.model.getColorModel()));
        this.colorModelButton.setToolTipText(this.getColorModelDescription(this.model.getColorModel()));
        this.colorModelButtonGrid.setIcon(this.getColorModelIcon(this.model.getColorModel()));
        this.colorModelButtonGrid.setToolTipText(this.getColorModelDescription(this.model.getColorModel()));
        this.colorModelButtonProjection.setIcon(this.getColorModelIcon(this.model.getColorModel()));
        this.colorModelButtonProjection.setToolTipText(this.getColorModelDescription(this.model.getColorModel()));
    }

    void setChannelsSelection(List channels) {
        for (ChannelButton button : this.channelButtonsGrid) {
            int index = button.getChannelIndex();
            button.setSelected(channels.contains(index));
        }
    }

    void setChannelsSelection(int index) {
        switch (index) {
            case 0: {
                for (ChannelButton button : this.channelButtonsGrid) {
                    button.setSelected(this.model.isChannelActive(button.getChannelIndex()));
                }
                break;
            }
            case 1: {
                for (ChannelButton button : this.channelButtons) {
                    button.setSelected(this.model.isChannelActive(button.getChannelIndex()));
                }
                break;
            }
            case 2: {
                for (ChannelButton button : this.channelButtonsProjection) {
                    button.setSelected(this.model.isChannelActive(button.getChannelIndex()));
                }
                break;
            }
            case 3: {
                for (ChannelButton button : this.channelButtons) {
                    button.setSelected(this.model.isChannelActive(button.getChannelIndex()));
                }
                for (ChannelButton button : this.channelButtonsGrid) {
                    button.setSelected(this.model.isChannelActive(button.getChannelIndex()));
                }
                for (ChannelButton button : this.channelButtonsProjection) {
                    button.setSelected(this.model.isChannelActive(button.getChannelIndex()));
                }
                break;
            }
        }
    }

    void setChannelColor(int index, Color c) {
        for (ChannelButton button : this.channelButtons) {
            if (index != button.getChannelIndex()) continue;
            button.setColor(c);
        }
        for (ChannelButton button : this.channelButtonsGrid) {
            if (index != button.getChannelIndex()) continue;
            button.setColor(c);
        }
        for (ChannelButton button : this.channelButtonsProjection) {
            if (index != button.getChannelIndex()) continue;
            button.setColor(c);
        }
    }

    void resetRndSettings() {
        int index;
        boolean gs = this.model.getColorModel().equals("greyscale");
        for (ChannelButton button : this.channelButtons) {
            index = button.getChannelIndex();
            button.setSelected(this.model.isChannelActive(index));
            button.setColor(this.model.getChannelColor(index));
            button.setGrayedOut(gs);
        }
        for (ChannelButton button : this.channelButtonsGrid) {
            index = button.getChannelIndex();
            button.setSelected(this.model.isChannelActive(index));
            button.setColor(this.model.getChannelColor(index));
            button.setGrayedOut(gs);
        }
        for (ChannelButton button : this.channelButtonsProjection) {
            index = button.getChannelIndex();
            button.setSelected(this.model.isChannelActive(index));
            button.setColor(this.model.getChannelColor(index));
            button.setGrayedOut(gs);
        }
        Icon icon = this.getColorModelIcon(this.model.getColorModel());
        String tip = this.getColorModelDescription(this.model.getColorModel());
        this.colorModelButton.setIcon(icon);
        this.colorModelButton.setToolTipText(tip);
        this.colorModelButtonGrid.setIcon(icon);
        this.colorModelButtonGrid.setToolTipText(tip);
        this.colorModelButtonProjection.setIcon(icon);
        this.colorModelButtonProjection.setToolTipText(tip);
        this.setZSection(this.model.getDefaultZ());
        this.setTimepoint(this.model.getDefaultT());
        ProjectionParam ref = this.model.getLastProjRef();
        if (ref != null) {
            this.projectionRange.setInterval(ref.getStartZ(), ref.getEndZ());
        }
    }

    void switchRndControl() {
        this.setSliderMax(this.zSlider, this.model.getMaxZ());
        this.setSliderMax(this.zSliderGrid, this.model.getMaxZ());
        this.resetRndSettings();
    }

    void onStateChange(boolean b) {
        Iterator<ChannelButton> i = this.channelButtons.iterator();
        while (i.hasNext()) {
            i.next().setEnabled(b);
        }
        i = this.channelButtonsGrid.iterator();
        while (i.hasNext()) {
            i.next().setEnabled(b);
        }
        i = this.channelButtonsProjection.iterator();
        while (i.hasNext()) {
            i.next().setEnabled(b);
        }
        this.colorModelButton.setEnabled(b);
        this.colorModelButtonGrid.setEnabled(b);
        this.colorModelButtonProjection.setEnabled(b);
        if (this.projectionTypesBox != null) {
            this.projectionTypesBox.setEnabled(b);
        }
        if (this.projectionFrequency != null) {
            this.projectionFrequency.setEnabled(b);
        }
    }

    JPanel getTimeSliderPane(int index) {
        switch (index) {
            case 1: {
                JPanel p = new JPanel();
                p.setLayout(new BoxLayout(p, 0));
                p.add(this.createMovieButtonBar(this.playTMovieGrid));
                p.add(this.tSliderGrid);
                return p;
            }
            case 2: {
                return this.layoutSlider(this.tSliderProjection);
            }
        }
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 0));
        pane.add(this.createMovieButtonBar(this.playTMovie));
        pane.add(this.tSlider);
        return pane;
    }

    void enableSliders(boolean b) {
        this.enableZSliders(b);
        this.enableTSliders(b);
    }

    void enableZSliders(boolean b) {
        if (b) {
            this.zSlider.setEnabled(this.model.getMaxZ() != 0);
            this.zSliderGrid.setEnabled(this.model.getMaxZ() != 0);
            this.projectionRange.setEnabled(this.model.getMaxZ() != 0);
        } else {
            this.zSlider.setEnabled(b);
            this.zSliderGrid.setEnabled(b);
            this.projectionRange.setEnabled(b);
        }
    }

    void enableTSliders(boolean b) {
        if (b) {
            this.tSlider.setEnabled(this.model.getMaxT() != 0);
            this.tSliderGrid.setEnabled(this.model.getMaxT() != 0);
            this.tSliderProjection.setEnabled(this.model.getMaxT() != 0);
        } else {
            this.tSlider.setEnabled(b);
            this.tSliderGrid.setEnabled(b);
            this.tSliderProjection.setEnabled(b);
        }
    }

    void setChannelActive(int index, int uiIndex) {
        switch (uiIndex) {
            case 0: {
                for (ChannelButton button : this.channelButtonsGrid) {
                    if (index != button.getChannelIndex()) continue;
                    button.setSelected(true);
                }
                break;
            }
            case 3: {
                for (ChannelButton button : this.channelButtons) {
                    if (index != button.getChannelIndex()) continue;
                    button.setSelected(true);
                }
                for (ChannelButton button : this.channelButtonsGrid) {
                    if (index != button.getChannelIndex()) continue;
                    button.setSelected(true);
                }
                for (ChannelButton button : this.channelButtonsProjection) {
                    if (index != button.getChannelIndex()) continue;
                    button.setSelected(true);
                }
                break;
            }
        }
    }

    List getActiveChannelsInGrid() {
        ArrayList<Integer> active = new ArrayList<Integer>();
        for (ChannelButton button : this.channelButtonsGrid) {
            if (!button.isSelected()) continue;
            active.add(button.getChannelIndex());
        }
        return active;
    }

    List getActiveChannelsInProjection() {
        ArrayList<Integer> active = new ArrayList<Integer>();
        for (ChannelButton button : this.channelButtonsProjection) {
            if (!button.isSelected()) continue;
            active.add(button.getChannelIndex());
        }
        return active;
    }

    void setZoomFactor(int zoomIndex) {
        if (this.ratioSlider.getMinimum() > zoomIndex || this.ratioSlider.getMaximum() < zoomIndex) {
            return;
        }
        this.ratioSlider.removeChangeListener(this);
        this.ratioSlider.setValue(zoomIndex);
        this.ratioSlider.addChangeListener(this);
        this.projectionRatioSlider.removeChangeListener(this);
        this.projectionRatioSlider.setValue(zoomIndex);
        this.projectionRatioSlider.addChangeListener(this);
    }

    int getProjectionStartZ() {
        return this.projectionRange.getStartValue() - 1;
    }

    int getProjectionEndZ() {
        return this.projectionRange.getEndValue() - 1;
    }

    void setGridMagnificationFactor(int zoomIndex) {
        if (this.gridRatioSlider.getMinimum() > zoomIndex || this.gridRatioSlider.getMaximum() < zoomIndex) {
            return;
        }
        this.gridRatioSlider.removeChangeListener(this);
        this.gridRatioSlider.setValue(zoomIndex);
        this.gridRatioSlider.addChangeListener(this);
    }

    int getProjectionStepping() {
        return (Integer)this.projectionFrequency.getValue();
    }

    int getProjectionType() {
        int index = this.projectionTypesBox.getSelectedIndex();
        return this.projectionTypes.get(index);
    }

    String getProjectionTypeName() {
        int index = this.projectionTypesBox.getSelectedIndex();
        return projections.get(index);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent comp;
        int index = Integer.parseInt(e.getActionCommand());
        if (index == 0 && (comp = this.projectionFrequency.getEditor()) instanceof JSpinner.NumberEditor) {
            JFormattedTextField field = ((JSpinner.NumberEditor)comp).getTextField();
            String value = field.getText();
            int v = -1;
            try {
                v = Integer.parseInt(value);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (v == -1 || v > this.model.getMaxZ() || v < 1) {
                return;
            }
            this.projectionFrequency.setValue(v);
        }
        this.controller.setProjectionRange(true);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object object = e.getSource();
        if (object instanceof JSlider) {
            if (object == this.gridRatioSlider) {
                double r = (double)this.gridRatioSlider.getValue() / 10.0;
                this.controller.setGridMagnificationFactor(r);
                return;
            }
            if (object == this.ratioSlider) {
                this.controller.setZoomFactor(this.ratioSlider.getValue());
            } else if (object == this.projectionRatioSlider) {
                this.controller.setZoomFactor(this.projectionRatioSlider.getValue());
            }
            if (object == this.zSlider || object == this.tSlider) {
                this.controller.setSelectedXYPlane(this.zSlider.getValue(), this.tSlider.getValue());
            } else if (object == this.zSliderGrid || object == this.tSliderGrid) {
                this.controller.setSelectedXYPlane(this.zSliderGrid.getValue(), this.tSliderGrid.getValue());
            } else if (object == this.tSliderProjection && !this.tSliderProjection.getValueIsAdjusting()) {
                try {
                    this.model.setSelectedXYPlane(-1, this.tSliderProjection.getValue() - 1);
                    this.controller.setProjectionRange(true);
                }
                catch (Exception exception) {}
            }
        } else if (object == this.projectionFrequency) {
            this.controller.setProjectionRange(true);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        Object source = e.getSource();
        if (source == this.zSlider && this.zSlider.isEnabled()) {
            this.mouseWheelMovedZ(e);
        } else if (source == this.tSlider && this.tSlider.isEnabled()) {
            this.mouseWheelMovedT(e);
        } else if (source == this.zSliderGrid && this.zSliderGrid.isEnabled()) {
            this.mouseWheelMovedZ(e);
        } else if (source == this.tSliderGrid && this.tSliderGrid.isEnabled()) {
            this.mouseWheelMovedT(e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("rightMoved".equals(name) || "leftMoved".equals(name)) {
            this.controller.setProjectionRange(false);
        } else if ("knobReleased".equals(name)) {
            this.controller.setProjectionRange(true);
        }
    }

    static {
        projections.put(ImViewer.MAX_INTENSITY, "Maximum");
        projections.put(ImViewer.MEAN_INTENSITY, "Mean");
    }
}

