/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util.proj;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import layout.TableLayout;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.util.proj.ProjectionRef;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.CreateFolderDialog;
import org.openmicroscopy.shoola.util.ui.slider.TextualTwoKnobsSlider;
import pojos.DatasetData;

public class ProjSavingDialog
extends JDialog
implements ActionListener,
DocumentListener,
PropertyChangeListener {
    public static final String PROJECTION_PROPERTY = "projection";
    private static final String TITLE = "Projection";
    private static final String DEFAULT_EXTENSION = "_proj";
    private static final int CLOSE = 0;
    private static final int PROJECT = 1;
    private static final int NEWFOLDER = 2;
    private JTextField nameField;
    private JButton closeButton;
    private JButton projectButton;
    private JButton newFolderButton;
    private JPanel selectionPane;
    private Map<JCheckBox, DatasetData> selection;
    private TextualTwoKnobsSlider timeSelection;
    private TextualTwoKnobsSlider zrangeSelection;
    private JComboBox pixelsType;
    private JCheckBox rndSettingsBox;
    private int maxT;
    private int algorithm;

    private void setProperties() {
        this.setTitle(TITLE);
        this.setModal(true);
    }

    private void initComponents(String imageName, String type, Collection datasets, int maxZ, int startZ, int endZ) {
        this.rndSettingsBox = new JCheckBox("Apply same rendering settings");
        this.rndSettingsBox.setToolTipText(UIUtilities.formatToolTipText("Apply the rendering settings to the projected image."));
        this.rndSettingsBox.setSelected(true);
        this.zrangeSelection = new TextualTwoKnobsSlider(1, maxZ, startZ, endZ);
        this.zrangeSelection.layoutComponents(1);
        this.timeSelection = new TextualTwoKnobsSlider(1, this.maxT, 1, this.maxT);
        this.timeSelection.layoutComponents(1);
        this.timeSelection.setEnabled(this.maxT > 1);
        Map<String, String> map = EditorUtil.PIXELS_TYPE_DESCRIPTION;
        String[] data = new String[map.size()];
        Set<Map.Entry<String, String>> set = map.entrySet();
        Iterator<Map.Entry<String, String>> i = set.iterator();
        int index = 0;
        int selectedIndex = 0;
        while (i.hasNext()) {
            Map.Entry<String, String> entry = i.next();
            String key = entry.getKey();
            data[index] = entry.getValue();
            if (key.equals(type)) {
                selectedIndex = index;
            }
            ++index;
        }
        this.pixelsType = new JComboBox<String>(data);
        this.pixelsType.setSelectedIndex(selectedIndex);
        this.pixelsType.setEnabled(this.algorithm == ImViewer.SUM_INTENSITY);
        this.selectionPane = new JPanel();
        this.selectionPane.setLayout(new BoxLayout(this.selectionPane, 1));
        this.closeButton = new JButton("Cancel");
        this.closeButton.setToolTipText(UIUtilities.formatToolTipText("Close the window."));
        this.closeButton.setActionCommand("0");
        this.closeButton.addActionListener(this);
        this.projectButton = new JButton("Save");
        this.projectButton.setToolTipText(UIUtilities.formatToolTipText("Project the image."));
        this.projectButton.setActionCommand("1");
        this.projectButton.addActionListener(this);
        this.newFolderButton = new JButton("New...");
        this.newFolderButton.setToolTipText(UIUtilities.formatToolTipText("Create a new Dataset."));
        this.newFolderButton.setActionCommand("2");
        this.newFolderButton.addActionListener(this);
        this.nameField = new JTextField();
        String s = EditorUtil.removeFileExtension(imageName);
        s = s + DEFAULT_EXTENSION;
        this.nameField.setText(s);
        this.nameField.getDocument().addDocumentListener(this);
        this.selection = new HashMap<JCheckBox, DatasetData>();
        if (datasets != null && datasets.size() > 0) {
            ViewerSorter sorter = new ViewerSorter();
            List l = sorter.sort(datasets);
            Iterator j = l.iterator();
            index = 0;
            while (j.hasNext()) {
                DatasetData d = (DatasetData)j.next();
                JCheckBox box = new JCheckBox(d.getName());
                this.selection.put(box, d);
                if (index == 0) {
                    box.setSelected(true);
                }
                ++index;
            }
        }
        this.getRootPane().setDefaultButton(this.projectButton);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ProjSavingDialog.this.close();
            }
        });
    }

    private JPanel buildParametersPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.buildRangePanel(this.zrangeSelection, "Z Range: "));
        p.add(this.buildRangePanel(this.timeSelection, "Timepoint: "));
        p.add(new JSeparator());
        if (this.pixelsType != null) {
            p.add(this.buildPixelsTypePanel());
            p.add(new JSeparator());
        }
        p.add(UIUtilities.buildComponentPanel(this.rndSettingsBox));
        JPanel r = UIUtilities.buildComponentPanel(p);
        r.setBorder(new TitledBorder(""));
        return r;
    }

    private JPanel buildRangePanel(JComponent comp, String text) {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(text));
        p.add(UIUtilities.buildComponentPanel(comp));
        return p;
    }

    private JPanel buildPixelsTypePanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel("Data Type: "));
        p.add(UIUtilities.buildComponentPanel(this.pixelsType));
        return p;
    }

    private JPanel buildBody() {
        JPanel content = new JPanel();
        int height = 80;
        double[][] tl = new double[][]{{-2.0, -1.0}, {-2.0, -2.0, 5.0, -2.0, -2.0, -2.0, height, 5.0, -2.0, -1.0}};
        content.setLayout((LayoutManager)new TableLayout((double[][])tl));
        content.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        content.add((Component)UIUtilities.setTextFont("Name "), "0, 1, l, c");
        content.add((Component)this.nameField, "1, 1, f, c");
        content.add((Component)new JLabel(), "0, 2, 1, 2");
        content.add((Component)UIUtilities.setTextFont("Save in "), "0, 3, l, c");
        content.add((Component)UIUtilities.setTextFont("datasets "), "0, 4, l, c");
        content.add((Component)UIUtilities.buildComponentPanel(this.newFolderButton), "0, 5, l, c");
        content.add((Component)new JScrollPane(this.selectionPane), "1, 3, 1, 6");
        if (this.selection != null) {
            Iterator<JCheckBox> i = this.selection.keySet().iterator();
            while (i.hasNext()) {
                this.selectionPane.add(i.next());
            }
        }
        content.add((Component)new JLabel(), "0, 7, 1, 7");
        content.add((Component)UIUtilities.setTextFont("Parameters "), "0, 8, l, c");
        content.add((Component)this.buildParametersPanel(), "1, 8, 1, 9");
        return content;
    }

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.add(this.closeButton);
        bar.add(Box.createHorizontalStrut(5));
        bar.add(this.projectButton);
        bar.add(Box.createHorizontalStrut(20));
        return UIUtilities.buildComponentPanelRight(bar);
    }

    private void buildGUI() {
        IconManager icons = IconManager.getInstance();
        TitlePanel tp = new TitlePanel(TITLE, "Set the projection's parameters.", icons.getIcon(59));
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(5, 5));
        c.add((Component)((Object)tp), "North");
        c.add((Component)this.buildBody(), "Center");
        c.add((Component)this.buildToolBar(), "South");
    }

    private void createDataset(String name) {
        JCheckBox newBox = new JCheckBox(name);
        newBox.setSelected(true);
        DatasetData d = new DatasetData();
        d.setName(name);
        this.selectionPane.removeAll();
        this.selectionPane.add(newBox);
        if (this.selection != null) {
            for (JCheckBox box : this.selection.keySet()) {
                box.setSelected(false);
                this.selectionPane.add(box);
            }
        }
        this.selection.put(newBox, d);
        this.selectionPane.revalidate();
        this.selectionPane.repaint();
        this.newFolderButton.setEnabled(false);
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void enableSave() {
        String name = this.nameField.getText();
        if (name == null) {
            this.projectButton.setEnabled(false);
        } else {
            int l = (name = name.trim()).length();
            this.projectButton.setEnabled(l > 0 && l < 256);
        }
    }

    private void project() {
        ArrayList<DatasetData> datasets = new ArrayList<DatasetData>();
        for (JCheckBox box : this.selection.keySet()) {
            if (!box.isSelected()) continue;
            datasets.add(this.selection.get(box));
        }
        int startT = 0;
        int endT = 0;
        if (this.maxT > 0) {
            startT = this.timeSelection.getStartValue() - 1;
            endT = this.timeSelection.getEndValue() - 1;
        }
        ProjectionRef ref = new ProjectionRef();
        ref.setDatasets(datasets);
        ref.setImageName(this.nameField.getText());
        ref.setTInterval(startT, endT);
        ref.setZInterval(this.zrangeSelection.getStartValue() - 1, this.zrangeSelection.getEndValue() - 1);
        ref.setApplySettings(this.rndSettingsBox.isSelected());
        this.firePropertyChange(PROJECTION_PROPERTY, null, ref);
        this.close();
    }

    public ProjSavingDialog(JFrame owner) {
        super(owner);
        this.setProperties();
    }

    public void initialize(int algorithm, int maxT, String pixelsType, String imageName, Collection datasets, int maxZ, int startZ, int endZ) {
        this.maxT = maxT;
        this.algorithm = algorithm;
        this.initComponents(imageName, pixelsType, datasets, maxZ, startZ, endZ);
        this.buildGUI();
    }

    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 1: {
                this.project();
                break;
            }
            case 0: {
                this.close();
                break;
            }
            case 2: {
                CreateFolderDialog d = new CreateFolderDialog(this, "New Dataset");
                d.setDefaultName("untitled dataset");
                d.addPropertyChangeListener("createFolder", this);
                d.pack();
                UIUtilities.centerAndShow(this, d);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String folderName;
        String name = evt.getPropertyName();
        if ("createFolder".equals(name) && (folderName = (String)evt.getNewValue()) != null && folderName.trim().length() > 0) {
            this.createDataset(folderName);
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.enableSave();
    }

    public void removeUpdate(DocumentEvent e) {
        this.enableSave();
    }

    public void changedUpdate(DocumentEvent e) {
    }
}

