/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util.player;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.imviewer.util.player.MoviePlayer;
import org.openmicroscopy.shoola.agents.imviewer.util.player.MoviePlayerControl;
import org.openmicroscopy.shoola.agents.imviewer.util.player.MoviePlayerUI;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;

public class MoviePlayerDialog
extends JDialog {
    public static final String CLOSE_PROPERTY = "close";
    public static final String MOVIE_STATE_CHANGED_PROPERTY = "movieStateChanged";
    public static final int ACROSS_Z = 300;
    public static final int ACROSS_T = 301;
    public static final int ACROSS_ZT = 302;
    public static final int DO_CLICK_PLAY = 0;
    public static final int DO_CLICK_PAUSE = 1;
    private MoviePlayer player;
    private MoviePlayerUI uiDelegate;
    private ImViewer model;

    private void buildGUI() {
        this.getContentPane().add(this.uiDelegate);
        this.pack();
    }

    private void initListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MoviePlayerDialog.this.player.setPlayerState(1);
                MoviePlayerDialog.this.firePropertyChange(MoviePlayerDialog.CLOSE_PROPERTY, Boolean.FALSE, Boolean.TRUE);
            }
        });
    }

    public MoviePlayerDialog(JFrame owner, ImViewer model) {
        super(owner);
        this.setResizable(false);
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.setTitle("Movie Player: " + model.getImageName());
        this.model = model;
        this.player = new MoviePlayer(model, this);
        this.uiDelegate = new MoviePlayerUI(this.player);
        new MoviePlayerControl(this.player, this.uiDelegate);
        this.initListeners();
        this.buildGUI();
    }

    void setMoviePlay(boolean b) {
        if (b) {
            this.firePropertyChange(MOVIE_STATE_CHANGED_PROPERTY, Boolean.FALSE, Boolean.TRUE);
        } else {
            this.firePropertyChange(MOVIE_STATE_CHANGED_PROPERTY, Boolean.TRUE, Boolean.FALSE);
        }
        if (this.uiDelegate != null) {
            this.uiDelegate.setMoviePlay(b);
        }
    }

    void renderImage() {
        int z = -1;
        int t = -1;
        switch (this.player.getMovieIndex()) {
            case 301: {
                z = this.model.getDefaultZ();
                t = this.player.getFrameNumberT();
                break;
            }
            case 300: {
                t = this.model.getDefaultT();
                z = this.player.getFrameNumberZ();
                break;
            }
            case 302: {
                z = this.player.getFrameNumberZ();
                t = this.player.getFrameNumberT();
            }
        }
        this.model.setSelectedXYPlane(z, t);
    }

    void notifyPlayerStateChange() {
    }

    public void setMovieIndex(int index) {
        if (this.uiDelegate != null) {
            this.uiDelegate.setMovieIndex(index);
            this.uiDelegate.setDefaultMovieType();
        }
        this.player.setMovieIndex(index);
    }

    public int getMovieIndex() {
        return this.player.getMovieIndex();
    }

    public void setTimeRange(int start, int end) {
        if (start < this.player.getMinT() || start >= end || end > this.player.getMaxT()) {
            return;
        }
        this.player.setEndT(end);
        this.player.setStartT(start);
        if (this.uiDelegate != null) {
            this.uiDelegate.setEndT(end);
            this.uiDelegate.setStartT(start);
        }
    }

    public void doClick(int index) {
        switch (index) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
        if (this.uiDelegate != null) {
            this.uiDelegate.doClick(index);
        }
    }
}

