/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.rnd.Renderer;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererFactory;
import org.openmicroscopy.shoola.agents.imviewer.util.HistogramCanvas;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.slider.TwoKnobsSlider;

public class HistogramDialog
extends JDialog
implements ActionListener,
FocusListener,
PropertyChangeListener {
    private static final String TITLE = "Histogram across time";
    private static final String TEXT = " Select the pixels intensity interval across time.";
    private static final String START = "Start: ";
    private static final String END = "End: ";
    private static final int START_CMD = 0;
    private static final int END_CMD = 1;
    private Renderer model;
    private JTextField startLabel;
    private JTextField endLabel;
    private TwoKnobsSlider slider;
    private HistogramCanvas canvas;

    private void initListeners() {
        this.slider.addPropertyChangeListener(this);
        this.model.addPropertyChangeListener(this);
        this.startLabel.addActionListener(this);
        this.startLabel.setActionCommand("0");
        this.startLabel.addFocusListener(this);
        this.endLabel.addActionListener(this);
        this.endLabel.setActionCommand("0");
        this.endLabel.addFocusListener(this);
    }

    private void initComponents() {
        int s = (int)this.model.getWindowStart();
        int e = (int)this.model.getWindowEnd();
        this.startLabel = new JTextField("" + s);
        this.endLabel = new JTextField("" + e);
        int min = (int)this.model.getGlobalMin();
        int max = (int)this.model.getGlobalMax();
        this.slider = new TwoKnobsSlider(min, max, s, e);
        this.slider.setOrientation(101);
        this.slider.setPaintEndLabels(false);
        this.slider.setPaintLabels(false);
        this.slider.setPaintTicks(false);
        this.canvas = new HistogramCanvas();
    }

    private JPanel buildLabels() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JLabel label = new JLabel(START);
        p.add((Component)label, c);
        c.gridx = 1;
        p.add((Component)this.startLabel, c);
        c.gridx = 0;
        c.gridy = 1;
        label = new JLabel(END);
        p.add((Component)label, c);
        c.gridx = 1;
        p.add((Component)this.endLabel, c);
        return p;
    }

    private JPanel buildBody() {
        JPanel body = new JPanel();
        body.setLayout(new BoxLayout(body, 1));
        JPanel p = new JPanel();
        p.add(this.slider);
        p.add(this.canvas);
        body.add(p);
        body.add(this.buildLabels());
        return body;
    }

    private void buildGUI() {
        Container c = this.getContentPane();
        IconManager icons = IconManager.getInstance();
        TitlePanel tp = new TitlePanel(TITLE, TEXT, icons.getIcon(18));
        c.add((Component)((Object)tp), "North");
        c.add((Component)this.buildBody(), "Center");
        this.pack();
    }

    private void setInputInterval() {
        int s = (int)this.model.getWindowStart();
        int e = (int)this.model.getWindowEnd();
        this.startLabel.setText(START + s);
        this.slider.setStartValue(s);
        this.endLabel.setText(END + e);
        this.slider.setEndValue(e);
    }

    private void resetValues() {
        int s = (int)this.model.getWindowStart();
        int e = (int)this.model.getWindowEnd();
        int min = (int)this.model.getGlobalMin();
        int max = (int)this.model.getGlobalMax();
        RendererFactory.initSlider(this.slider, (int)this.model.getLowestValue(), (int)this.model.getHighestValue(), min, max, s, e);
        this.startLabel.setText(START + s);
        this.endLabel.setText(END + e);
    }

    private void startSelectionHandler() {
        boolean valid = false;
        int val = 0;
        try {
            val = Integer.parseInt(this.startLabel.getText());
            if (this.model.getGlobalMin() <= (double)val && (double)val < this.model.getWindowEnd()) {
                valid = true;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (valid) {
            this.model.setInputInterval(val, this.model.getWindowEnd(), true);
        } else {
            this.startLabel.selectAll();
            UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Invalid pixels intensity interval", "[" + val + "," + this.model.getWindowEnd() + "]");
        }
    }

    private void endSelectionHandler() {
        boolean valid = false;
        int val = 0;
        try {
            val = Integer.parseInt(this.endLabel.getText());
            if (this.model.getWindowStart() < (double)val && (double)val <= this.model.getGlobalMax()) {
                valid = true;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (valid) {
            this.model.setInputInterval(this.model.getWindowStart(), val, true);
        } else {
            this.endLabel.selectAll();
            UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Invalid pixels intensity interval", "[" + this.model.getWindowStart() + "," + val + "]");
        }
    }

    public HistogramDialog(JFrame owner, Renderer model) {
        super(owner);
        this.setTitle(TITLE);
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.initComponents();
        this.initListeners();
        this.buildGUI();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name.equals("knobReleased")) {
            this.model.setInputInterval(this.slider.getStartValue(), this.slider.getEndValue(), true);
        } else if (name.equals("inputInterval")) {
            this.setInputInterval();
        } else if (name.equals("selectedChannel")) {
            this.resetValues();
        }
    }

    public void actionPerformed(ActionEvent e) {
        int index = -1;
        try {
            index = Integer.parseInt(e.getActionCommand());
            switch (index) {
                case 0: {
                    this.startSelectionHandler();
                    break;
                }
                case 1: {
                    this.endSelectionHandler();
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new Error("Invalid Action ID " + index, nfe);
        }
    }

    public void focusLost(FocusEvent fe) {
        String sVal = this.startLabel.getText();
        String s = "" + this.model.getWindowStart();
        String eVal = this.endLabel.getText();
        String e = "" + this.model.getWindowEnd();
        if (sVal == null || !sVal.equals(s)) {
            this.startLabel.setText(s);
        }
        if (eVal == null || !eVal.equals(e)) {
            this.endLabel.setText(e);
        }
    }

    public void focusGained(FocusEvent e) {
    }
}

