/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.rnd;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.openmicroscopy.shoola.agents.imviewer.rnd.CodomainPane;
import org.openmicroscopy.shoola.agents.imviewer.rnd.ControlPane;
import org.openmicroscopy.shoola.agents.imviewer.rnd.DomainPane;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererModel;

class RendererUI
extends JTabbedPane {
    static final Integer DOMAIN = 0;
    static final Integer CODOMAIN = 1;
    private RendererControl controller;
    private RendererModel model;
    private HashMap<Integer, ControlPane> controlPanes = new HashMap(2);

    private void initComponents() {
    }

    private void createControlPanes() {
        ControlPane p = new DomainPane(this.model, this.controller);
        p.addPropertyChangeListener(this.controller);
        this.controlPanes.put(DOMAIN, p);
        p = new CodomainPane(this.model, this.controller);
        p.addPropertyChangeListener(this.controller);
        this.controlPanes.put(CODOMAIN, p);
    }

    private void buildGUI(JComponent metadataView) {
        this.setAlignmentX(0.0f);
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        this.insertTab(pane.getPaneName(), null, new JScrollPane(pane), pane.getPaneDescription(), pane.getPaneIndex());
        this.insertTab("Metadata", null, new JScrollPane(metadataView), "Display the annotation and acquisition metadata", 1);
    }

    RendererUI() {
    }

    void initialize(RendererControl controller, RendererModel model, JComponent metadataView) {
        if (controller == null) {
            throw new NullPointerException("No control.");
        }
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.controller = controller;
        this.model = model;
        this.initComponents();
        this.createControlPanes();
        this.buildGUI(metadataView);
    }

    void addCodomainMap(Class mapType) {
        CodomainPane pane = (CodomainPane)this.controlPanes.get(CODOMAIN);
        pane.addCodomainMap(mapType);
    }

    void removeCodomainMap(Class mapType) {
        CodomainPane pane = (CodomainPane)this.controlPanes.get(CODOMAIN);
        pane.removeCodomainMap(mapType);
    }

    void setSelectedChannel() {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.setSelectedChannel();
    }

    void setChannelColor(int index) {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.setChannelColor(index);
    }

    void setInputInterval() {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.setInputInterval();
    }

    void resetDefaultRndSettings() {
        Iterator<Integer> i = this.controlPanes.keySet().iterator();
        while (i.hasNext()) {
            ControlPane pane = this.controlPanes.get(i.next());
            pane.resetDefaultRndSettings();
        }
    }

    void setColorModelChanged() {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.setColorModelChanged();
    }

    void onCurveChange() {
        DomainPane pane = (DomainPane)this.controlPanes.get(DOMAIN);
        pane.onCurveChange();
    }

    void loadMetadata() {
        this.model.loadMetadata();
    }

    void onStateChange(boolean b) {
        if (this.controlPanes != null && this.controlPanes.size() > 0) {
            for (Map.Entry<Integer, ControlPane> entry : this.controlPanes.entrySet()) {
                ControlPane pane = this.controlPanes.get(entry.getKey());
                pane.onStateChange(b);
            }
        }
    }

    void setPaneIndex(int index) {
        if (index == 3) {
            this.setSelectedIndex(0);
        } else if (index == 4) {
            this.setSelectedIndex(1);
        }
    }

    void showColorPicker(int index) {
        this.model.showColorPicker(index);
    }
}

