/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.rnd;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.imviewer.actions.ContrastStretchingAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.HistogramAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.NoiseReductionAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.PlaneSlicingAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ReverseIntensityAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.RndAction;
import org.openmicroscopy.shoola.agents.imviewer.rnd.Renderer;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererUI;

class RendererControl
implements ChangeListener,
PropertyChangeListener {
    static final Integer BIT_RESOLUTION = 0;
    static final Integer FAMILY = 1;
    static final Integer COEFFICIENT = 2;
    static final Integer NOISE_REDUCTION = 3;
    static final Integer REVERSE_INTENSITY = 4;
    static final Integer PLANE_SLICING = 5;
    static final Integer CONTRAST_STRETCHING = 6;
    static final Integer HISTOGRAM = 7;
    private Renderer model;
    private RendererUI view;
    private Map<Integer, RndAction> actionsMap = new HashMap<Integer, RndAction>();

    private void createActions() {
        this.actionsMap.put(REVERSE_INTENSITY, new ReverseIntensityAction(this.model));
        this.actionsMap.put(PLANE_SLICING, new PlaneSlicingAction(this.model));
        this.actionsMap.put(CONTRAST_STRETCHING, new ContrastStretchingAction(this.model));
        this.actionsMap.put(NOISE_REDUCTION, new NoiseReductionAction(this.model));
        this.actionsMap.put(HISTOGRAM, new HistogramAction(this.model));
    }

    private void attachListeners() {
        this.model.addPropertyChangeListener(this);
        this.model.getParentModel().addPropertyChangeListener(this);
        this.view.addChangeListener(this);
    }

    RendererControl() {
    }

    void initialize(Renderer model, RendererUI view) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.model = model;
        this.view = view;
        this.createActions();
        this.attachListeners();
    }

    Action getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    void addPropertyListener(PropertyChangeListener observer) {
        this.model.addPropertyChangeListener(observer);
    }

    void setInputInterval(double s, double e, boolean released) {
        this.model.setInputInterval(s, e, released);
    }

    void setCodomainInterval(int s, int e, boolean released) {
        this.model.setCodomainInterval(s, e, released);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("family".equals(name)) {
            String oldValue = (String)evt.getOldValue();
            String newValue = (String)evt.getNewValue();
            if (newValue.equals(oldValue)) {
                return;
            }
            this.model.setFamily(newValue);
            this.view.onCurveChange();
        } else if ("gamma".equals(name)) {
            Double oldValue = (Double)evt.getOldValue();
            Double newValue = (Double)evt.getNewValue();
            if (newValue.equals(oldValue)) {
                return;
            }
            this.model.setCurveCoefficient(newValue);
            this.view.onCurveChange();
        } else if ("bit_resolution".equals(name)) {
            Integer oldValue = (Integer)evt.getOldValue();
            Integer newValue = (Integer)evt.getNewValue();
            if (newValue.equals(oldValue)) {
                return;
            }
            this.model.setBitResolution(newValue);
        } else if (!"channelPicked".equals(name)) {
            if ("channelSelected".equals(name)) {
                Map map = (Map)evt.getNewValue();
                if (map == null) {
                    return;
                }
                if (map.size() != 1) {
                    return;
                }
                Set set = map.entrySet();
                for (Map.Entry entry : set) {
                    Integer index = (Integer)entry.getKey();
                    this.model.setChannelSelection(index, (Boolean)entry.getValue());
                }
            } else if ("channelColor".equals(name)) {
                this.view.showColorPicker((Integer)evt.getNewValue());
            } else if ("channelActive".equals(name)) {
                int v = (Integer)evt.getNewValue();
                this.model.setSelectedChannel(v);
            } else if ("inputInterval".equals(name)) {
                this.view.setInputInterval();
            } else if ("channelColorChanged".equals(name)) {
                int index = (Integer)evt.getNewValue();
                this.model.setChannelColor(index);
            } else if ("colorModelChanged".equals(name)) {
                this.model.setColorModelChanged();
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src instanceof JTabbedPane) {
            JTabbedPane pane = (JTabbedPane)src;
            if (pane.getSelectedIndex() == 1) {
                this.view.loadMetadata();
            }
            return;
        }
    }
}

