/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.rnd;

import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import org.openmicroscopy.shoola.agents.imviewer.rnd.Renderer;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererModel;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererUI;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;

class RendererComponent
extends AbstractComponent
implements Renderer {
    private RendererModel model;
    private RendererControl controller;
    private RendererUI view;

    RendererComponent(RendererModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new RendererControl();
        this.view = new RendererUI();
    }

    void initialize(JComponent metadataView) {
        this.model.initialize(this);
        this.controller.initialize(this, this.view);
        this.view.initialize(this.controller, this.model, metadataView);
        this.setSelectedChannel(-1);
    }

    public void discard() {
        this.model.discard();
    }

    public void setInputInterval(double s, double e, boolean released) {
        if (this.model.getParentModel().getHistoryState() == 8) {
            return;
        }
        try {
            this.model.setInputInterval(s, e);
            this.firePropertyChange("render_plane", Boolean.FALSE, Boolean.TRUE);
            this.firePropertyChange("inputInterval", Boolean.FALSE, Boolean.TRUE);
        }
        catch (Exception ex) {
            this.model.getParentModel().handleException(ex);
        }
    }

    public void setCodomainInterval(int s, int e, boolean released) {
        if (this.model.getParentModel().getHistoryState() == 8) {
            return;
        }
        try {
            this.model.setCodomainInterval(s, e);
            this.firePropertyChange("render_plane", Boolean.FALSE, Boolean.TRUE);
        }
        catch (Exception ex) {
            this.model.getParentModel().handleException(ex);
        }
    }

    public void setBitResolution(int v) {
        if (this.model.getParentModel().getHistoryState() == 8) {
            return;
        }
        try {
            this.model.setBitResolution(v);
            this.firePropertyChange("render_plane", Boolean.FALSE, Boolean.TRUE);
        }
        catch (Exception ex) {
            this.model.getParentModel().handleException(ex);
        }
    }

    public void setChannelSelection(int index, boolean selected) {
        if (this.model.getParentModel().getHistoryState() == 8) {
            return;
        }
        List<Integer> active = this.model.getActiveChannels();
        int oldIndex = this.model.getSelectedChannel();
        if (active.contains(index)) {
            if (oldIndex != index) {
                this.setSelectedChannel(index);
            } else {
                HashMap<Integer, Boolean> m = new HashMap<Integer, Boolean>(1);
                m.put(index, selected);
                this.firePropertyChange("selectedChannel", null, m);
            }
        } else {
            HashMap<Integer, Boolean> m = new HashMap<Integer, Boolean>(1);
            m.put(index, selected);
            this.firePropertyChange("selectedChannel", null, m);
        }
    }

    public void setSelectedChannel(int c) {
        if (this.model.getParentModel().getHistoryState() == 8) {
            return;
        }
        List<Integer> active = this.model.getActiveChannels();
        if (!active.contains(c) && active.size() > 0) {
            int oldSelected = this.model.getSelectedChannel();
            if (active.contains(oldSelected)) {
                c = oldSelected;
            } else {
                int setIndex = this.model.createSelectedChannel();
                if (setIndex >= 0) {
                    c = setIndex;
                }
            }
        }
        this.model.setSelectedChannel(c);
        this.view.setSelectedChannel();
    }

    public void setChannelColor(int index) {
        this.view.setChannelColor(index);
    }

    public void setColorModelChanged() {
        this.view.setColorModelChanged();
    }

    public void setFamily(String family) {
        if (this.model.getParentModel().getHistoryState() == 8) {
            return;
        }
        try {
            this.model.setFamily(family);
            this.firePropertyChange("render_plane", Boolean.FALSE, Boolean.TRUE);
        }
        catch (Exception ex) {
            this.model.getParentModel().handleException(ex);
        }
    }

    public void setCurveCoefficient(double k) {
        if (this.model.getParentModel().getHistoryState() == 8) {
            return;
        }
        try {
            this.model.setCurveCoefficient(k);
            this.firePropertyChange("render_plane", Boolean.FALSE, Boolean.TRUE);
        }
        catch (Exception ex) {
            this.model.getParentModel().handleException(ex);
        }
    }

    public void setNoiseReduction(boolean b) {
        if (this.model.getParentModel().getHistoryState() == 8) {
            return;
        }
        try {
            this.model.setNoiseReduction(b);
            this.firePropertyChange("render_plane", Boolean.FALSE, Boolean.TRUE);
        }
        catch (Exception ex) {
            this.model.getParentModel().handleException(ex);
        }
    }

    public int getState() {
        return this.model.getState();
    }

    public ImViewer getParentModel() {
        return this.model.getParentModel();
    }

    public double getWindowStart() {
        return this.model.getWindowStart();
    }

    public double getWindowEnd() {
        return this.model.getWindowEnd();
    }

    public double getGlobalMin() {
        return this.model.getGlobalMin();
    }

    public double getGlobalMax() {
        return this.model.getGlobalMax();
    }

    public JComponent getUI() {
        return this.view;
    }

    public void setRenderingControl(RenderingControl rndControl) {
        if (rndControl == null) {
            throw new IllegalArgumentException("No rendering control specified.");
        }
        this.model.setRenderingControl(rndControl);
    }

    public void resetRndSettings() {
        this.view.resetDefaultRndSettings();
    }

    public double getHighestValue() {
        return this.model.getHighestValue();
    }

    public double getLowestValue() {
        return this.model.getLowestValue();
    }

    public void onStateChange(boolean b) {
        if (this.view != null) {
            this.view.onStateChange(b);
        }
    }

    public void setPaneIndex(int index) {
        if (this.view != null) {
            this.view.setPaneIndex(index);
        }
    }
}

