/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.rnd;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import layout.TableLayout;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.rnd.GraphicsPaneUI;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererFactory;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererModel;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.slider.TwoKnobsSlider;

class GraphicsPane
extends JPanel
implements ActionListener,
FocusListener,
PropertyChangeListener {
    private static final String PREVIEW = "Immediate Update";
    private static final String PREVIEW_DESCRIPTION = "Update the rendering settings without releasing the mouse.";
    private static final int START_SELECTED = 0;
    private static final int END_SELECTED = 1;
    private static final int RANGE = 2;
    private TwoKnobsSlider codomainSlider;
    private TwoKnobsSlider domainSlider;
    private JTextField startField;
    private JTextField endField;
    private JLabel maxLabel;
    private JLabel minLabel;
    private JButton rangeButton;
    private GraphicsPaneUI uiDelegate;
    protected RendererModel model;
    protected RendererControl controller;
    private JCheckBox preview;
    private boolean paintLine;
    private int horizontalLine = -1;
    private int verticalLine = -1;

    private void setTextFieldValue(JTextField field, String value) {
        field.removeActionListener(this);
        field.removeFocusListener(this);
        field.setText(value);
        field.addActionListener(this);
        field.addFocusListener(this);
    }

    private void initDomainSlider() {
        int s = (int)this.model.getWindowStart();
        int e = (int)this.model.getWindowEnd();
        RendererFactory.initSlider(this.domainSlider, (int)this.model.getLowestValue(), (int)this.model.getHighestValue(), (int)this.model.getGlobalMin(), (int)this.model.getGlobalMax(), s, e);
    }

    private void initComponents() {
        this.uiDelegate = new GraphicsPaneUI(this, this.model);
        this.codomainSlider = new TwoKnobsSlider(0, 255, this.model.getCodomainStart(), this.model.getCodomainEnd());
        this.codomainSlider.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.codomainSlider.setPaintLabels(false);
        this.codomainSlider.setPaintEndLabels(false);
        this.codomainSlider.setPaintTicks(false);
        this.codomainSlider.setOrientation(101);
        this.codomainSlider.addPropertyChangeListener(this);
        int s = (int)this.model.getWindowStart();
        int e = (int)this.model.getWindowEnd();
        this.domainSlider = new TwoKnobsSlider();
        this.domainSlider.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.initDomainSlider();
        this.domainSlider.setPaintLabels(false);
        this.domainSlider.setPaintEndLabels(false);
        this.domainSlider.setPaintTicks(false);
        this.domainSlider.addPropertyChangeListener(this);
        double min = this.model.getGlobalMin();
        double max = this.model.getGlobalMax();
        int length = ("" + this.model.getHighestValue()).length() - 2;
        this.startField = new JTextField();
        this.startField.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.startField.setColumns(length);
        this.endField = new JTextField();
        this.endField.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.endField.setColumns(length);
        this.startField.setText("" + s);
        this.endField.setText("" + e);
        this.startField.addActionListener(this);
        this.startField.setActionCommand("0");
        this.startField.addFocusListener(this);
        this.endField.addActionListener(this);
        this.endField.setActionCommand("1");
        this.endField.addFocusListener(this);
        this.maxLabel = new JLabel("" + (int)max);
        this.minLabel = new JLabel("" + (int)min);
        this.maxLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.minLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.preview = new JCheckBox(PREVIEW);
        this.preview.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.preview.setToolTipText(PREVIEW_DESCRIPTION);
        this.rangeButton = new JButton("Min/Max");
        this.rangeButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.rangeButton.addActionListener(this);
        this.rangeButton.setActionCommand("2");
    }

    private void buildGUI() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        double[][] size = new double[][]{{-1.0}, {-2.0, 5.0, -2.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])size));
        this.add((Component)this.buildGraphicsPane(), "0, 0");
        this.add((Component)this.buildFieldsControls(), "0, 2");
    }

    private JPanel buildGraphicsPane() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        int knobWidth = this.domainSlider.getKnobWidth();
        int knobHeight = this.domainSlider.getKnobHeight();
        int width = this.codomainSlider.getPreferredSize().width;
        double[][] size = new double[][]{{width, (double)knobWidth / 2.0, -1.0, (double)knobWidth / 2.0}, {(double)knobHeight / 2.0, -1.0, (double)knobHeight / 2.0, (double)knobHeight + 2.0, -2.0, 5.0}};
        p.setLayout((LayoutManager)new TableLayout((double[][])size));
        p.add((Component)this.codomainSlider, "0, 0, 0, 2");
        p.add((Component)this.uiDelegate, "2, 1");
        p.add((Component)this.domainSlider, "1, 3, 3, 3");
        p.add((Component)this.preview, "0, 4, 3, 4");
        return p;
    }

    private JPanel buildFieldsControls() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        double[][] size = new double[][]{{-2.0, 10.0, -1.0}, {-2.0, 5.0}};
        p.setLayout((LayoutManager)new TableLayout((double[][])size));
        JPanel panel = this.buildFieldsPanel("Min", this.minLabel, "Start", this.startField);
        p.add((Component)panel, "0, 0");
        panel = this.buildFieldsPanel("Max", this.maxLabel, "End", this.endField);
        p.add((Component)panel, "2, 0");
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        content.add(p);
        JPanel comp = UIUtilities.buildComponentPanel(this.rangeButton);
        comp.setBackground(UIUtilities.BACKGROUND_COLOR);
        content.add(comp);
        return content;
    }

    private JPanel buildFieldsPanel(String txt1, JLabel l, String txt2, JTextField f) {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        double[][] size = new double[][]{{-2.0, 5.0, -2.0}, {-2.0, 5.0, -2.0}};
        p.setLayout((LayoutManager)new TableLayout((double[][])size));
        JLabel label = new JLabel();
        label.setBackground(UIUtilities.BACKGROUND_COLOR);
        label.setText(txt1);
        p.add((Component)label, "0, 0");
        p.add((Component)l, "2, 0");
        label = new JLabel();
        label.setBackground(UIUtilities.BACKGROUND_COLOR);
        label.setText(txt2);
        p.add((Component)label, "0, 2");
        p.add((Component)f, "2, 2");
        return p;
    }

    private boolean isStartFieldValid() {
        double val = 0.0;
        double e = this.model.getWindowEnd();
        try {
            val = Double.parseDouble(this.startField.getText());
            return this.model.getLowestValue() <= val && val < e;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private boolean isEndFieldValid() {
        double val = 0.0;
        double s = this.model.getWindowStart();
        try {
            val = Double.parseDouble(this.endField.getText());
            return s < val && val <= this.model.getHighestValue();
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private void startSelectionHandler() {
        double e = this.model.getWindowEnd();
        double val = -1.0;
        try {
            val = Double.parseDouble(this.startField.getText());
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (val == this.model.getWindowStart()) {
            return;
        }
        if (this.isStartFieldValid()) {
            this.controller.setInputInterval(val, e, true);
            this.onCurveChange();
        } else {
            this.startField.selectAll();
            UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Invalid pixels intensity interval", "The value must be in the interval [" + (int)this.model.getLowestValue() + "," + (int)e + "]");
        }
    }

    private void endSelectionHandler() {
        double s = this.model.getWindowStart();
        double val = -1.0;
        try {
            val = Double.parseDouble(this.endField.getText());
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (val == this.model.getWindowEnd()) {
            return;
        }
        if (this.isEndFieldValid()) {
            this.controller.setInputInterval(s, val, true);
            this.onCurveChange();
        } else {
            this.endField.selectAll();
            UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Invalid pixels intensity interval", "The value must be in the interval [" + (int)s + "," + (int)this.model.getHighestValue() + "]");
        }
    }

    GraphicsPane(RendererModel model, RendererControl controller) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (controller == null) {
            throw new NullPointerException("No controller.");
        }
        this.model = model;
        this.controller = controller;
        this.initComponents();
        this.buildGUI();
    }

    void setSelectedChannel() {
        int s = (int)this.model.getWindowStart();
        int e = (int)this.model.getWindowEnd();
        int min = (int)this.model.getGlobalMin();
        int max = (int)this.model.getGlobalMax();
        this.endField.setText("" + e);
        this.startField.setText("" + s);
        this.minLabel.setText("" + min);
        this.maxLabel.setText("" + max);
        this.initDomainSlider();
        this.onCurveChange();
    }

    void setInputInterval() {
        int s = (int)this.model.getWindowStart();
        int e = (int)this.model.getWindowEnd();
        this.endField.setText("" + e);
        this.startField.setText("" + s);
        this.domainSlider.setInterval(s, e);
        this.onCurveChange();
    }

    void setCodomainInterval() {
        this.codomainSlider.setInterval(this.model.getCodomainStart(), this.model.getCodomainEnd());
        this.onCurveChange();
    }

    void onCurveChange() {
        this.uiDelegate.invalidate();
        this.uiDelegate.repaint();
    }

    boolean isPaintLine() {
        return this.paintLine;
    }

    int getHorizontalLine() {
        return this.horizontalLine;
    }

    int getVerticalLine() {
        return this.verticalLine;
    }

    int getPartialMinimum() {
        return this.domainSlider.getPartialMinimum();
    }

    int getPartialMaximum() {
        return this.domainSlider.getPartialMaximum();
    }

    void onStateChange(boolean b) {
        if (this.codomainSlider != null) {
            this.codomainSlider.setEnabled(b);
        }
        if (this.domainSlider != null) {
            this.domainSlider.setEnabled(b);
        }
        if (this.startField != null) {
            this.startField.setEnabled(b);
        }
        if (this.endField != null) {
            this.endField.setEnabled(b);
        }
        if (this.rangeButton != null) {
            this.rangeButton.setEnabled(b);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        Object source = evt.getSource();
        if (!this.preview.isSelected()) {
            if ("knobReleased".equals(name)) {
                this.paintLine = false;
                this.horizontalLine = -1;
                this.verticalLine = -1;
                if (source.equals(this.domainSlider)) {
                    this.controller.setInputInterval(this.domainSlider.getStartValue(), this.domainSlider.getEndValue(), true);
                    this.onCurveChange();
                } else if (source.equals(this.codomainSlider)) {
                    int s = this.codomainSlider.getStartValue();
                    int e = this.codomainSlider.getEndValue();
                    this.controller.setCodomainInterval(s, e, true);
                    this.onCurveChange();
                }
            }
            if ("leftMoved".equals(name)) {
                this.paintLine = true;
                if (source.equals(this.domainSlider)) {
                    this.verticalLine = this.domainSlider.getStartValue();
                    this.horizontalLine = -1;
                    this.onCurveChange();
                } else if (source.equals(this.codomainSlider)) {
                    this.horizontalLine = this.codomainSlider.getEndValue();
                    this.verticalLine = -1;
                    this.onCurveChange();
                }
            } else if ("rightMoved".equals(name)) {
                this.paintLine = true;
                if (source.equals(this.domainSlider)) {
                    this.verticalLine = this.domainSlider.getEndValue();
                    this.horizontalLine = -1;
                    this.onCurveChange();
                } else if (source.equals(this.codomainSlider)) {
                    this.horizontalLine = this.codomainSlider.getStartValue();
                    this.verticalLine = -1;
                    this.onCurveChange();
                }
            }
        } else {
            int e;
            int s;
            this.paintLine = false;
            this.horizontalLine = -1;
            this.verticalLine = -1;
            if ("leftMoved".equals(name) || "rightMoved".equals(name)) {
                if (source.equals(this.domainSlider)) {
                    this.controller.setInputInterval(this.domainSlider.getStartValue(), this.domainSlider.getEndValue(), false);
                    this.onCurveChange();
                } else if (source.equals(this.codomainSlider)) {
                    s = this.codomainSlider.getStartValue();
                    e = this.codomainSlider.getEndValue();
                    this.controller.setCodomainInterval(s, e, false);
                    this.onCurveChange();
                }
            }
            if ("knobReleased".equals(name)) {
                if (source.equals(this.domainSlider)) {
                    this.controller.setInputInterval(this.domainSlider.getStartValue(), this.domainSlider.getEndValue(), true);
                    this.onCurveChange();
                } else if (source.equals(this.codomainSlider)) {
                    s = this.codomainSlider.getStartValue();
                    e = this.codomainSlider.getEndValue();
                    this.controller.setCodomainInterval(s, e, true);
                    this.onCurveChange();
                }
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        int index = -1;
        try {
            index = Integer.parseInt(e.getActionCommand());
            switch (index) {
                case 0: {
                    this.startSelectionHandler();
                    break;
                }
                case 1: {
                    this.endSelectionHandler();
                    break;
                }
                case 2: {
                    this.controller.setInputInterval(this.model.getGlobalMin(), this.model.getGlobalMax(), true);
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new Error("Invalid Action ID " + index, nfe);
        }
    }

    public void focusLost(FocusEvent fe) {
        if (fe.getSource() == this.startField) {
            this.setTextFieldValue(this.startField, "" + (int)this.model.getWindowStart());
        }
        if (fe.getSource() == this.endField) {
            this.setTextFieldValue(this.endField, "" + (int)this.model.getWindowEnd());
        }
    }

    public void focusGained(FocusEvent e) {
    }
}

