/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.rnd;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import layout.TableLayout;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.rnd.ControlPane;
import org.openmicroscopy.shoola.agents.imviewer.rnd.GraphicsPane;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererModel;
import org.openmicroscopy.shoola.agents.imviewer.util.ChannelButton;
import org.openmicroscopy.shoola.util.ui.SeparatorPane;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.slider.OneKnobSlider;
import pojos.ChannelData;

class DomainPane
extends ControlPane
implements ActionListener,
ChangeListener {
    static final int MIN_GAMMA = 1;
    static final int MAX_GAMMA = 40;
    static final int DEFAULT_GAMMA = 10;
    static final int MIN_BIT_DEPTH = 1;
    static final int MAX_BIT_DEPTH = 8;
    static final int DEFAULT_BIT_DEPTH = 8;
    private static final Border SELECTION_BORDER = BorderFactory.createLineBorder(Color.BLACK, 4);
    private static final int FACTOR = 10;
    private static final int FAMILY = 0;
    private static final Dimension VBOX = new Dimension(1, 10);
    private static final String ADVANCED_OPTIONS = "Advanced";
    private JComboBox familyBox;
    private List<ChannelButton> channelList;
    private JPanel channelButtonPanel;
    private OneKnobSlider gammaSlider;
    private OneKnobSlider bitDepthSlider;
    private JTextField gammaLabel;
    private JTextField bitDepthLabel;
    private JCheckBox noiseReduction;
    private JButton histogramButton;
    private GraphicsPane graphicsPane;
    private JXTaskPane taskPane;

    private void initComponents() {
        this.taskPane = new JXTaskPane();
        this.taskPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.taskPane.setTitle(ADVANCED_OPTIONS);
        this.taskPane.setCollapsed(true);
        this.graphicsPane = new GraphicsPane(this.model, this.controller);
        this.familyBox = new JComboBox<Object>(this.model.getFamilies().toArray());
        this.familyBox.setBackground(UIUtilities.BACKGROUND_COLOR);
        String family = this.model.getFamily();
        this.familyBox.setSelectedItem(family);
        this.familyBox.addActionListener(this);
        this.familyBox.setActionCommand("0");
        double k = this.model.getCurveCoefficient();
        this.gammaSlider = new OneKnobSlider(0, 1, 40, (int)(k * 10.0));
        this.gammaSlider.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.gammaSlider.setShowArrows(false);
        this.gammaSlider.setEnabled(family.equals("exponential") || family.equals("polynomial"));
        this.gammaSlider.addChangeListener(this);
        this.gammaSlider.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                double v = (double)DomainPane.this.gammaSlider.getValue() / 10.0;
                DomainPane.this.gammaLabel.setText("" + v);
                DomainPane.this.firePropertyChange("gamma", new Double(DomainPane.this.model.getCurveCoefficient()), new Double(v));
            }
        });
        this.gammaLabel = new JTextField("" + k);
        this.gammaLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.gammaLabel.setEnabled(false);
        this.gammaLabel.setEditable(false);
        int v = this.model.getBitResolution();
        this.bitDepthSlider = new OneKnobSlider(0, 1, 8, this.convertBitResolution(v));
        this.bitDepthSlider.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.bitDepthSlider.setShowArrows(false);
        this.bitDepthSlider.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                int v = DomainPane.this.convertUIBitResolution(DomainPane.this.bitDepthSlider.getValue());
                DomainPane.this.bitDepthLabel.setText("" + v);
                DomainPane.this.firePropertyChange("bit_resolution", DomainPane.this.model.getBitResolution(), v);
            }
        });
        this.bitDepthSlider.addChangeListener(this);
        this.bitDepthLabel = new JTextField("" + v);
        this.bitDepthLabel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.bitDepthLabel.setEnabled(false);
        this.bitDepthLabel.setEditable(false);
        this.noiseReduction = new JCheckBox();
        this.noiseReduction.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.noiseReduction.setSelected(this.model.isNoiseReduction());
        this.noiseReduction.setAction(this.controller.getAction(RendererControl.NOISE_REDUCTION));
        this.histogramButton = new JButton(this.controller.getAction(RendererControl.HISTOGRAM));
        this.channelList = new ArrayList<ChannelButton>();
        this.channelButtonPanel = this.createChannelButtons();
    }

    private void resetBitResolution() {
        int v = this.model.getBitResolution();
        this.bitDepthSlider.removeChangeListener(this);
        this.bitDepthSlider.setValue(this.convertBitResolution(v));
        this.bitDepthSlider.addChangeListener(this);
        this.bitDepthLabel.setText("" + v);
        this.bitDepthLabel.repaint();
    }

    private JPanel createChannelButtons() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new BoxLayout(p, 1));
        List<ChannelData> data = this.model.getChannelData();
        boolean gs = this.model.getColorModel().equals("greyscale");
        p.add(Box.createRigidArea(VBOX));
        Dimension dMax = ChannelButton.DEFAULT_MIN_SIZE;
        Iterator<ChannelData> i = data.iterator();
        List<Integer> active = this.model.getActiveChannels();
        while (i.hasNext()) {
            ChannelData d = i.next();
            int j = d.getIndex();
            ChannelButton item = new ChannelButton("" + d.getChannelLabeling(), this.model.getChannelColor(j), j);
            Dimension dim = item.getPreferredSize();
            if (dim.width > dMax.width) {
                dMax = new Dimension(dim.width, dMax.height);
            }
            item.setBackground(UIUtilities.BACKGROUND_COLOR);
            this.channelList.add(item);
            item.setSelected(active.contains(j));
            item.setGrayedOut(gs);
            item.addPropertyChangeListener(this.controller);
            p.add(item);
            p.add(Box.createRigidArea(VBOX));
        }
        Iterator<ChannelButton> index = this.channelList.iterator();
        while (index.hasNext()) {
            index.next().setPreferredSize(dMax);
        }
        JPanel controls = new JPanel();
        double[][] size = new double[][]{{-2.0}, {-2.0}};
        controls.setLayout((LayoutManager)new TableLayout((double[][])size));
        int k = 0;
        if (this.channelList.size() > 10) {
            controls.add((Component)new JScrollPane(p), "0, " + k);
        } else {
            controls.add((Component)p, "0, " + k);
        }
        JPanel content = UIUtilities.buildComponentPanel(controls);
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        return content;
    }

    private JPanel buildChannelGraphicsPanel() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new BorderLayout());
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add((Component)this.channelButtonPanel, "West");
        p.add((Component)this.graphicsPane, "Center");
        return p;
    }

    private JPanel buildSliderPane(JSlider slider, JTextField field) {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add(slider);
        p.add(field);
        return UIUtilities.buildComponentPanel(p);
    }

    private void addComponent(GridBagConstraints c, String l, JComponent comp, JPanel p) {
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        c.gridx = 0;
        if (l != null && l.length() > 0) {
            p.add((Component)new JLabel(l), c);
            ++c.gridx;
            p.add(Box.createHorizontalStrut(5), c);
            ++c.gridx;
        }
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        p.add((Component)comp, c);
    }

    private JPanel buildControlsPane() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridy = 0;
        JPanel comp = UIUtilities.buildComponentPanel(this.familyBox);
        comp.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.addComponent(c, "Map", comp, p);
        ++c.gridy;
        comp = this.buildSliderPane(this.gammaSlider, this.gammaLabel);
        comp.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.addComponent(c, "Gamma", comp, p);
        ++c.gridy;
        comp = this.buildSliderPane(this.bitDepthSlider, this.bitDepthLabel);
        comp.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.addComponent(c, "Bit Depth", comp, p);
        ++c.gridy;
        c.gridx = 0;
        comp = new SeparatorPane();
        comp.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add((Component)comp, c);
        ++c.gridy;
        this.addComponent(c, "", this.noiseReduction, p);
        ++c.gridy;
        return p;
    }

    private void buildGUI() {
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        double[][] size = new double[][]{{-1.0}, {-2.0, 5.0, -2.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])size));
        this.taskPane.add((Component)this.buildControlsPane());
        this.add((Component)this.buildChannelGraphicsPanel(), "0, 0");
        this.add((Component)this.taskPane, "0, 2");
    }

    private int convertUIBitResolution(int uiValue) {
        switch (uiValue) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 15;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 63;
            }
            case 7: {
                return 127;
            }
        }
        return 255;
    }

    private int convertBitResolution(int value) {
        switch (value) {
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 15: {
                return 4;
            }
            case 31: {
                return 5;
            }
            case 63: {
                return 6;
            }
            case 127: {
                return 7;
            }
        }
        return 8;
    }

    private void resetGamma(double k) {
        this.gammaSlider.removeChangeListener(this);
        this.gammaSlider.setValue((int)(k * 10.0));
        this.gammaSlider.addChangeListener(this);
        this.gammaLabel.setText("" + k);
    }

    protected String getPaneName() {
        return "Mapping";
    }

    protected Icon getPaneIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(6);
    }

    protected String getPaneDescription() {
        return "Define the mapping context for the pixels intensity values.";
    }

    protected int getPaneIndex() {
        return 0;
    }

    protected void resetDefaultRndSettings() {
        this.setInputInterval();
        this.setSelectedChannel();
        this.setCodomainInterval();
        this.resetBitResolution();
        boolean gs = this.model.getColorModel().equals("greyscale");
        for (int i = 0; i < this.channelList.size(); ++i) {
            ChannelButton btn = this.channelList.get(i);
            btn.setColor(this.model.getChannelColor(btn.getChannelIndex()));
            btn.setGrayedOut(gs);
        }
        this.resetGamma(this.model.getCurveCoefficient());
    }

    protected void onStateChange(boolean b) {
        if (this.familyBox != null) {
            this.familyBox.setEnabled(b);
        }
        if (this.gammaSlider != null) {
            String family = this.model.getFamily();
            this.gammaSlider.setEnabled(b);
            this.gammaSlider.setEnabled(family.equals("exponential") || family.equals("polynomial"));
        }
        if (this.bitDepthSlider != null) {
            this.bitDepthSlider.setEnabled(b);
        }
        if (this.noiseReduction != null) {
            this.noiseReduction.setEnabled(b);
        }
        if (this.channelList != null) {
            Iterator<ChannelButton> i = this.channelList.iterator();
            while (i.hasNext()) {
                i.next().setEnabled(b);
            }
        }
        this.graphicsPane.onStateChange(b);
    }

    protected void switchRndControl() {
    }

    DomainPane(RendererModel model, RendererControl controller) {
        super(model, controller);
        this.initComponents();
        this.buildGUI();
    }

    void setSelectedChannel() {
        this.graphicsPane.setSelectedChannel();
        String f = this.model.getFamily();
        this.familyBox.removeActionListener(this);
        this.familyBox.setSelectedItem(f);
        this.familyBox.addActionListener(this);
        boolean b = !f.equals("linear") && !f.equals("logarithmic");
        double k = 1.0;
        if (b) {
            k = this.model.getCurveCoefficient();
        }
        this.resetGamma(k);
        this.gammaSlider.setEnabled(b);
        this.noiseReduction.removeActionListener(this.controller.getAction(RendererControl.NOISE_REDUCTION));
        this.noiseReduction.setSelected(this.model.isNoiseReduction());
        this.noiseReduction.addActionListener(this.controller.getAction(RendererControl.NOISE_REDUCTION));
        this.noiseReduction.setText("Noise reduction");
        Iterator<ChannelButton> i = this.channelList.iterator();
        List<Integer> active = this.model.getActiveChannels();
        int c = this.model.getSelectedChannel();
        while (i.hasNext()) {
            ChannelButton btn = i.next();
            int index = btn.getChannelIndex();
            btn.setSelected(active.contains(index));
            if (index != c) continue;
            btn.setBorder(SELECTION_BORDER);
        }
    }

    void setInputInterval() {
        this.graphicsPane.setInputInterval();
    }

    void setCodomainInterval() {
        this.graphicsPane.setCodomainInterval();
    }

    void setChannelColor(int index) {
        Iterator<ChannelButton> i = this.channelList.iterator();
        boolean gs = this.model.getColorModel().equals("greyscale");
        while (i.hasNext()) {
            ChannelButton btn = i.next();
            if (index != btn.getChannelIndex()) continue;
            btn.setColor(this.model.getChannelColor(index));
            if (!gs) continue;
            btn.setGrayedOut(gs);
        }
    }

    void setColorModelChanged() {
        String colorModel = this.model.getColorModel();
        for (int i = 0; i < this.channelList.size(); ++i) {
            ChannelButton btn = this.channelList.get(i);
            btn.setColor(this.model.getChannelColor(btn.getChannelIndex()));
            btn.setGrayedOut(colorModel.equals("greyscale"));
        }
    }

    void onCurveChange() {
        String f = this.model.getFamily();
        boolean b = !f.equals("linear") && !f.equals("logarithmic");
        double k = 1.0;
        if (b) {
            k = this.model.getCurveCoefficient();
        }
        this.resetGamma(k);
        this.gammaSlider.setEnabled(b);
        this.graphicsPane.onCurveChange();
    }

    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source.equals(this.gammaSlider)) {
            this.gammaLabel.setText("" + (double)this.gammaSlider.getValue() / 10.0);
        } else if (source.equals(this.bitDepthSlider)) {
            this.bitDepthLabel.setText("" + this.convertUIBitResolution(this.bitDepthSlider.getValue()));
        }
    }

    public void actionPerformed(ActionEvent e) {
        int index = -1;
        index = Integer.parseInt(e.getActionCommand());
        try {
            switch (index) {
                case 0: {
                    String f = (String)((JComboBox)e.getSource()).getSelectedItem();
                    this.firePropertyChange("family", this.model.getFamily(), f);
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new Error("Invalid Action ID " + index, nfe);
        }
    }
}

