/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.rnd;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import layout.TableLayout;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.rnd.ControlPane;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererControl;
import org.openmicroscopy.shoola.agents.imviewer.rnd.RendererModel;

class CodomainPane
extends ControlPane {
    private JButton contrastStretchingButton;
    private JButton planeSlicingButton;
    private JCheckBox reverseIntensity;
    private JCheckBox contrastStretching;
    private JCheckBox planeSlicing;

    private void initComponents() {
        IconManager icons = IconManager.getInstance();
        this.contrastStretchingButton = new JButton(icons.getIcon(8));
        this.contrastStretchingButton.setEnabled(false);
        this.contrastStretchingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        this.planeSlicingButton = new JButton(icons.getIcon(9));
        this.planeSlicingButton.setEnabled(false);
        this.planeSlicingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        this.reverseIntensity = new JCheckBox(this.controller.getAction(RendererControl.REVERSE_INTENSITY));
        this.planeSlicing = new JCheckBox(this.controller.getAction(RendererControl.PLANE_SLICING));
        this.contrastStretching = new JCheckBox(this.controller.getAction(RendererControl.CONTRAST_STRETCHING));
        this.setDefaultValues();
    }

    private void setDefaultValues() {
    }

    private JPanel buildControlsPane() {
        JPanel p = new JPanel();
        double[][] size = new double[][]{{-2.0, 5.0, -2.0}, {-2.0, -2.0, -2.0}};
        p.setLayout((LayoutManager)new TableLayout((double[][])size));
        p.add((Component)this.reverseIntensity, "0, 0");
        p.add((Component)this.contrastStretching, "0, 1");
        p.add((Component)this.contrastStretchingButton, "2, 1");
        p.add((Component)this.planeSlicing, "0, 2");
        p.add((Component)this.planeSlicingButton, "2, 2");
        return p;
    }

    private void buildGUI() {
        this.setLayout(new FlowLayout(0));
        this.add(this.buildControlsPane());
    }

    protected String getPaneName() {
        return "Device Settings";
    }

    protected Icon getPaneIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(7);
    }

    protected String getPaneDescription() {
        return "Selects the transformations happening in the device space.";
    }

    protected int getPaneIndex() {
        return 2;
    }

    protected void resetDefaultRndSettings() {
        this.reverseIntensity.removeActionListener(this.controller.getAction(RendererControl.REVERSE_INTENSITY));
        this.planeSlicing.removeActionListener(this.controller.getAction(RendererControl.PLANE_SLICING));
        this.contrastStretching.removeActionListener(this.controller.getAction(RendererControl.CONTRAST_STRETCHING));
        this.setDefaultValues();
        this.reverseIntensity.setAction(this.controller.getAction(RendererControl.REVERSE_INTENSITY));
        this.planeSlicing.setAction(this.controller.getAction(RendererControl.PLANE_SLICING));
        this.contrastStretching.setAction(this.controller.getAction(RendererControl.CONTRAST_STRETCHING));
    }

    protected void onStateChange(boolean b) {
    }

    protected void switchRndControl() {
        this.resetDefaultRndSettings();
    }

    CodomainPane(RendererModel model, RendererControl controller) {
        super(model, controller);
        this.initComponents();
        this.buildGUI();
    }

    void addCodomainMap(Class mapType) {
    }

    void removeCodomainMap(Class mapType) {
    }
}

