/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserUI;
import org.openmicroscopy.shoola.agents.imviewer.browser.ImageCanvas;
import org.openmicroscopy.shoola.agents.imviewer.util.ImagePaintingFactory;

class ProjectionCanvas
extends ImageCanvas {
    private static final String DEFAULT_TEXT = "Click here to preview\n a projection of all the z-sections.";
    private BrowserUI view;
    private MouseAdapter listener;

    private void projectionPreview() {
        this.model.projectionPreview();
        this.removeMouseListener(this.listener);
    }

    private void attachListener() {
        if (this.listener != null) {
            return;
        }
        this.listener = new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                ProjectionCanvas.this.projectionPreview();
            }
        };
        this.addMouseListener(this.listener);
    }

    ProjectionCanvas(BrowserModel model, BrowserUI view) {
        super(model);
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.view = view;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        BufferedImage img = this.model.getDisplayedProjectedImage();
        Graphics2D g2D = (Graphics2D)g;
        ImagePaintingFactory.setGraphicRenderingSettings(g2D);
        if (img == null) {
            img = this.model.getDisplayedImage();
            if (img != null) {
                this.attachListener();
                int w = img.getWidth() - 1;
                int h = img.getHeight() - 1;
                g2D.setColor(Color.black);
                g2D.fillRect(0, 0, w, h);
                FontMetrics fm = g2D.getFontMetrics();
                g2D.setColor(Color.white);
                int width = fm.stringWidth(DEFAULT_TEXT);
                g2D.drawString(DEFAULT_TEXT, (w - width) / 2, h / 2);
            }
            return;
        }
        g2D.drawImage(img, null, 0, 0);
        this.paintScaleBar(g2D, img.getWidth(), img.getHeight(), this.view.getViewport());
        g2D.dispose();
    }
}

