/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JViewport;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.imviewer.util.ImagePaintingFactory;

class ImageCanvas
extends JPanel {
    static final Color BACKGROUND = Color.BLACK;
    protected BrowserModel model;
    protected String paintedString;
    protected int height;

    ImageCanvas(BrowserModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.setBackground(model.getBackgroundColor());
        this.setDoubleBuffered(true);
        this.setFont(this.getFont().deriveFont(10.0f));
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.height = fm.getHeight();
        this.paintedString = null;
    }

    void setPaintedString(int pressedZ, int pressedT) {
        this.paintedString = pressedZ < 0 || pressedT < 0 ? null : "z=" + pressedZ + ", t=" + pressedT;
        this.repaint();
    }

    void paintScaleBar(Graphics2D g2D, int width, int height, JViewport viewPort) {
        if (!this.model.isUnitBar()) {
            return;
        }
        String value = this.model.getUnitBarValue();
        if (value == null) {
            return;
        }
        int size = (int)this.model.getUnitBarSize();
        Rectangle imgRect = new Rectangle(0, 0, width, height);
        Rectangle viewRect = viewPort.getBounds();
        Point p = viewPort.getViewPosition();
        int x = (int)p.getX();
        int y = (int)p.getY();
        int w = Math.min(x + viewRect.width, width);
        int h = Math.min(y + viewRect.height, height);
        if (imgRect.contains(viewRect)) {
            w = x + viewRect.width;
            h = y + viewRect.height;
        }
        if (viewRect.width >= size) {
            ImagePaintingFactory.paintScaleBar(g2D, w - size - 10, h - 10, size, value, this.model.getUnitBarColor());
        }
    }
}

