/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserUI;
import org.openmicroscopy.shoola.agents.imviewer.browser.GridCanvas;

class GridUI
extends JScrollPane {
    private GridCanvas canvas;
    private BrowserModel model;
    private BrowserUI view;
    private JLayeredPane layeredPane;

    private void initComponents() {
        this.layeredPane = new JLayeredPane();
        this.canvas = new GridCanvas(this.model);
        this.layeredPane.add((Component)this.canvas, (Object)0);
    }

    private void buildGUI() {
        this.getViewport().setLayout(null);
        this.getViewport().setBackground(this.model.getBackgroundColor());
        this.getViewport().add(this.layeredPane);
    }

    GridUI() {
    }

    void initialize(BrowserModel model, BrowserUI view) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.model = model;
        this.view = view;
        this.initComponents();
        this.buildGUI();
    }

    void setGridSize() {
        Dimension d = this.model.getGridSize();
        this.layeredPane.setPreferredSize(d);
        this.layeredPane.setSize(d);
        this.canvas.setPreferredSize(d);
        this.canvas.setSize(d);
        this.layeredPane.setBackground(Color.RED);
    }

    void addComponentToLayer(JComponent c) {
        this.layeredPane.add((Component)c, (Object)1);
    }

    void removeComponentFromLayer(JComponent c) {
        this.layeredPane.remove(c);
    }

    void paintImage() {
        this.repaint();
    }

    BufferedImage getGridImage() {
        return this.canvas.getGridImage();
    }

    void setGridRatio() {
        this.setGridSize();
        this.getViewport().setViewPosition(new Point(-1, -1));
        this.canvas.repaint();
        this.setBounds(this.getBounds());
    }

    Point isOnImageInGrid(Rectangle rect) {
        return this.canvas.isOnImageInGrid(rect);
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.view.isAdjusting()) {
            return;
        }
        Rectangle r = this.getViewport().getViewRect();
        Dimension d = this.layeredPane.getPreferredSize();
        int xLoc = (r.width - d.width) / 2;
        int yLoc = (r.height - d.height) / 2;
        this.layeredPane.setBounds(xLoc, yLoc, d.width, d.height);
    }
}

