/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserCanvas;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.imviewer.browser.ImageCanvasListener;

class BrowserUI
extends JScrollPane
implements MouseMotionListener {
    private JLayeredPane layeredPane;
    private BrowserCanvas browserCanvas;
    private BrowserModel model;
    private BrowserControl controller;
    private ImageCanvasListener canvasListener;
    private Map<Integer, JComponent> siblings = new HashMap<Integer, JComponent>();
    private boolean adjusting;

    private void initComponents() {
        this.layeredPane = new JLayeredPane();
        this.browserCanvas = new BrowserCanvas(this.model, this);
        this.layeredPane.add((Component)this.browserCanvas, (Object)0);
        this.canvasListener = new ImageCanvasListener(this, this.model, this.browserCanvas);
        this.canvasListener.setHandleKeyDown(true);
        this.getVerticalScrollBar().addMouseMotionListener(this);
        this.getHorizontalScrollBar().addMouseMotionListener(this);
    }

    private void buildGUI() {
        JViewport viewport = this.getViewport();
        viewport.setLayout(null);
        viewport.setBackground(this.model.getBackgroundColor());
        viewport.add(this.layeredPane);
    }

    private boolean scrollbarsVisible() {
        JScrollBar hBar = this.getHorizontalScrollBar();
        JScrollBar vBar = this.getVerticalScrollBar();
        if (hBar.isVisible()) {
            return true;
        }
        return vBar.isVisible();
    }

    BrowserUI() {
    }

    void initialize(BrowserControl controller, BrowserModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        if (controller == null) {
            throw new NullPointerException("No control.");
        }
        this.model = model;
        this.controller = controller;
        this.initComponents();
        this.buildGUI();
    }

    void setSibling(int index, JComponent sibling) {
        this.siblings.put(index, sibling);
    }

    void addComponentToLayer(JComponent c) {
        Component[] components = this.layeredPane.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] != c) continue;
            return;
        }
        this.layeredPane.add((Component)c, (Object)1);
    }

    void removeComponentFromLayer(JComponent c) {
        this.layeredPane.remove(c);
    }

    void paintMainImage() {
        if (this.model.getRenderedImage() == null) {
            return;
        }
        this.model.createDisplayedImage();
        BufferedImage img = this.model.getDisplayedImage();
        if (img == null) {
            return;
        }
        this.canvasListener.setAreaSize(img.getWidth(), img.getHeight());
        this.browserCanvas.repaint();
    }

    void zoomImage() {
        if (this.model.getRenderedImage() == null) {
            return;
        }
        this.model.createDisplayedImage();
        BufferedImage img = this.model.getDisplayedImage();
        if (img == null) {
            return;
        }
        this.setComponentsSize(img.getWidth(), img.getHeight());
        this.canvasListener.setAreaSize(img.getWidth(), img.getHeight());
        this.getViewport().setViewPosition(new Point(-1, -1));
        this.browserCanvas.repaint();
        this.setBounds(this.getBounds());
    }

    void setComponentsSize(int w, int h) {
        Dimension d = new Dimension(w, h);
        this.layeredPane.setPreferredSize(d);
        this.layeredPane.setSize(d);
        this.browserCanvas.setPreferredSize(d);
        this.browserCanvas.setSize(d);
    }

    Dimension getViewportSize() {
        return this.getViewport().getSize();
    }

    void scrollTo(Rectangle bounds, boolean blockIncrement) {
        Rectangle viewRect = this.getViewport().getViewRect();
        JScrollBar hBar = this.getHorizontalScrollBar();
        JScrollBar vBar = this.getVerticalScrollBar();
        int x = 0;
        int y = 0;
        if (!viewRect.contains(bounds)) {
            int deltaX = viewRect.x - bounds.x;
            int deltaY = viewRect.y - bounds.y;
            if (deltaX < 0 && blockIncrement) {
                x = hBar.getValue() + hBar.getBlockIncrement();
            } else {
                int w = viewRect.width - bounds.width;
                if (w < 0) {
                    w = -w;
                }
                x = bounds.x - w / 2;
            }
            if (deltaY < 0 && blockIncrement) {
                y = vBar.getValue() + vBar.getBlockIncrement();
            } else {
                int h = viewRect.height - bounds.height;
                if (h < 0) {
                    h = -h;
                }
                y = bounds.y - h / 2;
            }
        } else {
            if (blockIncrement) {
                return;
            }
            int w = viewRect.width - bounds.width;
            if (w < 0) {
                w = -w;
            }
            x = bounds.x - w / 2;
            int h = viewRect.height - bounds.height;
            if (h < 0) {
                h = -h;
            }
            y = bounds.y - h / 2;
        }
        vBar.setValue(y);
        hBar.setValue(x);
    }

    void scrollTo(int vValue, int hValue) {
        JScrollBar vBar = this.getVerticalScrollBar();
        JScrollBar hBar = this.getHorizontalScrollBar();
        hBar.setValue(hBar.getValue() + hValue);
        vBar.setValue(vBar.getValue() + vValue);
    }

    void clearGridImages() {
        this.model.clearGridImages();
    }

    boolean isAdjusting() {
        return this.adjusting;
    }

    public void mouseDragged(MouseEvent e) {
        this.adjusting = true;
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (!this.scrollbarsVisible() && this.adjusting) {
            this.adjusting = false;
        }
        if (this.adjusting) {
            return;
        }
        Rectangle r = this.getViewport().getViewRect();
        Dimension d = this.layeredPane.getPreferredSize();
        int xLoc = (r.width - d.width) / 2;
        int yLoc = (r.height - d.height) / 2;
        JComponent sibling = this.siblings.get(this.model.getSelectedIndex());
        if (sibling != null) {
            sibling.setBounds(sibling.getBounds());
        }
        this.layeredPane.setBounds(xLoc, yLoc, d.width, d.height);
    }

    public void mouseMoved(MouseEvent e) {
    }
}

