/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.actions.UnitBarSizeAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ZoomAction;
import org.openmicroscopy.shoola.agents.imviewer.actions.ZoomCmd;
import org.openmicroscopy.shoola.agents.imviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.imviewer.browser.SplitImage;
import org.openmicroscopy.shoola.agents.imviewer.util.ImagePaintingFactory;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.agents.imviewer.view.ViewerPreferences;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ChannelData;
import pojos.ImageData;

class BrowserModel {
    private static final String COMBINED = "Combined";
    private static final String PREFIX = "w=";
    static final int GAP = 2;
    private Browser component;
    private BufferedImage renderedImage;
    private BufferedImage displayedImage;
    private BufferedImage projectedImage;
    private BufferedImage displayedProjectedImage;
    private BufferedImage combinedImage;
    private double zoomFactor;
    private ImViewer parent;
    private boolean unitBar;
    private double unitInMicrons;
    private Color unitBarColor;
    private Color backgroundColor;
    private ImageData data;
    private List<BufferedImage> originalGridImages;
    private List<BufferedImage> gridImages;
    private List<SplitImage> splitImages;
    private double ratio;
    private double gridRatio;
    private boolean init;

    private BufferedImage createBandImage(DataBuffer buf, int sizeX, int sizeY, int redMask, int greenMask, int blueMask) {
        int[] masks = new int[]{redMask, greenMask, blueMask};
        switch (buf.getDataType()) {
            case 0: {
                DataBufferByte bufferByte = (DataBufferByte)buf;
                byte[] values = bufferByte.getData();
                int i = 0;
                int j = 0;
                int l = values.length / 3;
                int[] buffer = new int[l];
                while (i < l) {
                    buffer[i++] = values[j++] | values[j++] << 8 | values[j++] << 16;
                }
                return Factory.createImage(buffer, 24, masks, sizeX, sizeY);
            }
            case 3: {
                return Factory.createImage(buf, 32, masks, sizeX, sizeY);
            }
        }
        return null;
    }

    private boolean isChannelRGB(int index) {
        if (this.parent.isChannelRed(index)) {
            return true;
        }
        if (this.parent.isChannelGreen(index)) {
            return true;
        }
        return this.parent.isChannelBlue(index);
    }

    private boolean isImageRGB(List channels) {
        if (channels == null) {
            return false;
        }
        int n = channels.size();
        if (n == 0 || n > 3) {
            return false;
        }
        ArrayList<Boolean> rgb = new ArrayList<Boolean>();
        Iterator i = channels.iterator();
        while (i.hasNext()) {
            int index = (Integer)i.next();
            if (!this.isChannelRGB(index)) continue;
            rgb.add(true);
        }
        return n == rgb.size();
    }

    private void createGridImagesForGreyScale() {
        int maxC = this.parent.getMaxC();
        List l = this.parent.getActiveChannelsInGrid();
        int n = l.size();
        switch (n) {
            case 0: {
                for (int i = 0; i < maxC; ++i) {
                    this.gridImages.add(null);
                }
                this.combinedImage = null;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                if (this.isImageRGB(l)) {
                    BufferedImage image = this.parent.getCombinedGridImage();
                    if (image == null) {
                        for (int i = 0; i < maxC; ++i) {
                            this.gridImages.add(null);
                        }
                    } else {
                        this.combinedImage = Factory.magnifyImage(this.gridRatio, image);
                        int w = this.combinedImage.getWidth();
                        int h = this.combinedImage.getHeight();
                        DataBuffer buf = this.combinedImage.getRaster().getDataBuffer();
                        List<ChannelData> list = this.parent.getSortedChannelData();
                        Iterator<ChannelData> i = list.iterator();
                        while (i.hasNext()) {
                            int index = i.next().getIndex();
                            if (l.contains(index)) {
                                if (this.parent.isChannelRed(index)) {
                                    this.gridImages.add(this.createBandImage(buf, w, h, 0xFF0000, 0xFF0000, 0xFF0000));
                                    continue;
                                }
                                if (this.parent.isChannelGreen(index)) {
                                    this.gridImages.add(this.createBandImage(buf, w, h, 65280, 65280, 65280));
                                    continue;
                                }
                                if (!this.parent.isChannelBlue(index)) continue;
                                this.gridImages.add(this.createBandImage(buf, w, h, 255, 255, 255));
                                continue;
                            }
                            this.gridImages.add(null);
                        }
                    }
                    break;
                }
                this.retrieveGridImagesForGreyScale(l);
                break;
            }
            default: {
                this.retrieveGridImagesForGreyScale(l);
            }
        }
    }

    private void retrieveGridImagesForGreyScale(List channels) {
        List images = this.parent.getGridImages();
        if (images != null) {
            int last = images.size() - 1;
            this.combinedImage = Factory.magnifyImage(this.gridRatio, (BufferedImage)images.get(last));
            images.remove(last);
            Iterator i = images.iterator();
            while (i.hasNext()) {
                this.gridImages.add(Factory.magnifyImage(this.gridRatio, (BufferedImage)i.next()));
            }
            if (this.originalGridImages.size() == 0 && !this.isImageRGB(channels)) {
                i = images.iterator();
                while (i.hasNext()) {
                    this.originalGridImages.add((BufferedImage)i.next());
                }
            }
        }
    }

    private void retrieveGridImages() {
        List images = this.parent.getGridImages();
        if (images != null) {
            Iterator i = images.iterator();
            while (i.hasNext()) {
                this.gridImages.add(Factory.magnifyImage(this.gridRatio, (BufferedImage)i.next()));
            }
            if (this.originalGridImages.size() == 0) {
                i = images.iterator();
                while (i.hasNext()) {
                    this.originalGridImages.add((BufferedImage)i.next());
                }
            }
            this.combinedImage = Factory.magnifyImage(this.gridRatio, this.renderedImage);
        }
    }

    private void createGridImages() {
        if (this.originalGridImages == null) {
            this.originalGridImages = new ArrayList<BufferedImage>();
        }
        this.gridImages.clear();
        if (this.parent.getColorModel().equals("greyscale")) {
            this.createGridImagesForGreyScale();
            return;
        }
        List l = this.parent.getActiveChannels();
        int maxC = this.parent.getMaxC();
        switch (l.size()) {
            case 0: {
                for (int i = 0; i < maxC; ++i) {
                    this.gridImages.add(null);
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                if (this.isImageRGB(l)) {
                    this.combinedImage = Factory.magnifyImage(this.gridRatio, this.renderedImage);
                    int w = this.combinedImage.getWidth();
                    int h = this.combinedImage.getHeight();
                    DataBuffer buf = this.combinedImage.getRaster().getDataBuffer();
                    List<ChannelData> list = this.parent.getSortedChannelData();
                    Iterator<ChannelData> i = list.iterator();
                    while (i.hasNext()) {
                        int index = i.next().getIndex();
                        if (this.parent.isChannelActive(index)) {
                            if (this.parent.isChannelRed(index)) {
                                this.gridImages.add(this.createBandImage(buf, w, h, 0xFF0000, 0, 0));
                                continue;
                            }
                            if (this.parent.isChannelGreen(index)) {
                                this.gridImages.add(this.createBandImage(buf, w, h, 0, 65280, 0));
                                continue;
                            }
                            if (!this.parent.isChannelBlue(index)) continue;
                            this.gridImages.add(this.createBandImage(buf, w, h, 0, 0, 255));
                            continue;
                        }
                        this.gridImages.add(null);
                    }
                    break;
                }
                this.retrieveGridImages();
                break;
            }
            default: {
                this.retrieveGridImages();
            }
        }
    }

    BrowserModel(ImViewer parent, long imageID, ViewerPreferences pref) {
        if (parent == null) {
            throw new IllegalArgumentException("No parent.");
        }
        this.data = new ImageData();
        this.data.setId(imageID);
        this.parent = parent;
        this.unitBar = true;
        this.ratio = 0.5;
        this.gridRatio = 0.5;
        this.init = true;
        this.unitInMicrons = UnitBarSizeAction.getDefaultValue();
        this.unitBarColor = ImagePaintingFactory.UNIT_BAR_COLOR;
        this.backgroundColor = ImagePaintingFactory.DEFAULT_BACKGROUND;
        this.gridImages = new ArrayList<BufferedImage>();
        this.zoomFactor = 1.0;
        if (pref != null) {
            if (pref.getBackgroundColor() != null) {
                this.backgroundColor = pref.getBackgroundColor();
            }
            if (pref.getScaleBarColor() != null) {
                this.unitBarColor = pref.getScaleBarColor();
            }
            if (pref.isFieldSelected("Zoom factor")) {
                this.zoomFactor = ZoomAction.getZoomFactor(pref.getZoomIndex());
            }
        }
    }

    void initialize(Browser component) {
        this.component = component;
    }

    void setRenderedImage(BufferedImage image) {
        this.renderedImage = image;
        if (this.renderedImage != null && this.init) {
            int imageWidth = image.getWidth();
            if (imageWidth < 96) {
                this.ratio = 1.0;
                this.gridRatio = 1.0;
                this.unitBar = false;
            }
            if ((double)imageWidth * this.ratio > 256.0) {
                this.ratio = 256.0 / (double)imageWidth;
            }
            this.init = false;
        }
        this.displayedImage = null;
        this.combinedImage = null;
        this.gridImages.clear();
    }

    void setGridImages() {
        if (this.gridImages.size() != 0) {
            return;
        }
        if (this.originalGridImages != null) {
            this.originalGridImages.clear();
        }
        this.createGridImages();
    }

    BufferedImage getDisplayedImage() {
        return this.displayedImage;
    }

    BufferedImage getDisplayedProjectedImage() {
        return this.displayedProjectedImage;
    }

    BufferedImage getRenderedImage() {
        return this.renderedImage;
    }

    void setZoomFactor(double factor) {
        this.zoomFactor = factor;
    }

    double getZoomFactor() {
        return this.zoomFactor;
    }

    String getTitle() {
        return "Image";
    }

    Icon getIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(22);
    }

    void createDisplayedImage() {
        if (this.renderedImage == null) {
            return;
        }
        if (this.zoomFactor != 1.0) {
            BufferedImage img = null;
            try {
                img = Factory.magnifyImage(this.renderedImage, this.zoomFactor, 0);
            }
            catch (Exception e) {
                UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
                un.notifyInfo("Magnification", "An error occurs while magnifying the image.");
            }
            if (img != null) {
                this.displayedImage = img;
            }
        } else {
            this.displayedImage = this.renderedImage;
        }
    }

    void createDisplayedProjectedImage() {
        if (this.projectedImage == null) {
            return;
        }
        if (this.zoomFactor != 1.0) {
            BufferedImage img = null;
            try {
                img = Factory.magnifyImage(this.projectedImage, this.zoomFactor, 0);
            }
            catch (Exception e) {
                UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
                un.notifyInfo("Magnification", "An error occurs while magnifying the image.");
            }
            if (img != null) {
                this.displayedProjectedImage = img;
            }
        } else {
            this.displayedProjectedImage = this.projectedImage;
        }
    }

    int getMaxZ() {
        return this.parent.getMaxZ();
    }

    int getMaxT() {
        return this.parent.getMaxT();
    }

    double getPixelsSizeX() {
        return this.parent.getPixelsSizeX();
    }

    boolean isUnitBar() {
        return this.unitBar;
    }

    void setUnitBar(boolean unitBar) {
        this.unitBar = unitBar;
    }

    void setUnitBarSize(double size) {
        this.unitInMicrons = size;
    }

    double getUnitInMicrons() {
        return this.unitInMicrons;
    }

    double getUnitBarSize() {
        double v = this.unitInMicrons;
        if (this.getPixelsSizeX() > 0.0) {
            v = this.unitInMicrons / this.getPixelsSizeX();
        }
        return v *= this.zoomFactor;
    }

    double getGridBarSize() {
        double v = this.unitInMicrons;
        if (this.getPixelsSizeX() > 0.0) {
            v = this.unitInMicrons / this.getPixelsSizeX();
        }
        return v *= this.gridRatio;
    }

    String getUnitBarValue() {
        return UIUtilities.twoDecimalPlaces(this.unitInMicrons);
    }

    Color getUnitBarColor() {
        return this.unitBarColor;
    }

    void setUnitBarColor(Color c) {
        this.unitBarColor = c;
    }

    Color getBackgroundColor() {
        return this.backgroundColor;
    }

    void setBackgroundColor(Color c) {
        this.backgroundColor = c;
    }

    ImageData getImageData() {
        return this.data;
    }

    String getGridViewTitle() {
        return "Split";
    }

    Icon getGridViewIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(34);
    }

    String getProjectionViewTitle() {
        return "Projection";
    }

    Icon getProjectionViewIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(58);
    }

    Icon getAnnotatorIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(33);
    }

    void setSelectedXYPlane(int z, int t) {
        this.parent.setSelectedXYPlane(z, t);
    }

    int getDefaultT() {
        return this.parent.getDefaultT();
    }

    int getDefaultZ() {
        return this.parent.getDefaultZ();
    }

    int getMaxX() {
        return this.parent.getMaxX();
    }

    int getMaxY() {
        return this.parent.getMaxY();
    }

    double getPixelsSizeY() {
        return this.parent.getPixelsSizeY();
    }

    double getPixelsSizeZ() {
        return this.parent.getPixelsSizeZ();
    }

    int getGridColumn() {
        return 2;
    }

    int getGridRow() {
        int n = this.parent.getMaxC();
        if (n <= 3) {
            return 2;
        }
        int row = n / 2;
        if (n % 2 != 0) {
            ++row;
        }
        return row;
    }

    Dimension getGridSize() {
        int w = (int)((double)this.getMaxX() * this.gridRatio);
        int h = (int)((double)this.getMaxY() * this.gridRatio);
        int n = this.parent.getMaxC();
        int row = 0;
        int col = 0;
        if (n == 1) {
            row = 1;
            col = 2;
        } else if (n == 2 || n == 3) {
            row = 2;
            col = 2;
        } else {
            col = 3;
            row = n / 2;
            if (n % 2 != 0) {
                ++row;
            }
        }
        return new Dimension(col * w + (col - 1) * 2, row * h + (row - 1) * 2);
    }

    boolean hasNoGridImages() {
        return this.gridImages.size() == 0;
    }

    List getSplitImages() {
        if (this.splitImages == null) {
            this.splitImages = new ArrayList<SplitImage>();
        } else {
            this.splitImages.clear();
        }
        BufferedImage combined = this.combinedImage;
        List<ChannelData> list = this.parent.getSortedChannelData();
        Iterator<ChannelData> i = list.iterator();
        int j = 0;
        while (i.hasNext()) {
            ChannelData channel = i.next();
            String n = PREFIX + channel.getChannelLabeling();
            this.splitImages.add(new SplitImage(this.gridImages.get(j), n));
            ++j;
        }
        this.splitImages.add(new SplitImage(combined, COMBINED));
        return this.splitImages;
    }

    int getSelectedIndex() {
        return this.parent.getSelectedIndex();
    }

    boolean isTextVisible() {
        return this.parent.isTextVisible();
    }

    double getRatio() {
        return this.ratio;
    }

    double getGridRatio() {
        return this.gridRatio;
    }

    void setGridRatio(double gridRatio) {
        double max = 1.0;
        if (gridRatio > max) {
            return;
        }
        this.gridRatio = gridRatio;
        if (this.originalGridImages == null || this.originalGridImages.size() == 0) {
            this.createGridImages();
            return;
        }
        int n = this.originalGridImages.size();
        this.gridImages.clear();
        int maxC = this.parent.getMaxC();
        switch (n) {
            case 0: {
                for (int i = 0; i < maxC; ++i) {
                    this.gridImages.add(null);
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                if (this.isImageRGB(this.parent.getActiveChannels())) {
                    this.createGridImages();
                    break;
                }
                this.combinedImage = Factory.magnifyImage(gridRatio, this.renderedImage);
                Iterator<BufferedImage> i = this.originalGridImages.iterator();
                while (i.hasNext()) {
                    this.gridImages.add(Factory.magnifyImage(gridRatio, i.next()));
                }
                break;
            }
            default: {
                this.combinedImage = Factory.magnifyImage(gridRatio, this.renderedImage);
                Iterator<BufferedImage> i = this.originalGridImages.iterator();
                while (i.hasNext()) {
                    this.gridImages.add(Factory.magnifyImage(gridRatio, i.next()));
                }
                break block0;
            }
        }
    }

    BufferedImage getCombinedImage() {
        return this.combinedImage;
    }

    int getMaxC() {
        return this.parent.getMaxC();
    }

    void zoom(boolean increase) {
        int index = 0;
        if (!increase) {
            index = 1;
        }
        ZoomCmd cmd = new ZoomCmd(this.parent, index);
        cmd.execute();
    }

    BufferedImage getProjectedImage() {
        return this.projectedImage;
    }

    void setProjectedImage(BufferedImage projectedImage) {
        this.projectedImage = projectedImage;
    }

    void projectionPreview() {
        this.parent.renderXYPlane();
    }

    ImViewer getParentModel() {
        return this.parent;
    }

    void clearGridImages() {
        if (this.gridImages != null) {
            this.gridImages.clear();
        }
    }
}

