/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserUI;
import org.openmicroscopy.shoola.agents.imviewer.browser.GridUI;
import org.openmicroscopy.shoola.agents.imviewer.browser.ProjectionUI;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;

class BrowserComponent
extends AbstractComponent
implements Browser {
    private BrowserModel model;
    private BrowserControl controller;
    private BrowserUI view;
    private GridUI gridView;
    private ProjectionUI projectionView;

    BrowserComponent(BrowserModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new BrowserControl();
        model.getParentModel().addPropertyChangeListener(this.controller);
        this.view = new BrowserUI();
        this.gridView = new GridUI();
        this.projectionView = new ProjectionUI();
        this.view.setSibling(1, this.gridView);
        this.view.setSibling(2, this.projectionView);
    }

    void initialize() {
        this.model.initialize(this);
        this.controller.initialize(this, this.view);
        this.view.initialize(this.controller, this.model);
        this.gridView.initialize(this.model, this.view);
        this.projectionView.initialize(this.model, this.view);
    }

    public JComponent getUI() {
        return this.view;
    }

    public void setRenderedImage(BufferedImage image) {
        if (image == null) {
            throw new IllegalArgumentException("Image cannot be null.");
        }
        this.model.setRenderedImage(image);
        this.view.paintMainImage();
        this.viewSplitImages();
    }

    public BufferedImage getDisplayedImage() {
        return this.model.getDisplayedImage();
    }

    public BufferedImage getRenderedImage() {
        return this.model.getRenderedImage();
    }

    public void removeComponent(JComponent c, int index) {
        if (c == null) {
            throw new IllegalArgumentException("Component cannot be null.");
        }
        switch (index) {
            case 0: {
                this.view.removeComponentFromLayer(c);
                break;
            }
            case 1: {
                this.gridView.removeComponentFromLayer(c);
                break;
            }
            case 2: {
                this.projectionView.removeComponentFromLayer(c);
            }
        }
    }

    public void addComponent(JComponent c, int index) {
        if (c == null) {
            throw new IllegalArgumentException("Component cannot be null.");
        }
        switch (index) {
            case 0: {
                this.view.addComponentToLayer(c);
                break;
            }
            case 1: {
                this.gridView.addComponentToLayer(c);
                break;
            }
            case 2: {
                this.projectionView.addComponentToLayer(c);
            }
        }
    }

    public void setZoomFactor(double factor, boolean reset) {
        int index = this.model.getSelectedIndex();
        if (factor != -1.0) {
            if (factor > 3.0 || factor < 0.25) {
                throw new IllegalArgumentException("The zoom factor is value between 0.25 and 3.0");
            }
        } else {
            BufferedImage img = null;
            Dimension viewport = null;
            if (index == 0) {
                img = this.model.getRenderedImage();
                viewport = this.view.getViewportSize();
            } else if (index == 2) {
                img = this.model.getProjectedImage();
                viewport = this.projectionView.getViewportSize();
            }
            if (img != null) {
                int width = img.getWidth();
                int height = img.getHeight();
                double zoomFactorX = 0.0;
                if (width > 0) {
                    zoomFactorX = viewport.getWidth() / (double)width;
                }
                double zoomFactorY = 0.0;
                if (height > 0) {
                    zoomFactorY = viewport.getHeight() / (double)height;
                }
                factor = Math.min(zoomFactorX, zoomFactorY);
            }
        }
        this.model.setZoomFactor(factor);
        if (!reset) {
            if (index == 0) {
                this.view.zoomImage();
            } else if (index == 2) {
                this.projectionView.zoomImage();
            }
        }
    }

    public double getZoomFactor() {
        return this.model.getZoomFactor();
    }

    public String getTitle() {
        return this.model.getTitle();
    }

    public Icon getIcon() {
        return this.model.getIcon();
    }

    public void setComponentsSize(int w, int h) {
        this.view.setComponentsSize(w, h);
        this.view.setPreferredSize(new Dimension(w + 5, h + 5));
        this.gridView.setGridSize();
        this.projectionView.setComponentsSize(w, h);
    }

    public void setUnitBar(boolean b) {
        if (b == this.model.isUnitBar()) {
            return;
        }
        this.model.setUnitBar(b);
        this.view.repaint();
        int index = this.model.getSelectedIndex();
        if (index == 1) {
            this.gridView.repaint();
        } else if (index == 2) {
            this.projectionView.repaint();
        }
    }

    public void setUnitBarSize(double size) {
        double oldUnit = this.model.getUnitInMicrons();
        this.model.setUnitBarSize(size);
        Rectangle viewRect = this.view.getViewport().getBounds();
        if ((double)viewRect.width >= this.model.getUnitBarSize()) {
            this.view.repaint();
            int index = this.model.getSelectedIndex();
            if (index == 1) {
                this.gridView.repaint();
            } else if (index == 2) {
                this.projectionView.repaint();
            }
            return;
        }
        UserNotifier un = ImViewerAgent.getRegistry().getUserNotifier();
        un.notifyInfo("Scale bar size", "A scale bar of the selected size cannot be displayed on the image. Please select a new size.");
        this.model.setUnitBarSize(oldUnit);
    }

    public boolean isUnitBar() {
        return this.model.isUnitBar();
    }

    public String getUnitBarValue() {
        return this.model.getUnitBarValue();
    }

    public double getUnitBarSize() {
        return this.model.getUnitBarSize();
    }

    public Color getUnitBarColor() {
        return this.model.getUnitBarColor();
    }

    public void setUnitBarColor(Color color) {
        if (this.model.getUnitBarColor().equals(color)) {
            return;
        }
        this.model.setUnitBarColor(color);
        this.view.repaint();
        int index = this.model.getSelectedIndex();
        if (index == 1) {
            this.gridView.repaint();
        } else if (index == 2) {
            this.projectionView.repaint();
        }
    }

    public void scrollTo(Rectangle bounds, boolean blockIncrement) {
        if (bounds == null) {
            return;
        }
        this.view.scrollTo(bounds, blockIncrement);
    }

    public void setBackgroundColor(Color color) {
        if (this.model.getBackgroundColor().equals(color)) {
            return;
        }
        this.model.setBackgroundColor(color);
        this.view.getViewport().setBackground(color);
        int index = this.model.getSelectedIndex();
        if (index == 1) {
            this.gridView.getViewport().setBackground(color);
        } else if (index == 2) {
            this.projectionView.getViewport().setBackground(color);
        }
    }

    public Color getBackgroundColor() {
        return this.model.getBackgroundColor();
    }

    public JComponent getGridView() {
        return this.gridView;
    }

    public JComponent getProjectionView() {
        return this.projectionView;
    }

    public void setSelectedPane(int index) {
        switch (index) {
            case 1: {
                if (this.model.hasNoGridImages()) {
                    this.model.setGridImages();
                }
                this.gridView.paintImage();
                break;
            }
            case 2: {
                this.projectionView.repaint();
                break;
            }
            case 0: {
                this.view.zoomImage();
            }
        }
    }

    public Icon getGridViewIcon() {
        return this.model.getGridViewIcon();
    }

    public String getGridViewTitle() {
        return this.model.getGridViewTitle();
    }

    public Icon getProjectionViewIcon() {
        return this.model.getProjectionViewIcon();
    }

    public String getProjectionViewTitle() {
        return this.model.getProjectionViewTitle();
    }

    public void viewSplitImages() {
        if (this.model.getSelectedIndex() != 1) {
            return;
        }
        this.model.setGridImages();
        if (this.gridView != null) {
            this.gridView.repaint();
        }
    }

    public BufferedImage getGridImage() {
        if (this.model.getCombinedImage() != null) {
            return this.gridView.getGridImage();
        }
        this.model.setGridImages();
        return this.gridView.getGridImage();
    }

    public Point isOnImageInGrid(Rectangle rect) {
        return this.gridView.isOnImageInGrid(rect);
    }

    public double getRatio() {
        return this.model.getRatio();
    }

    public void setGridRatio(double r) {
        this.model.setGridRatio(r);
        this.gridView.setGridRatio();
    }

    public double getGridRatio() {
        return this.model.getGridRatio();
    }

    public void initializeMagnificationFactor(double f) {
        this.model.setZoomFactor(f);
    }

    public void setRenderProjected(BufferedImage image) {
        if (image == null) {
            throw new IllegalArgumentException("Image cannot be null.");
        }
        this.model.setProjectedImage(image);
        this.model.createDisplayedProjectedImage();
        BufferedImage img = this.model.getDisplayedProjectedImage();
        if (img == null) {
            return;
        }
        this.projectionView.repaint();
    }

    public boolean hasProjectedPreview() {
        return this.model.getProjectedImage() != null;
    }

    public BufferedImage getProjectedImage() {
        return this.model.getProjectedImage();
    }

    public void onColorModelChange() {
        this.view.clearGridImages();
        this.viewSplitImages();
    }
}

