/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ZoomGridAction
extends ViewerAction {
    public static final double MAX_ZOOM_FACTOR = 1.0;
    public static final double MIN_ZOOM_FACTOR = 0.25;
    public static final double DEFAULT_ZOOM_FACTOR = 0.5;
    public static final int ZOOM_25 = 0;
    public static final int ZOOM_50 = 1;
    public static final int ZOOM_75 = 2;
    public static final int ZOOM_100 = 3;
    public static final int DEFAULT_ZOOM_INDEX = 1;
    public static final int MIN_ZOOM_INDEX = 0;
    public static final int MAX_ZOOM_INDEX = 3;
    private static final int MAX = 4;
    private static final String DESCRIPTION = "Zoom in or out the grid image.";
    private static String[] names;
    private static double[] factors;
    private int zoomingIndex;

    private void controlsIndex(int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return;
            }
        }
        throw new IllegalArgumentException("Zoom index not supported.");
    }

    public static int getIndex(double f) {
        for (int i = 0; i < factors.length; ++i) {
            if (factors[i] != f) continue;
            return i;
        }
        return -1;
    }

    public static double getZoomFactor(int index) {
        if (index < 0 || index >= factors.length - 1) {
            return -1.0;
        }
        return factors[index];
    }

    public ZoomGridAction(ImViewer model, int zoomingIndex) {
        super(model);
        this.controlsIndex(zoomingIndex);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        this.zoomingIndex = zoomingIndex;
        this.putValue("Name", names[zoomingIndex]);
        this.name = names[zoomingIndex];
    }

    public int getIndex() {
        return this.zoomingIndex;
    }

    public void actionPerformed(ActionEvent e) {
        this.model.setGridMagnificationFactor(factors[this.zoomingIndex]);
    }

    static {
        factors = new double[5];
        ZoomGridAction.factors[0] = 0.25;
        ZoomGridAction.factors[1] = factors[0] + 0.25;
        ZoomGridAction.factors[2] = factors[1] + 0.25;
        ZoomGridAction.factors[3] = factors[2] + 0.25;
        names = new String[5];
        ZoomGridAction.names[0] = (int)(factors[0] * 100.0) + "%";
        ZoomGridAction.names[1] = (int)(factors[1] * 100.0) + "%";
        ZoomGridAction.names[2] = (int)(factors[2] * 100.0) + "%";
        ZoomGridAction.names[3] = (int)(factors[3] * 100.0) + "%";
    }
}

