/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.actions;

import java.awt.event.ActionEvent;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class UnitBarSizeAction
extends ViewerAction {
    public static final int ONE = 0;
    public static final int TWO = 1;
    public static final int FIVE = 2;
    public static final int TEN = 3;
    public static final int TWENTY = 4;
    public static final int FIFTY = 5;
    public static final int HUNDRED = 6;
    public static final int CUSTOMIZED = 7;
    public static final int DEFAULT_UNIT_INDEX = 2;
    private static final int MAX = 7;
    private static final String DESCRIPTION = "Selects the size of the Scale bar displayed on top of the image.";
    private static String[] names;
    private static int[] values;
    private int index;

    public static int getDefaultValue() {
        return values[2];
    }

    private void checkIndex(int i) {
        switch (i) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return;
            }
        }
        throw new IllegalArgumentException("Index not supported.");
    }

    public UnitBarSizeAction(ImViewer model, int index) {
        super(model);
        this.checkIndex(index);
        this.index = index;
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        this.putValue("Name", names[index]);
    }

    public int getIndex() {
        return this.index;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.index != 7) {
            this.model.setUnitBarSize(values[this.index]);
        } else {
            this.model.showUnitBarSelection();
        }
    }

    static {
        values = new int[8];
        UnitBarSizeAction.values[0] = 1;
        UnitBarSizeAction.values[1] = 2;
        UnitBarSizeAction.values[2] = 5;
        UnitBarSizeAction.values[3] = 10;
        UnitBarSizeAction.values[4] = 20;
        UnitBarSizeAction.values[5] = 50;
        UnitBarSizeAction.values[6] = 100;
        names = new String[8];
        UnitBarSizeAction.names[0] = "" + values[0];
        UnitBarSizeAction.names[1] = "" + values[1];
        UnitBarSizeAction.names[2] = "" + values[2];
        UnitBarSizeAction.names[3] = "" + values[3];
        UnitBarSizeAction.names[4] = "" + values[4];
        UnitBarSizeAction.names[5] = "" + values[5];
        UnitBarSizeAction.names[6] = "" + values[6];
        UnitBarSizeAction.names[7] = "Custom";
    }
}

