/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.actions;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class MovieAction
extends ViewerAction {
    private static final String NAME = "Movie...";
    private static final String DESCRIPTION = "Bring up the movie player.";

    protected void onTabSelection() {
        this.setEnabled(this.model.getSelectedIndex() != 2);
    }

    protected void onStateChange(ChangeEvent e) {
        switch (this.model.getState()) {
            case 8: {
                this.setEnabled(false);
                break;
            }
            case 6: 
            case 9: {
                if (this.model.getSelectedIndex() == 2) {
                    this.setEnabled(false);
                    break;
                }
                if (this.model.isPlayingMovie()) {
                    this.setEnabled(false);
                    break;
                }
                int max = Math.max(this.model.getMaxZ(), this.model.getMaxT());
                this.setEnabled(max != 0);
            }
        }
    }

    public MovieAction(ImViewer model) {
        super(model, NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager icons = IconManager.getInstance();
        this.putValue("SmallIcon", icons.getIcon(3));
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.model.isPlayingMovie()) {
            this.model.playMovie(true, true, -1);
        }
    }
}

