/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer;

import org.openmicroscopy.shoola.agents.imviewer.DataLoader;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.log.LogMessage;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;

public class RenderingControlLoader
extends DataLoader {
    public static final int LOAD = 0;
    public static final int RELOAD = 1;
    public static final int RESET = 2;
    private long pixelsID;
    private int index;
    private CallHandle handle;

    private void checkIndex(int value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: {
                return;
            }
        }
        throw new IllegalArgumentException("Index not supported.");
    }

    public RenderingControlLoader(ImViewer viewer, long pixelsID, int index) {
        super(viewer);
        this.checkIndex(index);
        this.pixelsID = pixelsID;
        this.index = index;
    }

    public void load() {
        this.handle = this.ivView.loadRenderingControl(this.pixelsID, this.index, this);
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void handleException(Throwable exc) {
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        this.registry.getUserNotifier().notifyInfo("Loading Rendering data", "The image could not be opened. \nThe image is not a valid image.");
        this.viewer.discard();
    }

    public void handleResult(Object result) {
        if (this.viewer.getState() == 7) {
            return;
        }
        switch (this.index) {
            case 0: {
                this.viewer.setRenderingControl((RenderingControl)result);
                break;
            }
            case 1: {
                this.viewer.setRenderingControlReloaded(false);
                break;
            }
            case 2: {
                this.viewer.setRenderingControlReloaded(true);
            }
        }
    }
}

