/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer;

import java.awt.image.BufferedImage;
import org.openmicroscopy.shoola.agents.imviewer.DataLoader;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.env.data.model.ProjectionParam;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.log.LogMessage;
import pojos.ImageData;

public class ProjectionSaver
extends DataLoader {
    public static final int PREVIEW = 0;
    public static final int PROJECTION = 1;
    private boolean applySettings;
    private int index;
    private ProjectionParam ref;
    private CallHandle handle;

    private void checkIndex(int value) {
        switch (value) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Projection index not supported.");
            }
        }
    }

    public ProjectionSaver(ImViewer model, ProjectionParam ref, int index) {
        this(model, ref, index, false);
    }

    public ProjectionSaver(ImViewer model, ProjectionParam ref, int index, boolean applySettings) {
        super(model);
        if (ref == null) {
            throw new IllegalArgumentException("Parameters not specified.");
        }
        this.checkIndex(index);
        this.index = index;
        this.ref = ref;
        this.applySettings = applySettings;
    }

    public void load() {
        switch (this.index) {
            case 0: {
                this.handle = this.ivView.renderProjected(this.ref.getPixelsID(), this.ref.getStartZ(), this.ref.getEndZ(), this.ref.getStepping(), this.ref.getAlgorithm(), this.ref.getChannels(), this);
                break;
            }
            case 1: {
                this.handle = this.ivView.projectImage(this.ref, this);
            }
        }
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void handleException(Throwable exc) {
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        switch (this.index) {
            case 0: {
                this.viewer.setProjectionPreview(null);
                break;
            }
            case 1: {
                this.viewer.setProjectedImage(null, null, false);
            }
        }
    }

    public void handleResult(Object result) {
        if (this.viewer.getState() == 7) {
            return;
        }
        switch (this.index) {
            case 0: {
                this.viewer.setProjectionPreview((BufferedImage)result);
                break;
            }
            case 1: {
                this.viewer.setProjectedImage((ImageData)result, this.ref.getChannels(), this.applySettings);
            }
        }
    }
}

