/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer;

import org.openmicroscopy.shoola.agents.imviewer.DataLoader;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.log.LogMessage;
import pojos.ImageData;

public class ImageDataLoader
extends DataLoader {
    private long imageID;
    private CallHandle handle;

    public ImageDataLoader(ImViewer viewer, long imageID) {
        super(viewer);
        this.imageID = imageID;
    }

    public void load() {
        this.handle = this.ivView.loadImage(this.imageID, this.getCurrentUserID(), this);
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void handleException(Throwable exc) {
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        this.registry.getUserNotifier().notifyInfo("Data Retrieval Failure", "The image with ID:" + this.imageID + " does not exist.");
        this.viewer.discard();
    }

    public void handleResult(Object result) {
        if (this.viewer.getState() == 7) {
            return;
        }
        this.viewer.setImageData((ImageData)result);
    }
}

