/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer;

import java.awt.Rectangle;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.events.FocusGainedEvent;
import org.openmicroscopy.shoola.agents.events.iviewer.CopyRndSettings;
import org.openmicroscopy.shoola.agents.events.iviewer.MeasurementTool;
import org.openmicroscopy.shoola.agents.events.iviewer.RndSettingsCopied;
import org.openmicroscopy.shoola.agents.events.iviewer.SaveRelatedData;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.events.measurement.MeasurementToolLoaded;
import org.openmicroscopy.shoola.agents.events.measurement.SelectPlane;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerFactory;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.event.EventBus;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.PixelsData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImViewerAgent
implements Agent,
AgentEventListener {
    public static final String ERROR = " An error occured while modifying  the rendering settings.";
    private static Registry registry;

    public static Registry getRegistry() {
        return registry;
    }

    public static ExperimenterData getUserDetails() {
        return (ExperimenterData)registry.lookup("/current_user/details");
    }

    public static boolean isFastConnection() {
        return (Boolean)registry.lookup("/connection/speed");
    }

    private void handleViewImage(ViewImage evt) {
        if (evt == null) {
            return;
        }
        ImageData image = evt.getImage();
        Rectangle r = evt.getRequesterBounds();
        ImViewer view = image != null ? ImViewerFactory.getImageViewer(image, r) : ImViewerFactory.getImageViewer(evt.getImageID(), r);
        if (view != null) {
            view.activate(evt.getSettings(), evt.getSelectedUserID());
            view.setContext(evt.getParent(), evt.getGrandParent());
        }
    }

    private void handleSaveRelatedData(SaveRelatedData evt) {
        if (evt == null) {
            return;
        }
        ImViewerFactory.storeEvent(evt);
    }

    private void handleMeasurementToolLoaded(MeasurementToolLoaded evt) {
        if (evt == null) {
            return;
        }
        MeasurementTool request = (MeasurementTool)evt.getACT();
        PixelsData pixels = request.getPixels();
        if (pixels == null) {
            return;
        }
        long pixelsID = pixels.getId();
        ImViewer view = ImViewerFactory.getImageViewer(pixelsID);
        if (view != null) {
            switch (evt.getIndex()) {
                case 0: {
                    view.addToView(evt.getView());
                    break;
                }
                case 1: {
                    view.removeFromView(evt.getView());
                }
            }
        }
    }

    private void handleSelectPlane(SelectPlane evt) {
        if (evt == null) {
            return;
        }
        long pixelsID = evt.getPixelsID();
        ImViewer view = ImViewerFactory.getImageViewer(pixelsID);
        if (view != null) {
            view.setSelectedXYPlane(evt.getDefaultZ(), evt.getDefaultT());
        }
    }

    public void handleCopyRndSettings(CopyRndSettings evt) {
        if (evt == null) {
            return;
        }
        ImViewerFactory.copyRndSettings(evt.getImage());
    }

    private void handleFocusGainedEvent(FocusGainedEvent evt) {
        ImViewer viewer = ImViewerFactory.getImageViewer(evt.getPixelsID());
        if (viewer == null) {
            return;
        }
        if (viewer.getState() != 7 || evt.getIndex() != 0) {
            // empty if block
        }
    }

    private void handleRndSettingsCopiedEvent(RndSettingsCopied evt) {
        if (evt == null) {
            return;
        }
        ImViewerFactory.reloadRenderingEngine(evt.getPixelsIDs(), evt.getRefPixelsID());
    }

    @Override
    public void activate() {
    }

    @Override
    public void terminate() {
    }

    @Override
    public void setContext(Registry ctx) {
        registry = ctx;
        EventBus bus = registry.getEventBus();
        bus.register((AgentEventListener)this, ViewImage.class);
        bus.register((AgentEventListener)this, MeasurementToolLoaded.class);
        bus.register((AgentEventListener)this, SelectPlane.class);
        bus.register((AgentEventListener)this, CopyRndSettings.class);
        bus.register((AgentEventListener)this, SaveRelatedData.class);
        bus.register((AgentEventListener)this, FocusGainedEvent.class);
        bus.register((AgentEventListener)this, RndSettingsCopied.class);
    }

    @Override
    public boolean canTerminate() {
        return true;
    }

    @Override
    public Map<String, Set> hasDataToSave() {
        return ImViewerFactory.hasDataToSave();
    }

    @Override
    public void eventFired(AgentEvent e) {
        if (e instanceof ViewImage) {
            this.handleViewImage((ViewImage)e);
        } else if (e instanceof MeasurementToolLoaded) {
            this.handleMeasurementToolLoaded((MeasurementToolLoaded)e);
        } else if (e instanceof SelectPlane) {
            this.handleSelectPlane((SelectPlane)e);
        } else if (e instanceof CopyRndSettings) {
            this.handleCopyRndSettings((CopyRndSettings)e);
        } else if (e instanceof SaveRelatedData) {
            this.handleSaveRelatedData((SaveRelatedData)e);
        } else if (e instanceof FocusGainedEvent) {
            this.handleFocusGainedEvent((FocusGainedEvent)e);
        } else if (e instanceof RndSettingsCopied) {
            this.handleRndSettingsCopiedEvent((RndSettingsCopied)e);
        }
    }
}

