/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.view;

import java.io.File;
import java.util.ArrayList;
import org.openmicroscopy.shoola.agents.fsimporter.DataImporterLoader;
import org.openmicroscopy.shoola.agents.fsimporter.DirectoryMonitor;
import org.openmicroscopy.shoola.agents.fsimporter.ImagesImporter;
import org.openmicroscopy.shoola.agents.fsimporter.view.Importer;
import pojos.DataObject;

class ImporterModel {
    private int state = 1;
    protected Importer component;
    private DataObject container;
    private DataImporterLoader currentLoader;

    ImporterModel() {
    }

    void initialize(Importer component) {
        this.component = component;
    }

    int getState() {
        return this.state;
    }

    void setState(int state) {
        this.state = state;
    }

    void discard() {
        this.cancel();
        this.state = 3;
    }

    void cancel() {
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
            this.currentLoader = null;
        }
        this.state = 2;
    }

    void setContainer(DataObject container) {
        this.container = container;
    }

    DataObject getContainer() {
        return this.container;
    }

    void fireImportData(File[] data) {
        ArrayList<Object> files = new ArrayList<Object>(data.length);
        for (int i = 0; i < data.length; ++i) {
            files.add(data[i]);
        }
        this.currentLoader = new ImagesImporter(this.component, this.container, files);
        this.currentLoader.load();
        this.state = 4;
    }

    void fireMonitorDirectory(File directory) {
        if (this.currentLoader != null) {
            this.cancel();
        }
        this.currentLoader = new DirectoryMonitor(this.component, directory, this.container);
        this.currentLoader.load();
        this.state = 4;
    }
}

